/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import com.oracle.bmc.waas.model.WafLog;
import com.oracle.bmc.waas.requests.ListWafLogsRequest;
import com.oracle.bmc.waas.responses.ListWafLogsResponse;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWafLogsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListWafLogsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListWafLogsRequest interceptRequest(ListWafLogsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListWafLogsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWaasPolicyId(), (String)"waasPolicyId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20181116").path("waasPolicies").path(HttpUtils.encodePathSegment((String)request.getWaasPolicyId())).path("wafLogs");
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getTimeObservedGreaterThanOrEqualTo() != null) {
            target = target.queryParam("timeObservedGreaterThanOrEqualTo", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeObservedGreaterThanOrEqualTo())});
        }
        if (request.getTimeObservedLessThan() != null) {
            target = target.queryParam("timeObservedLessThan", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTimeObservedLessThan())});
        }
        if (request.getTextContains() != null) {
            target = target.queryParam("textContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getTextContains())});
        }
        if (request.getAccessRuleKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"accessRuleKey", request.getAccessRuleKey(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getAction() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"action", request.getAction(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getClientAddress() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"clientAddress", request.getClientAddress(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getCountryCode() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"countryCode", request.getCountryCode(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getCountryName() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"countryName", request.getCountryName(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getFingerprint() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"fingerprint", request.getFingerprint(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getHttpMethod() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"httpMethod", request.getHttpMethod(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getIncidentKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"incidentKey", request.getIncidentKey(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getLogType() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"logType", request.getLogType(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getOriginAddress() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"originAddress", request.getOriginAddress(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getReferrer() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"referrer", request.getReferrer(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getRequestUrl() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"requestUrl", request.getRequestUrl(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getResponseCode() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"responseCode", request.getResponseCode(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getThreatFeedKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"threatFeedKey", request.getThreatFeedKey(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getUserAgent() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"userAgent", request.getUserAgent(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getProtectionRuleKey() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"protectionRuleKey", request.getProtectionRuleKey(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListWafLogsResponse> fromResponse() {
        Function<Response, ListWafLogsResponse> transformer = new Function<Response, ListWafLogsResponse>(){

            public ListWafLogsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.waas.responses.ListWafLogsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<WafLog>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListWafLogsResponse.Builder builder = ListWafLogsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListWafLogsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

