/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waas.RedirectAsync;
import com.oracle.bmc.waas.model.HttpRedirect;
import com.oracle.bmc.waas.model.HttpRedirectSummary;
import com.oracle.bmc.waas.requests.ChangeHttpRedirectCompartmentRequest;
import com.oracle.bmc.waas.requests.CreateHttpRedirectRequest;
import com.oracle.bmc.waas.requests.DeleteHttpRedirectRequest;
import com.oracle.bmc.waas.requests.GetHttpRedirectRequest;
import com.oracle.bmc.waas.requests.ListHttpRedirectsRequest;
import com.oracle.bmc.waas.requests.UpdateHttpRedirectRequest;
import com.oracle.bmc.waas.responses.ChangeHttpRedirectCompartmentResponse;
import com.oracle.bmc.waas.responses.CreateHttpRedirectResponse;
import com.oracle.bmc.waas.responses.DeleteHttpRedirectResponse;
import com.oracle.bmc.waas.responses.GetHttpRedirectResponse;
import com.oracle.bmc.waas.responses.ListHttpRedirectsResponse;
import com.oracle.bmc.waas.responses.UpdateHttpRedirectResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectAsyncClient
extends BaseAsyncClient
implements RedirectAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("REDIRECT").serviceEndpointPrefix("waas").serviceEndpointTemplate("https://waas.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(RedirectAsyncClient.class);

    RedirectAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeHttpRedirectCompartmentResponse> changeHttpRedirectCompartment(ChangeHttpRedirectCompartmentRequest request, AsyncHandler<ChangeHttpRedirectCompartmentRequest, ChangeHttpRedirectCompartmentResponse> handler) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeHttpRedirectCompartmentDetails(), "changeHttpRedirectCompartmentDetails is required");
        return this.clientCall(request, ChangeHttpRedirectCompartmentResponse::builder).logger(LOG, "changeHttpRedirectCompartment").serviceDetails("Redirect", "ChangeHttpRedirectCompartment", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/ChangeHttpRedirectCompartment").method(Method.POST).requestBuilder(ChangeHttpRedirectCompartmentRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeHttpRedirectCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateHttpRedirectResponse> createHttpRedirect(CreateHttpRedirectRequest request, AsyncHandler<CreateHttpRedirectRequest, CreateHttpRedirectResponse> handler) {
        Objects.requireNonNull(request.getCreateHttpRedirectDetails(), "createHttpRedirectDetails is required");
        return this.clientCall(request, CreateHttpRedirectResponse::builder).logger(LOG, "createHttpRedirect").serviceDetails("Redirect", "CreateHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/CreateHttpRedirect").method(Method.POST).requestBuilder(CreateHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", CreateHttpRedirectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateHttpRedirectResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteHttpRedirectResponse> deleteHttpRedirect(DeleteHttpRedirectRequest request, AsyncHandler<DeleteHttpRedirectRequest, DeleteHttpRedirectResponse> handler) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteHttpRedirectResponse::builder).logger(LOG, "deleteHttpRedirect").serviceDetails("Redirect", "DeleteHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/DeleteHttpRedirect").method(Method.DELETE).requestBuilder(DeleteHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteHttpRedirectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteHttpRedirectResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetHttpRedirectResponse> getHttpRedirect(GetHttpRedirectRequest request, AsyncHandler<GetHttpRedirectRequest, GetHttpRedirectResponse> handler) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetHttpRedirectResponse::builder).logger(LOG, "getHttpRedirect").serviceDetails("Redirect", "GetHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/GetHttpRedirect").method(Method.GET).requestBuilder(GetHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(HttpRedirect.class, GetHttpRedirectResponse.Builder::httpRedirect).handleResponseHeaderString("etag", GetHttpRedirectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetHttpRedirectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListHttpRedirectsResponse> listHttpRedirects(ListHttpRedirectsRequest request, AsyncHandler<ListHttpRedirectsRequest, ListHttpRedirectsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListHttpRedirectsResponse::builder).logger(LOG, "listHttpRedirects").serviceDetails("Redirect", "ListHttpRedirects", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/ListHttpRedirects").method(Method.GET).requestBuilder(ListHttpRedirectsRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("id", request.getId(), CollectionFormatType.Multi).appendListQueryParam("displayName", request.getDisplayName(), CollectionFormatType.Multi).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(HttpRedirectSummary.class, ListHttpRedirectsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListHttpRedirectsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListHttpRedirectsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateHttpRedirectResponse> updateHttpRedirect(UpdateHttpRedirectRequest request, AsyncHandler<UpdateHttpRedirectRequest, UpdateHttpRedirectResponse> handler) {
        Validate.notBlank((String)request.getHttpRedirectId(), (String)"httpRedirectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateHttpRedirectDetails(), "updateHttpRedirectDetails is required");
        return this.clientCall(request, UpdateHttpRedirectResponse::builder).logger(LOG, "updateHttpRedirect").serviceDetails("Redirect", "UpdateHttpRedirect", "https://docs.oracle.com/iaas/api/#/en/waas/20181116/HttpRedirect/UpdateHttpRedirect").method(Method.PUT).requestBuilder(UpdateHttpRedirectRequest::builder).basePath("/20181116").appendPathParam("httpRedirects").appendPathParam(request.getHttpRedirectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateHttpRedirectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateHttpRedirectResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public RedirectAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)RedirectAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RedirectAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(RedirectAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RedirectAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)RedirectAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public RedirectAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)RedirectAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public RedirectAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)RedirectAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public RedirectAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)RedirectAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public RedirectAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)RedirectAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RedirectAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "waas";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"waas");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RedirectAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new RedirectAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

