/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WafBlockedRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeObserved")
    private final Date timeObserved;
    @JsonProperty(value="timeRangeInSeconds")
    private final Integer timeRangeInSeconds;
    @JsonProperty(value="wafFeature")
    private final WafFeature wafFeature;
    @JsonProperty(value="count")
    private final Integer count;

    @Deprecated
    @ConstructorProperties(value={"timeObserved", "timeRangeInSeconds", "wafFeature", "count"})
    public WafBlockedRequest(Date timeObserved, Integer timeRangeInSeconds, WafFeature wafFeature, Integer count) {
        this.timeObserved = timeObserved;
        this.timeRangeInSeconds = timeRangeInSeconds;
        this.wafFeature = wafFeature;
        this.count = count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeObserved() {
        return this.timeObserved;
    }

    public Integer getTimeRangeInSeconds() {
        return this.timeRangeInSeconds;
    }

    public WafFeature getWafFeature() {
        return this.wafFeature;
    }

    public Integer getCount() {
        return this.count;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WafBlockedRequest(");
        sb.append("super=").append(super.toString());
        sb.append("timeObserved=").append(String.valueOf(this.timeObserved));
        sb.append(", timeRangeInSeconds=").append(String.valueOf(this.timeRangeInSeconds));
        sb.append(", wafFeature=").append(String.valueOf((Object)this.wafFeature));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WafBlockedRequest)) {
            return false;
        }
        WafBlockedRequest other = (WafBlockedRequest)((Object)o);
        return Objects.equals(this.timeObserved, other.timeObserved) && Objects.equals(this.timeRangeInSeconds, other.timeRangeInSeconds) && Objects.equals((Object)this.wafFeature, (Object)other.wafFeature) && Objects.equals(this.count, other.count) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeObserved == null ? 43 : this.timeObserved.hashCode());
        result = result * 59 + (this.timeRangeInSeconds == null ? 43 : this.timeRangeInSeconds.hashCode());
        result = result * 59 + (this.wafFeature == null ? 43 : this.wafFeature.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum WafFeature implements BmcEnum
    {
        ProtectionRules("PROTECTION_RULES"),
        JsChallenge("JS_CHALLENGE"),
        AccessRules("ACCESS_RULES"),
        ThreatFeeds("THREAT_FEEDS"),
        HumanInteractionChallenge("HUMAN_INTERACTION_CHALLENGE"),
        DeviceFingerprintChallenge("DEVICE_FINGERPRINT_CHALLENGE"),
        Captcha("CAPTCHA"),
        AddressRateLimiting("ADDRESS_RATE_LIMITING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, WafFeature> map;

        private WafFeature(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WafFeature create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'WafFeature', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(WafFeature.class);
            map = new HashMap<String, WafFeature>();
            for (WafFeature v : WafFeature.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeObserved")
        private Date timeObserved;
        @JsonProperty(value="timeRangeInSeconds")
        private Integer timeRangeInSeconds;
        @JsonProperty(value="wafFeature")
        private WafFeature wafFeature;
        @JsonProperty(value="count")
        private Integer count;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeObserved(Date timeObserved) {
            this.timeObserved = timeObserved;
            this.__explicitlySet__.add("timeObserved");
            return this;
        }

        public Builder timeRangeInSeconds(Integer timeRangeInSeconds) {
            this.timeRangeInSeconds = timeRangeInSeconds;
            this.__explicitlySet__.add("timeRangeInSeconds");
            return this;
        }

        public Builder wafFeature(WafFeature wafFeature) {
            this.wafFeature = wafFeature;
            this.__explicitlySet__.add("wafFeature");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public WafBlockedRequest build() {
            WafBlockedRequest model = new WafBlockedRequest(this.timeObserved, this.timeRangeInSeconds, this.wafFeature, this.count);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WafBlockedRequest model) {
            if (model.wasPropertyExplicitlySet("timeObserved")) {
                this.timeObserved(model.getTimeObserved());
            }
            if (model.wasPropertyExplicitlySet("timeRangeInSeconds")) {
                this.timeRangeInSeconds(model.getTimeRangeInSeconds());
            }
            if (model.wasPropertyExplicitlySet("wafFeature")) {
                this.wafFeature(model.getWafFeature());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            return this;
        }
    }
}

