/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waas.model.PurgeCache;
import java.util.Objects;

public class PurgeCacheRequest
extends BmcRequest<PurgeCache> {
    private String waasPolicyId;
    private String opcRequestId;
    private String ifMatch;
    private PurgeCache purgeCache;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public PurgeCache getPurgeCache() {
        return this.purgeCache;
    }

    @InternalSdk
    public PurgeCache getBody$() {
        return this.purgeCache;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).purgeCache(this.purgeCache);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",purgeCache=").append(String.valueOf((Object)this.purgeCache));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PurgeCacheRequest)) {
            return false;
        }
        PurgeCacheRequest other = (PurgeCacheRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals((Object)this.purgeCache, (Object)other.purgeCache);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.purgeCache == null ? 43 : this.purgeCache.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PurgeCacheRequest, PurgeCache> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private PurgeCache purgeCache = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder purgeCache(PurgeCache purgeCache) {
            this.purgeCache = purgeCache;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PurgeCacheRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.purgeCache(o.getPurgeCache());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PurgeCacheRequest build() {
            PurgeCacheRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PurgeCache body) {
            this.purgeCache(body);
            return this;
        }

        public PurgeCacheRequest buildWithoutInvocationCallback() {
            PurgeCacheRequest request = new PurgeCacheRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.purgeCache = this.purgeCache;
            return request;
        }
    }
}

