/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waas.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.waas.model.ProtectionRuleAction;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class UpdateProtectionRulesRequest
extends BmcRequest<List<ProtectionRuleAction>> {
    private String waasPolicyId;
    private List<ProtectionRuleAction> protectionRules;
    private String opcRequestId;
    private String ifMatch;

    public String getWaasPolicyId() {
        return this.waasPolicyId;
    }

    public List<ProtectionRuleAction> getProtectionRules() {
        return this.protectionRules;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public List<ProtectionRuleAction> getBody$() {
        return this.protectionRules;
    }

    public Builder toBuilder() {
        return new Builder().waasPolicyId(this.waasPolicyId).protectionRules(this.protectionRules).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",waasPolicyId=").append(String.valueOf(this.waasPolicyId));
        sb.append(",protectionRules=").append(String.valueOf(this.protectionRules));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProtectionRulesRequest)) {
            return false;
        }
        UpdateProtectionRulesRequest other = (UpdateProtectionRulesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.waasPolicyId, other.waasPolicyId) && Objects.equals(this.protectionRules, other.protectionRules) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.waasPolicyId == null ? 43 : this.waasPolicyId.hashCode());
        result = result * 59 + (this.protectionRules == null ? 43 : this.protectionRules.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProtectionRulesRequest, List<ProtectionRuleAction>> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String waasPolicyId = null;
        private List<ProtectionRuleAction> protectionRules = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder waasPolicyId(String waasPolicyId) {
            this.waasPolicyId = waasPolicyId;
            return this;
        }

        public Builder protectionRules(List<ProtectionRuleAction> protectionRules) {
            this.protectionRules = protectionRules;
            return this;
        }

        public Builder protectionRules(ProtectionRuleAction singularValue) {
            return this.protectionRules(Arrays.asList(singularValue));
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProtectionRulesRequest o) {
            this.waasPolicyId(o.getWaasPolicyId());
            this.protectionRules(o.getProtectionRules());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProtectionRulesRequest build() {
            UpdateProtectionRulesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(List<ProtectionRuleAction> body) {
            this.protectionRules(body);
            return this;
        }

        public UpdateProtectionRulesRequest buildWithoutInvocationCallback() {
            UpdateProtectionRulesRequest request = new UpdateProtectionRulesRequest();
            request.waasPolicyId = this.waasPolicyId;
            request.protectionRules = this.protectionRules;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

