/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waf.WafAsync;
import com.oracle.bmc.waf.model.NetworkAddressList;
import com.oracle.bmc.waf.model.NetworkAddressListCollection;
import com.oracle.bmc.waf.model.ProtectionCapabilityCollection;
import com.oracle.bmc.waf.model.ProtectionCapabilityGroupTagCollection;
import com.oracle.bmc.waf.model.WebAppFirewall;
import com.oracle.bmc.waf.model.WebAppFirewallCollection;
import com.oracle.bmc.waf.model.WebAppFirewallPolicy;
import com.oracle.bmc.waf.model.WebAppFirewallPolicyCollection;
import com.oracle.bmc.waf.model.WorkRequest;
import com.oracle.bmc.waf.model.WorkRequestCollection;
import com.oracle.bmc.waf.model.WorkRequestErrorCollection;
import com.oracle.bmc.waf.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.waf.requests.ChangeNetworkAddressListCompartmentRequest;
import com.oracle.bmc.waf.requests.ChangeWebAppFirewallCompartmentRequest;
import com.oracle.bmc.waf.requests.ChangeWebAppFirewallPolicyCompartmentRequest;
import com.oracle.bmc.waf.requests.CreateNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.CreateWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.CreateWebAppFirewallRequest;
import com.oracle.bmc.waf.requests.DeleteNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.DeleteWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.DeleteWebAppFirewallRequest;
import com.oracle.bmc.waf.requests.GetNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.GetWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.GetWebAppFirewallRequest;
import com.oracle.bmc.waf.requests.GetWorkRequestRequest;
import com.oracle.bmc.waf.requests.ListNetworkAddressListsRequest;
import com.oracle.bmc.waf.requests.ListProtectionCapabilitiesRequest;
import com.oracle.bmc.waf.requests.ListProtectionCapabilityGroupTagsRequest;
import com.oracle.bmc.waf.requests.ListWebAppFirewallPoliciesRequest;
import com.oracle.bmc.waf.requests.ListWebAppFirewallsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waf.requests.UpdateNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.UpdateWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.UpdateWebAppFirewallRequest;
import com.oracle.bmc.waf.responses.ChangeNetworkAddressListCompartmentResponse;
import com.oracle.bmc.waf.responses.ChangeWebAppFirewallCompartmentResponse;
import com.oracle.bmc.waf.responses.ChangeWebAppFirewallPolicyCompartmentResponse;
import com.oracle.bmc.waf.responses.CreateNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.CreateWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.CreateWebAppFirewallResponse;
import com.oracle.bmc.waf.responses.DeleteNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.DeleteWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.DeleteWebAppFirewallResponse;
import com.oracle.bmc.waf.responses.GetNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.GetWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.GetWebAppFirewallResponse;
import com.oracle.bmc.waf.responses.GetWorkRequestResponse;
import com.oracle.bmc.waf.responses.ListNetworkAddressListsResponse;
import com.oracle.bmc.waf.responses.ListProtectionCapabilitiesResponse;
import com.oracle.bmc.waf.responses.ListProtectionCapabilityGroupTagsResponse;
import com.oracle.bmc.waf.responses.ListWebAppFirewallPoliciesResponse;
import com.oracle.bmc.waf.responses.ListWebAppFirewallsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestsResponse;
import com.oracle.bmc.waf.responses.UpdateNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.UpdateWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.UpdateWebAppFirewallResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WafAsyncClient
extends BaseAsyncClient
implements WafAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WAF").serviceEndpointPrefix("").serviceEndpointTemplate("https://waf.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(WafAsyncClient.class);

    WafAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeNetworkAddressListCompartmentResponse> changeNetworkAddressListCompartment(ChangeNetworkAddressListCompartmentRequest request, AsyncHandler<ChangeNetworkAddressListCompartmentRequest, ChangeNetworkAddressListCompartmentResponse> handler) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNetworkAddressListCompartmentDetails(), "changeNetworkAddressListCompartmentDetails is required");
        return this.clientCall(request, ChangeNetworkAddressListCompartmentResponse::builder).logger(LOG, "changeNetworkAddressListCompartment").serviceDetails("Waf", "ChangeNetworkAddressListCompartment", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/ChangeNetworkAddressListCompartment").method(Method.POST).requestBuilder(ChangeNetworkAddressListCompartmentRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeNetworkAddressListCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeNetworkAddressListCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeWebAppFirewallCompartmentResponse> changeWebAppFirewallCompartment(ChangeWebAppFirewallCompartmentRequest request, AsyncHandler<ChangeWebAppFirewallCompartmentRequest, ChangeWebAppFirewallCompartmentResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeWebAppFirewallCompartmentDetails(), "changeWebAppFirewallCompartmentDetails is required");
        return this.clientCall(request, ChangeWebAppFirewallCompartmentResponse::builder).logger(LOG, "changeWebAppFirewallCompartment").serviceDetails("Waf", "ChangeWebAppFirewallCompartment", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/ChangeWebAppFirewallCompartment").method(Method.POST).requestBuilder(ChangeWebAppFirewallCompartmentRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeWebAppFirewallCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeWebAppFirewallCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeWebAppFirewallPolicyCompartmentResponse> changeWebAppFirewallPolicyCompartment(ChangeWebAppFirewallPolicyCompartmentRequest request, AsyncHandler<ChangeWebAppFirewallPolicyCompartmentRequest, ChangeWebAppFirewallPolicyCompartmentResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeWebAppFirewallPolicyCompartmentDetails(), "changeWebAppFirewallPolicyCompartmentDetails is required");
        return this.clientCall(request, ChangeWebAppFirewallPolicyCompartmentResponse::builder).logger(LOG, "changeWebAppFirewallPolicyCompartment").serviceDetails("Waf", "ChangeWebAppFirewallPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/ChangeWebAppFirewallPolicyCompartment").method(Method.POST).requestBuilder(ChangeWebAppFirewallPolicyCompartmentRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeWebAppFirewallPolicyCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeWebAppFirewallPolicyCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateNetworkAddressListResponse> createNetworkAddressList(CreateNetworkAddressListRequest request, AsyncHandler<CreateNetworkAddressListRequest, CreateNetworkAddressListResponse> handler) {
        Objects.requireNonNull(request.getCreateNetworkAddressListDetails(), "createNetworkAddressListDetails is required");
        return this.clientCall(request, CreateNetworkAddressListResponse::builder).logger(LOG, "createNetworkAddressList").serviceDetails("Waf", "CreateNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/CreateNetworkAddressList").method(Method.POST).requestBuilder(CreateNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(NetworkAddressList.class, CreateNetworkAddressListResponse.Builder::networkAddressList).handleResponseHeaderString("etag", CreateNetworkAddressListResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateNetworkAddressListResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNetworkAddressListResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateNetworkAddressListResponse.Builder::location).handleResponseHeaderString("content-location", CreateNetworkAddressListResponse.Builder::contentLocation).callAsync(handler);
    }

    @Override
    public Future<CreateWebAppFirewallResponse> createWebAppFirewall(CreateWebAppFirewallRequest request, AsyncHandler<CreateWebAppFirewallRequest, CreateWebAppFirewallResponse> handler) {
        Objects.requireNonNull(request.getCreateWebAppFirewallDetails(), "createWebAppFirewallDetails is required");
        return this.clientCall(request, CreateWebAppFirewallResponse::builder).logger(LOG, "createWebAppFirewall").serviceDetails("Waf", "CreateWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/CreateWebAppFirewall").method(Method.POST).requestBuilder(CreateWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(WebAppFirewall.class, CreateWebAppFirewallResponse.Builder::webAppFirewall).handleResponseHeaderString("etag", CreateWebAppFirewallResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateWebAppFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateWebAppFirewallResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateWebAppFirewallResponse.Builder::location).handleResponseHeaderString("content-location", CreateWebAppFirewallResponse.Builder::contentLocation).callAsync(handler);
    }

    @Override
    public Future<CreateWebAppFirewallPolicyResponse> createWebAppFirewallPolicy(CreateWebAppFirewallPolicyRequest request, AsyncHandler<CreateWebAppFirewallPolicyRequest, CreateWebAppFirewallPolicyResponse> handler) {
        Objects.requireNonNull(request.getCreateWebAppFirewallPolicyDetails(), "createWebAppFirewallPolicyDetails is required");
        return this.clientCall(request, CreateWebAppFirewallPolicyResponse::builder).logger(LOG, "createWebAppFirewallPolicy").serviceDetails("Waf", "CreateWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/CreateWebAppFirewallPolicy").method(Method.POST).requestBuilder(CreateWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(WebAppFirewallPolicy.class, CreateWebAppFirewallPolicyResponse.Builder::webAppFirewallPolicy).handleResponseHeaderString("etag", CreateWebAppFirewallPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateWebAppFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateWebAppFirewallPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateWebAppFirewallPolicyResponse.Builder::location).handleResponseHeaderString("content-location", CreateWebAppFirewallPolicyResponse.Builder::contentLocation).callAsync(handler);
    }

    @Override
    public Future<DeleteNetworkAddressListResponse> deleteNetworkAddressList(DeleteNetworkAddressListRequest request, AsyncHandler<DeleteNetworkAddressListRequest, DeleteNetworkAddressListResponse> handler) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteNetworkAddressListResponse::builder).logger(LOG, "deleteNetworkAddressList").serviceDetails("Waf", "DeleteNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/DeleteNetworkAddressList").method(Method.DELETE).requestBuilder(DeleteNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteNetworkAddressListResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNetworkAddressListResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWebAppFirewallResponse> deleteWebAppFirewall(DeleteWebAppFirewallRequest request, AsyncHandler<DeleteWebAppFirewallRequest, DeleteWebAppFirewallResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWebAppFirewallResponse::builder).logger(LOG, "deleteWebAppFirewall").serviceDetails("Waf", "DeleteWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/DeleteWebAppFirewall").method(Method.DELETE).requestBuilder(DeleteWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteWebAppFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWebAppFirewallResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteWebAppFirewallPolicyResponse> deleteWebAppFirewallPolicy(DeleteWebAppFirewallPolicyRequest request, AsyncHandler<DeleteWebAppFirewallPolicyRequest, DeleteWebAppFirewallPolicyResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteWebAppFirewallPolicyResponse::builder).logger(LOG, "deleteWebAppFirewallPolicy").serviceDetails("Waf", "DeleteWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/DeleteWebAppFirewallPolicy").method(Method.DELETE).requestBuilder(DeleteWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteWebAppFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWebAppFirewallPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetNetworkAddressListResponse> getNetworkAddressList(GetNetworkAddressListRequest request, AsyncHandler<GetNetworkAddressListRequest, GetNetworkAddressListResponse> handler) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetNetworkAddressListResponse::builder).logger(LOG, "getNetworkAddressList").serviceDetails("Waf", "GetNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/GetNetworkAddressList").method(Method.GET).requestBuilder(GetNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkAddressList.class, GetNetworkAddressListResponse.Builder::networkAddressList).handleResponseHeaderString("etag", GetNetworkAddressListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkAddressListResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWebAppFirewallResponse> getWebAppFirewall(GetWebAppFirewallRequest request, AsyncHandler<GetWebAppFirewallRequest, GetWebAppFirewallResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWebAppFirewallResponse::builder).logger(LOG, "getWebAppFirewall").serviceDetails("Waf", "GetWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/GetWebAppFirewall").method(Method.GET).requestBuilder(GetWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppFirewall.class, GetWebAppFirewallResponse.Builder::webAppFirewall).handleResponseHeaderString("etag", GetWebAppFirewallResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWebAppFirewallResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWebAppFirewallPolicyResponse> getWebAppFirewallPolicy(GetWebAppFirewallPolicyRequest request, AsyncHandler<GetWebAppFirewallPolicyRequest, GetWebAppFirewallPolicyResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWebAppFirewallPolicyResponse::builder).logger(LOG, "getWebAppFirewallPolicy").serviceDetails("Waf", "GetWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/GetWebAppFirewallPolicy").method(Method.GET).requestBuilder(GetWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppFirewallPolicy.class, GetWebAppFirewallPolicyResponse.Builder::webAppFirewallPolicy).handleResponseHeaderString("etag", GetWebAppFirewallPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWebAppFirewallPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Waf", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListNetworkAddressListsResponse> listNetworkAddressLists(ListNetworkAddressListsRequest request, AsyncHandler<ListNetworkAddressListsRequest, ListNetworkAddressListsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListNetworkAddressListsResponse::builder).logger(LOG, "listNetworkAddressLists").serviceDetails("Waf", "ListNetworkAddressLists", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/ListNetworkAddressLists").method(Method.GET).requestBuilder(ListNetworkAddressListsRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(NetworkAddressListCollection.class, ListNetworkAddressListsResponse.Builder::networkAddressListCollection).handleResponseHeaderString("opc-request-id", ListNetworkAddressListsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNetworkAddressListsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProtectionCapabilitiesResponse> listProtectionCapabilities(ListProtectionCapabilitiesRequest request, AsyncHandler<ListProtectionCapabilitiesRequest, ListProtectionCapabilitiesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProtectionCapabilitiesResponse::builder).logger(LOG, "listProtectionCapabilities").serviceDetails("Waf", "ListProtectionCapabilities", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/ProtectionCapability/ListProtectionCapabilities").method(Method.GET).requestBuilder(ListProtectionCapabilitiesRequest::builder).basePath("/20210930").appendPathParam("protectionCapabilities").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("key", (Object)request.getKey()).appendListQueryParam("isLatestVersion", request.getIsLatestVersion(), CollectionFormatType.Multi).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendListQueryParam("groupTag", request.getGroupTag(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectionCapabilityCollection.class, ListProtectionCapabilitiesResponse.Builder::protectionCapabilityCollection).handleResponseHeaderString("opc-request-id", ListProtectionCapabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectionCapabilitiesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProtectionCapabilityGroupTagsResponse> listProtectionCapabilityGroupTags(ListProtectionCapabilityGroupTagsRequest request, AsyncHandler<ListProtectionCapabilityGroupTagsRequest, ListProtectionCapabilityGroupTagsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListProtectionCapabilityGroupTagsResponse::builder).logger(LOG, "listProtectionCapabilityGroupTags").serviceDetails("Waf", "ListProtectionCapabilityGroupTags", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/ProtectionCapability/ListProtectionCapabilityGroupTags").method(Method.GET).requestBuilder(ListProtectionCapabilityGroupTagsRequest::builder).basePath("/20210930").appendPathParam("protectionCapabilities").appendPathParam("groupTags").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProtectionCapabilityGroupTagCollection.class, ListProtectionCapabilityGroupTagsResponse.Builder::protectionCapabilityGroupTagCollection).handleResponseHeaderString("opc-request-id", ListProtectionCapabilityGroupTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectionCapabilityGroupTagsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWebAppFirewallPoliciesResponse> listWebAppFirewallPolicies(ListWebAppFirewallPoliciesRequest request, AsyncHandler<ListWebAppFirewallPoliciesRequest, ListWebAppFirewallPoliciesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWebAppFirewallPoliciesResponse::builder).logger(LOG, "listWebAppFirewallPolicies").serviceDetails("Waf", "ListWebAppFirewallPolicies", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/ListWebAppFirewallPolicies").method(Method.GET).requestBuilder(ListWebAppFirewallPoliciesRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppFirewallPolicyCollection.class, ListWebAppFirewallPoliciesResponse.Builder::webAppFirewallPolicyCollection).handleResponseHeaderString("opc-request-id", ListWebAppFirewallPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWebAppFirewallPoliciesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWebAppFirewallsResponse> listWebAppFirewalls(ListWebAppFirewallsRequest request, AsyncHandler<ListWebAppFirewallsRequest, ListWebAppFirewallsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWebAppFirewallsResponse::builder).logger(LOG, "listWebAppFirewalls").serviceDetails("Waf", "ListWebAppFirewalls", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/ListWebAppFirewalls").method(Method.GET).requestBuilder(ListWebAppFirewallsRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("webAppFirewallPolicyId", (Object)request.getWebAppFirewallPolicyId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WebAppFirewallCollection.class, ListWebAppFirewallsResponse.Builder::webAppFirewallCollection).handleResponseHeaderString("opc-request-id", ListWebAppFirewallsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWebAppFirewallsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Waf", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Waf", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Waf", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateNetworkAddressListResponse> updateNetworkAddressList(UpdateNetworkAddressListRequest request, AsyncHandler<UpdateNetworkAddressListRequest, UpdateNetworkAddressListResponse> handler) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkAddressListDetails(), "updateNetworkAddressListDetails is required");
        return this.clientCall(request, UpdateNetworkAddressListResponse::builder).logger(LOG, "updateNetworkAddressList").serviceDetails("Waf", "UpdateNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/UpdateNetworkAddressList").method(Method.PUT).requestBuilder(UpdateNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkAddressListResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkAddressListResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateWebAppFirewallResponse> updateWebAppFirewall(UpdateWebAppFirewallRequest request, AsyncHandler<UpdateWebAppFirewallRequest, UpdateWebAppFirewallResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWebAppFirewallDetails(), "updateWebAppFirewallDetails is required");
        return this.clientCall(request, UpdateWebAppFirewallResponse::builder).logger(LOG, "updateWebAppFirewall").serviceDetails("Waf", "UpdateWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/UpdateWebAppFirewall").method(Method.PUT).requestBuilder(UpdateWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateWebAppFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateWebAppFirewallResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateWebAppFirewallPolicyResponse> updateWebAppFirewallPolicy(UpdateWebAppFirewallPolicyRequest request, AsyncHandler<UpdateWebAppFirewallPolicyRequest, UpdateWebAppFirewallPolicyResponse> handler) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWebAppFirewallPolicyDetails(), "updateWebAppFirewallPolicyDetails is required");
        return this.clientCall(request, UpdateWebAppFirewallPolicyResponse::builder).logger(LOG, "updateWebAppFirewallPolicy").serviceDetails("Waf", "UpdateWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/UpdateWebAppFirewallPolicy").method(Method.PUT).requestBuilder(UpdateWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateWebAppFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateWebAppFirewallPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public WafAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)WafAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public WafAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(WafAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public WafAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)WafAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public WafAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)WafAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public WafAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)WafAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public WafAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)WafAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public WafAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)WafAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WafAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "waf";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"waf");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public WafAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new WafAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

