/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waf.Waf;
import com.oracle.bmc.waf.WafPaginators;
import com.oracle.bmc.waf.WafWaiters;
import com.oracle.bmc.waf.model.NetworkAddressList;
import com.oracle.bmc.waf.model.NetworkAddressListCollection;
import com.oracle.bmc.waf.model.ProtectionCapabilityCollection;
import com.oracle.bmc.waf.model.ProtectionCapabilityGroupTagCollection;
import com.oracle.bmc.waf.model.WebAppFirewall;
import com.oracle.bmc.waf.model.WebAppFirewallCollection;
import com.oracle.bmc.waf.model.WebAppFirewallPolicy;
import com.oracle.bmc.waf.model.WebAppFirewallPolicyCollection;
import com.oracle.bmc.waf.model.WorkRequest;
import com.oracle.bmc.waf.model.WorkRequestCollection;
import com.oracle.bmc.waf.model.WorkRequestErrorCollection;
import com.oracle.bmc.waf.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.waf.requests.ChangeNetworkAddressListCompartmentRequest;
import com.oracle.bmc.waf.requests.ChangeWebAppFirewallCompartmentRequest;
import com.oracle.bmc.waf.requests.ChangeWebAppFirewallPolicyCompartmentRequest;
import com.oracle.bmc.waf.requests.CreateNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.CreateWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.CreateWebAppFirewallRequest;
import com.oracle.bmc.waf.requests.DeleteNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.DeleteWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.DeleteWebAppFirewallRequest;
import com.oracle.bmc.waf.requests.GetNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.GetWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.GetWebAppFirewallRequest;
import com.oracle.bmc.waf.requests.GetWorkRequestRequest;
import com.oracle.bmc.waf.requests.ListNetworkAddressListsRequest;
import com.oracle.bmc.waf.requests.ListProtectionCapabilitiesRequest;
import com.oracle.bmc.waf.requests.ListProtectionCapabilityGroupTagsRequest;
import com.oracle.bmc.waf.requests.ListWebAppFirewallPoliciesRequest;
import com.oracle.bmc.waf.requests.ListWebAppFirewallsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.waf.requests.ListWorkRequestsRequest;
import com.oracle.bmc.waf.requests.UpdateNetworkAddressListRequest;
import com.oracle.bmc.waf.requests.UpdateWebAppFirewallPolicyRequest;
import com.oracle.bmc.waf.requests.UpdateWebAppFirewallRequest;
import com.oracle.bmc.waf.responses.ChangeNetworkAddressListCompartmentResponse;
import com.oracle.bmc.waf.responses.ChangeWebAppFirewallCompartmentResponse;
import com.oracle.bmc.waf.responses.ChangeWebAppFirewallPolicyCompartmentResponse;
import com.oracle.bmc.waf.responses.CreateNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.CreateWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.CreateWebAppFirewallResponse;
import com.oracle.bmc.waf.responses.DeleteNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.DeleteWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.DeleteWebAppFirewallResponse;
import com.oracle.bmc.waf.responses.GetNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.GetWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.GetWebAppFirewallResponse;
import com.oracle.bmc.waf.responses.GetWorkRequestResponse;
import com.oracle.bmc.waf.responses.ListNetworkAddressListsResponse;
import com.oracle.bmc.waf.responses.ListProtectionCapabilitiesResponse;
import com.oracle.bmc.waf.responses.ListProtectionCapabilityGroupTagsResponse;
import com.oracle.bmc.waf.responses.ListWebAppFirewallPoliciesResponse;
import com.oracle.bmc.waf.responses.ListWebAppFirewallsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.waf.responses.ListWorkRequestsResponse;
import com.oracle.bmc.waf.responses.UpdateNetworkAddressListResponse;
import com.oracle.bmc.waf.responses.UpdateWebAppFirewallPolicyResponse;
import com.oracle.bmc.waf.responses.UpdateWebAppFirewallResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WafClient
extends BaseSyncClient
implements Waf {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("WAF").serviceEndpointPrefix("").serviceEndpointTemplate("https://waf.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(WafClient.class);
    private final WafWaiters waiters;
    private final WafPaginators paginators;

    WafClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Waf-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new WafWaiters(executorService, this);
        this.paginators = new WafPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeNetworkAddressListCompartmentResponse changeNetworkAddressListCompartment(ChangeNetworkAddressListCompartmentRequest request) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeNetworkAddressListCompartmentDetails(), "changeNetworkAddressListCompartmentDetails is required");
        return (ChangeNetworkAddressListCompartmentResponse)this.clientCall(request, ChangeNetworkAddressListCompartmentResponse::builder).logger(LOG, "changeNetworkAddressListCompartment").serviceDetails("Waf", "ChangeNetworkAddressListCompartment", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/ChangeNetworkAddressListCompartment").method(Method.POST).requestBuilder(ChangeNetworkAddressListCompartmentRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeNetworkAddressListCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeNetworkAddressListCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeWebAppFirewallCompartmentResponse changeWebAppFirewallCompartment(ChangeWebAppFirewallCompartmentRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeWebAppFirewallCompartmentDetails(), "changeWebAppFirewallCompartmentDetails is required");
        return (ChangeWebAppFirewallCompartmentResponse)this.clientCall(request, ChangeWebAppFirewallCompartmentResponse::builder).logger(LOG, "changeWebAppFirewallCompartment").serviceDetails("Waf", "ChangeWebAppFirewallCompartment", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/ChangeWebAppFirewallCompartment").method(Method.POST).requestBuilder(ChangeWebAppFirewallCompartmentRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeWebAppFirewallCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeWebAppFirewallCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeWebAppFirewallPolicyCompartmentResponse changeWebAppFirewallPolicyCompartment(ChangeWebAppFirewallPolicyCompartmentRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeWebAppFirewallPolicyCompartmentDetails(), "changeWebAppFirewallPolicyCompartmentDetails is required");
        return (ChangeWebAppFirewallPolicyCompartmentResponse)this.clientCall(request, ChangeWebAppFirewallPolicyCompartmentResponse::builder).logger(LOG, "changeWebAppFirewallPolicyCompartment").serviceDetails("Waf", "ChangeWebAppFirewallPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/ChangeWebAppFirewallPolicyCompartment").method(Method.POST).requestBuilder(ChangeWebAppFirewallPolicyCompartmentRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeWebAppFirewallPolicyCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeWebAppFirewallPolicyCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateNetworkAddressListResponse createNetworkAddressList(CreateNetworkAddressListRequest request) {
        Objects.requireNonNull(request.getCreateNetworkAddressListDetails(), "createNetworkAddressListDetails is required");
        return (CreateNetworkAddressListResponse)this.clientCall(request, CreateNetworkAddressListResponse::builder).logger(LOG, "createNetworkAddressList").serviceDetails("Waf", "CreateNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/CreateNetworkAddressList").method(Method.POST).requestBuilder(CreateNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(NetworkAddressList.class, CreateNetworkAddressListResponse.Builder::networkAddressList).handleResponseHeaderString("etag", CreateNetworkAddressListResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateNetworkAddressListResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateNetworkAddressListResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateNetworkAddressListResponse.Builder::location).handleResponseHeaderString("content-location", CreateNetworkAddressListResponse.Builder::contentLocation).callSync();
    }

    @Override
    public CreateWebAppFirewallResponse createWebAppFirewall(CreateWebAppFirewallRequest request) {
        Objects.requireNonNull(request.getCreateWebAppFirewallDetails(), "createWebAppFirewallDetails is required");
        return (CreateWebAppFirewallResponse)this.clientCall(request, CreateWebAppFirewallResponse::builder).logger(LOG, "createWebAppFirewall").serviceDetails("Waf", "CreateWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/CreateWebAppFirewall").method(Method.POST).requestBuilder(CreateWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(WebAppFirewall.class, CreateWebAppFirewallResponse.Builder::webAppFirewall).handleResponseHeaderString("etag", CreateWebAppFirewallResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateWebAppFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateWebAppFirewallResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateWebAppFirewallResponse.Builder::location).handleResponseHeaderString("content-location", CreateWebAppFirewallResponse.Builder::contentLocation).callSync();
    }

    @Override
    public CreateWebAppFirewallPolicyResponse createWebAppFirewallPolicy(CreateWebAppFirewallPolicyRequest request) {
        Objects.requireNonNull(request.getCreateWebAppFirewallPolicyDetails(), "createWebAppFirewallPolicyDetails is required");
        return (CreateWebAppFirewallPolicyResponse)this.clientCall(request, CreateWebAppFirewallPolicyResponse::builder).logger(LOG, "createWebAppFirewallPolicy").serviceDetails("Waf", "CreateWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/CreateWebAppFirewallPolicy").method(Method.POST).requestBuilder(CreateWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(WebAppFirewallPolicy.class, CreateWebAppFirewallPolicyResponse.Builder::webAppFirewallPolicy).handleResponseHeaderString("etag", CreateWebAppFirewallPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateWebAppFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateWebAppFirewallPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateWebAppFirewallPolicyResponse.Builder::location).handleResponseHeaderString("content-location", CreateWebAppFirewallPolicyResponse.Builder::contentLocation).callSync();
    }

    @Override
    public DeleteNetworkAddressListResponse deleteNetworkAddressList(DeleteNetworkAddressListRequest request) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        return (DeleteNetworkAddressListResponse)this.clientCall(request, DeleteNetworkAddressListResponse::builder).logger(LOG, "deleteNetworkAddressList").serviceDetails("Waf", "DeleteNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/DeleteNetworkAddressList").method(Method.DELETE).requestBuilder(DeleteNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteNetworkAddressListResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteNetworkAddressListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteWebAppFirewallResponse deleteWebAppFirewall(DeleteWebAppFirewallRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        return (DeleteWebAppFirewallResponse)this.clientCall(request, DeleteWebAppFirewallResponse::builder).logger(LOG, "deleteWebAppFirewall").serviceDetails("Waf", "DeleteWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/DeleteWebAppFirewall").method(Method.DELETE).requestBuilder(DeleteWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteWebAppFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWebAppFirewallResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteWebAppFirewallPolicyResponse deleteWebAppFirewallPolicy(DeleteWebAppFirewallPolicyRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteWebAppFirewallPolicyResponse)this.clientCall(request, DeleteWebAppFirewallPolicyResponse::builder).logger(LOG, "deleteWebAppFirewallPolicy").serviceDetails("Waf", "DeleteWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/DeleteWebAppFirewallPolicy").method(Method.DELETE).requestBuilder(DeleteWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteWebAppFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteWebAppFirewallPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetNetworkAddressListResponse getNetworkAddressList(GetNetworkAddressListRequest request) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        return (GetNetworkAddressListResponse)this.clientCall(request, GetNetworkAddressListResponse::builder).logger(LOG, "getNetworkAddressList").serviceDetails("Waf", "GetNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/GetNetworkAddressList").method(Method.GET).requestBuilder(GetNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(NetworkAddressList.class, GetNetworkAddressListResponse.Builder::networkAddressList).handleResponseHeaderString("etag", GetNetworkAddressListResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetNetworkAddressListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWebAppFirewallResponse getWebAppFirewall(GetWebAppFirewallRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        return (GetWebAppFirewallResponse)this.clientCall(request, GetWebAppFirewallResponse::builder).logger(LOG, "getWebAppFirewall").serviceDetails("Waf", "GetWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/GetWebAppFirewall").method(Method.GET).requestBuilder(GetWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WebAppFirewall.class, GetWebAppFirewallResponse.Builder::webAppFirewall).handleResponseHeaderString("etag", GetWebAppFirewallResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWebAppFirewallResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWebAppFirewallPolicyResponse getWebAppFirewallPolicy(GetWebAppFirewallPolicyRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        return (GetWebAppFirewallPolicyResponse)this.clientCall(request, GetWebAppFirewallPolicyResponse::builder).logger(LOG, "getWebAppFirewallPolicy").serviceDetails("Waf", "GetWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/GetWebAppFirewallPolicy").method(Method.GET).requestBuilder(GetWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WebAppFirewallPolicy.class, GetWebAppFirewallPolicyResponse.Builder::webAppFirewallPolicy).handleResponseHeaderString("etag", GetWebAppFirewallPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWebAppFirewallPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Waf", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListNetworkAddressListsResponse listNetworkAddressLists(ListNetworkAddressListsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListNetworkAddressListsResponse)this.clientCall(request, ListNetworkAddressListsResponse::builder).logger(LOG, "listNetworkAddressLists").serviceDetails("Waf", "ListNetworkAddressLists", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/ListNetworkAddressLists").method(Method.GET).requestBuilder(ListNetworkAddressListsRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(NetworkAddressListCollection.class, ListNetworkAddressListsResponse.Builder::networkAddressListCollection).handleResponseHeaderString("opc-request-id", ListNetworkAddressListsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListNetworkAddressListsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProtectionCapabilitiesResponse listProtectionCapabilities(ListProtectionCapabilitiesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProtectionCapabilitiesResponse)this.clientCall(request, ListProtectionCapabilitiesResponse::builder).logger(LOG, "listProtectionCapabilities").serviceDetails("Waf", "ListProtectionCapabilities", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/ProtectionCapability/ListProtectionCapabilities").method(Method.GET).requestBuilder(ListProtectionCapabilitiesRequest::builder).basePath("/20210930").appendPathParam("protectionCapabilities").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("key", (Object)request.getKey()).appendListQueryParam("isLatestVersion", request.getIsLatestVersion(), CollectionFormatType.Multi).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendListQueryParam("groupTag", request.getGroupTag(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProtectionCapabilityCollection.class, ListProtectionCapabilitiesResponse.Builder::protectionCapabilityCollection).handleResponseHeaderString("opc-request-id", ListProtectionCapabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectionCapabilitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProtectionCapabilityGroupTagsResponse listProtectionCapabilityGroupTags(ListProtectionCapabilityGroupTagsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProtectionCapabilityGroupTagsResponse)this.clientCall(request, ListProtectionCapabilityGroupTagsResponse::builder).logger(LOG, "listProtectionCapabilityGroupTags").serviceDetails("Waf", "ListProtectionCapabilityGroupTags", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/ProtectionCapability/ListProtectionCapabilityGroupTags").method(Method.GET).requestBuilder(ListProtectionCapabilityGroupTagsRequest::builder).basePath("/20210930").appendPathParam("protectionCapabilities").appendPathParam("groupTags").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProtectionCapabilityGroupTagCollection.class, ListProtectionCapabilityGroupTagsResponse.Builder::protectionCapabilityGroupTagCollection).handleResponseHeaderString("opc-request-id", ListProtectionCapabilityGroupTagsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectionCapabilityGroupTagsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWebAppFirewallPoliciesResponse listWebAppFirewallPolicies(ListWebAppFirewallPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWebAppFirewallPoliciesResponse)this.clientCall(request, ListWebAppFirewallPoliciesResponse::builder).logger(LOG, "listWebAppFirewallPolicies").serviceDetails("Waf", "ListWebAppFirewallPolicies", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/ListWebAppFirewallPolicies").method(Method.GET).requestBuilder(ListWebAppFirewallPoliciesRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WebAppFirewallPolicyCollection.class, ListWebAppFirewallPoliciesResponse.Builder::webAppFirewallPolicyCollection).handleResponseHeaderString("opc-request-id", ListWebAppFirewallPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWebAppFirewallPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWebAppFirewallsResponse listWebAppFirewalls(ListWebAppFirewallsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWebAppFirewallsResponse)this.clientCall(request, ListWebAppFirewallsResponse::builder).logger(LOG, "listWebAppFirewalls").serviceDetails("Waf", "ListWebAppFirewalls", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/ListWebAppFirewalls").method(Method.GET).requestBuilder(ListWebAppFirewallsRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("webAppFirewallPolicyId", (Object)request.getWebAppFirewallPolicyId()).appendListQueryParam("lifecycleState", request.getLifecycleState(), CollectionFormatType.Multi).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WebAppFirewallCollection.class, ListWebAppFirewallsResponse.Builder::webAppFirewallCollection).handleResponseHeaderString("opc-request-id", ListWebAppFirewallsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWebAppFirewallsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Waf", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Waf", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Waf", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210930").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateNetworkAddressListResponse updateNetworkAddressList(UpdateNetworkAddressListRequest request) {
        Validate.notBlank((String)request.getNetworkAddressListId(), (String)"networkAddressListId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNetworkAddressListDetails(), "updateNetworkAddressListDetails is required");
        return (UpdateNetworkAddressListResponse)this.clientCall(request, UpdateNetworkAddressListResponse::builder).logger(LOG, "updateNetworkAddressList").serviceDetails("Waf", "UpdateNetworkAddressList", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/NetworkAddressList/UpdateNetworkAddressList").method(Method.PUT).requestBuilder(UpdateNetworkAddressListRequest::builder).basePath("/20210930").appendPathParam("networkAddressLists").appendPathParam(request.getNetworkAddressListId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateNetworkAddressListResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateNetworkAddressListResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateWebAppFirewallResponse updateWebAppFirewall(UpdateWebAppFirewallRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallId(), (String)"webAppFirewallId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWebAppFirewallDetails(), "updateWebAppFirewallDetails is required");
        return (UpdateWebAppFirewallResponse)this.clientCall(request, UpdateWebAppFirewallResponse::builder).logger(LOG, "updateWebAppFirewall").serviceDetails("Waf", "UpdateWebAppFirewall", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewall/UpdateWebAppFirewall").method(Method.PUT).requestBuilder(UpdateWebAppFirewallRequest::builder).basePath("/20210930").appendPathParam("webAppFirewalls").appendPathParam(request.getWebAppFirewallId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateWebAppFirewallResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateWebAppFirewallResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateWebAppFirewallPolicyResponse updateWebAppFirewallPolicy(UpdateWebAppFirewallPolicyRequest request) {
        Validate.notBlank((String)request.getWebAppFirewallPolicyId(), (String)"webAppFirewallPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateWebAppFirewallPolicyDetails(), "updateWebAppFirewallPolicyDetails is required");
        return (UpdateWebAppFirewallPolicyResponse)this.clientCall(request, UpdateWebAppFirewallPolicyResponse::builder).logger(LOG, "updateWebAppFirewallPolicy").serviceDetails("Waf", "UpdateWebAppFirewallPolicy", "https://docs.oracle.com/iaas/api/#/en/waf/20210930/WebAppFirewallPolicy/UpdateWebAppFirewallPolicy").method(Method.PUT).requestBuilder(UpdateWebAppFirewallPolicyRequest::builder).basePath("/20210930").appendPathParam("webAppFirewallPolicies").appendPathParam(request.getWebAppFirewallPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateWebAppFirewallPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateWebAppFirewallPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public WafWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public WafPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public WafClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)WafClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WafClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(WafClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WafClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)WafClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public WafClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)WafClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WafClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)WafClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WafClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)WafClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WafClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)WafClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public WafClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)WafClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, WafClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "waf";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"waf");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public WafClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new WafClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

