/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProtectionCapabilitySettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="maxNumberOfArguments")
    private final Integer maxNumberOfArguments;
    @JsonProperty(value="maxSingleArgumentLength")
    private final Integer maxSingleArgumentLength;
    @JsonProperty(value="maxTotalArgumentLength")
    private final Integer maxTotalArgumentLength;
    @JsonProperty(value="maxHttpRequestHeaders")
    private final Integer maxHttpRequestHeaders;
    @JsonProperty(value="maxHttpRequestHeaderLength")
    private final Integer maxHttpRequestHeaderLength;
    @JsonProperty(value="allowedHttpMethods")
    private final List<String> allowedHttpMethods;

    @Deprecated
    @ConstructorProperties(value={"maxNumberOfArguments", "maxSingleArgumentLength", "maxTotalArgumentLength", "maxHttpRequestHeaders", "maxHttpRequestHeaderLength", "allowedHttpMethods"})
    public ProtectionCapabilitySettings(Integer maxNumberOfArguments, Integer maxSingleArgumentLength, Integer maxTotalArgumentLength, Integer maxHttpRequestHeaders, Integer maxHttpRequestHeaderLength, List<String> allowedHttpMethods) {
        this.maxNumberOfArguments = maxNumberOfArguments;
        this.maxSingleArgumentLength = maxSingleArgumentLength;
        this.maxTotalArgumentLength = maxTotalArgumentLength;
        this.maxHttpRequestHeaders = maxHttpRequestHeaders;
        this.maxHttpRequestHeaderLength = maxHttpRequestHeaderLength;
        this.allowedHttpMethods = allowedHttpMethods;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getMaxNumberOfArguments() {
        return this.maxNumberOfArguments;
    }

    public Integer getMaxSingleArgumentLength() {
        return this.maxSingleArgumentLength;
    }

    public Integer getMaxTotalArgumentLength() {
        return this.maxTotalArgumentLength;
    }

    public Integer getMaxHttpRequestHeaders() {
        return this.maxHttpRequestHeaders;
    }

    public Integer getMaxHttpRequestHeaderLength() {
        return this.maxHttpRequestHeaderLength;
    }

    public List<String> getAllowedHttpMethods() {
        return this.allowedHttpMethods;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProtectionCapabilitySettings(");
        sb.append("super=").append(super.toString());
        sb.append("maxNumberOfArguments=").append(String.valueOf(this.maxNumberOfArguments));
        sb.append(", maxSingleArgumentLength=").append(String.valueOf(this.maxSingleArgumentLength));
        sb.append(", maxTotalArgumentLength=").append(String.valueOf(this.maxTotalArgumentLength));
        sb.append(", maxHttpRequestHeaders=").append(String.valueOf(this.maxHttpRequestHeaders));
        sb.append(", maxHttpRequestHeaderLength=").append(String.valueOf(this.maxHttpRequestHeaderLength));
        sb.append(", allowedHttpMethods=").append(String.valueOf(this.allowedHttpMethods));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtectionCapabilitySettings)) {
            return false;
        }
        ProtectionCapabilitySettings other = (ProtectionCapabilitySettings)((Object)o);
        return Objects.equals(this.maxNumberOfArguments, other.maxNumberOfArguments) && Objects.equals(this.maxSingleArgumentLength, other.maxSingleArgumentLength) && Objects.equals(this.maxTotalArgumentLength, other.maxTotalArgumentLength) && Objects.equals(this.maxHttpRequestHeaders, other.maxHttpRequestHeaders) && Objects.equals(this.maxHttpRequestHeaderLength, other.maxHttpRequestHeaderLength) && Objects.equals(this.allowedHttpMethods, other.allowedHttpMethods) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.maxNumberOfArguments == null ? 43 : this.maxNumberOfArguments.hashCode());
        result = result * 59 + (this.maxSingleArgumentLength == null ? 43 : this.maxSingleArgumentLength.hashCode());
        result = result * 59 + (this.maxTotalArgumentLength == null ? 43 : this.maxTotalArgumentLength.hashCode());
        result = result * 59 + (this.maxHttpRequestHeaders == null ? 43 : this.maxHttpRequestHeaders.hashCode());
        result = result * 59 + (this.maxHttpRequestHeaderLength == null ? 43 : this.maxHttpRequestHeaderLength.hashCode());
        result = result * 59 + (this.allowedHttpMethods == null ? 43 : this.allowedHttpMethods.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="maxNumberOfArguments")
        private Integer maxNumberOfArguments;
        @JsonProperty(value="maxSingleArgumentLength")
        private Integer maxSingleArgumentLength;
        @JsonProperty(value="maxTotalArgumentLength")
        private Integer maxTotalArgumentLength;
        @JsonProperty(value="maxHttpRequestHeaders")
        private Integer maxHttpRequestHeaders;
        @JsonProperty(value="maxHttpRequestHeaderLength")
        private Integer maxHttpRequestHeaderLength;
        @JsonProperty(value="allowedHttpMethods")
        private List<String> allowedHttpMethods;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder maxNumberOfArguments(Integer maxNumberOfArguments) {
            this.maxNumberOfArguments = maxNumberOfArguments;
            this.__explicitlySet__.add("maxNumberOfArguments");
            return this;
        }

        public Builder maxSingleArgumentLength(Integer maxSingleArgumentLength) {
            this.maxSingleArgumentLength = maxSingleArgumentLength;
            this.__explicitlySet__.add("maxSingleArgumentLength");
            return this;
        }

        public Builder maxTotalArgumentLength(Integer maxTotalArgumentLength) {
            this.maxTotalArgumentLength = maxTotalArgumentLength;
            this.__explicitlySet__.add("maxTotalArgumentLength");
            return this;
        }

        public Builder maxHttpRequestHeaders(Integer maxHttpRequestHeaders) {
            this.maxHttpRequestHeaders = maxHttpRequestHeaders;
            this.__explicitlySet__.add("maxHttpRequestHeaders");
            return this;
        }

        public Builder maxHttpRequestHeaderLength(Integer maxHttpRequestHeaderLength) {
            this.maxHttpRequestHeaderLength = maxHttpRequestHeaderLength;
            this.__explicitlySet__.add("maxHttpRequestHeaderLength");
            return this;
        }

        public Builder allowedHttpMethods(List<String> allowedHttpMethods) {
            this.allowedHttpMethods = allowedHttpMethods;
            this.__explicitlySet__.add("allowedHttpMethods");
            return this;
        }

        public ProtectionCapabilitySettings build() {
            ProtectionCapabilitySettings model = new ProtectionCapabilitySettings(this.maxNumberOfArguments, this.maxSingleArgumentLength, this.maxTotalArgumentLength, this.maxHttpRequestHeaders, this.maxHttpRequestHeaderLength, this.allowedHttpMethods);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProtectionCapabilitySettings model) {
            if (model.wasPropertyExplicitlySet("maxNumberOfArguments")) {
                this.maxNumberOfArguments(model.getMaxNumberOfArguments());
            }
            if (model.wasPropertyExplicitlySet("maxSingleArgumentLength")) {
                this.maxSingleArgumentLength(model.getMaxSingleArgumentLength());
            }
            if (model.wasPropertyExplicitlySet("maxTotalArgumentLength")) {
                this.maxTotalArgumentLength(model.getMaxTotalArgumentLength());
            }
            if (model.wasPropertyExplicitlySet("maxHttpRequestHeaders")) {
                this.maxHttpRequestHeaders(model.getMaxHttpRequestHeaders());
            }
            if (model.wasPropertyExplicitlySet("maxHttpRequestHeaderLength")) {
                this.maxHttpRequestHeaderLength(model.getMaxHttpRequestHeaderLength());
            }
            if (model.wasPropertyExplicitlySet("allowedHttpMethods")) {
                this.allowedHttpMethods(model.getAllowedHttpMethods());
            }
            return this;
        }
    }
}

