/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waf.model.CollaborativeCapabilityWeight;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProtectionCapabilitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="version")
    private final Integer version;
    @JsonProperty(value="isLatestVersion")
    private final Boolean isLatestVersion;
    @JsonProperty(value="groupTags")
    private final List<String> groupTags;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="collaborativeActionThreshold")
    private final Integer collaborativeActionThreshold;
    @JsonProperty(value="collaborativeWeights")
    private final List<CollaborativeCapabilityWeight> collaborativeWeights;

    @Deprecated
    @ConstructorProperties(value={"key", "displayName", "description", "version", "isLatestVersion", "groupTags", "type", "collaborativeActionThreshold", "collaborativeWeights"})
    public ProtectionCapabilitySummary(String key, String displayName, String description, Integer version, Boolean isLatestVersion, List<String> groupTags, Type type, Integer collaborativeActionThreshold, List<CollaborativeCapabilityWeight> collaborativeWeights) {
        this.key = key;
        this.displayName = displayName;
        this.description = description;
        this.version = version;
        this.isLatestVersion = isLatestVersion;
        this.groupTags = groupTags;
        this.type = type;
        this.collaborativeActionThreshold = collaborativeActionThreshold;
        this.collaborativeWeights = collaborativeWeights;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Boolean getIsLatestVersion() {
        return this.isLatestVersion;
    }

    public List<String> getGroupTags() {
        return this.groupTags;
    }

    public Type getType() {
        return this.type;
    }

    public Integer getCollaborativeActionThreshold() {
        return this.collaborativeActionThreshold;
    }

    public List<CollaborativeCapabilityWeight> getCollaborativeWeights() {
        return this.collaborativeWeights;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProtectionCapabilitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", isLatestVersion=").append(String.valueOf(this.isLatestVersion));
        sb.append(", groupTags=").append(String.valueOf(this.groupTags));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", collaborativeActionThreshold=").append(String.valueOf(this.collaborativeActionThreshold));
        sb.append(", collaborativeWeights=").append(String.valueOf(this.collaborativeWeights));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProtectionCapabilitySummary)) {
            return false;
        }
        ProtectionCapabilitySummary other = (ProtectionCapabilitySummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.version, other.version) && Objects.equals(this.isLatestVersion, other.isLatestVersion) && Objects.equals(this.groupTags, other.groupTags) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.collaborativeActionThreshold, other.collaborativeActionThreshold) && Objects.equals(this.collaborativeWeights, other.collaborativeWeights) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.isLatestVersion == null ? 43 : this.isLatestVersion.hashCode());
        result = result * 59 + (this.groupTags == null ? 43 : this.groupTags.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.collaborativeActionThreshold == null ? 43 : this.collaborativeActionThreshold.hashCode());
        result = result * 59 + (this.collaborativeWeights == null ? 43 : this.collaborativeWeights.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        RequestProtectionCapability("REQUEST_PROTECTION_CAPABILITY"),
        ResponseProtectionCapability("RESPONSE_PROTECTION_CAPABILITY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="version")
        private Integer version;
        @JsonProperty(value="isLatestVersion")
        private Boolean isLatestVersion;
        @JsonProperty(value="groupTags")
        private List<String> groupTags;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="collaborativeActionThreshold")
        private Integer collaborativeActionThreshold;
        @JsonProperty(value="collaborativeWeights")
        private List<CollaborativeCapabilityWeight> collaborativeWeights;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder isLatestVersion(Boolean isLatestVersion) {
            this.isLatestVersion = isLatestVersion;
            this.__explicitlySet__.add("isLatestVersion");
            return this;
        }

        public Builder groupTags(List<String> groupTags) {
            this.groupTags = groupTags;
            this.__explicitlySet__.add("groupTags");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder collaborativeActionThreshold(Integer collaborativeActionThreshold) {
            this.collaborativeActionThreshold = collaborativeActionThreshold;
            this.__explicitlySet__.add("collaborativeActionThreshold");
            return this;
        }

        public Builder collaborativeWeights(List<CollaborativeCapabilityWeight> collaborativeWeights) {
            this.collaborativeWeights = collaborativeWeights;
            this.__explicitlySet__.add("collaborativeWeights");
            return this;
        }

        public ProtectionCapabilitySummary build() {
            ProtectionCapabilitySummary model = new ProtectionCapabilitySummary(this.key, this.displayName, this.description, this.version, this.isLatestVersion, this.groupTags, this.type, this.collaborativeActionThreshold, this.collaborativeWeights);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProtectionCapabilitySummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("isLatestVersion")) {
                this.isLatestVersion(model.getIsLatestVersion());
            }
            if (model.wasPropertyExplicitlySet("groupTags")) {
                this.groupTags(model.getGroupTags());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("collaborativeActionThreshold")) {
                this.collaborativeActionThreshold(model.getCollaborativeActionThreshold());
            }
            if (model.wasPropertyExplicitlySet("collaborativeWeights")) {
                this.collaborativeWeights(model.getCollaborativeWeights());
            }
            return this;
        }
    }
}

