/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.waf.model.Action;
import com.oracle.bmc.waf.model.HttpResponseBody;
import com.oracle.bmc.waf.model.ResponseHeader;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ReturnHttpResponseAction
extends Action {
    @JsonProperty(value="code")
    private final Integer code;
    @JsonProperty(value="headers")
    private final List<ResponseHeader> headers;
    @JsonProperty(value="body")
    private final HttpResponseBody body;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ReturnHttpResponseAction(String name, Integer code, List<ResponseHeader> headers, HttpResponseBody body) {
        super(name);
        this.code = code;
        this.headers = headers;
        this.body = body;
    }

    public Integer getCode() {
        return this.code;
    }

    public List<ResponseHeader> getHeaders() {
        return this.headers;
    }

    public HttpResponseBody getBody() {
        return this.body;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReturnHttpResponseAction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", code=").append(String.valueOf(this.code));
        sb.append(", headers=").append(String.valueOf(this.headers));
        sb.append(", body=").append(String.valueOf((Object)this.body));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReturnHttpResponseAction)) {
            return false;
        }
        ReturnHttpResponseAction other = (ReturnHttpResponseAction)((Object)o);
        return Objects.equals(this.code, other.code) && Objects.equals(this.headers, other.headers) && Objects.equals((Object)this.body, (Object)other.body) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.code == null ? 43 : this.code.hashCode());
        result = result * 59 + (this.headers == null ? 43 : this.headers.hashCode());
        result = result * 59 + (this.body == null ? 43 : this.body.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="code")
        private Integer code;
        @JsonProperty(value="headers")
        private List<ResponseHeader> headers;
        @JsonProperty(value="body")
        private HttpResponseBody body;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder code(Integer code) {
            this.code = code;
            this.__explicitlySet__.add("code");
            return this;
        }

        public Builder headers(List<ResponseHeader> headers) {
            this.headers = headers;
            this.__explicitlySet__.add("headers");
            return this;
        }

        public Builder body(HttpResponseBody body) {
            this.body = body;
            this.__explicitlySet__.add("body");
            return this;
        }

        public ReturnHttpResponseAction build() {
            ReturnHttpResponseAction model = new ReturnHttpResponseAction(this.name, this.code, this.headers, this.body);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReturnHttpResponseAction model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("code")) {
                this.code(model.getCode());
            }
            if (model.wasPropertyExplicitlySet("headers")) {
                this.headers(model.getHeaders());
            }
            if (model.wasPropertyExplicitlySet("body")) {
                this.body(model.getBody());
            }
            return this;
        }
    }
}

