/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waf.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.waf.model.AccessControlRule;
import com.oracle.bmc.waf.model.ProtectionRule;
import com.oracle.bmc.waf.model.RequestRateLimitingRule;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=WebAppFirewallPolicyRule.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ProtectionRule.class, name="PROTECTION"), @JsonSubTypes.Type(value=RequestRateLimitingRule.class, name="REQUEST_RATE_LIMITING"), @JsonSubTypes.Type(value=AccessControlRule.class, name="ACCESS_CONTROL")})
@JsonFilter(value="explicitlySetFilter")
public class WebAppFirewallPolicyRule
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="conditionLanguage")
    private final ConditionLanguage conditionLanguage;
    @JsonProperty(value="condition")
    private final String condition;
    @JsonProperty(value="actionName")
    private final String actionName;

    @Deprecated
    @ConstructorProperties(value={"name", "conditionLanguage", "condition", "actionName"})
    protected WebAppFirewallPolicyRule(String name, ConditionLanguage conditionLanguage, String condition, String actionName) {
        this.name = name;
        this.conditionLanguage = conditionLanguage;
        this.condition = condition;
        this.actionName = actionName;
    }

    public String getName() {
        return this.name;
    }

    public ConditionLanguage getConditionLanguage() {
        return this.conditionLanguage;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WebAppFirewallPolicyRule(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", conditionLanguage=").append(String.valueOf((Object)this.conditionLanguage));
        sb.append(", condition=").append(String.valueOf(this.condition));
        sb.append(", actionName=").append(String.valueOf(this.actionName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebAppFirewallPolicyRule)) {
            return false;
        }
        WebAppFirewallPolicyRule other = (WebAppFirewallPolicyRule)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.conditionLanguage, (Object)other.conditionLanguage) && Objects.equals(this.condition, other.condition) && Objects.equals(this.actionName, other.actionName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.conditionLanguage == null ? 43 : this.conditionLanguage.hashCode());
        result = result * 59 + (this.condition == null ? 43 : this.condition.hashCode());
        result = result * 59 + (this.actionName == null ? 43 : this.actionName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        AccessControl("ACCESS_CONTROL"),
        Protection("PROTECTION"),
        RequestRateLimiting("REQUEST_RATE_LIMITING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ConditionLanguage implements BmcEnum
    {
        Jmespath("JMESPATH"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConditionLanguage> map;

        private ConditionLanguage(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConditionLanguage create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConditionLanguage', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConditionLanguage.class);
            map = new HashMap<String, ConditionLanguage>();
            for (ConditionLanguage v : ConditionLanguage.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

