/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.zpr;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.zpr.Zpr;
import com.oracle.bmc.zpr.ZprPaginators;
import com.oracle.bmc.zpr.ZprWaiters;
import com.oracle.bmc.zpr.model.Configuration;
import com.oracle.bmc.zpr.model.WorkRequest;
import com.oracle.bmc.zpr.model.WorkRequestErrorCollection;
import com.oracle.bmc.zpr.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.zpr.model.WorkRequestSummaryCollection;
import com.oracle.bmc.zpr.model.ZprPolicy;
import com.oracle.bmc.zpr.model.ZprPolicyCollection;
import com.oracle.bmc.zpr.requests.CreateConfigurationRequest;
import com.oracle.bmc.zpr.requests.CreateZprPolicyRequest;
import com.oracle.bmc.zpr.requests.DeleteZprPolicyRequest;
import com.oracle.bmc.zpr.requests.GetConfigurationRequest;
import com.oracle.bmc.zpr.requests.GetZprConfigurationWorkRequestRequest;
import com.oracle.bmc.zpr.requests.GetZprPolicyRequest;
import com.oracle.bmc.zpr.requests.GetZprPolicyWorkRequestRequest;
import com.oracle.bmc.zpr.requests.ListZprConfigurationWorkRequestErrorsRequest;
import com.oracle.bmc.zpr.requests.ListZprConfigurationWorkRequestLogsRequest;
import com.oracle.bmc.zpr.requests.ListZprConfigurationWorkRequestsRequest;
import com.oracle.bmc.zpr.requests.ListZprPoliciesRequest;
import com.oracle.bmc.zpr.requests.ListZprPolicyWorkRequestErrorsRequest;
import com.oracle.bmc.zpr.requests.ListZprPolicyWorkRequestLogsRequest;
import com.oracle.bmc.zpr.requests.ListZprPolicyWorkRequestsRequest;
import com.oracle.bmc.zpr.requests.UpdateZprPolicyRequest;
import com.oracle.bmc.zpr.responses.CreateConfigurationResponse;
import com.oracle.bmc.zpr.responses.CreateZprPolicyResponse;
import com.oracle.bmc.zpr.responses.DeleteZprPolicyResponse;
import com.oracle.bmc.zpr.responses.GetConfigurationResponse;
import com.oracle.bmc.zpr.responses.GetZprConfigurationWorkRequestResponse;
import com.oracle.bmc.zpr.responses.GetZprPolicyResponse;
import com.oracle.bmc.zpr.responses.GetZprPolicyWorkRequestResponse;
import com.oracle.bmc.zpr.responses.ListZprConfigurationWorkRequestErrorsResponse;
import com.oracle.bmc.zpr.responses.ListZprConfigurationWorkRequestLogsResponse;
import com.oracle.bmc.zpr.responses.ListZprConfigurationWorkRequestsResponse;
import com.oracle.bmc.zpr.responses.ListZprPoliciesResponse;
import com.oracle.bmc.zpr.responses.ListZprPolicyWorkRequestErrorsResponse;
import com.oracle.bmc.zpr.responses.ListZprPolicyWorkRequestLogsResponse;
import com.oracle.bmc.zpr.responses.ListZprPolicyWorkRequestsResponse;
import com.oracle.bmc.zpr.responses.UpdateZprPolicyResponse;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZprClient
extends BaseSyncClient
implements Zpr {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("ZPR").serviceEndpointPrefix("").serviceEndpointTemplate("https://zpr.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ZprClient.class);
    private final ZprWaiters waiters;
    private final ZprPaginators paginators;

    ZprClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Zpr-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ZprWaiters(executorService, this);
        this.paginators = new ZprPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateConfigurationResponse createConfiguration(CreateConfigurationRequest request) {
        Objects.requireNonNull(request.getCreateConfigurationDetails(), "createConfigurationDetails is required");
        return (CreateConfigurationResponse)this.clientCall(request, CreateConfigurationResponse::builder).logger(LOG, "createConfiguration").serviceDetails("Zpr", "CreateConfiguration", "").method(Method.POST).requestBuilder(CreateConfigurationRequest::builder).basePath("/20240301").appendPathParam("configuration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-dry-run", request.getOpcDryRun()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", CreateConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateConfigurationResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateZprPolicyResponse createZprPolicy(CreateZprPolicyRequest request) {
        Objects.requireNonNull(request.getCreateZprPolicyDetails(), "createZprPolicyDetails is required");
        return (CreateZprPolicyResponse)this.clientCall(request, CreateZprPolicyResponse::builder).logger(LOG, "createZprPolicy").serviceDetails("Zpr", "CreateZprPolicy", "").method(Method.POST).requestBuilder(CreateZprPolicyRequest::builder).basePath("/20240301").appendPathParam("zprPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-dry-run", request.getOpcDryRun()).operationUsesDefaultRetries().hasBody().handleBody(ZprPolicy.class, CreateZprPolicyResponse.Builder::zprPolicy).handleResponseHeaderString("location", CreateZprPolicyResponse.Builder::location).handleResponseHeaderString("content-location", CreateZprPolicyResponse.Builder::contentLocation).handleResponseHeaderString("opc-request-id", CreateZprPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateZprPolicyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteZprPolicyResponse deleteZprPolicy(DeleteZprPolicyRequest request) {
        Validate.notBlank((String)request.getZprPolicyId(), (String)"zprPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteZprPolicyResponse)this.clientCall(request, DeleteZprPolicyResponse::builder).logger(LOG, "deleteZprPolicy").serviceDetails("Zpr", "DeleteZprPolicy", "").method(Method.DELETE).requestBuilder(DeleteZprPolicyRequest::builder).basePath("/20240301").appendPathParam("zprPolicies").appendPathParam(request.getZprPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-dry-run", request.getOpcDryRun()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteZprPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteZprPolicyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetConfigurationResponse getConfiguration(GetConfigurationRequest request) {
        return (GetConfigurationResponse)this.clientCall(request, GetConfigurationResponse::builder).logger(LOG, "getConfiguration").serviceDetails("Zpr", "GetConfiguration", "").method(Method.GET).requestBuilder(GetConfigurationRequest::builder).basePath("/20240301").appendPathParam("configuration").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Configuration.class, GetConfigurationResponse.Builder::configuration).handleResponseHeaderString("etag", GetConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetZprConfigurationWorkRequestResponse getZprConfigurationWorkRequest(GetZprConfigurationWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetZprConfigurationWorkRequestResponse)this.clientCall(request, GetZprConfigurationWorkRequestResponse::builder).logger(LOG, "getZprConfigurationWorkRequest").serviceDetails("Zpr", "GetZprConfigurationWorkRequest", "").method(Method.GET).requestBuilder(GetZprConfigurationWorkRequestRequest::builder).basePath("/20240301").appendPathParam("zprConfigurationWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetZprConfigurationWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetZprConfigurationWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetZprConfigurationWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetZprConfigurationWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public GetZprPolicyResponse getZprPolicy(GetZprPolicyRequest request) {
        Validate.notBlank((String)request.getZprPolicyId(), (String)"zprPolicyId must not be blank", (Object[])new Object[0]);
        return (GetZprPolicyResponse)this.clientCall(request, GetZprPolicyResponse::builder).logger(LOG, "getZprPolicy").serviceDetails("Zpr", "GetZprPolicy", "").method(Method.GET).requestBuilder(GetZprPolicyRequest::builder).basePath("/20240301").appendPathParam("zprPolicies").appendPathParam(request.getZprPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ZprPolicy.class, GetZprPolicyResponse.Builder::zprPolicy).handleResponseHeaderString("etag", GetZprPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetZprPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetZprPolicyWorkRequestResponse getZprPolicyWorkRequest(GetZprPolicyWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetZprPolicyWorkRequestResponse)this.clientCall(request, GetZprPolicyWorkRequestResponse::builder).logger(LOG, "getZprPolicyWorkRequest").serviceDetails("Zpr", "GetZprPolicyWorkRequest", "").method(Method.GET).requestBuilder(GetZprPolicyWorkRequestRequest::builder).basePath("/20240301").appendPathParam("zprPolicyWorkRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetZprPolicyWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetZprPolicyWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetZprPolicyWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetZprPolicyWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListZprConfigurationWorkRequestErrorsResponse listZprConfigurationWorkRequestErrors(ListZprConfigurationWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListZprConfigurationWorkRequestErrorsResponse)this.clientCall(request, ListZprConfigurationWorkRequestErrorsResponse::builder).logger(LOG, "listZprConfigurationWorkRequestErrors").serviceDetails("Zpr", "ListZprConfigurationWorkRequestErrors", "").method(Method.GET).requestBuilder(ListZprConfigurationWorkRequestErrorsRequest::builder).basePath("/20240301").appendPathParam("zprConfigurationWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListZprConfigurationWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListZprConfigurationWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListZprConfigurationWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListZprConfigurationWorkRequestLogsResponse listZprConfigurationWorkRequestLogs(ListZprConfigurationWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListZprConfigurationWorkRequestLogsResponse)this.clientCall(request, ListZprConfigurationWorkRequestLogsResponse::builder).logger(LOG, "listZprConfigurationWorkRequestLogs").serviceDetails("Zpr", "ListZprConfigurationWorkRequestLogs", "").method(Method.GET).requestBuilder(ListZprConfigurationWorkRequestLogsRequest::builder).basePath("/20240301").appendPathParam("zprConfigurationWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListZprConfigurationWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListZprConfigurationWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListZprConfigurationWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListZprConfigurationWorkRequestsResponse listZprConfigurationWorkRequests(ListZprConfigurationWorkRequestsRequest request) {
        return (ListZprConfigurationWorkRequestsResponse)this.clientCall(request, ListZprConfigurationWorkRequestsResponse::builder).logger(LOG, "listZprConfigurationWorkRequests").serviceDetails("Zpr", "ListZprConfigurationWorkRequests", "").method(Method.GET).requestBuilder(ListZprConfigurationWorkRequestsRequest::builder).basePath("/20240301").appendPathParam("zprConfigurationWorkRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListZprConfigurationWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListZprConfigurationWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListZprConfigurationWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListZprPoliciesResponse listZprPolicies(ListZprPoliciesRequest request) {
        return (ListZprPoliciesResponse)this.clientCall(request, ListZprPoliciesResponse::builder).logger(LOG, "listZprPolicies").serviceDetails("Zpr", "ListZprPolicies", "").method(Method.GET).requestBuilder(ListZprPoliciesRequest::builder).basePath("/20240301").appendPathParam("zprPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ZprPolicyCollection.class, ListZprPoliciesResponse.Builder::zprPolicyCollection).handleResponseHeaderString("opc-request-id", ListZprPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListZprPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListZprPolicyWorkRequestErrorsResponse listZprPolicyWorkRequestErrors(ListZprPolicyWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListZprPolicyWorkRequestErrorsResponse)this.clientCall(request, ListZprPolicyWorkRequestErrorsResponse::builder).logger(LOG, "listZprPolicyWorkRequestErrors").serviceDetails("Zpr", "ListZprPolicyWorkRequestErrors", "").method(Method.GET).requestBuilder(ListZprPolicyWorkRequestErrorsRequest::builder).basePath("/20240301").appendPathParam("zprPolicyWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListZprPolicyWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListZprPolicyWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListZprPolicyWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListZprPolicyWorkRequestLogsResponse listZprPolicyWorkRequestLogs(ListZprPolicyWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListZprPolicyWorkRequestLogsResponse)this.clientCall(request, ListZprPolicyWorkRequestLogsResponse::builder).logger(LOG, "listZprPolicyWorkRequestLogs").serviceDetails("Zpr", "ListZprPolicyWorkRequestLogs", "").method(Method.GET).requestBuilder(ListZprPolicyWorkRequestLogsRequest::builder).basePath("/20240301").appendPathParam("zprPolicyWorkRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListZprPolicyWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListZprPolicyWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListZprPolicyWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListZprPolicyWorkRequestsResponse listZprPolicyWorkRequests(ListZprPolicyWorkRequestsRequest request) {
        return (ListZprPolicyWorkRequestsResponse)this.clientCall(request, ListZprPolicyWorkRequestsResponse::builder).logger(LOG, "listZprPolicyWorkRequests").serviceDetails("Zpr", "ListZprPolicyWorkRequests", "").method(Method.GET).requestBuilder(ListZprPolicyWorkRequestsRequest::builder).basePath("/20240301").appendPathParam("zprPolicyWorkRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListZprPolicyWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListZprPolicyWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListZprPolicyWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateZprPolicyResponse updateZprPolicy(UpdateZprPolicyRequest request) {
        Validate.notBlank((String)request.getZprPolicyId(), (String)"zprPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateZprPolicyDetails(), "updateZprPolicyDetails is required");
        return (UpdateZprPolicyResponse)this.clientCall(request, UpdateZprPolicyResponse::builder).logger(LOG, "updateZprPolicy").serviceDetails("Zpr", "UpdateZprPolicy", "").method(Method.PUT).requestBuilder(UpdateZprPolicyRequest::builder).basePath("/20240301").appendPathParam("zprPolicies").appendPathParam(request.getZprPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-dry-run", request.getOpcDryRun()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateZprPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateZprPolicyResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public ZprWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ZprPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ZprClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ZprClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ZprClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ZprClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ZprClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ZprClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ZprClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ZprClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ZprClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ZprClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ZprClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ZprClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ZprClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ZprClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ZprClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ZprClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ZprClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "zpr";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"zpr");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ZprClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ZprClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

