/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.zpr;

import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.zpr.Zpr;
import com.oracle.bmc.zpr.model.Configuration;
import com.oracle.bmc.zpr.model.ZprPolicy;
import com.oracle.bmc.zpr.requests.GetConfigurationRequest;
import com.oracle.bmc.zpr.requests.GetZprPolicyRequest;
import com.oracle.bmc.zpr.responses.GetConfigurationResponse;
import com.oracle.bmc.zpr.responses.GetZprPolicyResponse;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class ZprWaiters {
    private final ExecutorService executorService;
    private final Zpr client;

    public ZprWaiters(ExecutorService executorService, Zpr client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(GetConfigurationRequest request, Configuration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(GetConfigurationRequest request, Configuration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(GetConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Configuration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetConfigurationRequest, GetConfigurationResponse> forConfiguration(BmcGenericWaiter waiter, GetConfigurationRequest request, Configuration.LifecycleState ... targetStates) {
        final HashSet<Configuration.LifecycleState> targetStatesSet = new HashSet<Configuration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetConfigurationRequest, GetConfigurationResponse>(){

            @Override
            public GetConfigurationResponse apply(GetConfigurationRequest request) {
                return ZprWaiters.this.client.getConfiguration(request);
            }
        }, (Predicate)new Predicate<GetConfigurationResponse>(){

            @Override
            public boolean test(GetConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Configuration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetZprPolicyRequest, GetZprPolicyResponse> forZprPolicy(GetZprPolicyRequest request, ZprPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forZprPolicy(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetZprPolicyRequest, GetZprPolicyResponse> forZprPolicy(GetZprPolicyRequest request, ZprPolicy.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forZprPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetZprPolicyRequest, GetZprPolicyResponse> forZprPolicy(GetZprPolicyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ZprPolicy.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forZprPolicy(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetZprPolicyRequest, GetZprPolicyResponse> forZprPolicy(BmcGenericWaiter waiter, GetZprPolicyRequest request, ZprPolicy.LifecycleState ... targetStates) {
        final HashSet<ZprPolicy.LifecycleState> targetStatesSet = new HashSet<ZprPolicy.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetZprPolicyRequest, GetZprPolicyResponse>(){

            @Override
            public GetZprPolicyResponse apply(GetZprPolicyRequest request) {
                return ZprWaiters.this.client.getZprPolicy(request);
            }
        }, (Predicate)new Predicate<GetZprPolicyResponse>(){

            @Override
            public boolean test(GetZprPolicyResponse response) {
                return targetStatesSet.contains((Object)response.getZprPolicy().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ZprPolicy.LifecycleState.Deleted)), (Object)request);
    }
}

