/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.zpr.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteZprPolicyRequest
extends BmcRequest<Void> {
    private String zprPolicyId;
    private String ifMatch;
    private String opcRequestId;
    private Boolean opcDryRun;

    public String getZprPolicyId() {
        return this.zprPolicyId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getOpcDryRun() {
        return this.opcDryRun;
    }

    public Builder toBuilder() {
        return new Builder().zprPolicyId(this.zprPolicyId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcDryRun(this.opcDryRun);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",zprPolicyId=").append(String.valueOf(this.zprPolicyId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcDryRun=").append(String.valueOf(this.opcDryRun));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteZprPolicyRequest)) {
            return false;
        }
        DeleteZprPolicyRequest other = (DeleteZprPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.zprPolicyId, other.zprPolicyId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcDryRun, other.opcDryRun);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.zprPolicyId == null ? 43 : this.zprPolicyId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcDryRun == null ? 43 : this.opcDryRun.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteZprPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String zprPolicyId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean opcDryRun = null;

        public Builder zprPolicyId(String zprPolicyId) {
            this.zprPolicyId = zprPolicyId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcDryRun(Boolean opcDryRun) {
            this.opcDryRun = opcDryRun;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteZprPolicyRequest o) {
            this.zprPolicyId(o.getZprPolicyId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcDryRun(o.getOpcDryRun());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteZprPolicyRequest build() {
            DeleteZprPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteZprPolicyRequest buildWithoutInvocationCallback() {
            DeleteZprPolicyRequest request = new DeleteZprPolicyRequest();
            request.zprPolicyId = this.zprPolicyId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcDryRun = this.opcDryRun;
            return request;
        }
    }
}

