/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.zpr.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetZprPolicyRequest
extends BmcRequest<Void> {
    private String zprPolicyId;
    private String opcRequestId;

    public String getZprPolicyId() {
        return this.zprPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().zprPolicyId(this.zprPolicyId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",zprPolicyId=").append(String.valueOf(this.zprPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetZprPolicyRequest)) {
            return false;
        }
        GetZprPolicyRequest other = (GetZprPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.zprPolicyId, other.zprPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.zprPolicyId == null ? 43 : this.zprPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetZprPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String zprPolicyId = null;
        private String opcRequestId = null;

        public Builder zprPolicyId(String zprPolicyId) {
            this.zprPolicyId = zprPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetZprPolicyRequest o) {
            this.zprPolicyId(o.getZprPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetZprPolicyRequest build() {
            GetZprPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetZprPolicyRequest buildWithoutInvocationCallback() {
            GetZprPolicyRequest request = new GetZprPolicyRequest();
            request.zprPolicyId = this.zprPolicyId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

