/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.config.parameter;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.config.Config;
import oracle.dms.config.ConfigChild;
import oracle.dms.config.ConfigResourceBundle;
import oracle.dms.config.DMSConfigurationException;
import oracle.dms.config.parameter.ClockType;
import oracle.dms.config.parameter.ClockUnits;
import oracle.dms.config.parameter.SensorValue;
import oracle.dms.event.config.EventConfigException;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Time;
import oracle.dms.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterConfig
implements ConfigChild {
    public static final boolean DMS_CONTEXT_ENABLED_DEFAULT = true;
    public static final boolean JVM_MEMORY_STATS_ENABLED_DEFAULT = true;
    public static final boolean NON_DECREASING_TIME_ENABLED_DEFAULT = false;
    public static final boolean JVM_THREAD_MONITOR_ENABLED_DEFAULT = true;
    public static final int JVM_THREAD_MONITOR_REFRESH_INTERVAL_DEFAULT = 20;
    public static final int DMS_HTTP_PORT_DEFAULT = 0;
    private Logger m_logger;
    private boolean m_UpdatedConfig;
    private boolean m_isRuntime;
    private static String LOGGER_NAME = "oracle.dms.config";
    private ClockType m_DMSClockType = ClockType.DEFAULT;
    private ClockUnits m_DMSClockUnits = ClockUnits.MICROSECONDS;
    private SensorValue m_SensorActivationLevel = SensorValue.NORMAL;
    private String m_DMSPublisherClass;
    private int m_DMSHTTPPort = 0;
    private int m_JVMThreadMonitorRefreshIntervalSeconds = 20;
    private boolean m_JVMThreadMonitorEnabled = true;
    private boolean m_DMSContextEnabled = true;
    private boolean m_NonDecreasingTimeEnabled = false;
    private boolean m_JVMMemoryStatsEnabled = true;
    private boolean m_paramListChanged = true;
    private Map<String, String> m_AllDMSConfigParams = new HashMap<String, String>();
    public static final String CLOCK_TYPE = "DMSClockType";
    public static final String CLOCK_UNITS = "DMSClockUnits";
    public static final String SENSOR = "SensorActivationLevel";
    public static final String CONTEXT = "DMSContextEnabled";
    public static final String DMS_PUBLISHING = "DMSPublisherClass";
    public static final String HTTP_DAEMON = "DMSHTTPPort";
    public static final String JVM_MEMORY_STATS = "JVMMemoryStatsEnabled";
    public static final String JVM_THREAD_MONITOR_ENABLED = "JVMThreadMonitorEnabled";
    public static final String JVM_THREAD_MONITOR_REFRESH_INTERVAL = "JVMThreadMonitorRefreshInterval";
    public static final String NON_DECREASING_TIME = "NonDecreasingTimeEnabled";
    public static final String CLOCK_TYPE_PARAM = "oracle.dms.clock";
    public static final String CLOCK_UNITS_PARAM = "oracle.dms.clock.units";
    public static final String SENSOR_PARAM = "oracle.dms.sensors";
    public static final String CONTEXT_PARAM = "oracle.dms.context";
    public static final String DMS_PUBLISHING_PARAM = "oracle.dms.publisher.classes";
    public static final String HTTP_DAEMON_PARAM = "oracle.dms.httpd.port.start";
    public static final String JVM_MEMORY_STATS_PARAM = "oracle.dms.spy.jvm";
    public static final String JVM_THREAD_MONITOR_ENABLED_PARAM = "oracle.dms.spy.jvm.ThreadMonitor.enable";
    public static final String JVM_THREAD_MONITOR_REFRESH_INTERVAL_PARAM = "oracle.dms.spy.jvm.ThreadMonitor.threadListRefresh";
    public static final String NON_DECREASING_TIME_PARAM = "oracle.dms.time.enforceNonDecreasingTime";
    private static final String X_NON_DECREASING_TIME_ENABLED = "enabled";
    private static final String X_CLOCK = "clock";
    private static final String X_CLOCK_TYPE = "type";
    private static final String X_CLOCK_UNITS = "units";
    private static final String X_SENSOR = "sensor";
    private static final String X_SENSOR_ACTIVATION_LEVEL = "activationLevel";
    private static final String X_CONTEXT = "_context";
    private static final String X_CONTEXT_ENABLED = "enabled";
    private static final String X_DMS_PUBLISHING = "_dmsPublishing";
    private static final String X_DMS_PUBLISHING_CLASSES = "classes";
    private static final String X_HTTP_DAEMON = "_httpDaemon";
    private static final String X_HTTP_DAEMON_PORT = "port";
    private static final String X_JVM_MEMORY_STATS = "_jvmMemoryStats";
    private static final String X_JVM_MEMORY_STATS_ENABLED = "enabled";
    private static final String X_JVM_THREAD_MONITOR = "_jvmThreadMonitor";
    private static final String X_JVM_THREAD_MONITOR_ENABLED = "enabled";
    private static final String X_JVM_THREAD_MONITOR_INTERVAL_SECONDS = "refreshIntervalSeconds";
    private static final String X_NON_DECREASING_TIME = "_nonDecreasingTime";
    private static final String EMPTY_ELEMENT_OR_ATTRIB = "empty element or attributeName";
    private static final String PARAMETER_CONFIGURATION = "paramConfiguration";
    private static final String CLASS_NAME = ParameterConfig.class.getName();

    public ParameterConfig() {
        this.m_logger = Logger.getLogger(LOGGER_NAME, ConfigResourceBundle.class.getName());
    }

    public boolean isDMSContextEnabled() {
        return this.m_DMSContextEnabled;
    }

    public void setDMSContextEnabled(boolean enabled) {
        this.m_DMSContextEnabled = enabled;
        this.m_paramListChanged = true;
    }

    public void setDMSClockType(ClockType clockType) {
        if (clockType == null) {
            throw new IllegalArgumentException("DMSClockType cannot be null. Provide a valid value as described in online help.");
        }
        this.m_DMSClockType = clockType;
        this.m_paramListChanged = true;
    }

    public ClockType getDMSClockType() {
        return this.m_DMSClockType;
    }

    public void setDMSClockUnits(ClockUnits clockUnits) {
        if (clockUnits == null) {
            throw new IllegalArgumentException("DMSClockUnits cannot be null. Provide a valid value as described in online help.");
        }
        this.m_DMSClockUnits = clockUnits;
        this.m_paramListChanged = true;
    }

    public ClockUnits getDMSClockUnits() {
        return this.m_DMSClockUnits;
    }

    public void setSensorActivationLevel(SensorValue activationLevel) {
        if (activationLevel == null) {
            throw new IllegalArgumentException("SensorActivationLevel cannot be null. Provide a valid value as described in online help.");
        }
        this.m_SensorActivationLevel = activationLevel;
        this.m_paramListChanged = true;
    }

    public SensorValue getSensorActivationLevel() {
        return this.m_SensorActivationLevel;
    }

    public void setDMSPublisherClass(String pubClass) {
        this.m_DMSPublisherClass = pubClass;
        this.m_paramListChanged = true;
    }

    public String getDMSPublisherClass() {
        return this.m_DMSPublisherClass;
    }

    public void setDMSHTTPPort(int port) {
        this.m_DMSHTTPPort = port;
        this.m_paramListChanged = true;
    }

    public int getDMSHTTPPort() {
        return this.m_DMSHTTPPort;
    }

    public boolean isJVMMemoryStatsEnabled() {
        return this.m_JVMMemoryStatsEnabled;
    }

    public void setJVMMemoryStatsEnabled(boolean enabled) {
        this.m_JVMMemoryStatsEnabled = enabled;
        this.m_paramListChanged = true;
    }

    public boolean isJVMThreadMonitorEnabled() {
        return this.m_JVMThreadMonitorEnabled;
    }

    public void setJVMThreadMonitorEnabled(Boolean enabled) {
        this.m_JVMThreadMonitorEnabled = enabled;
        this.m_paramListChanged = true;
    }

    public void setJVMThreadMonitorRefreshIntervalSeconds(int seconds) {
        this.m_JVMThreadMonitorRefreshIntervalSeconds = seconds;
        this.m_paramListChanged = true;
    }

    public int getJVMThreadMonitorRefreshIntervalSeconds() {
        return this.m_JVMThreadMonitorRefreshIntervalSeconds;
    }

    public boolean isNonDecreasingTimeEnabled() {
        return this.m_NonDecreasingTimeEnabled;
    }

    public void setNonDecreasingTime(boolean enabled) {
        this.m_NonDecreasingTimeEnabled = enabled;
        this.m_paramListChanged = true;
    }

    public Map<String, String> listAllDMSConfigParams() {
        if (this.m_paramListChanged) {
            this.initDMSConfigParamList();
        }
        return this.m_AllDMSConfigParams;
    }

    @Override
    public synchronized void parseConfigDocument(Element xdms) throws DMSConfigurationException {
        if (xdms == null) {
            throw new IllegalArgumentException("xdms=null");
        }
        try {
            this.getClockParams(xdms);
            this.getSensorParams(xdms);
            this.getContextParams(xdms);
            this.getHTTPParams(xdms);
            this.getPublisherParams(xdms);
            this.getJVMMemoryStatsParams(xdms);
            this.getJVMThreadMonitorParams(xdms);
            this.getNonDecreasingTimeParams(xdms);
        }
        catch (Exception e) {
            String mesg = DMSUtil.errorMessage("50727", new Object[0]);
            throw new DMSConfigurationException(mesg, e);
        }
    }

    @Override
    public synchronized Element buildElement(Document document) throws DMSConfigurationException {
        Element xparameter = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", PARAMETER_CONFIGURATION);
        Element xclock = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_CLOCK);
        xclock.setAttribute(X_CLOCK_TYPE, this.m_DMSClockType.toString().toLowerCase());
        xclock.setAttribute(X_CLOCK_UNITS, this.m_DMSClockUnits.toString().toLowerCase());
        xparameter.appendChild(xclock);
        Element xsensor = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_SENSOR);
        xsensor.setAttribute(X_SENSOR_ACTIVATION_LEVEL, this.m_SensorActivationLevel.toString().toLowerCase());
        xparameter.appendChild(xsensor);
        if (!this.m_DMSContextEnabled) {
            Element xcontext = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_CONTEXT);
            xcontext.setAttribute("enabled", String.valueOf(this.m_DMSContextEnabled).toLowerCase());
            xparameter.appendChild(xcontext);
        }
        if (this.m_DMSPublisherClass != null) {
            Element xdmsPublishing = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_DMS_PUBLISHING);
            xdmsPublishing.setAttribute(X_DMS_PUBLISHING_CLASSES, this.m_DMSPublisherClass);
            xparameter.appendChild(xdmsPublishing);
        }
        if (this.m_DMSHTTPPort != 0) {
            Element xhttpDaemon = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_HTTP_DAEMON);
            xhttpDaemon.setAttribute(X_HTTP_DAEMON_PORT, String.valueOf(this.m_DMSHTTPPort));
            xparameter.appendChild(xhttpDaemon);
        }
        if (!this.m_JVMMemoryStatsEnabled) {
            Element xjvmMemoryStats = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_JVM_MEMORY_STATS);
            xjvmMemoryStats.setAttribute("enabled", String.valueOf(this.m_JVMMemoryStatsEnabled).toLowerCase());
            xparameter.appendChild(xjvmMemoryStats);
        }
        if (!this.m_JVMThreadMonitorEnabled || this.m_JVMThreadMonitorRefreshIntervalSeconds != 20) {
            Element xjvmThreadMonitor = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_JVM_THREAD_MONITOR);
            xjvmThreadMonitor.setAttribute("enabled", String.valueOf(this.m_JVMThreadMonitorEnabled).toLowerCase());
            xjvmThreadMonitor.setAttribute(X_JVM_THREAD_MONITOR_INTERVAL_SECONDS, String.valueOf(this.m_JVMThreadMonitorRefreshIntervalSeconds));
            xparameter.appendChild(xjvmThreadMonitor);
        }
        if (this.m_NonDecreasingTimeEnabled) {
            Element xnonDecreasingTime = document.createElementNS("http://xmlns.oracle.com/dms/DMSConfiguration/V2", X_NON_DECREASING_TIME);
            xnonDecreasingTime.setAttribute("enabled", String.valueOf(this.m_NonDecreasingTimeEnabled).toLowerCase());
            xparameter.appendChild(xnonDecreasingTime);
        }
        return xparameter;
    }

    private void initDMSConfigParamList() {
        this.m_AllDMSConfigParams.clear();
        this.m_AllDMSConfigParams.put(CLOCK_TYPE, this.m_DMSClockType.toString());
        this.m_AllDMSConfigParams.put(CLOCK_UNITS, this.m_DMSClockUnits.toString());
        this.m_AllDMSConfigParams.put(SENSOR, this.m_SensorActivationLevel.toString());
        if (!this.m_DMSContextEnabled) {
            this.m_AllDMSConfigParams.put(CONTEXT, Boolean.toString(this.m_DMSContextEnabled));
        }
        if (this.m_DMSPublisherClass != null) {
            this.m_AllDMSConfigParams.put(DMS_PUBLISHING, this.m_DMSPublisherClass);
        }
        if (this.m_DMSHTTPPort != 0) {
            this.m_AllDMSConfigParams.put(HTTP_DAEMON, Integer.toString(this.m_DMSHTTPPort));
        }
        if (!this.m_JVMMemoryStatsEnabled) {
            this.m_AllDMSConfigParams.put(JVM_MEMORY_STATS, Boolean.toString(this.m_JVMMemoryStatsEnabled));
        }
        if (!this.m_JVMThreadMonitorEnabled) {
            this.m_AllDMSConfigParams.put(JVM_THREAD_MONITOR_ENABLED, Boolean.toString(this.m_JVMThreadMonitorEnabled));
        }
        if (this.m_JVMThreadMonitorRefreshIntervalSeconds != 20) {
            this.m_AllDMSConfigParams.put(JVM_THREAD_MONITOR_REFRESH_INTERVAL, Integer.toString(this.m_JVMThreadMonitorRefreshIntervalSeconds));
        }
        if (this.m_NonDecreasingTimeEnabled) {
            this.m_AllDMSConfigParams.put(NON_DECREASING_TIME, Boolean.toString(this.m_NonDecreasingTimeEnabled));
        }
        this.m_paramListChanged = false;
    }

    @Override
    public boolean isConfigurationUpdated() {
        return this.m_paramListChanged;
    }

    @Override
    public void setConfigurationUpdated(boolean updated) {
    }

    private void getClockParams(Element parameterConfig) throws DMSConfigurationException {
        NodeList clockTypeList = parameterConfig.getElementsByTagName(X_CLOCK);
        if (clockTypeList.getLength() == 1) {
            Node child = clockTypeList.item(0);
            Element x_clock = (Element)child;
            this.m_DMSClockType = ParameterConfig.getAttributeClockType(x_clock, X_CLOCK_TYPE);
            this.m_DMSClockUnits = ParameterConfig.getAttributeClockUnits(x_clock, X_CLOCK_UNITS);
        }
    }

    private void getSensorParams(Element parameterConfig) throws DMSConfigurationException {
        NodeList sensorList = parameterConfig.getElementsByTagName(X_SENSOR);
        if (sensorList.getLength() == 1) {
            Node child = sensorList.item(0);
            Element x_sensor = (Element)child;
            this.m_SensorActivationLevel = ParameterConfig.getAttributeActivationLevel(x_sensor, X_SENSOR_ACTIVATION_LEVEL);
        }
    }

    private void getContextParams(Element parameterConfig) throws DMSConfigurationException {
        NodeList contextList = parameterConfig.getElementsByTagName(X_CONTEXT);
        if (contextList.getLength() == 1) {
            Node child = contextList.item(0);
            Element x_context = (Element)child;
            this.m_DMSContextEnabled = XmlUtil.getAttributeBoolean(x_context, "enabled");
        }
    }

    private void getHTTPParams(Element parameterConfig) {
        NodeList httpList = parameterConfig.getElementsByTagName(X_HTTP_DAEMON);
        if (httpList.getLength() == 1) {
            Node child = httpList.item(0);
            Element x_http_daemon_port = (Element)child;
            this.m_DMSHTTPPort = XmlUtil.getAttributeInt(x_http_daemon_port, X_HTTP_DAEMON_PORT);
        }
    }

    private void getPublisherParams(Element parameterConfig) {
        NodeList publisherList = parameterConfig.getElementsByTagName(X_DMS_PUBLISHING);
        if (publisherList.getLength() == 1) {
            Node child = publisherList.item(0);
            Element x_dms_publishing_classes = (Element)child;
            this.m_DMSPublisherClass = XmlUtil.getAttributeString(x_dms_publishing_classes, X_DMS_PUBLISHING_CLASSES);
        }
    }

    private void getJVMMemoryStatsParams(Element parameterConfig) {
        NodeList jvmMemoryStatsList = parameterConfig.getElementsByTagName(X_JVM_MEMORY_STATS);
        if (jvmMemoryStatsList.getLength() == 1) {
            Node child = jvmMemoryStatsList.item(0);
            Element x_JVMMemoryStatsParams = (Element)child;
            this.m_JVMMemoryStatsEnabled = XmlUtil.getAttributeBoolean(x_JVMMemoryStatsParams, "enabled");
        }
    }

    private void getJVMThreadMonitorParams(Element parameterConfig) {
        NodeList threadMonitorList = parameterConfig.getElementsByTagName(X_JVM_THREAD_MONITOR);
        if (threadMonitorList.getLength() == 1) {
            Node child = threadMonitorList.item(0);
            Element x_JVMThreadMonitor = (Element)child;
            this.m_JVMThreadMonitorEnabled = XmlUtil.getAttributeBoolean(x_JVMThreadMonitor, "enabled");
            this.m_JVMThreadMonitorRefreshIntervalSeconds = XmlUtil.getAttributeInt(x_JVMThreadMonitor, X_JVM_THREAD_MONITOR_INTERVAL_SECONDS);
        }
    }

    private void getNonDecreasingTimeParams(Element parameterConfig) {
        NodeList nonDecreasingTimeList = parameterConfig.getElementsByTagName(X_NON_DECREASING_TIME);
        if (nonDecreasingTimeList.getLength() == 1) {
            Node child = nonDecreasingTimeList.item(0);
            Element x_NonDecreasingTimeParams = (Element)child;
            this.m_NonDecreasingTimeEnabled = XmlUtil.getAttributeBoolean(x_NonDecreasingTimeParams, "enabled");
        }
    }

    public static ClockType getAttributeClockType(Element element, String attributeName) throws DMSConfigurationException {
        if (element == null || attributeName == null || attributeName.trim().length() == 0) {
            throw new DMSConfigurationException(EMPTY_ELEMENT_OR_ATTRIB);
        }
        String attribute = element.getAttribute(attributeName);
        ClockType c = DMSUtil.getEnumFromString(ClockType.class, attribute);
        return c;
    }

    public static ClockUnits getAttributeClockUnits(Element element, String attributeName) throws DMSConfigurationException {
        if (element == null || attributeName == null || attributeName.trim().length() == 0) {
            throw new DMSConfigurationException(EMPTY_ELEMENT_OR_ATTRIB);
        }
        String attribute = element.getAttribute(attributeName);
        ClockUnits c = DMSUtil.getEnumFromString(ClockUnits.class, attribute);
        return c;
    }

    public static SensorValue getAttributeActivationLevel(Element element, String attributeName) throws DMSConfigurationException {
        if (element == null || attributeName == null || attributeName.trim().length() == 0) {
            throw new DMSConfigurationException(EMPTY_ELEMENT_OR_ATTRIB);
        }
        String attribute = element.getAttribute(attributeName);
        SensorValue c = DMSUtil.getEnumFromString(SensorValue.class, attribute);
        return c;
    }

    public void setRuntime(boolean isRuntime) {
        this.m_isRuntime = isRuntime;
    }

    @Override
    public synchronized void sync(Config pendingConfig) throws DMSConfigurationException {
        if (!this.m_isRuntime) {
            this.syncConfig(pendingConfig.getParamConfig());
        }
    }

    private synchronized void syncConfig(ParameterConfig updatedConfig) throws EventConfigException {
        String METHOD_NAME = "sync";
        if (this.m_logger.isLoggable(Level.FINER)) {
            String msg = "START sync:" + Time.currentTimeMillis();
            this.m_logger.logp(Level.FINER, CLASS_NAME, "sync", msg);
        }
        this.m_DMSClockType = updatedConfig.m_DMSClockType;
        this.m_DMSClockUnits = updatedConfig.m_DMSClockUnits;
        this.m_SensorActivationLevel = updatedConfig.m_SensorActivationLevel;
        this.m_DMSContextEnabled = updatedConfig.m_DMSContextEnabled;
        this.m_DMSPublisherClass = updatedConfig.m_DMSPublisherClass;
        this.m_DMSHTTPPort = updatedConfig.m_DMSHTTPPort;
        this.m_JVMMemoryStatsEnabled = updatedConfig.m_JVMMemoryStatsEnabled;
        this.m_JVMThreadMonitorEnabled = updatedConfig.m_JVMThreadMonitorEnabled;
        this.m_JVMThreadMonitorRefreshIntervalSeconds = updatedConfig.m_JVMThreadMonitorRefreshIntervalSeconds;
        this.m_NonDecreasingTimeEnabled = updatedConfig.m_NonDecreasingTimeEnabled;
        this.m_paramListChanged = true;
    }

    static boolean okToShowParameter(String key, String value) {
        boolean retVal = false;
        if (key.equals(SENSOR) || key.equals(CLOCK_TYPE) || key.equals(CLOCK_UNITS)) {
            retVal = true;
        } else if (key.equals(CONTEXT)) {
            if (!Boolean.parseBoolean(value)) {
                retVal = true;
            }
        } else if (key.equals(DMS_PUBLISHING)) {
            if (value != null) {
                retVal = true;
            }
        } else if (key.equals(HTTP_DAEMON)) {
            if (Integer.parseInt(value) != 0) {
                retVal = true;
            }
        } else if (key.equals(JVM_MEMORY_STATS)) {
            if (!Boolean.parseBoolean(value)) {
                retVal = true;
            }
        } else if (key.equals(JVM_THREAD_MONITOR_ENABLED)) {
            if (!Boolean.parseBoolean(value)) {
                retVal = true;
            }
        } else if (key.equals(JVM_THREAD_MONITOR_REFRESH_INTERVAL)) {
            if (Integer.parseInt(value) != 20) {
                retVal = true;
            }
        } else if (key.equals(NON_DECREASING_TIME) && Boolean.parseBoolean(value)) {
            retVal = true;
        }
        return retVal;
    }

    static String getConfigParam(String runtime) {
        if (runtime.equalsIgnoreCase(CLOCK_TYPE_PARAM)) {
            return CLOCK_TYPE;
        }
        if (runtime.equalsIgnoreCase(CLOCK_UNITS_PARAM)) {
            return CLOCK_UNITS;
        }
        if (runtime.equalsIgnoreCase(SENSOR_PARAM)) {
            return SENSOR;
        }
        if (runtime.equalsIgnoreCase(CONTEXT_PARAM)) {
            return CONTEXT;
        }
        if (runtime.equalsIgnoreCase(DMS_PUBLISHING_PARAM)) {
            return DMS_PUBLISHING;
        }
        if (runtime.equalsIgnoreCase(HTTP_DAEMON_PARAM)) {
            return HTTP_DAEMON;
        }
        if (runtime.equalsIgnoreCase(JVM_MEMORY_STATS_PARAM)) {
            return JVM_MEMORY_STATS;
        }
        if (runtime.equalsIgnoreCase(JVM_THREAD_MONITOR_ENABLED_PARAM)) {
            return JVM_THREAD_MONITOR_ENABLED;
        }
        if (runtime.equalsIgnoreCase(JVM_THREAD_MONITOR_REFRESH_INTERVAL_PARAM)) {
            return JVM_THREAD_MONITOR_REFRESH_INTERVAL;
        }
        if (runtime.equalsIgnoreCase(NON_DECREASING_TIME_PARAM)) {
            return NON_DECREASING_TIME;
        }
        return runtime;
    }

    static String getConfigValue(String configParam, String runtimeValue) {
        String configValue = runtimeValue;
        if (configParam.equals(SENSOR)) {
            configValue = runtimeValue.toUpperCase();
        } else if (configParam.equals(CLOCK_UNITS)) {
            if (runtimeValue.equalsIgnoreCase("MSECS")) {
                configValue = ClockUnits.MILLISECONDS.toString();
            } else if (runtimeValue.equalsIgnoreCase("USECS")) {
                configValue = ClockUnits.MICROSECONDS.toString();
            } else if (runtimeValue.equalsIgnoreCase("NSECS")) {
                configValue = ClockUnits.NANOSECONDS.toString();
            }
        } else if (configParam.equals(CONTEXT)) {
            configValue = runtimeValue.equalsIgnoreCase("ON") ? "true" : "false";
        }
        return configValue;
    }
}

