/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.jfr;

import com.oracle.jrockit.jfr.DurationEvent;
import com.oracle.jrockit.jfr.DynamicEventToken;
import com.oracle.jrockit.jfr.DynamicValue;
import com.oracle.jrockit.jfr.FlightRecorder;
import com.oracle.jrockit.jfr.InstantEvent;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import com.oracle.jrockit.jfr.client.FlightRecorderClient;
import com.oracle.jrockit.jfr.client.FlightRecordingClient;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.servlet.http.HttpServletRequest;
import oracle.dms.context.ContextContent;
import oracle.dms.context.ExecutionContext;
import oracle.dms.event.Event;
import oracle.dms.event.EventActionType;
import oracle.dms.event.EventSourceType;
import oracle.dms.event.LoadableDestination;
import oracle.dms.event.config.DestinationDescription;
import oracle.dms.instrument.ActivationParameter;
import oracle.dms.instrument.ActivationParameterDescriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.PhaseEvent;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.State;
import oracle.dms.spy.Metric;
import oracle.dms.trace.TraceResourceBundle;
import oracle.dms.util.ClientObjectKey;
import oracle.dms.util.ClientObjectKeyManager;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.JSONUtils;
import oracle.dms.util.Validatable;
import oracle.dms.util.ValidationException;
import org.w3c.dom.Element;

@DestinationDescription(nlsDescriptionResourceBundle="oracle.dms.trace.TraceResourceBundle", nlsDescriptionID="JFR_DESTINATION")
public class JFRDestination
implements LoadableDestination {
    private static final String CLASS_NAME = JFRDestination.class.getName();
    private String mName;
    private String mId;
    private String mOutputDirName;
    private String mOutputFileName;
    private long mRecordingSizeInBytes = 0xA00000L;
    private boolean mCollectStackTraces = true;
    private boolean mAddThread = true;
    private static JFRDestination sJFRDestinationInstance;
    private JFRIntegration mJFRIntegration;
    private static final String RECORDING_NAME_PREFIX = "DMS-";
    private static final Logger sLogger;

    @Override
    public void validate(Set<Validatable.ValidationLevel> validationLevels) throws ValidationException {
        if (validationLevels.contains((Object)Validatable.ValidationLevel.ENVIRONMENT)) {
            try {
                Class<?> c = Class.forName("com.oracle.jrockit.jfr.FlightRecorder");
            }
            catch (ClassNotFoundException e) {
                throw new ValidationException("DMS-58035", TraceResourceBundle.class.getName());
            }
            if (!FlightRecorder.isActive()) {
                throw new ValidationException("DMS-58041", TraceResourceBundle.class.getName());
            }
            if (sJFRDestinationInstance != null && sJFRDestinationInstance != this) {
                ValidationException ve = new ValidationException("DMS-58052", TraceResourceBundle.class.getName());
                throw ve;
            }
        }
    }

    @Override
    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public void setId(String id) {
        this.mId = id;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean needsContext() {
        return true;
    }

    public void setOutputDirectory(String outputDirName) {
        this.mOutputDirName = outputDirName;
    }

    public void setOutputFilename(String outputFilename) {
        this.mOutputFileName = outputFilename;
    }

    public void setMaxRecordingSize(String s) {
        long proposedSize = 0xA00000L;
        try {
            proposedSize = DMSUtil.parseMemSizeString(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.mRecordingSizeInBytes = proposedSize;
    }

    public void setCollectStackTraces(String trueOrFalse) {
        this.mCollectStackTraces = Boolean.parseBoolean(trueOrFalse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initDestination() {
        String METHOD_NAME = "initDestination";
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.logp(Level.FINE, CLASS_NAME, "initDestination", "Starting initialization of " + this.toString());
        }
        Class<JFRDestination> clazz = JFRDestination.class;
        synchronized (JFRDestination.class) {
            if (sJFRDestinationInstance != null) {
                throw new RuntimeException("No more than one JFRDestination can be initialized at any one time.");
            }
            this.mJFRIntegration = JFRIntegration.getInstance(this.getOutputFileName(), this.mRecordingSizeInBytes, this.mCollectStackTraces, this.mAddThread);
            sJFRDestinationInstance = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "initDestination", "Finished initialization of " + this.toString(Level.FINE));
            }
            return;
        }
    }

    private String getOutputFileName() {
        if (this.mOutputFileName == null) {
            this.mOutputFileName = this.deriveOutputFileName();
        }
        return this.mOutputFileName;
    }

    private String deriveOutputFileName() {
        String METHOD_NAME = "deriveOutputFileName";
        String retVal = null;
        if (this.mOutputFileName != null) {
            retVal = this.mOutputFileName;
        } else if (this.mOutputDirName != null) {
            String hostname = "hostname";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ex) {
                sLogger.logp(Level.FINE, CLASS_NAME, "deriveOutputFileName", "Unable to resolve hostname address - will use default value: " + hostname, ex);
            }
            String weblogicName = System.getProperty("weblogic.Name", "weblogic");
            StringBuilder sb = new StringBuilder(this.mOutputDirName);
            sb.append(File.separator);
            sb.append(hostname);
            sb.append('_');
            sb.append(weblogicName);
            sb.append('_');
            sb.append(System.currentTimeMillis());
            sb.append(".jfr");
            File f = new File(sb.toString());
            retVal = f.getAbsolutePath();
        }
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.logp(Level.FINE, CLASS_NAME, "deriveOutputFileName", "Returning output file name " + retVal + " for " + this.toString());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownDestination() {
        String METHOD_NAME = "shutdownDestination";
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.logp(Level.FINE, CLASS_NAME, "shutdownDestination", "Starting shutdown of " + this.toString());
        }
        Class<JFRDestination> clazz = JFRDestination.class;
        synchronized (JFRDestination.class) {
            if (sJFRDestinationInstance == this) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        JFRDestination.this.mJFRIntegration.shutdownJFR();
                        return null;
                    }
                });
                sJFRDestinationInstance = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "shutdownDestination", "Finished shutdown of " + this.toString(Level.FINE));
            }
            return;
        }
    }

    @Override
    public void handleEvent(Event event) {
        this.mJFRIntegration.handleEvent(event);
    }

    public String toString() {
        return this.toString(Level.INFO);
    }

    public String toString(Level level) {
        StringBuilder sb = new StringBuilder("JFRDestination:");
        sb.append(" name=");
        sb.append(this.mName);
        sb.append(", id=");
        sb.append(this.mId);
        if (level.intValue() >= Level.FINE.intValue()) {
            if (this.mOutputFileName != null) {
                sb.append(", output-filename=").append(this.mOutputFileName);
            }
            if (this.mOutputDirName != null) {
                sb.append(", output-dir-name=").append(this.mOutputDirName);
            }
        }
        return sb.toString();
    }

    static {
        sLogger = Logger.getLogger("oracle.dms.jfr", TraceResourceBundle.class.getName());
    }

    static class DurationEventContextContent
    implements ContextContent {
        transient DurationEvent mDurationEvent;

        DurationEventContextContent(DurationEvent durationEvent) {
            this.mDurationEvent = durationEvent;
        }

        @Override
        public Element toXml() {
            return null;
        }

        @Override
        public void fromXml(Element xml) {
        }

        @Override
        public int expireMinutes() {
            return 0;
        }

        @Override
        public void onExpiration() {
        }

        @Override
        public void onDeactivation() {
        }
    }

    static class ProducerProxy {
        String mProducerName;
        Producer mProducer;
        Map<String, DynamicEventToken> mDynamicEventTokenMap;

        ProducerProxy(String producerName, Producer p) {
            this.mProducerName = producerName;
            this.mProducer = p;
            this.mDynamicEventTokenMap = new HashMap<String, DynamicEventToken>(10);
        }
    }

    static class PhaseSensorJFREventTuple {
        final PhaseEvent mPhaseEvent;
        final DurationEvent mDurationEvent;
        final boolean mIsAnonymousPhase;
        final String mNounType;
        final String mLeadingNounPath;
        String mAsString;

        PhaseSensorJFREventTuple(PhaseEvent phaseEvent, DurationEvent durationEvent) {
            this.mPhaseEvent = phaseEvent;
            this.mDurationEvent = durationEvent;
            this.mIsAnonymousPhase = false;
            this.mNounType = null;
            this.mLeadingNounPath = null;
        }

        PhaseSensorJFREventTuple(DurationEvent durationEvent, String nounType, String leadingNounPath) {
            this.mPhaseEvent = null;
            this.mDurationEvent = durationEvent;
            this.mIsAnonymousPhase = true;
            this.mNounType = nounType;
            this.mLeadingNounPath = leadingNounPath;
        }

        boolean matches(PhaseEvent phaseEvent, NounDescriptor nd) {
            boolean retVal = false;
            retVal = this.mIsAnonymousPhase ? this.mNounType.equals(nd.getName()) && phaseEvent.toString().startsWith(this.mLeadingNounPath) : phaseEvent == phaseEvent;
            return retVal;
        }

        boolean matches(String nounType, String leadingNounPath) {
            boolean retVal = false;
            if (this.mIsAnonymousPhase) {
                retVal = this.mNounType.equals(nounType) && leadingNounPath.startsWith(this.mLeadingNounPath);
            }
            return retVal;
        }

        public String toString() {
            if (this.mAsString == null) {
                StringBuilder sb = new StringBuilder(128);
                sb.append('{');
                JSONUtils.appendNameValuePair(sb, "phaseEvent", this.mPhaseEvent.toString());
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "isAnonymous", this.mIsAnonymousPhase);
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "nounType", this.mNounType);
                sb.append(',');
                JSONUtils.appendNameValuePair(sb, "leadingNounPath", this.mLeadingNounPath);
                sb.append('}');
                this.mAsString = sb.toString();
            }
            return this.mAsString;
        }
    }

    static class JFRIntegration {
        static String CLASS_NAME = JFRIntegration.class.getName();
        private static Producer sContextProducer;
        private static DynamicEventToken[] sContextEventTokens;
        private static Producer sHttpProducer;
        private static DynamicEventToken[] sHttpEventTokens;
        private static Producer sAnonymousPhasesProducer;
        private static DynamicEventToken sAnonymousPhaseToken;
        private static boolean sStaticInitComplete;
        private static AtomicInteger sRecordingCount;
        private FlightRecorderClient mFlightRecorderClient;
        private FlightRecordingClient mFlightRecordingClient;
        private boolean mIsRecordingToFile;
        private long mRecordingSizeInBytes;
        private boolean mCollectStackTraces = true;
        private boolean mAddThread = true;
        private String mOutputFileName;
        private static DynamicValue sDynamicValueECID;
        private static DynamicValue sDynamicValueRID;
        private static Map<String, ProducerProxy> sDynamicProducerMap;
        private static ThreadLocal<Stack<PhaseSensorJFREventTuple>> tPhaseSensorStack;
        private static final ClientObjectKey NOUN_CLIENT_OBJECT_KEY;
        private static final ClientObjectKey SENSOR_CLIENT_OBJECT_KEY;

        JFRIntegration() {
        }

        static JFRIntegration getInstance(String outputFileName, long recordingSizeInBytes, boolean collectStackTraces, boolean addThread) {
            JFRIntegration retVal = null;
            retVal = new JFRIntegration();
            retVal.mOutputFileName = outputFileName;
            retVal.mRecordingSizeInBytes = recordingSizeInBytes;
            retVal.mCollectStackTraces = collectStackTraces;
            retVal.mAddThread = addThread;
            retVal.init();
            return retVal;
        }

        void init() {
            String METHOD_NAME = "init";
            JFRIntegration.staticInit();
            try {
                final JFRIntegration jfri = this;
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        jfri.initJFR();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Throwable t = e;
                if (e instanceof PrivilegedActionException) {
                    t = ((PrivilegedActionException)e).getCause();
                }
                sLogger.logp(Level.FINE, CLASS_NAME, "init", "An exception has prevented complete initialization of " + this.toString(), t);
                throw new RuntimeException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void staticInit() {
            String METHOD_NAME = "staticInit";
            Class<JFRIntegration> clazz = JFRIntegration.class;
            synchronized (JFRIntegration.class) {
                if (!sStaticInitComplete) {
                    tPhaseSensorStack = new ThreadLocal();
                    sDynamicProducerMap = new HashMap<String, ProducerProxy>();
                    try {
                        sDynamicValueECID = new DynamicValue("ECID", "ECID", "The DMS execution context ID in place at the time of the event.", "http://www.oracle.com/fmw/ECID", (String)null, String.class);
                        sDynamicValueRID = new DynamicValue("RID", "RID", "The DMS relationship ID in place at the time of the event.", "http://www.oracle.com/fmw/RID", (String)null, String.class);
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                JFRIntegration.initStaticProducers();
                                return null;
                            }
                        });
                    }
                    catch (Exception e) {
                        Throwable t = e;
                        if (e instanceof PrivilegedActionException) {
                            t = ((PrivilegedActionException)e).getCause();
                        }
                        sLogger.logp(Level.FINE, CLASS_NAME, "staticInit", "An exception has prevented static initialization of JFRIntegration class", t);
                        throw new RuntimeException(t);
                    }
                    sStaticInitComplete = true;
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initJFR() throws InstanceNotFoundException, IOException, NoSuchRecordingException, NoSuchEventException {
            String METHOD_NAME = "initJFR";
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "initJFR", "Configuring JFR settings for " + this.toString());
            }
            this.mFlightRecorderClient = new FlightRecorderClient();
            this.mFlightRecordingClient = this.mFlightRecorderClient.createRecordingObject(JFRDestination.RECORDING_NAME_PREFIX + sRecordingCount.incrementAndGet());
            this.mFlightRecordingClient.setMaxSize(this.mRecordingSizeInBytes);
            this.mIsRecordingToFile = false;
            if (this.mOutputFileName != null) {
                this.mIsRecordingToFile = true;
                this.mFlightRecordingClient.setDestination(this.mOutputFileName);
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "initJFR", "Configured JFR to make a DMS recording to file " + this.mOutputFileName);
                }
            }
            this.mFlightRecordingClient.start();
            this.mFlightRecordingClient.setEventEnabled(sContextEventTokens[0].getId(), true);
            this.mFlightRecordingClient.setEventEnabled(sContextEventTokens[1].getId(), true);
            this.mFlightRecordingClient.setEventEnabled(sHttpEventTokens[0].getId(), true);
            this.mFlightRecordingClient.setEventEnabled(sHttpEventTokens[1].getId(), true);
            this.mFlightRecordingClient.setEventEnabled(sAnonymousPhaseToken.getId(), true);
            Map<String, ProducerProxy> map = sDynamicProducerMap;
            synchronized (map) {
                for (ProducerProxy producerProxy : sDynamicProducerMap.values()) {
                    if (producerProxy.mDynamicEventTokenMap == null) continue;
                    for (DynamicEventToken token : producerProxy.mDynamicEventTokenMap.values()) {
                        this.mFlightRecordingClient.setEventEnabled(token.getId(), true);
                    }
                }
            }
        }

        private static void initStaticProducers() throws Exception {
            String METHOD_NAME = "initStaticProducers";
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "initStaticProducers", "Starting initialization of static producers.");
            }
            sContextProducer = new Producer("DMS-Context", "The DMS Execution Context Producer", "http://www.oracle.com/dms-context");
            sContextEventTokens = new DynamicEventToken[2];
            JFRIntegration.sContextEventTokens[0] = sContextProducer.createDynamicInstantEvent("DMS execution context start", "Start of an execution context", "dms/ExecutionContext/start", true, true, new DynamicValue[]{sDynamicValueECID, sDynamicValueRID});
            JFRIntegration.sContextEventTokens[1] = sContextProducer.createDynamicDurationEvent("DMS execution context", "Span of an execution context", "dms/ExecutionContext/span", true, true, new DynamicValue[]{sDynamicValueECID, sDynamicValueRID});
            sContextProducer.register();
            sHttpProducer = new Producer("Http", "The DMS HTTP Producer", "http://www.oracle.com/dms-http");
            DynamicValue queryStringDV = new DynamicValue("RequestQueryString", "HTTP request query string", "The query string of the HTTP request.", String.class);
            DynamicValue requestUriDV = new DynamicValue("RequestURI", "HTTP request URI", "The URI of the HTTP request.", "http://www.oracle.com/fmw/RequestURI", null, String.class);
            sHttpEventTokens = new DynamicEventToken[2];
            JFRIntegration.sHttpEventTokens[0] = sHttpProducer.createDynamicInstantEvent("HTTP request begin", "The start of an HTTP request", "dms/HttpRequest/start", true, true, new DynamicValue[]{sDynamicValueECID, sDynamicValueRID, requestUriDV, queryStringDV});
            JFRIntegration.sHttpEventTokens[1] = sHttpProducer.createDynamicDurationEvent("HTTP request", "The span of an HTTP request", "dms/HttpRequest/span", true, true, new DynamicValue[]{sDynamicValueECID, sDynamicValueRID, requestUriDV, queryStringDV});
            sHttpProducer.register();
            sAnonymousPhasesProducer = new Producer("DMS-AnonymousPhase", "The DMS Anonymous Phase Producer", "http://www.oracle.com/dms-anonymous-phase");
            DynamicValue nounTypeDV = new DynamicValue("NounType", "Noun type", "The noun type of the anonmous phase event.", String.class);
            DynamicValue nounPathDV = new DynamicValue("LeadingNounPath", "Leading noun path", "The leading path of the noun on which the anonymous phase event has taken place.", String.class);
            DynamicValue sensorNameDV = new DynamicValue("SensorName", "Sensor name", "The name of the phase event that has been started anonymously.", String.class);
            sAnonymousPhaseToken = sAnonymousPhasesProducer.createDynamicDurationEvent("Anonymous phase", "The span of an anonymous phase", "dms/AnonymousPhase/span", true, true, new DynamicValue[]{sDynamicValueECID, sDynamicValueRID, nounTypeDV, nounPathDV, sensorNameDV});
            sAnonymousPhasesProducer.register();
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "initStaticProducers", "Finished initialization of static producers.");
            }
        }

        private void shutdownJFR() {
            String METHOD_NAME = "shutdownJFR";
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "shutdownJFR", "Starting process of clearing references in JFR to this destination.");
            }
            if (this.mIsRecordingToFile) {
                try {
                    this.mFlightRecordingClient.stop();
                }
                catch (IOException e) {
                    LogRecord lr = new LogRecord(Level.WARNING, "DMS-58036");
                    lr.setResourceBundle(sLogger.getResourceBundle());
                    lr.setSourceClassName(CLASS_NAME);
                    lr.setSourceMethodName("shutdownJFR");
                    lr.setThrown(e);
                    sLogger.log(lr);
                }
            }
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "shutdownJFR", "Finished process of clearing references in JFR to this destination.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void staticShutdown() {
            String METHOD_NAME = "staticShutdown";
            int clearedCount = this.clearClientObjects(Noun.getRoot());
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.logp(Level.FINER, CLASS_NAME, "staticShutdown", "Cleared " + clearedCount + " client objects from the noun and sensor tree.");
            }
            Class<JFRIntegration> clazz = JFRIntegration.class;
            synchronized (JFRIntegration.class) {
                for (ProducerProxy pp : sDynamicProducerMap.values()) {
                    if (pp.mProducer == null) continue;
                    pp.mProducer.unregister();
                }
                sHttpProducer.unregister();
                sContextProducer.unregister();
                sStaticInitComplete = false;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }

        private int clearClientObjects(Noun n) {
            Vector<Noun> nouns;
            Sensor[] sensors;
            int retVal = 0;
            Object o = null;
            o = n.setClientObject(NOUN_CLIENT_OBJECT_KEY, null);
            if (o != null) {
                ++retVal;
            }
            if ((sensors = n.getSensors()) != null) {
                for (Sensor sensor : sensors) {
                    o = sensor.setClientObject(SENSOR_CLIENT_OBJECT_KEY, null);
                    if (o == null) continue;
                    ++retVal;
                }
            }
            if ((nouns = n.getNouns()) != null) {
                for (Noun childNoun : nouns) {
                    retVal += this.clearClientObjects(childNoun);
                }
            }
            return retVal;
        }

        public void handleEvent(Event event) {
            String METHOD_NAME = "handleEvent";
            try {
                Sensor s;
                Noun n;
                NounDescriptor d;
                EventSourceType eventSourceType = event.getSourceType();
                if (eventSourceType == EventSourceType.HTTP_REQUEST) {
                    this.handleHttpEvent(event);
                } else if (eventSourceType == EventSourceType.EXECUTION_CONTEXT) {
                    this.handleContextEvent(event);
                } else if (eventSourceType.isTypeOf(EventSourceType.ANONYMOUS_PHASE_SENSOR)) {
                    NounDescriptor d2;
                    String nounType = (String)event.getSubsidiaryObject(1);
                    if (nounType != null && (d2 = Noun.getDescriptorByType(nounType)) != null) {
                        this.handleAnonymousPhaseEvent(event, d2);
                    }
                } else if (eventSourceType.isTypeOf(EventSourceType.SENSOR) && (d = (n = (s = (Sensor)event.getSource()).getParent()).getDescriptor()) != null) {
                    if (eventSourceType == EventSourceType.PHASE_SENSOR) {
                        this.handlePhaseSensorEvent(event, d, n, (PhaseEvent)s);
                    } else if (eventSourceType == EventSourceType.EVENT_SENSOR || eventSourceType == EventSourceType.STATE_SENSOR) {
                        this.handleEventOrStateSensorEvent(event, d, n, s);
                    }
                }
            }
            catch (Exception e) {
                sLogger.logp(Level.FINER, CLASS_NAME, "handleEvent", "Error handling event '" + event.toString() + "' in " + this.toString(), e);
            }
        }

        private void handleHttpEvent(Event event) {
            Object o;
            String DMS_JFR_DURATION_EVENT_KEY = "oracle.dms.jfr.HttpDurationEvent";
            String ECID = null;
            String RID2 = null;
            ExecutionContext ctx = event.getExecutionContext();
            if (ctx != null) {
                ECID = ctx.getECID();
                RID2 = ctx.getRID().toString();
            }
            String requestURI = null;
            String requestQueryString = null;
            HttpServletRequest httpRequest = (HttpServletRequest)event.getSubsidiaryObject(0);
            if (httpRequest != null) {
                requestURI = httpRequest.getRequestURI();
                requestQueryString = httpRequest.getQueryString();
            }
            if (event.getActionType() == EventActionType.START) {
                InstantEvent jfrEvent;
                if (sHttpEventTokens[0].isEnabled()) {
                    jfrEvent = sHttpEventTokens[0].newInstantEvent();
                    jfrEvent.setValue(0, (Object)ECID);
                    jfrEvent.setValue(1, (Object)RID2);
                    jfrEvent.setValue(2, (Object)requestURI);
                    jfrEvent.setValue(3, (Object)requestQueryString);
                    jfrEvent.commit();
                }
                if (sHttpEventTokens[1].isEnabled() && httpRequest != null) {
                    jfrEvent = sHttpEventTokens[1].newDurationEvent();
                    jfrEvent.begin();
                    jfrEvent.setValue(0, (Object)ECID);
                    jfrEvent.setValue(1, (Object)RID2);
                    jfrEvent.setValue(2, (Object)requestURI);
                    jfrEvent.setValue(3, (Object)requestQueryString);
                    httpRequest.setAttribute("oracle.dms.jfr.HttpDurationEvent", (Object)jfrEvent);
                }
            } else if (event.getActionType() == EventActionType.STOP && httpRequest != null && (o = httpRequest.getAttribute("oracle.dms.jfr.HttpDurationEvent")) != null) {
                DurationEvent jfrEvent = (DurationEvent)o;
                jfrEvent.end();
                jfrEvent.commit();
            }
        }

        private void handleContextEvent(Event event) {
            DurationEventContextContent cc;
            String DMS_JFR_CTX_DURATION_KEY = "oracle.dms.jfr.ContextDurationEvent";
            String ECID = null;
            String RID2 = null;
            ExecutionContext ctx = event.getExecutionContext();
            if (ctx != null) {
                ECID = ctx.getECID();
                RID2 = ctx.getRID().toString();
            }
            if (event.getActionType() == EventActionType.START) {
                InstantEvent jfrEvent;
                if (sContextEventTokens[0].isEnabled()) {
                    jfrEvent = sContextEventTokens[0].newInstantEvent();
                    jfrEvent.setValue(0, (Object)ECID);
                    jfrEvent.setValue(1, (Object)RID2);
                    jfrEvent.commit();
                }
                if (ctx != null) {
                    if (sContextEventTokens[1].isEnabled()) {
                        jfrEvent = sContextEventTokens[1].newDurationEvent();
                        jfrEvent.begin();
                        jfrEvent.setValue(0, (Object)ECID);
                        jfrEvent.setValue(1, (Object)RID2);
                        DurationEventContextContent cc2 = new DurationEventContextContent((DurationEvent)jfrEvent);
                        ctx.setContent("oracle.dms.jfr.ContextDurationEvent", cc2);
                    }
                    ctx.setUpdateSqlText(true);
                }
            } else if (event.getActionType() == EventActionType.STOP && ctx != null && (cc = (DurationEventContextContent)ctx.getContent("oracle.dms.jfr.ContextDurationEvent")) != null && cc.mDurationEvent != null) {
                cc.mDurationEvent.end();
                cc.mDurationEvent.commit();
            }
        }

        private void handleEventOrStateSensorEvent(Event event, NounDescriptor nounDescriptor, Noun noun, Sensor sensor) {
            DynamicEventToken token;
            if (event.getActionType() == EventActionType.UPDATE && nounDescriptor != null && (token = this.getDynamicEventTokenForNoun(nounDescriptor, noun)) != null && token.isEnabled()) {
                InstantEvent jfrEvent = token.newInstantEvent();
                ExecutionContext ctx = event.getExecutionContext();
                if (ctx != null) {
                    jfrEvent.setValue(0, (Object)ctx.getECID());
                    jfrEvent.setValue(1, (Object)ctx.getRID().toString());
                    jfrEvent.setValue(2, (Object)noun.toString());
                }
                this.populateDynamicEvent(jfrEvent, nounDescriptor, noun, sensor, event);
                String valueId = this.getDynamicValueIdForUpdatedSensor(nounDescriptor);
                if (event.getSourceType() == EventSourceType.EVENT_SENSOR) {
                    jfrEvent.setValue(valueId, (Object)sensor.getName());
                } else if (event.getSourceType() == EventSourceType.STATE_SENSOR) {
                    jfrEvent.setValue(valueId, (Object)(sensor.getName() + " updated"));
                }
                jfrEvent.commit();
            }
        }

        private Stack<PhaseSensorJFREventTuple> getPhaseSensorStack() {
            Stack<PhaseSensorJFREventTuple> stack = tPhaseSensorStack.get();
            if (stack == null) {
                stack = new Stack();
                tPhaseSensorStack.set(stack);
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "getPhaseEventStack", "Created thread local stack for phase event handling on thread " + Thread.currentThread().getId());
                }
            }
            return stack;
        }

        private PhaseSensorJFREventTuple popPhaseSensorStack(Stack<PhaseSensorJFREventTuple> stack, PhaseEvent phaseSensor, NounDescriptor nounDescriptor) {
            String METHOD_NAME = "popPhaseSensorStack";
            PhaseSensorJFREventTuple tuple = null;
            if (stack != null && stack.size() > 0 && !(tuple = stack.pop()).matches(phaseSensor, nounDescriptor)) {
                if (sLogger.isLoggable(Level.FINER)) {
                    sLogger.logp(Level.FINER, CLASS_NAME, "popPhaseSensorStack", "Phase sensor tuple on top of stack, " + tuple.toString() + ", does not match phase sensor of the event being processed " + phaseSensor.toString());
                }
                while (stack.size() > 0 && !(tuple = stack.pop()).matches(phaseSensor, nounDescriptor)) {
                    if (!sLogger.isLoggable(Level.FINER)) continue;
                    sLogger.logp(Level.FINER, CLASS_NAME, "popPhaseSensorStack", "Popped non-matching phase sensor from stack: " + tuple.toString());
                }
            }
            return tuple;
        }

        private PhaseSensorJFREventTuple popPhaseSensorStack(Stack<PhaseSensorJFREventTuple> stack, String nounType, String leadingNounPath) {
            String METHOD_NAME = "popPhaseSensorStack";
            PhaseSensorJFREventTuple tuple = null;
            if (stack != null && stack.size() > 0 && !(tuple = stack.pop()).matches(nounType, leadingNounPath)) {
                if (sLogger.isLoggable(Level.FINER)) {
                    sLogger.logp(Level.FINER, CLASS_NAME, "popPhaseSensorStack", "Phase sensor tuple on top of stack, " + tuple.toString() + ", does not match the anonmymous phase of the event being processed " + nounType + "/" + leadingNounPath);
                }
                while (stack.size() > 0 && !(tuple = stack.pop()).matches(nounType, leadingNounPath)) {
                    if (!sLogger.isLoggable(Level.FINER)) continue;
                    sLogger.logp(Level.FINER, CLASS_NAME, "popPhaseSensorStack", "Popped non-matching phase sensor from stack: " + tuple.toString());
                }
            }
            return tuple;
        }

        private void handleAnonymousPhaseEvent(Event event, NounDescriptor nounDescriptor) {
            String METHOD_NAME = "handleAnonymousPhaseEvent";
            if (nounDescriptor != null) {
                PhaseSensorJFREventTuple tuple;
                Stack<PhaseSensorJFREventTuple> stack = this.getPhaseSensorStack();
                String nounType = nounDescriptor.getName();
                String leadingNounPath = (String)event.getSubsidiaryObject(2);
                Object sensorName = null;
                if (event.getActionType() == EventActionType.START) {
                    DynamicEventToken token = sAnonymousPhaseToken;
                    if (token != null) {
                        DurationEvent jfrEvent = null;
                        if (token.isEnabled()) {
                            jfrEvent = token.newDurationEvent();
                            ExecutionContext ctx = event.getExecutionContext();
                            if (ctx != null) {
                                jfrEvent.setValue(0, (Object)ctx.getECID());
                                jfrEvent.setValue(1, (Object)ctx.getRID().toString());
                                jfrEvent.setValue(2, (Object)nounType);
                                jfrEvent.setValue(3, (Object)leadingNounPath);
                                jfrEvent.setValue(4, sensorName);
                            }
                            jfrEvent.begin();
                        }
                        stack.push(new PhaseSensorJFREventTuple(jfrEvent, nounType, leadingNounPath));
                    } else if (sLogger.isLoggable(Level.FINER)) {
                        sLogger.logp(Level.FINER, CLASS_NAME, "handleAnonymousPhaseEvent", "Failed to push a PhaseSensorJFREventTuple onto the stack in response to event " + event.toString());
                    }
                } else if (event.getActionType() == EventActionType.ABORT && (tuple = this.popPhaseSensorStack(stack, nounType, leadingNounPath)) == null && sLogger.isLoggable(Level.FINER)) {
                    sLogger.logp(Level.FINER, CLASS_NAME, "handleAnonymousPhaseEvent", "Tuple stack is empty which is not a good state when handling a phase event stop or abort: " + event);
                }
            }
        }

        private void handlePhaseSensorEvent(Event event, NounDescriptor nounDescriptor, Noun noun, PhaseEvent phaseSensor) {
            String METHOD_NAME = "handlePhaseSensorEvent";
            if (nounDescriptor != null) {
                DynamicEventToken token;
                Stack<PhaseSensorJFREventTuple> stack = this.getPhaseSensorStack();
                if (event.getActionType() == EventActionType.STOP || event.getActionType() == EventActionType.ABORT) {
                    PhaseSensorJFREventTuple tuple = this.popPhaseSensorStack(stack, phaseSensor, nounDescriptor);
                    if (tuple != null) {
                        if (tuple.matches(phaseSensor, nounDescriptor)) {
                            if (event.getActionType() == EventActionType.STOP && tuple.mDurationEvent != null) {
                                if (!tuple.mIsAnonymousPhase) {
                                    this.populateDynamicEvent((InstantEvent)tuple.mDurationEvent, nounDescriptor, noun, phaseSensor, event);
                                }
                                tuple.mDurationEvent.end();
                                tuple.mDurationEvent.commit();
                            }
                        } else if (sLogger.isLoggable(Level.FINER)) {
                            sLogger.logp(Level.FINER, CLASS_NAME, "handlePhaseSensorEvent", "Could not find a phase sensor on the stack that matched the event being handled: " + event);
                        }
                    } else if (sLogger.isLoggable(Level.FINER)) {
                        sLogger.logp(Level.FINER, CLASS_NAME, "handlePhaseSensorEvent", "Tuple stack is empty which is not a good state when handling a phase event stop or abort: " + event);
                    }
                } else if (event.getActionType() == EventActionType.START && (token = this.getDynamicEventTokenForPhaseSensor(nounDescriptor, noun, phaseSensor)) != null) {
                    DurationEvent jfrEvent = null;
                    if (token.isEnabled()) {
                        jfrEvent = token.newDurationEvent();
                        ExecutionContext ctx = event.getExecutionContext();
                        if (ctx != null) {
                            jfrEvent.setValue(0, (Object)ctx.getECID());
                            jfrEvent.setValue(1, (Object)ctx.getRID().toString());
                            jfrEvent.setValue(2, (Object)noun.toString());
                        }
                        jfrEvent.begin();
                    }
                    stack.push(new PhaseSensorJFREventTuple(phaseSensor, jfrEvent));
                }
            }
        }

        private DynamicEventToken getDynamicEventTokenForNoun(final NounDescriptor nounDescriptor, final Noun noun) {
            String METHOD_NAME = "getDynamicEventTokeForNoun";
            DynamicEventToken retVal = (DynamicEventToken)noun.getClientObject(NOUN_CLIENT_OBJECT_KEY);
            if (retVal == null) {
                String eventTypeName;
                String producerName;
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "getDynamicEventTokeForNoun", "DynamicEventToken not found as client object on noun '" + noun.toString() + "'.");
                }
                if ((retVal = this.findEventType(producerName = JFRIntegration.getProducerName(noun), eventTypeName = this.getEventTypeName(nounDescriptor))) == null) {
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.logp(Level.FINE, CLASS_NAME, "getDynamicEventTokeForNoun", "DynamicEventToken of name '" + eventTypeName + "' in producer '" + producerName + "' not yet known - will attempt to create it using sample noun '" + noun.toString() + "'.");
                    }
                    retVal = AccessController.doPrivileged(new PrivilegedAction<DynamicEventToken>(){

                        @Override
                        public DynamicEventToken run() {
                            DynamicEventToken det = JFRIntegration.this.createDynamicEventTokenForNoun(nounDescriptor, noun, producerName, eventTypeName);
                            return det;
                        }
                    });
                }
                noun.setClientObject(NOUN_CLIENT_OBJECT_KEY, retVal);
            }
            return retVal;
        }

        private void populateDynamicEvent(InstantEvent jfrEvent, NounDescriptor nounDescriptor, Noun noun, Sensor updatedSensor, Event dmsEvent) {
            Sensor[] sensors;
            String METHOD_NAME = "populateDynamicEvent";
            for (Sensor sensor : sensors = noun.getSensors()) {
                if (!(sensor instanceof State)) continue;
                String valueId = this.getDynamicValueIdForStateSensor(nounDescriptor, sensor.getName());
                Object oValue = null;
                if (updatedSensor == sensor) {
                    oValue = dmsEvent.getSubsidiaryObject(0);
                } else {
                    Metric m = sensor.getMetric(1);
                    if (m != null) {
                        oValue = sensor.getValue();
                    }
                }
                if (oValue == null) continue;
                try {
                    jfrEvent.setValue(valueId, (Object)oValue.toString());
                }
                catch (IllegalArgumentException iae) {
                    if (!sLogger.isLoggable(Level.FINEST)) continue;
                    sLogger.logp(Level.FINEST, CLASS_NAME, "populateDynamicEvent", "Can not set value of Id='" + valueId + "' on jfr event " + jfrEvent);
                }
            }
            ActivationParameter[] actParams = updatedSensor.getActivationParametersFromEvent(dmsEvent);
            if (actParams != null) {
                for (ActivationParameter actParam : actParams) {
                    String valueId = this.getDynamicValueIdForActivationParameter(nounDescriptor, actParam.getDescriptor());
                    String value = actParam.getValue();
                    jfrEvent.setValue(valueId, (Object)(value == null ? "null" : value.toString()));
                }
            }
            if (sLogger.isLoggable(Level.FINEST)) {
                sLogger.logp(Level.FINEST, CLASS_NAME, "populateDynamicEvent", "Populated JFR event '" + jfrEvent + "' in response to DMS event '" + dmsEvent + "'.");
            }
        }

        private DynamicEventToken getDynamicEventTokenForPhaseSensor(final NounDescriptor nounDescriptor, final Noun noun, final PhaseEvent phaseSensor) {
            String METHOD_NAME = "getDynamicEventTokenForPhaseSensor";
            DynamicEventToken retVal = (DynamicEventToken)phaseSensor.getClientObject(SENSOR_CLIENT_OBJECT_KEY);
            if (retVal == null) {
                String eventTypeName;
                String producerName;
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "getDynamicEventTokenForPhaseSensor", "DynamicEventToken not found as client object on phase sensor '" + phaseSensor.toString() + "'.");
                }
                if ((retVal = this.findEventType(producerName = JFRIntegration.getProducerName(noun), eventTypeName = this.getEventTypeName(nounDescriptor, phaseSensor))) == null) {
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.logp(Level.FINE, CLASS_NAME, "getDynamicEventTokenForPhaseSensor", "DynamicEventToken of name '" + eventTypeName + "' in producer '" + producerName + "' not yet known - will attempt to create it using sample noun '" + noun.toString() + "'.");
                    }
                    retVal = AccessController.doPrivileged(new PrivilegedAction<DynamicEventToken>(){

                        @Override
                        public DynamicEventToken run() {
                            DynamicEventToken det = JFRIntegration.this.createDynamicEventTokenForPhaseSensor(nounDescriptor, noun, producerName, eventTypeName, phaseSensor);
                            return det;
                        }
                    });
                    phaseSensor.setClientObject(SENSOR_CLIENT_OBJECT_KEY, retVal);
                }
            }
            return retVal;
        }

        private DynamicEventToken findEventType(String producerName, String eventTypeName) {
            DynamicEventToken retVal = null;
            ProducerProxy pp = sDynamicProducerMap.get(producerName);
            if (pp != null) {
                retVal = pp.mDynamicEventTokenMap.get(eventTypeName);
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicEventToken createDynamicEventTokenForNoun(NounDescriptor nounDescriptor, Noun noun, String producerName, String eventTypeName) {
            String METHOD_NAME = "createDynamicEventTokenForNoun";
            DynamicEventToken retVal = null;
            ProducerProxy producerProxy = JFRIntegration.getProducerProxy(producerName);
            if (producerProxy.mProducer != null) {
                retVal = producerProxy.mDynamicEventTokenMap.get(eventTypeName);
                if (retVal == null) {
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.logp(Level.FINE, CLASS_NAME, "createDynamicEventTokenForNoun", "Attempting to create DynamicEventToken of name '" + eventTypeName + "' in producer '" + producerName + "' using sample noun '" + noun.toString() + "' of noun type '" + nounDescriptor.getName() + "'.");
                    }
                    String nounDescriptorName = nounDescriptor.getName();
                    String eventTypeDescription = "The current state of this " + nounDescriptorName;
                    String eventTypePath = this.getEventTypePath(producerName, nounDescriptorName, eventTypeName);
                    DynamicValue[] dynValues = this.createDynamicValueArray(nounDescriptor, true);
                    Map<String, DynamicEventToken> map = producerProxy.mDynamicEventTokenMap;
                    synchronized (map) {
                        retVal = producerProxy.mDynamicEventTokenMap.get(eventTypeName);
                        if (retVal == null) {
                            try {
                                retVal = producerProxy.mProducer.createDynamicInstantEvent(eventTypeName, eventTypeDescription, eventTypePath, this.mAddThread, this.mCollectStackTraces, dynValues);
                                producerProxy.mDynamicEventTokenMap.put(eventTypeName, retVal);
                                this.mFlightRecordingClient.setEventEnabled(retVal.getId(), true);
                                this.mFlightRecordingClient.setStackTraceEnabled(retVal.getId(), this.mCollectStackTraces);
                            }
                            catch (Exception e) {
                                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58036");
                                lr.setResourceBundle(sLogger.getResourceBundle());
                                lr.setSourceClassName(CLASS_NAME);
                                lr.setSourceMethodName("createDynamicEventTokenForNoun");
                                lr.setParameters(new Object[]{eventTypeName, eventTypeDescription, eventTypePath});
                                lr.setThrown(e);
                                sLogger.log(lr);
                            }
                        }
                    }
                }
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "createDynamicEventTokenForNoun", "Called to create DynamicEventToken of name '" + eventTypeName + "' in producer '" + producerName + "' using sample noun '" + noun.toString() + "' of noun type '" + nounDescriptor.getName() + "' then found it already created in the ProducerProxy's cache.");
                }
            }
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DynamicEventToken createDynamicEventTokenForPhaseSensor(NounDescriptor nounDescriptor, Noun noun, String producerName, String eventTypeName, PhaseEvent phaseSensor) {
            String METHOD_NAME = "createDynamicEventTokenForPhaseSensor";
            DynamicEventToken retVal = null;
            ProducerProxy producerProxy = JFRIntegration.getProducerProxy(producerName);
            if (producerProxy.mProducer != null) {
                retVal = producerProxy.mDynamicEventTokenMap.get(eventTypeName);
                if (retVal == null) {
                    if (sLogger.isLoggable(Level.FINE)) {
                        sLogger.logp(Level.FINE, CLASS_NAME, "createDynamicEventTokenForPhaseSensor", "Attempting to create DynamicEventToken of name '" + eventTypeName + "' in producer '" + producerName + "' using phase sensor '" + phaseSensor.toString() + "' in a noun of type '" + nounDescriptor.getName() + "'.");
                    }
                    String eventTypeDescription = phaseSensor.getDescription();
                    String nounDescriptorName = nounDescriptor.getName();
                    String eventTypePath = this.getEventTypePath(producerName, nounDescriptorName, eventTypeName);
                    DynamicValue[] dynValues = this.createDynamicValueArray(nounDescriptor, false);
                    Map<String, DynamicEventToken> map = producerProxy.mDynamicEventTokenMap;
                    synchronized (map) {
                        retVal = producerProxy.mDynamicEventTokenMap.get(eventTypeName);
                        if (retVal == null) {
                            try {
                                retVal = producerProxy.mProducer.createDynamicDurationEvent(eventTypeName, eventTypeDescription, eventTypePath, true, true, dynValues);
                                producerProxy.mDynamicEventTokenMap.put(eventTypeName, retVal);
                                this.mFlightRecordingClient.setEventEnabled(retVal.getId(), true);
                            }
                            catch (Exception e) {
                                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58036");
                                lr.setResourceBundle(sLogger.getResourceBundle());
                                lr.setSourceClassName(CLASS_NAME);
                                lr.setSourceMethodName("createDynamicEventTokenForPhaseSensor");
                                lr.setParameters(new Object[]{eventTypeName, eventTypeDescription, eventTypePath});
                                lr.setThrown(e);
                                sLogger.log(lr);
                            }
                        }
                    }
                }
                if (sLogger.isLoggable(Level.FINE)) {
                    sLogger.logp(Level.FINE, CLASS_NAME, "createDynamicEventTokenForPhaseSensor", "Called to create DynamicEventToken of name '" + eventTypeName + "' in producer '" + producerName + "' using phase sensor '" + phaseSensor.toString() + "' in a noun of type '" + nounDescriptor.getName() + "' but then found it already created and in the ProducerProxy's cache.");
                }
            }
            return retVal;
        }

        private DynamicValue[] createDynamicValueArray(NounDescriptor nounDescriptor, boolean includeUpdatedSensorValue) {
            String METHOD_NAME = "createDynamicValueArray";
            DynamicValue[] retVal = null;
            ArrayList<DynamicValue> dynValueList = new ArrayList<DynamicValue>(8);
            StringBuilder stringBuilder = null;
            if (sLogger.isLoggable(Level.FINE)) {
                stringBuilder = new StringBuilder(256);
            }
            String jfrValueId = null;
            Object jfrValueName = null;
            String jfrValueDescription = null;
            String jfrValueRelationalKey = null;
            dynValueList.add(sDynamicValueECID);
            if (stringBuilder != null) {
                stringBuilder.append("('ECID') ");
            }
            dynValueList.add(sDynamicValueRID);
            if (stringBuilder != null) {
                stringBuilder.append("('RID') ");
            }
            jfrValueId = "nounName";
            jfrValueName = nounDescriptor.getName() + " name";
            jfrValueRelationalKey = "http://www.oracle.com/dms/nounType/" + nounDescriptor.getName() + "/name";
            jfrValueDescription = "The path used to identify this particular " + nounDescriptor.getName();
            JFRIntegration.addNewDynamicValueToList(jfrValueId, (String)jfrValueName, jfrValueDescription, dynValueList, jfrValueRelationalKey, nounDescriptor, stringBuilder);
            if (nounDescriptor.getActivationParameterDescriptors() != null) {
                for (ActivationParameterDescriptor apd : nounDescriptor.getActivationParameterDescriptors()) {
                    jfrValueId = this.getDynamicValueIdForActivationParameter(nounDescriptor, apd);
                    jfrValueName = apd.getName();
                    jfrValueDescription = apd.getDescription(Locale.ENGLISH);
                    JFRIntegration.addNewDynamicValueToList(jfrValueId, (String)jfrValueName, jfrValueDescription, dynValueList, null, nounDescriptor, stringBuilder);
                }
            }
            for (String sensorName : nounDescriptor.getSensorNames()) {
                SensorDescriptor sensorDescriptor = nounDescriptor.getSensorDescriptor(sensorName);
                if (!"State".equals(sensorDescriptor.getType())) continue;
                jfrValueId = this.getDynamicValueIdForStateSensor(nounDescriptor, sensorName);
                jfrValueName = sensorName;
                jfrValueDescription = sensorDescriptor.getDescription();
                JFRIntegration.addNewDynamicValueToList(jfrValueId, (String)jfrValueName, jfrValueDescription, dynValueList, null, nounDescriptor, stringBuilder);
            }
            if (includeUpdatedSensorValue) {
                jfrValueId = this.getDynamicValueIdForUpdatedSensor(nounDescriptor);
                jfrValueName = nounDescriptor.getName() + " action";
                jfrValueRelationalKey = "http://www.oracle.com/dms/nounType/" + nounDescriptor.getName() + "/updatedSensorName";
                jfrValueDescription = "The name of the sensor the update of which has caused the state if this particular " + nounDescriptor.getName() + " to be recorded at this time.";
                JFRIntegration.addNewDynamicValueToList(jfrValueId, (String)jfrValueName, jfrValueDescription, dynValueList, jfrValueRelationalKey, nounDescriptor, stringBuilder);
            }
            retVal = new DynamicValue[dynValueList.size()];
            retVal = dynValueList.toArray(retVal);
            if (sLogger.isLoggable(Level.FINE)) {
                sLogger.logp(Level.FINE, CLASS_NAME, "createDynamicValueArray", "Created DynamicValue array for nouns of type '" + nounDescriptor.getName() + "', the content of the array is: " + stringBuilder.toString());
            }
            return retVal;
        }

        private static void addNewDynamicValueToList(String valueId, String valueName, String valueDescription, List<DynamicValue> list, String valueRelationalKey, NounDescriptor nounDescriptor, StringBuilder stringBuilder) {
            String METHOD_NAME = "addNewDynamicValueToList";
            try {
                if (valueDescription == null) {
                    valueDescription = "";
                }
                DynamicValue dv = valueRelationalKey != null ? new DynamicValue(valueId, valueName, valueDescription, valueRelationalKey, null, String.class) : new DynamicValue(valueId, valueName, valueDescription, String.class);
                list.add(dv);
                if (stringBuilder != null) {
                    stringBuilder.append("('").append(valueId).append("','").append(valueName).append("') ");
                }
            }
            catch (Exception ive) {
                LogRecord lr = new LogRecord(Level.WARNING, "DMS-58037");
                lr.setResourceBundle(sLogger.getResourceBundle());
                lr.setSourceClassName(CLASS_NAME);
                lr.setSourceMethodName("addNewDynamicValueToList");
                lr.setParameters(new Object[]{nounDescriptor.getName(), valueId, valueName});
                lr.setThrown(ive);
                sLogger.log(lr);
            }
        }

        private static String getProducerName(Noun noun) {
            if (noun == null) {
                throw new IllegalArgumentException("Can not get a producer name from a null noun");
            }
            if (noun.getParent() == null) {
                throw new IllegalArgumentException("Can not get a producer name from the root noun");
            }
            Noun n3 = noun;
            Noun n2 = n3.getParent();
            Noun n1 = n2.getParent();
            String producerName = null;
            if (n1 == null) {
                producerName = n3.getName();
            } else {
                while (n1.getParent() != null) {
                    n3 = n2;
                    n2 = n1;
                    n1 = n1.getParent();
                }
                producerName = "oracle".equals(n2.getName()) ? n3.getName() : n2.getName();
            }
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.log(Level.FINER, "Got producer name '" + producerName + "' for noun '" + noun.toString() + "'.");
            }
            return producerName;
        }

        private String getEventTypeName(NounDescriptor nounDescriptor) {
            String retVal = nounDescriptor.getName() + " state";
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.log(Level.FINER, "Got event type name '" + retVal + "' for noun type '" + nounDescriptor.getName() + "'.");
            }
            return retVal;
        }

        private String getEventTypeName(NounDescriptor nounDescriptor, PhaseEvent phaseSensor) {
            String retVal = nounDescriptor.getName() + " " + phaseSensor.getName();
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.log(Level.FINER, "Got event type name '" + retVal + "' for noun type '" + nounDescriptor.getName() + "' and phase sensor '" + phaseSensor.getName() + "'.");
            }
            return retVal;
        }

        private String getEventTypePath(String producerName, String nounDescriptorName, String eventTypeName) {
            String retVal = "dms/" + producerName + "/" + nounDescriptorName + "/" + eventTypeName;
            retVal = retVal.replaceAll(" ", "_");
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.log(Level.FINER, "Got event type path '" + retVal + "' given producer name '" + producerName + "' and noun type name '" + nounDescriptorName + "' and event type name '" + eventTypeName + "'.");
            }
            return retVal;
        }

        private String getDynamicValueIdForStateSensor(NounDescriptor nounDescriptor, String sensorName) {
            String retVal = "sensor" + (sensorName.hashCode() ^ nounDescriptor.getName().hashCode());
            return retVal;
        }

        private String getDynamicValueIdForUpdatedSensor(NounDescriptor nounDescriptor) {
            String retVal = nounDescriptor.getName() + "_updatedSensor";
            return retVal;
        }

        private String getDynamicValueIdForActivationParameter(NounDescriptor nounDescriptor, ActivationParameterDescriptor parameterDescriptor) {
            String retVal = nounDescriptor.getName() + "_activationParameter_" + parameterDescriptor.getName();
            return retVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ProducerProxy getProducerProxy(String producerName) {
            String METHOD_NAME = "getProducerProxy";
            ProducerProxy retVal = sDynamicProducerMap.get(producerName);
            if (retVal == null) {
                Map<String, ProducerProxy> map = sDynamicProducerMap;
                synchronized (map) {
                    retVal = sDynamicProducerMap.get(producerName);
                    if (retVal == null) {
                        String producerDescription = "The DMS-instrumentation producer for " + producerName;
                        String producerPath = "http://www.oracle.com/dms/" + producerName;
                        Producer p = null;
                        try {
                            if (sLogger.isLoggable(Level.FINE)) {
                                sLogger.log(Level.FINE, "Creating and registering a producer of name  '" + producerName + "' and description '" + producerDescription + "' and path '" + producerPath + "'.");
                            }
                            p = new Producer(producerName, producerDescription, producerPath);
                            p.register();
                        }
                        catch (Exception e) {
                            LogRecord lr = new LogRecord(Level.WARNING, "DMS-58038");
                            lr.setResourceBundle(sLogger.getResourceBundle());
                            lr.setSourceClassName(CLASS_NAME);
                            lr.setSourceMethodName("getProducerProxy");
                            lr.setParameters(new Object[]{producerName, producerPath});
                            lr.setThrown(e);
                            sLogger.log(lr);
                        }
                        retVal = new ProducerProxy(producerName, p);
                        sDynamicProducerMap.put(producerName, retVal);
                    }
                }
            }
            return retVal;
        }

        static {
            sStaticInitComplete = false;
            sRecordingCount = new AtomicInteger();
            NOUN_CLIENT_OBJECT_KEY = ClientObjectKeyManager.requestClientObjectKey(ClientObjectKeyManager.ClientObjectHolderType.NOUN, "oracle.dms.jrf.DynamicEventToken:DynamicEventToken");
            SENSOR_CLIENT_OBJECT_KEY = ClientObjectKeyManager.requestClientObjectKey(ClientObjectKeyManager.ClientObjectHolderType.SENSOR, "oracle.dms.jrf.DynamicEventToken:DynamicEventToken");
        }
    }
}

