/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.BlockSource;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SimpleByteArray;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterSet;
import oracle.sql.converter.CharacterConverter1Byte;
import oracle.sql.converter.CharacterConverterJDBC;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH, Feature.PARAMETER_SET, Feature.CHARACTER_SET_CONVERSION})
final class DynamicByteArray
extends ByteArray {
    static final int INITIAL_BLOCKS = 16;
    static final int GROWTH_FACTOR = 8;
    private static final int CACHED_CHAR_ARRAY_SIZE = 256;
    private static final int COMPACT_THRESHOLD = 131072;
    private final BlockSource source;
    private final long blockSize;
    private byte[][] blocks;
    protected long length;
    private char[] charsForNewString;
    private static final char[] ISO_LATIN_1_TO_JAVA;
    private static final char[] WE8DEC_TO_JAVA;
    private static final char[] WE8MSWIN1252_TO_JAVA;
    private static final char[] WE8ISO8859P15_TO_JAVA;
    private static final char[] JAVA_TO_ISO_LATIN_1_LEVEL1;
    private static final char[] JAVA_TO_ISO_LATIN_1_LEVEL2;
    private static final char[] JAVA_TO_WE8DEC_LEVEL1;
    private static final char[] JAVA_TO_WE8DEC_LEVEL2;
    private static final char[] JAVA_TO_WE8MSWIN1252_LEVEL1;
    private static final char[] JAVA_TO_WE8MSWIN1252_LEVEL2;
    private static final char[] JAVA_TO_US7ASCII_LEVEL1;
    private static final char[] JAVA_TO_US7ASCII_LEVEL2;
    private static final char[] JAVA_TO_WE8ISO8859P15_LEVEL1;
    private static final char[] JAVA_TO_WE8ISO8859P15_LEVEL2;
    private static final char INVALID_ORA_CHAR = '\uffff';
    private static final char JAVA_TO_ISO_LATIN_1_REPLACEMENT;
    private static final char JAVA_TO_WE8DEC_REPLACEMENT;
    private static final char JAVA_TO_WE8MSWIN1252_REPLACEMENT;
    private static final char JAVA_TO_US7ASCII_REPLACEMENT;
    private static final char JAVA_TO_WE8ISO8859P15_REPLACEMENT;
    private int globalBlockIndex;
    private int globalByteIndex;
    private int globalRemaining;
    private int globalBlockSize;
    private byte[] globalBytes;
    private static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;

    static DynamicByteArray createDynamicByteArray(BlockSource blockSource) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            BlockSource source;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$0, null, blockSource);
            }
            DynamicByteArray dynamicByteArray = new DynamicByteArray(source);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$0, null, dynamicByteArray);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$0, null, null);
            }
            return dynamicByteArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    private DynamicByteArray(BlockSource source) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$66, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$66, null, source);
            }
            this.blocks = new byte[16][];
            this.length = 0L;
            this.charsForNewString = null;
            this.globalBlockIndex = -1;
            this.globalByteIndex = -1;
            this.globalRemaining = -1;
            this.globalBlockSize = -1;
            this.globalBytes = null;
            if (!$assertionsDisabled && source == null) {
                AssertionError assertionError = new AssertionError((Object)"source is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$66, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$66, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.source = source;
            this.blockSize = source.getBlockSize();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$66, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$66, null);
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$66, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$66, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$66, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    long length() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$1, this, new Object[0]);
            }
            long l2 = this.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$1, this, l2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$1, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    long getCapacity() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$2, this, new Object[0]);
            }
            long sum = 0L;
            for (byte[] b2 : this.blocks) {
                if (b2 == null) continue;
                sum += (long)b2.length;
            }
            long l2 = sum;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$2, this, l2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$2, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    private void grow() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$3, this, new Object[0]);
            }
            byte[][] tmp = new byte[this.blocks.length * 8][];
            System.arraycopy(this.blocks, 0, tmp, 0, this.blocks.length);
            this.blocks = tmp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final char[] getCharsForNewString(int n2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void minLen;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$4, this, n2);
            }
            if (this.charsForNewString == null || minLen > this.charsForNewString.length) {
                this.charsForNewString = new char[Math.max(256, (int)minLen)];
            }
            char[] cArray = this.charsForNewString;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$4, this, cArray);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$4, this, null);
            }
            return this.charsForNewString;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int unmarshalCLR(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void mare;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, t4CMAREngine);
            }
            int len = 0;
            int bytesRead = 0;
            len = mare.unmarshalUB1();
            if (len == 0) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, null);
                }
                return 0;
            }
            if (mare.escapeSequenceNull(len)) {
                int n3 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, null);
                }
                return 0;
            }
            this.globalBlockIndex = (int)(this.position / this.blockSize);
            this.globalByteIndex = (int)(this.position % this.blockSize);
            if (len == 254) {
                while (true) {
                    int n4 = len = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                    if (len > 0) {
                        this.unmarshalBuffer((T4CMAREngine)mare, len);
                        bytesRead += len;
                        continue;
                    }
                    break;
                }
            } else {
                this.unmarshalBuffer((T4CMAREngine)mare, len);
                bytesRead += len;
            }
            this.position += (long)bytesRead;
            this.length = Math.max(this.length, this.position + 1L);
            int n5 = bytesRead;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, n5);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int unmarshalCLR(T4CMAREngine t4CMAREngine, int n2) throws SQLException, IOException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void maxLength;
            void mare;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, t4CMAREngine, n2);
            }
            int len = 0;
            int bytesRead = 0;
            int keepThem = 0;
            len = mare.unmarshalUB1();
            if (len == 0) {
                int n3 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, n3);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, null);
                }
                return 0;
            }
            if (mare.escapeSequenceNull(len)) {
                int n4 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, n4);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, null);
                }
                return 0;
            }
            this.globalBlockIndex = (int)(this.position / this.blockSize);
            this.globalByteIndex = (int)(this.position % this.blockSize);
            if (len == 254) {
                while (true) {
                    int n5 = len = mare.useCLRBigChunks ? mare.unmarshalSB4() : (int)mare.unmarshalUB1();
                    if (len > 0) {
                        keepThem = Math.min((int)(maxLength - bytesRead), len);
                        this.unmarshalBuffer((T4CMAREngine)mare, keepThem);
                        bytesRead += keepThem;
                        int rest = len - keepThem;
                        if (rest <= 0) continue;
                        mare.unmarshalBuffer(T4CMAREngine.IGNORED, 0, rest);
                        continue;
                    }
                    break;
                }
            } else {
                keepThem = Math.min((int)(maxLength - bytesRead), len);
                this.unmarshalBuffer((T4CMAREngine)mare, keepThem);
                bytesRead += keepThem;
                int rest = len - keepThem;
                if (rest > 0) {
                    mare.unmarshalBuffer(T4CMAREngine.IGNORED, 0, rest);
                }
            }
            this.position += (long)bytesRead;
            this.length = Math.max(this.length, this.position + 1L);
            int n6 = bytesRead;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, n6);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, null);
            }
            return n6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void unmarshalBuffer(T4CMAREngine t4CMAREngine, int n2) throws SQLException, IOException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$7, this, t4CMAREngine, n2);
            }
            while (len > 0) {
                void mare;
                while (this.globalBlockIndex >= this.blocks.length) {
                    this.grow();
                }
                if (this.blocks[this.globalBlockIndex] == null) {
                    this.blocks[this.globalBlockIndex] = this.source.get();
                }
                int l2 = Math.min((int)len, (int)this.blockSize - this.globalByteIndex);
                mare.unmarshalNBytes(this.blocks[this.globalBlockIndex], this.globalByteIndex, l2);
                this.globalByteIndex += l2;
                if (this.globalByteIndex >= (int)this.blockSize) {
                    this.globalByteIndex = 0;
                    ++this.globalBlockIndex;
                }
                len -= l2;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int unmarshalCLRforREFS(T4CMAREngine t4CMAREngine) throws SQLException, IOException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void mare;
            byte[] bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$8, this, t4CMAREngine);
            }
            if ((bytes = mare.unmarshalCLRforREFS()) == null) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$8, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$8, this, null);
                }
                return 0;
            }
            this.put(bytes);
            int n3 = bytes.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$8, this, n3);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$8, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void marshalB1Array(T4CMAREngine t4CMAREngine, long l2, int n2) throws IOException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$9, this, t4CMAREngine, l2, n2);
            }
            if (!($assertionsDisabled || offset >= 0L && offset + (long)length <= this.length)) {
                AssertionError assertionError = new AssertionError((Object)(" offset: " + (long)offset + " this.length: " + this.length + " length: " + (int)length));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$9, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            int blksiz = (int)this.blockSize;
            void remaining = length;
            do {
                void mare;
                mare.marshalB1Array(this.blocks[blockIndex], byteIndex, Math.min(blksiz - byteIndex, (int)remaining));
                ++blockIndex;
            } while ((remaining -= blksiz - (byteIndex = 0)) > 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void copyLeft(long l2, int n2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            int len;
            void length;
            void srcOffset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this, l2, n2);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "copyLeft  srcOffset: " + (long)srcOffset + " length: " + (int)length + " this.position: " + this.position + " this.length: " + this.length);
            }
            if (!($assertionsDisabled || srcOffset >= this.position && length >= 0 && this.length >= this.position + (long)length)) {
                AssertionError assertionError = new AssertionError((Object)("this.position: " + this.position + " this.length: " + this.length + " srcOffset: " + (long)srcOffset + " length: " + (int)length));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (srcOffset == this.position || length == false) {
                this.position += (long)length;
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, " copyLeft position  increased by: " + (int)length + " to: " + this.position);
                }
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this, null);
                }
                return;
            }
            if (!($assertionsDisabled || srcOffset > this.position && length > 0)) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int destBlockIndex = (int)(this.position / this.blockSize);
            int destByteIndex = (int)(this.position % this.blockSize);
            int srcBlockIndex = (int)(srcOffset / this.blockSize);
            int srcByteIndex = (int)(srcOffset % this.blockSize);
            int blksiz = (int)this.blockSize;
            for (void remaining = length; remaining > 0; remaining -= len) {
                len = Math.min((int)remaining, Math.min(blksiz - srcByteIndex, blksiz - destByteIndex));
                System.arraycopy(this.blocks[srcBlockIndex], srcByteIndex, this.blocks[destBlockIndex], destByteIndex, len);
                if ((srcByteIndex += len) == blksiz) {
                    ++srcBlockIndex;
                    srcByteIndex = 0;
                }
                if ((destByteIndex += len) != blksiz) continue;
                ++destBlockIndex;
                destByteIndex = 0;
            }
            this.position += (long)length;
            if (bl) {
                OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, " copyLeft position increased by: " + (int)length + " to: " + this.position);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "srcOffset: " + (long)srcOffset + " length: " + (int)length + " this.position: " + this.position + " this.length: " + this.length);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void put(long l2, byte by) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$11, this, l2, by);
            }
            if (!$assertionsDisabled && index < 0L) {
                AssertionError assertionError = new AssertionError((Object)("index: " + (long)index));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$11, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(index / this.blockSize);
            int byteIndex = (int)(index % this.blockSize);
            while (blockIndex >= this.blocks.length) {
                this.grow();
            }
            if (this.blocks[blockIndex] == null) {
                this.blocks[blockIndex] = this.source.get();
            }
            this.blocks[blockIndex][byteIndex] = value;
            this.length = Math.max(this.length, (long)(index + 1L));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte get(long l2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void index;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$12, this, l2);
            }
            if (!($assertionsDisabled || index >= 0L && index < this.length)) {
                AssertionError assertionError = new AssertionError();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$12, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(index / this.blockSize);
            int byteIndex = (int)(index % this.blockSize);
            if (!($assertionsDisabled || this.blocks.length >= blockIndex && this.blocks[blockIndex] != null)) {
                AssertionError assertionError = new AssertionError((Object)("invalid read--blocks.length: " + this.blocks.length + " blockIndex: " + blockIndex + (String)(blockIndex < this.blocks.length ? " blocks[" + blockIndex + "]: " + this.blocks[blockIndex] : "")));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$12, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            byte by = this.blocks[blockIndex][byteIndex];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$12, this, by);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$12, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void put(long l2, byte[] byArray, int n2, int n3) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void srcOffset;
            void src;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$13, this, l2, byArray, n2, n3);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$13, Level.FINEST, this.getClass(), $$$methodRef$$$13, "DBA put absolute offset: " + (long)offset + " src.length: " + ((void)src).length + " srcOffset: " + (int)srcOffset + " length: " + (int)length);
            }
            if (!$assertionsDisabled && src == null) {
                AssertionError assertionError = new AssertionError((Object)"src is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$13, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!($assertionsDisabled || offset >= 0L && srcOffset + length <= ((void)src).length)) {
                AssertionError assertionError = new AssertionError((Object)("offset: " + (long)offset + " src.length: " + ((void)src).length + " srcOffset: " + (int)srcOffset + " length: " + (int)length));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$13, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            int blksiz = (int)this.blockSize;
            void remaining = length;
            while (true) {
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                System.arraycopy(src, (int)(srcOffset + length - remaining), this.blocks[blockIndex], byteIndex, Math.min(blksiz - byteIndex, (int)remaining));
                ++blockIndex;
                byteIndex = 0;
                if ((remaining -= blksiz - byteIndex) <= 0) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)length + 1L));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void get(long l2, byte[] byArray, int n2, int n3) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void dest;
            void destOffset;
            void length;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$14, this, l2, byArray, n2, n3);
            }
            if (!($assertionsDisabled || offset >= 0L && offset + (long)length <= this.length && destOffset >= 0 && destOffset + length <= ((void)dest).length)) {
                AssertionError assertionError = new AssertionError((Object)(" offset: " + (long)offset + " this.length: " + this.length + " destOffset: " + (int)destOffset + " length: " + (int)length));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$14, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            int blksiz = (int)this.blockSize;
            void remaining = length;
            do {
                System.arraycopy(this.blocks[blockIndex], byteIndex, dest, (int)(destOffset + length - remaining), Math.min(blksiz - byteIndex, (int)remaining));
                ++blockIndex;
            } while ((remaining -= blksiz - (byteIndex = 0)) > 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void free() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$15, this, new Object[0]);
            }
            for (int i2 = 0; i2 < this.blocks.length; ++i2) {
                if (this.blocks[i2] == null) continue;
                this.source.put(this.blocks[i2]);
                this.blocks[i2] = null;
            }
            this.position = 0L;
            if (bl) {
                OracleLog.debug($$$loggerRef$$$15, Level.FINEST, this.getClass(), $$$methodRef$$$15, "position free set to 0");
            }
            this.length = 0L;
            this.charsForNewString = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    long updateChecksum(long l2, int n2, CRC64 cRC64, long l3) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void checksum;
            void length;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$16, this, l2, n2, cRC64, l3);
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            void remaining = length;
            long result = checksum;
            while (remaining > 0) {
                int len = Math.min((int)remaining, (int)this.blockSize - byteIndex);
                result = CRC64.updateChecksum(result, this.blocks[blockIndex], byteIndex, len);
                remaining -= len;
                ++blockIndex;
                byteIndex = 0;
            }
            void var14_11 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$16, this, (long)var14_11);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$16, this, null);
            }
            return (long)var14_11;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void updateDigest(MessageDigest messageDigest, long l2, int n2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void valLen;
            void valOffset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$17, this, messageDigest, l2, n2);
            }
            if (!($assertionsDisabled || valOffset >= 0L && valOffset + (long)valLen <= this.length)) {
                AssertionError assertionError = new AssertionError((Object)(" valOffset: " + (long)valOffset + " this.length: " + this.length + " valLen: " + (int)valLen));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$17, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(valOffset / this.blockSize);
            int byteIndex = (int)(valOffset % this.blockSize);
            void remaining = valLen;
            while (remaining > 0) {
                void md;
                int len = Math.min((int)remaining, (int)this.blockSize - byteIndex);
                md.update(this.blocks[blockIndex], byteIndex, len);
                remaining -= len;
                ++blockIndex;
                byteIndex = 0;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final char[] getChars(long l2, int n2, CharacterSet characterSet, int[] nArray) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void charSet;
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$18, this, l2, n2, characterSet, nArray);
            }
            String s2 = this.getString((long)offset, (int)lengthInBytes, (CharacterSet)charSet);
            char[] c2 = s2.toCharArray();
            out_lengthInChars[0] = c2.length;
            char[] cArray = c2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$18, this, cArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$18, this, null);
            }
            return c2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final String getString(long l2, int n2, CharacterSet characterSet) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            void charSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, l2, n2, characterSet);
            }
            switch (charSet.getOracleId()) {
                case 1: {
                    String string = this.getStringFromUS7ASCII((long)offset, (int)lengthInBytes);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 2: {
                    String string = this.getStringFrom1Byte((long)offset, (int)lengthInBytes, WE8DEC_TO_JAVA);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 31: {
                    String string = this.getStringFrom1Byte((long)offset, (int)lengthInBytes, ISO_LATIN_1_TO_JAVA);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 46: {
                    String string = this.getStringFrom1Byte((long)offset, (int)lengthInBytes, WE8ISO8859P15_TO_JAVA);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 178: {
                    String string = this.getStringFrom1Byte((long)offset, (int)lengthInBytes, WE8MSWIN1252_TO_JAVA);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 2000: {
                    String string = this.getStringFromAL16UTF16((long)offset, (int)lengthInBytes);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 2002: {
                    String string = this.getStringFromAL16UTF16LE((long)offset, (int)lengthInBytes);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 871: {
                    String string = this.getStringFromUTF8((long)offset, (int)lengthInBytes);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
                case 873: {
                    String string = this.getStringFromAL32UTF8((long)offset, (int)lengthInBytes);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                    }
                    return string;
                }
            }
            if (!$assertionsDisabled) {
                AssertionError assertionError = new AssertionError((Object)("charSet: " + charSet.toString()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            if (lengthInBytes <= (int)this.blockSize - byteIndex) {
                String string = charSet.toString(this.blocks[blockIndex], byteIndex, (int)lengthInBytes);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                    ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
                }
                return string;
            }
            byte[] b2 = this.get((long)offset, (int)lengthInBytes);
            String string = charSet.toString(b2, 0, b2.length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, string);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int putString(long l2, String string, CharacterSet characterSet) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void charSet;
            void val;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, l2, string, characterSet);
            }
            if (val == null || val.length() == 0) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                }
                return 0;
            }
            switch (charSet.getOracleId()) {
                case 1: {
                    int n3 = this.putStringFrom1Byte((long)offset, (String)val, JAVA_TO_US7ASCII_LEVEL1, JAVA_TO_US7ASCII_LEVEL2);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n3;
                }
                case 2: {
                    int n4 = this.putStringFrom1Byte((long)offset, (String)val, JAVA_TO_WE8DEC_LEVEL1, JAVA_TO_WE8DEC_LEVEL2);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n4);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n4;
                }
                case 31: {
                    int n5 = this.putStringFrom1Byte((long)offset, (String)val, JAVA_TO_ISO_LATIN_1_LEVEL1, JAVA_TO_ISO_LATIN_1_LEVEL2);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n5;
                }
                case 46: {
                    int n6 = this.putStringFrom1Byte((long)offset, (String)val, JAVA_TO_WE8ISO8859P15_LEVEL1, JAVA_TO_WE8ISO8859P15_LEVEL2);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n6);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n6;
                }
                case 178: {
                    int n7 = this.putStringFrom1Byte((long)offset, (String)val, JAVA_TO_WE8MSWIN1252_LEVEL1, JAVA_TO_WE8MSWIN1252_LEVEL2);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n7);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n7;
                }
                case 2000: {
                    int n8 = this.putStringFromAL16UTF16((long)offset, (String)val);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n8);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n8;
                }
                case 2002: {
                    int n9 = this.putStringFromAL16UTF16LE((long)offset, (String)val);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n9);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n9;
                }
                case 871: {
                    int n10 = this.putStringFromUTF8((long)offset, (String)val);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n10);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n10;
                }
                case 873: {
                    int n11 = this.putStringFromAL32UTF8((long)offset, (String)val);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n11);
                        ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
                    }
                    return n11;
                }
            }
            int n12 = this.putStringFromCharset((long)offset, (String)val, (CharacterSet)charSet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, n12);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, null);
            }
            return n12;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int putStringWithReplacement(long l2, String string, CharacterSet characterSet) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void charSet;
            void val;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, l2, string, characterSet);
            }
            if (val == null || val.length() == 0) {
                int n2 = 0;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
                }
                return 0;
            }
            switch (charSet.getOracleId()) {
                case 871: 
                case 873: 
                case 2000: 
                case 2002: {
                    int n3 = this.putString((long)offset, (String)val, (CharacterSet)charSet);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
                    }
                    return n3;
                }
                case 31: {
                    int n4 = this.putStringFromISOLatin1WithReplacement((long)offset, (String)val);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n4);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
                    }
                    return n4;
                }
                case 46: {
                    int n5 = this.putStringFrom1ByteWithReplacement((long)offset, (String)val, JAVA_TO_WE8ISO8859P15_LEVEL1, JAVA_TO_WE8ISO8859P15_LEVEL2, JAVA_TO_WE8ISO8859P15_REPLACEMENT);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
                    }
                    return n5;
                }
                case 1: {
                    int n6 = this.putStringFrom1ByteWithReplacement((long)offset, (String)val, JAVA_TO_US7ASCII_LEVEL1, JAVA_TO_US7ASCII_LEVEL2, JAVA_TO_US7ASCII_REPLACEMENT);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n6);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
                    }
                    return n6;
                }
                case 2: {
                    int n7 = this.putStringFrom1ByteWithReplacement((long)offset, (String)val, JAVA_TO_WE8DEC_LEVEL1, JAVA_TO_WE8DEC_LEVEL2, JAVA_TO_WE8DEC_REPLACEMENT);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n7);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
                    }
                    return n7;
                }
                case 178: {
                    int n8 = this.putStringFrom1ByteWithReplacement((long)offset, (String)val, JAVA_TO_WE8MSWIN1252_LEVEL1, JAVA_TO_WE8MSWIN1252_LEVEL2, JAVA_TO_WE8MSWIN1252_REPLACEMENT);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n8);
                        ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
                    }
                    return n8;
                }
            }
            int n9 = this.putStringFromCharsetWithReplacement((long)offset, (String)val, (CharacterSet)charSet);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, n9);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, null);
            }
            return n9;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringFromUS7ASCII(long l2, int n2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$22, this, l2, n2);
            }
            if (!($assertionsDisabled || offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$22, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            void bytesRemaining = lengthInBytes;
            char[] chars = this.getCharsForNewString((int)lengthInBytes);
            int charIndex = 0;
            while (bytesRemaining > 0) {
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
                bytesRemaining = bytesRemaining - lastByte + byteIndex;
                while (byteIndex < lastByte) {
                    chars[charIndex++] = (char)bytes[byteIndex++];
                }
                byteIndex = 0;
            }
            if (!$assertionsDisabled && charIndex != lengthInBytes) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tlengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$22, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            String string = new String(chars, 0, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$22, this, string);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$22, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final int putAsciiString(long l2, String string) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$23, this, l2, string);
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$23, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            while (true) {
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + (strLen - charIndex), bytes.length);
                while (byteIndex < lastByte) {
                    bytes[byteIndex++] = (byte)val.charAt(charIndex++);
                }
                byteIndex = 0;
                if (charIndex >= strLen) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)strLen + 1L));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tstrLen: " + strLen));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$23, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = strLen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$23, this, n2);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$23, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    private static final char[] intToChar(int[] nArray) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            int[] ints;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$24, null, new Object[]{nArray});
            }
            char[] chars = new char[ints.length];
            for (int i2 = 0; i2 < ints.length; ++i2) {
                chars[i2] = (char)ints[i2];
            }
            char[] cArray = chars;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$24, null, cArray);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$24, null, null);
            }
            return chars;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getCharsFrom1Byte(char[] cArray, long l2, int n2, char[] cArray2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$25, this, cArray, l2, n2, cArray2);
            }
            if (!($assertionsDisabled || offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$25, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            void bytesRemaining = lengthInBytes;
            int charIndex = 0;
            while (bytesRemaining > 0) {
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
                bytesRemaining = bytesRemaining - lastByte + byteIndex;
                while (byteIndex < lastByte) {
                    void byteToChar;
                    chars[charIndex++] = byteToChar[bytes[byteIndex++] & 0xFF];
                }
                byteIndex = 0;
            }
            if (!$assertionsDisabled && charIndex != lengthInBytes) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tlengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$25, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n3 = charIndex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$25, this, n3);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$25, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringFrom1Byte(long l2, int n2, char[] cArray) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void byteToChar;
            void offset;
            void lengthInBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$26, this, l2, n2, cArray);
            }
            char[] chars = this.getCharsForNewString((int)lengthInBytes);
            int charIndex = this.getCharsFrom1Byte(chars, (long)offset, (int)lengthInBytes, (char[])byteToChar);
            String string = new String(chars, 0, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$26, this, string);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$26, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int putStringFrom1Byte(long l2, String string, char[] cArray, char[] cArray2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$27, this, l2, string, cArray, cArray2);
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$27, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            while (true) {
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + (strLen - charIndex), bytes.length);
                while (byteIndex < lastByte) {
                    int l4Key;
                    char srcChar;
                    int l3Key;
                    void charToByteLevel1;
                    void charToByteLevel2;
                    void retChar;
                    if ((retChar = charToByteLevel2[charToByteLevel1[l3Key = (srcChar = val.charAt(charIndex++)) >>> 8] + (l4Key = srcChar & 0xFF)]) != 65535) {
                        bytes[byteIndex++] = (byte)retChar;
                        continue;
                    }
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(155).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$27, this, sQLException);
                    }
                    throw sQLException;
                }
                byteIndex = 0;
                if (charIndex >= strLen) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)strLen + 1L));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tstrLen: " + strLen));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$27, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = strLen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$27, this, n2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$27, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int putStringFrom1ByteWithReplacement(long l2, String string, char[] cArray, char[] cArray2, char c2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$28, this, l2, string, cArray, cArray2, Character.valueOf(c2));
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$28, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int bytesStored = 0;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            while (true) {
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                while (byteIndex < bytes.length && charIndex < strLen) {
                    void replacementChar;
                    byte nextByte;
                    char srcChar;
                    if ((srcChar = val.charAt(charIndex++)) < '\u0080') {
                        nextByte = (byte)srcChar;
                    } else if (Character.isHighSurrogate(srcChar)) {
                        nextByte = (byte)replacementChar;
                        if (charIndex < strLen && Character.isLowSurrogate(val.charAt(charIndex))) {
                            ++charIndex;
                        }
                    } else {
                        void charToByteLevel1;
                        void charToByteLevel2;
                        int l3Key = srcChar >>> 8;
                        int l4Key = srcChar & 0xFF;
                        void retChar = charToByteLevel2[charToByteLevel1[l3Key] + l4Key];
                        nextByte = retChar == 65535 ? (byte)replacementChar : (byte)retChar;
                    }
                    bytes[byteIndex++] = nextByte;
                    ++bytesStored;
                }
                byteIndex = 0;
                if (charIndex >= strLen) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)bytesStored));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tstrLen: " + strLen));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$28, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = bytesStored;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$28, this, n2);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$28, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int putStringFromISOLatin1WithReplacement(long l2, String string) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$29, this, l2, string);
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$29, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$29, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            while (true) {
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + (strLen - charIndex), bytes.length);
                while (byteIndex < lastByte) {
                    char nextChar = val.charAt(charIndex++);
                    bytes[byteIndex++] = (byte)(nextChar > '\u00ff' ? 191 : (int)nextChar);
                }
                byteIndex = 0;
                if (charIndex >= strLen) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)strLen));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tstrLen: " + strLen));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$29, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$29, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = strLen;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$29, this, n2);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$29, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setGlobals(long l2, int n2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$30, this, l2, n2);
            }
            this.globalBlockIndex = (int)(offset / this.blockSize);
            this.globalByteIndex = (int)(offset % this.blockSize);
            this.globalRemaining = length;
            this.globalBlockSize = (int)this.blockSize;
            byte[] byArray = this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    private final byte next() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$31, this, new Object[0]);
            }
            if (!$assertionsDisabled && this.globalRemaining <= 0) {
                AssertionError assertionError = new AssertionError((Object)"next overrun in DBA");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$31, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            byte b2 = this.globalBytes[this.globalByteIndex++];
            --this.globalRemaining;
            if (this.globalByteIndex >= this.globalBlockSize) {
                this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
                this.globalByteIndex = 0;
            }
            byte by = b2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$31, this, by);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$31, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    private final byte peek() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$32, this, new Object[0]);
            }
            if (!$assertionsDisabled && this.globalRemaining <= 0) {
                AssertionError assertionError = new AssertionError((Object)"peek overrun in DBA");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$32, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            byte by = this.globalBytes[this.globalByteIndex];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$32, this, by);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$32, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    private final void back() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$33, this, new Object[0]);
            }
            if (this.globalByteIndex == 0) {
                this.globalByteIndex = this.globalBlockSize;
                --this.globalBlockIndex;
                this.globalBytes = this.blocks[this.globalBlockIndex];
            }
            --this.globalByteIndex;
            ++this.globalRemaining;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getCharsFromAL16UTF16(char[] cArray, long l2, int n2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$34, this, cArray, l2, n2);
            }
            if (!($assertionsDisabled || offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$34, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && lengthInBytes % 2 != false) {
                AssertionError assertionError = new AssertionError((Object)("lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$34, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.setGlobals((long)offset, (int)lengthInBytes);
            int charIndex = 0;
            while (this.globalRemaining > 0) {
                int hibyte = this.next() << 8;
                chars[charIndex++] = (char)(hibyte | this.next() & 0xFF);
            }
            if (!$assertionsDisabled && charIndex != lengthInBytes / 2) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tlengthInBytes/2: " + (int)(lengthInBytes / 2)));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$34, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$34, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n3 = charIndex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$34, this, n3);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$34, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringFromAL16UTF16(long l2, int n2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void lengthInBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$35, this, l2, n2);
            }
            char[] chars = this.getCharsForNewString((int)(lengthInBytes / 2));
            int charIndex = this.getCharsFromAL16UTF16(chars, (long)offset, (int)lengthInBytes);
            String string = new String(chars, 0, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$35, this, string);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$35, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int putStringFromAL16UTF16(long l2, String string) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            int totalSrcBytes;
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$36, this, l2, string);
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$36, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$36, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            int bytesRemaining = totalSrcBytes = strLen * 2;
            boolean lastCharLeftOverByte = false;
            while (true) {
                char srcChar;
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
                bytesRemaining = bytesRemaining - lastByte + byteIndex;
                if (lastCharLeftOverByte) {
                    lastCharLeftOverByte = false;
                    bytes[byteIndex++] = (byte)(val.charAt(charIndex - 1) & 0xFF);
                }
                while (byteIndex < lastByte - 1) {
                    srcChar = val.charAt(charIndex++);
                    bytes[byteIndex++] = (byte)(srcChar >>> 8 & 0xFF);
                    bytes[byteIndex++] = (byte)(srcChar & 0xFF);
                }
                if (byteIndex < lastByte) {
                    srcChar = val.charAt(charIndex++);
                    bytes[byteIndex++] = (byte)(srcChar >>> 8 & 0xFF);
                    lastCharLeftOverByte = true;
                }
                byteIndex = 0;
                if (bytesRemaining <= 0) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)totalSrcBytes + 1L));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\ttotalSrcBytes: " + totalSrcBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$36, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$36, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = totalSrcBytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$36, this, n2);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$36, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getCharsFromAL16UTF16LE(char[] cArray, long l2, int n2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$37, this, cArray, l2, n2);
            }
            if (!($assertionsDisabled || offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$37, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$37, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && lengthInBytes % 2 != false) {
                AssertionError assertionError = new AssertionError((Object)("lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$37, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$37, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.setGlobals((long)offset, (int)lengthInBytes);
            int charIndex = 0;
            while (this.globalRemaining > 0) {
                byte lobyte = this.next();
                int c2 = this.next() << 8 | lobyte & 0xFF;
                if (!this.isHiSurrogate((char)c2)) {
                    chars[charIndex++] = c2;
                    continue;
                }
                if (this.globalRemaining == 0) {
                    chars[charIndex++] = 65533;
                    break;
                }
                lobyte = this.next();
                char c22 = (char)(this.next() << 8 | lobyte & 0xFF);
                chars[charIndex++] = this.isLoSurrogate(c22) ? c2 : 65533;
                chars[charIndex++] = c22;
            }
            if (!$assertionsDisabled && charIndex != lengthInBytes / 2) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\tlengthInBytes/2: " + (int)(lengthInBytes / 2)));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$37, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$37, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n3 = charIndex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$37, this, n3);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$37, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringFromAL16UTF16LE(long l2, int n2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void lengthInBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$38, this, l2, n2);
            }
            char[] chars = this.getCharsForNewString((int)(lengthInBytes / 2));
            int charIndex = this.getCharsFromAL16UTF16LE(chars, (long)offset, (int)lengthInBytes);
            String string = new String(chars, 0, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$38, this, string);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$38, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int putStringFromAL16UTF16LE(long l2, String string) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            int totalSrcBytes;
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$39, this, l2, string);
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$39, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            int bytesRemaining = totalSrcBytes = strLen * 2;
            boolean lastCharLeftOverByte = false;
            while (true) {
                char srcChar;
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
                bytesRemaining = bytesRemaining - lastByte + byteIndex;
                if (lastCharLeftOverByte) {
                    lastCharLeftOverByte = false;
                    bytes[byteIndex++] = (byte)(val.charAt(charIndex - 1) >>> 8);
                }
                while (byteIndex < lastByte - 1) {
                    srcChar = val.charAt(charIndex++);
                    bytes[byteIndex++] = (byte)(srcChar & 0xFF);
                    bytes[byteIndex++] = (byte)(srcChar >>> 8);
                }
                if (byteIndex < lastByte) {
                    srcChar = val.charAt(charIndex++);
                    bytes[byteIndex++] = (byte)(srcChar & 0xFF);
                    lastCharLeftOverByte = true;
                }
                byteIndex = 0;
                if (bytesRemaining <= 0) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)totalSrcBytes + 1L));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\ttotalSrcBytes: " + totalSrcBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$39, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$39, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = totalSrcBytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$39, this, n2);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$39, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringFromUTF8(long l2, int n2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$40, this, l2, n2);
            }
            if (!($assertionsDisabled || offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$40, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$40, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.setGlobals((long)offset, (int)lengthInBytes);
            int lastBlock = (int)((offset + (long)lengthInBytes - 1L) / this.blockSize) + 1;
            int lastByte = (int)((offset + (long)lengthInBytes - 1L) % this.blockSize) + 1;
            char[] chars = this.getCharsForNewString((int)lengthInBytes);
            int charIndex = 0;
            while (this.globalRemaining > 0) {
                char c2;
                byte c3 = this.next();
                if (c3 >= 0) {
                    int localByteIndex;
                    chars[charIndex++] = (char)c3;
                    int end = this.globalBlockIndex == lastBlock ? lastByte : (this.globalBlockIndex < lastBlock ? (int)this.blockSize : 0);
                    for (localByteIndex = this.globalByteIndex; localByteIndex < end && this.globalBytes != null && (c3 = this.globalBytes[localByteIndex]) >= 0; ++localByteIndex) {
                        chars[charIndex++] = (char)c3;
                    }
                    this.globalRemaining -= localByteIndex - this.globalByteIndex;
                    this.globalByteIndex = localByteIndex;
                    if (this.globalByteIndex < this.globalBlockSize) continue;
                    this.globalByteIndex = 0;
                    this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
                    continue;
                }
                int b2 = c3 & 0xF0;
                byte bb = c3;
                if ((bb = (byte)(bb << 2)) >= 0) {
                    if (this.globalRemaining < 1) {
                        chars[charIndex++] = 65533;
                        continue;
                    }
                    c2 = this.conv2ByteUTFtoUTF16(c3, this.next());
                    chars[charIndex++] = c2;
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    byte b1;
                    if (this.globalRemaining < 2) {
                        chars[charIndex++] = 65533;
                        continue;
                    }
                    byte b0 = this.next();
                    int c1 = this.conv3ByteUTFtoUTF16(c3, b0, b1 = this.next());
                    if (this.isHiSurrogate((char)c1) && this.globalRemaining > 0) {
                        c3 = this.peek();
                        if ((byte)(c3 & 0xF0) != -32) {
                            chars[charIndex++] = 65533;
                            continue;
                        }
                        this.next();
                        if (this.globalRemaining < 2) {
                            chars[charIndex++] = 65533;
                            continue;
                        }
                        b0 = this.next();
                        c2 = this.conv3ByteUTFtoUTF16(c3, b0, b1 = this.next());
                        chars[charIndex++] = this.isLoSurrogate(c2) ? c1 : 65533;
                        chars[charIndex++] = c2;
                        continue;
                    }
                    chars[charIndex++] = c1;
                    continue;
                }
                chars[charIndex++] = 65533;
            }
            String string = new String(chars, 0, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$40, this, string);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$40, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int putStringFromUTF8(long l2, String string) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$41, this, l2, string);
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$41, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int MAX_BYTES_IN_CHAR = 3;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            int totalBytesWritten = 0;
            int lastCharLeftOverByteCount = 0;
            while (true) {
                char c2;
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                int lastByte = bytes.length;
                int startIndex = byteIndex;
                if (lastCharLeftOverByteCount > 0) {
                    c2 = val.charAt(charIndex++);
                    if (lastCharLeftOverByteCount == 2) {
                        bytes[byteIndex++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                    }
                    bytes[byteIndex++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                    lastCharLeftOverByteCount = 0;
                }
                while (byteIndex < lastByte - 3 && charIndex < strLen) {
                    if ((c2 = val.charAt(charIndex++)) >= '\u0000' && c2 <= '\u007f') {
                        bytes[byteIndex++] = (byte)c2;
                        continue;
                    }
                    if (c2 > '\u07ff') {
                        bytes[byteIndex++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                        bytes[byteIndex++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                        bytes[byteIndex++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                        continue;
                    }
                    bytes[byteIndex++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
                    bytes[byteIndex++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                }
                while (byteIndex < lastByte && charIndex < strLen) {
                    c2 = val.charAt(charIndex);
                    if (c2 >= '\u0000' && c2 <= '\u007f') {
                        bytes[byteIndex++] = (byte)c2;
                    } else if (c2 > '\u07ff') {
                        bytes[byteIndex++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                            if (byteIndex < lastByte) {
                                bytes[byteIndex++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                            } else {
                                lastCharLeftOverByteCount = 1;
                            }
                        } else {
                            lastCharLeftOverByteCount = 2;
                        }
                    } else {
                        bytes[byteIndex++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = (byte)(0x80 | c2 >>> 0 & 0x3F);
                        } else {
                            lastCharLeftOverByteCount = 1;
                        }
                    }
                    if (lastCharLeftOverByteCount != 0) continue;
                    ++charIndex;
                }
                totalBytesWritten += byteIndex - startIndex;
                byteIndex = 0;
                if (charIndex >= strLen) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)totalBytesWritten + 1L));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\ttotalBytesWritten: " + totalBytesWritten));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$41, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = totalBytesWritten;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$41, this, n2);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$41, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getStringFromAL32UTF8(long l2, int n2) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$42, this, l2, n2);
            }
            if (!($assertionsDisabled || offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$42, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$42, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.setGlobals((long)offset, (int)lengthInBytes);
            int lastBlock = (int)((offset + (long)lengthInBytes - 1L) / this.blockSize) + 1;
            int lastByte = (int)((offset + (long)lengthInBytes - 1L) % this.blockSize) + 1;
            char[] chars = this.getCharsForNewString((int)lengthInBytes);
            int charIndex = 0;
            while (this.globalRemaining > 0) {
                byte c2 = this.next();
                if (c2 >= 0) {
                    int localByteIndex;
                    chars[charIndex++] = (char)c2;
                    int end = this.globalBlockIndex == lastBlock ? lastByte : (this.globalBlockIndex < lastBlock ? (int)this.blockSize : 0);
                    for (localByteIndex = this.globalByteIndex; localByteIndex < end && this.globalBytes != null && (c2 = this.globalBytes[localByteIndex]) >= 0; ++localByteIndex) {
                        chars[charIndex++] = (char)c2;
                    }
                    this.globalRemaining -= localByteIndex - this.globalByteIndex;
                    this.globalByteIndex = localByteIndex;
                    if (this.globalByteIndex < this.globalBlockSize) continue;
                    this.globalByteIndex = 0;
                    this.globalBytes = this.globalBlockIndex < this.blocks.length ? this.blocks[this.globalBlockIndex++] : null;
                    continue;
                }
                byte bb = c2;
                if ((bb = (byte)(bb << 2)) >= 0) {
                    if (this.globalRemaining < 1) {
                        chars[charIndex++] = 65533;
                        continue;
                    }
                    chars[charIndex++] = this.conv2ByteUTFtoUTF16(c2, this.next());
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (this.globalRemaining < 2) {
                        chars[charIndex++] = 65533;
                        continue;
                    }
                    chars[charIndex++] = this.conv3ByteAL32UTF8toUTF16(c2, this.next(), this.next());
                    continue;
                }
                if ((bb = (byte)(bb << 1)) >= 0) {
                    if (this.globalRemaining < 3) {
                        chars[charIndex++] = 65533;
                        continue;
                    }
                    charIndex = this.conv4ByteAL32UTF8toUTF16(c2, this.next(), this.next(), this.next(), chars, charIndex);
                    continue;
                }
                chars[charIndex++] = 65533;
            }
            String string = new String(chars, 0, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$42, this, string);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$42, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int putStringFromAL32UTF8(long l2, String string) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void val;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$43, this, l2, string);
            }
            if (!($assertionsDisabled || offset >= 0L && val != null && val.length() >= 0)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " val.length(): " + val.length()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$43, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int strLen = val.length();
            int charIndex = 0;
            int MAX_BYTES_IN_CHAR = 4;
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            int totalBytesWritten = 0;
            int lastCharLeftOverByteCount = 0;
            byte[] lastCharLeftOverBytes = new byte[3];
            while (true) {
                int uuuuu;
                char c2;
                char c3;
                if (blockIndex >= this.blocks.length) {
                    this.grow();
                    continue;
                }
                if (this.blocks[blockIndex] == null) {
                    this.blocks[blockIndex] = this.source.get();
                }
                bytes = this.blocks[blockIndex++];
                int lastByte = bytes.length;
                int startIndex = byteIndex;
                if (lastCharLeftOverByteCount > 0) {
                    for (int i2 = 0; i2 < lastCharLeftOverByteCount; ++i2) {
                        bytes[byteIndex++] = lastCharLeftOverBytes[i2];
                    }
                    lastCharLeftOverByteCount = 0;
                }
                while (byteIndex < lastByte - 4 && charIndex < strLen) {
                    c3 = val.charAt(charIndex++);
                    c2 = '\u0000';
                    if (c3 >= '\u0000' && c3 <= '\u007f') {
                        bytes[byteIndex++] = (byte)c3;
                        continue;
                    }
                    if (this.isHiSurrogate(c3)) {
                        if (charIndex < strLen && this.isLoSurrogate(c2 = val.charAt(charIndex))) {
                            uuuuu = (c3 >>> 6 & 0xF) + 1;
                            bytes[byteIndex++] = (byte)(uuuuu >>> 2 | 0xF0);
                            bytes[byteIndex++] = (byte)((uuuuu & 3) << 4 | c3 >>> 2 & 0xF | 0x80);
                            bytes[byteIndex++] = (byte)((c3 & 3) << 4 | c2 >>> 6 & 0xF | 0x80);
                            bytes[byteIndex++] = (byte)(c2 & 0x3F | 0x80);
                            ++charIndex;
                            continue;
                        }
                        bytes[byteIndex++] = -17;
                        bytes[byteIndex++] = -65;
                        bytes[byteIndex++] = -67;
                        continue;
                    }
                    if (c3 > '\u07ff') {
                        bytes[byteIndex++] = (byte)(0xE0 | c3 >>> 12 & 0xF);
                        bytes[byteIndex++] = (byte)(0x80 | c3 >>> 6 & 0x3F);
                        bytes[byteIndex++] = (byte)(0x80 | c3 >>> 0 & 0x3F);
                        continue;
                    }
                    bytes[byteIndex++] = (byte)(0xC0 | c3 >>> 6 & 0x1F);
                    bytes[byteIndex++] = (byte)(0x80 | c3 >>> 0 & 0x3F);
                }
                while (byteIndex < lastByte && charIndex < strLen) {
                    byte b3;
                    byte b2;
                    c3 = val.charAt(charIndex++);
                    c2 = '\u0000';
                    if (c3 >= '\u0000' && c3 <= '\u007f') {
                        bytes[byteIndex++] = (byte)c3;
                        continue;
                    }
                    if (this.isHiSurrogate(c3)) {
                        if (charIndex < strLen && this.isLoSurrogate(c2 = val.charAt(charIndex))) {
                            uuuuu = (c3 >>> 6 & 0xF) + 1;
                            bytes[byteIndex++] = (byte)(uuuuu >>> 2 | 0xF0);
                            b2 = (byte)((uuuuu & 3) << 4 | c3 >>> 2 & 0xF | 0x80);
                            b3 = (byte)((c3 & 3) << 4 | c2 >>> 6 & 0xF | 0x80);
                            byte b4 = (byte)(c2 & 0x3F | 0x80);
                            if (byteIndex < lastByte) {
                                bytes[byteIndex++] = b2;
                            } else {
                                lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b2;
                            }
                            if (byteIndex < lastByte) {
                                bytes[byteIndex++] = b3;
                            } else {
                                lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b3;
                            }
                            if (byteIndex < lastByte) {
                                bytes[byteIndex++] = b4;
                            } else {
                                lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b4;
                            }
                            ++charIndex;
                            continue;
                        }
                        bytes[byteIndex++] = -17;
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = -65;
                        } else {
                            lastCharLeftOverBytes[lastCharLeftOverByteCount++] = -65;
                        }
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = -67;
                            continue;
                        }
                        lastCharLeftOverBytes[lastCharLeftOverByteCount++] = -67;
                        continue;
                    }
                    if (c3 > '\u07ff') {
                        bytes[byteIndex++] = (byte)(0xE0 | c3 >>> 12 & 0xF);
                        b2 = (byte)(0x80 | c3 >>> 6 & 0x3F);
                        b3 = (byte)(0x80 | c3 >>> 0 & 0x3F);
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = b2;
                        } else {
                            lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b2;
                        }
                        if (byteIndex < lastByte) {
                            bytes[byteIndex++] = b3;
                            continue;
                        }
                        lastCharLeftOverBytes[lastCharLeftOverByteCount++] = b3;
                        continue;
                    }
                    bytes[byteIndex++] = (byte)(0xC0 | c3 >>> 6 & 0x1F);
                    if (byteIndex < lastByte) {
                        bytes[byteIndex++] = (byte)(0x80 | c3 >>> 0 & 0x3F);
                        continue;
                    }
                    lastCharLeftOverBytes[lastCharLeftOverByteCount++] = (byte)(0x80 | c3 >>> 0 & 0x3F);
                }
                totalBytesWritten += byteIndex - startIndex;
                byteIndex = 0;
                if (charIndex >= strLen && lastCharLeftOverByteCount <= 0) break;
            }
            this.length = Math.max(this.length, (long)(offset + (long)totalBytesWritten + 1L));
            if (!$assertionsDisabled && charIndex != strLen) {
                AssertionError assertionError = new AssertionError((Object)("charIndex: " + charIndex + "\ttotalBytesWritten: " + totalBytesWritten));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$43, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$43, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int n2 = totalBytesWritten;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$43, this, n2);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$43, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int putStringFromCharset(long l2, String string, CharacterSet characterSet) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void val;
            void charSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$44, this, l2, string, characterSet);
            }
            byte[] srcBytes = charSet.convert((String)val);
            this.put((long)offset, srcBytes, 0, srcBytes.length);
            int n2 = srcBytes.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$44, this, n2);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$44, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int putStringFromCharsetWithReplacement(long l2, String string, CharacterSet characterSet) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void val;
            void charSet;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$45, this, l2, string, characterSet);
            }
            byte[] srcBytes = charSet.convertWithReplacement((String)val);
            this.put((long)offset, srcBytes, 0, srcBytes.length);
            int n2 = srcBytes.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$45, this, n2);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$45, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isHiSurrogate(char c2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void c3;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$46, this, Character.valueOf(c2));
            }
            boolean bl3 = bl2 = (char)(c3 & 0xFC00) == '\ud800';
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$46, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$46, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isLoSurrogate(char c2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void c3;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$47, this, Character.valueOf(c2));
            }
            boolean bl3 = bl2 = (char)(c3 & 0xFC00) == '\udc00';
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$47, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$47, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean check80toBF(byte by) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$48, this, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFC0) == -128;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$48, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$48, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean check80to8F(byte by) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$49, this, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFF0) == -128;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$49, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$49, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean check80to9F(byte by) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$50, this, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFE0) == -128;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$50, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$50, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$50, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkA0toBF(byte by) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$51, this, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFE0) == -96;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$51, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$51, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$51, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean check90toBF(byte by) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$52, this, by);
            }
            boolean bl3 = bl2 = (b2 & 0xFFFFFFC0) == -128 && (b2 & 0x30) != 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$52, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$52, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$52, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final char conv2ByteUTFtoUTF16(byte by, byte by2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void c2;
            void c3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$53, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$53, this, by, by2);
            }
            if (c3 < -62 || c3 > -33 || !this.check80toBF((byte)c2)) {
                this.back();
                char c4 = '\ufffd';
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$53, this, Character.valueOf(c4));
                    ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$53, this, null);
                }
                return '\ufffd';
            }
            char c5 = (char)((c3 & 0x1F) << 6 | c2 & 0x3F);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$53, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$53, this, Character.valueOf(c5));
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$53, this, null);
            }
            return c5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$53, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$53, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final char conv3ByteUTFtoUTF16(byte by, byte by2, byte by3) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void c3;
            void c2;
            void c4;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$54, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$54, this, by, by2, by3);
            }
            if (!(c4 == -32 && this.checkA0toBF((byte)c2) && this.check80toBF((byte)c3) || c4 >= -31 && c4 <= -17 && this.check80toBF((byte)c2) && this.check80toBF((byte)c3))) {
                this.back();
                this.back();
                char c5 = '\ufffd';
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$54, this, Character.valueOf(c5));
                    ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$54, this, null);
                }
                return '\ufffd';
            }
            char c6 = (char)((c4 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$54, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$54, this, Character.valueOf(c6));
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$54, this, null);
            }
            return c6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$54, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$54, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final char conv3ByteAL32UTF8toUTF16(byte by, byte by2, byte by3) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void c3;
            void c2;
            void c4;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$55, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$55, this, by, by2, by3);
            }
            if (!(c4 == -32 && this.checkA0toBF((byte)c2) && this.check80toBF((byte)c3) || c4 >= -31 && c4 <= -20 && this.check80toBF((byte)c2) && this.check80toBF((byte)c3) || c4 == -19 && this.check80to9F((byte)c2) && this.check80toBF((byte)c3) || c4 >= -18 && c4 <= -17 && this.check80toBF((byte)c2) && this.check80toBF((byte)c3))) {
                this.back();
                this.back();
                char c5 = '\ufffd';
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$55, this, Character.valueOf(c5));
                    ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$55, this, null);
                }
                return '\ufffd';
            }
            char c6 = (char)((c4 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$55, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$55, this, Character.valueOf(c6));
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$55, this, null);
            }
            return c6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$55, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$55, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int conv4ByteAL32UTF8toUTF16(byte by, byte by2, byte by3, byte by4, char[] cArray, int n2) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void charIndex;
            void c4;
            void c3;
            void c2;
            void c5;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$56, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$56, this, by, by2, by3, by4, cArray, n2);
            }
            boolean chars_count = false;
            if (!(c5 == -16 && this.check90toBF((byte)c2) && this.check80toBF((byte)c3) && this.check80toBF((byte)c4) || c5 >= -15 && c5 <= -13 && this.check80toBF((byte)c2) && this.check80toBF((byte)c3) && this.check80toBF((byte)c4) || c5 == -12 && this.check80to8F((byte)c2) && this.check80toBF((byte)c3) && this.check80toBF((byte)c4))) {
                this.back();
                this.back();
                this.back();
                chars[charIndex++] = 65533;
            } else {
                chars[charIndex++] = (char)((((c5 & 7) << 2 | c2 >>> 4 & 3) - 1 & 0xF) << 6 | (c2 & 0xF) << 2 | c3 >>> 4 & 3 | 0xD800);
                chars[charIndex++] = (char)((c3 & 0xF) << 6 | c4 & 0x3F | 0xDC00);
            }
            void var9_9 = charIndex;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$56, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$56, this, (int)var9_9);
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$56, this, null);
            }
            return (int)var9_9;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$56, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$56, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBlockBasic(long l2, int[] nArray) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$57, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$57, this, l2, nArray);
            }
            int blockIndex = (int)(offset / this.blockSize);
            initialByteIndex[0] = (int)(offset % this.blockSize);
            if (blockIndex >= this.blocks.length) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$57, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$57, this, null);
                }
                return null;
            }
            byte[] byArray = this.blocks[blockIndex];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$57, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$57, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$57, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$57, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$57, this, throwable2);
            }
            throw throwable;
        }
    }

    private static String escape(String string) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            String a2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$58, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$58, null, string);
            }
            StringBuilder b2 = new StringBuilder(a2.length() * 6);
            for (char c2 : a2.toCharArray()) {
                b2.append("\\u");
                byte d2 = (byte)(c2 >> 8);
                String e2 = "00" + Integer.toHexString(d2 & 0xFF);
                b2.append(e2, e2.length() - 2, e2.length());
                e2 = "00" + Integer.toHexString((byte)c2 & 0xFF);
                b2.append(e2, e2.length() - 2, e2.length());
            }
            String string2 = b2.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$58, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$58, null, string2);
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$58, null, null);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$58, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$58, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    ByteArray compact() {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$59, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$59, this, new Object[0]);
            }
            ByteArray returnValue = this;
            if (!$assertionsDisabled && this.length >= 0L) {
                AssertionError assertionError = new AssertionError((Object)("DynamicByteArray length cannot be less than 0 length = " + this.length));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$59, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$59, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (this.length == 0L) {
                returnValue = new SimpleByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY);
            } else if (this.length < 131072L) {
                returnValue = new SimpleByteArray(this.get(0L, (int)this.length()));
            }
            ByteArray byteArray = returnValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$59, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$59, this, byteArray);
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$59, this, null);
            }
            return byteArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$59, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$59, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getUtf8Bytes(long l2, int n2, byte[] byArray, int n3, CharacterSet characterSet) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            String s2;
            void bufferOffset;
            void buffer;
            void offset;
            void charSet;
            void lengthInBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, l2, n2, byArray, n3, characterSet);
            }
            int returnValue = lengthInBytes;
            switch (charSet.getOracleId()) {
                case 1: {
                    int n4 = this.getBytes((long)offset, (int)lengthInBytes, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n4);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n4;
                }
                case 2: {
                    int n5 = this.getBytesFrom1Byte((long)offset, (int)lengthInBytes, WE8DEC_TO_JAVA, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n5);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n5;
                }
                case 31: {
                    int n6 = this.getBytesFrom1Byte((long)offset, (int)lengthInBytes, ISO_LATIN_1_TO_JAVA, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n6);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n6;
                }
                case 46: {
                    int n7 = this.getBytesFrom1Byte((long)offset, (int)lengthInBytes, WE8ISO8859P15_TO_JAVA, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n7);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n7;
                }
                case 178: {
                    int n8 = this.getBytesFrom1Byte((long)offset, (int)lengthInBytes, WE8MSWIN1252_TO_JAVA, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n8);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n8;
                }
                case 2000: {
                    int n9 = this.getBytesFromAL16UTF16((long)offset, (int)lengthInBytes, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n9);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n9;
                }
                case 2002: {
                    int n10 = this.getBytesFromAL16UTF16LE((long)offset, (int)lengthInBytes, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n10);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n10;
                }
                case 871: {
                    int n11 = this.getBytes((long)offset, (int)lengthInBytes, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n11);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n11;
                }
                case 873: {
                    int n12 = this.getBytes((long)offset, (int)lengthInBytes, (byte[])buffer, (int)bufferOffset);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n12);
                        ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
                    }
                    return n12;
                }
            }
            if (!$assertionsDisabled) {
                AssertionError assertionError = new AssertionError((Object)("charSet: " + charSet.toString()));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            if (lengthInBytes <= (int)this.blockSize - byteIndex) {
                s2 = charSet.toString(this.blocks[blockIndex], byteIndex, (int)lengthInBytes);
            } else {
                byte[] b2 = this.get((long)offset, (int)lengthInBytes);
                s2 = charSet.toString(b2, 0, b2.length);
            }
            CharacterSet utf8CharSet = CharacterSet.make(871);
            byte[] s2b = utf8CharSet.convert(s2);
            System.arraycopy(s2b, 0, buffer, (int)bufferOffset, s2b.length);
            int n13 = returnValue = s2b.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, n13);
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, null);
            }
            return n13;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$60, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$60, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getBytesFrom1Byte(long l2, int n2, char[] cArray, byte[] byArray, int n3) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void bufferOffset;
            void buffer;
            void byteToChar;
            void offset;
            void lengthInBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$61, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$61, this, l2, n2, cArray, byArray, n3);
            }
            char[] chars = this.getCharsForNewString((int)lengthInBytes);
            int charIndex = this.getCharsFrom1Byte(chars, (long)offset, (int)lengthInBytes, (char[])byteToChar);
            int n4 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, (byte[])buffer, (int)bufferOffset, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$61, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$61, this, n4);
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$61, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$61, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$61, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getBytesFromAL16UTF16(long l2, int n2, byte[] byArray, int n3) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void bufferOffset;
            void buffer;
            void offset;
            void lengthInBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$62, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$62, this, l2, n2, byArray, n3);
            }
            char[] chars = this.getCharsForNewString((int)(lengthInBytes / 2));
            int charIndex = this.getCharsFromAL16UTF16(chars, (long)offset, (int)lengthInBytes);
            int n4 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, (byte[])buffer, (int)bufferOffset, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$62, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$62, this, n4);
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$62, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$62, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$62, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getBytesFromAL16UTF16LE(long l2, int n2, byte[] byArray, int n3) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void bufferOffset;
            void buffer;
            void offset;
            void lengthInBytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$63, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$63, this, l2, n2, byArray, n3);
            }
            char[] chars = this.getCharsForNewString((int)(lengthInBytes / 2));
            int charIndex = this.getCharsFromAL16UTF16LE(chars, (long)offset, (int)lengthInBytes);
            int n4 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chars, 0, (byte[])buffer, (int)bufferOffset, charIndex);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$63, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$63, this, n4);
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$63, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$63, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$63, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getBytes(long l2, int n2, byte[] byArray, int n3) throws SQLException {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            void lengthInBytes;
            void offset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$64, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$64, this, l2, n2, byArray, n3);
            }
            if (!($assertionsDisabled || offset >= 0L && lengthInBytes >= 0 && this.length >= offset + (long)lengthInBytes)) {
                AssertionError assertionError = new AssertionError((Object)("this.length: " + this.length + " offset: " + (long)offset + " lengthInBytes: " + (int)lengthInBytes));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$64, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$64, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            int blockIndex = (int)(offset / this.blockSize);
            int byteIndex = (int)(offset % this.blockSize);
            byte[] bytes = null;
            void bytesRemaining = lengthInBytes;
            int totalBytes = 0;
            while (bytesRemaining > 0) {
                void bufferOffset;
                void buffer;
                bytes = this.blocks[blockIndex++];
                int lastByte = Math.min(byteIndex + bytesRemaining, bytes.length);
                int numCopyBytes = lastByte - byteIndex;
                System.arraycopy(bytes, byteIndex, buffer, (int)bufferOffset, numCopyBytes);
                bytesRemaining -= numCopyBytes;
                bufferOffset += numCopyBytes;
                totalBytes += numCopyBytes;
                byteIndex = 0;
            }
            int n4 = totalBytes;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$64, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$64, this, n4);
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$64, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$64, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$64, this, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ char[] access$000(int[] nArray) {
        boolean bl = (0x286L & TraceControllerImpl.feature) != 0L;
        try {
            int[] x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$65, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$65, null, new Object[]{nArray});
            }
            char[] cArray = DynamicByteArray.intToChar(x0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$65, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$65, null, cArray);
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$65, null, null);
            }
            return cArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$65, Level.FINEST, DynamicByteArray.class, $$$methodRef$$$65, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$66 = DynamicByteArray.class.getDeclaredConstructor(BlockSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$65 = DynamicByteArray.class.getDeclaredMethod("access$000", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$64 = DynamicByteArray.class.getDeclaredMethod("getBytes", Long.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$63 = DynamicByteArray.class.getDeclaredMethod("getBytesFromAL16UTF16LE", Long.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$62 = DynamicByteArray.class.getDeclaredMethod("getBytesFromAL16UTF16", Long.TYPE, Integer.TYPE, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$61 = DynamicByteArray.class.getDeclaredMethod("getBytesFrom1Byte", Long.TYPE, Integer.TYPE, char[].class, byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$60 = DynamicByteArray.class.getDeclaredMethod("getUtf8Bytes", Long.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$59 = DynamicByteArray.class.getDeclaredMethod("compact", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$58 = DynamicByteArray.class.getDeclaredMethod("escape", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$57 = DynamicByteArray.class.getDeclaredMethod("getBlockBasic", Long.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$56 = DynamicByteArray.class.getDeclaredMethod("conv4ByteAL32UTF8toUTF16", Byte.TYPE, Byte.TYPE, Byte.TYPE, Byte.TYPE, char[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$55 = DynamicByteArray.class.getDeclaredMethod("conv3ByteAL32UTF8toUTF16", Byte.TYPE, Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$54 = DynamicByteArray.class.getDeclaredMethod("conv3ByteUTFtoUTF16", Byte.TYPE, Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$53 = DynamicByteArray.class.getDeclaredMethod("conv2ByteUTFtoUTF16", Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$52 = DynamicByteArray.class.getDeclaredMethod("check90toBF", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$51 = DynamicByteArray.class.getDeclaredMethod("checkA0toBF", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = DynamicByteArray.class.getDeclaredMethod("check80to9F", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = DynamicByteArray.class.getDeclaredMethod("check80to8F", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = DynamicByteArray.class.getDeclaredMethod("check80toBF", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = DynamicByteArray.class.getDeclaredMethod("isLoSurrogate", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = DynamicByteArray.class.getDeclaredMethod("isHiSurrogate", Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = DynamicByteArray.class.getDeclaredMethod("putStringFromCharsetWithReplacement", Long.TYPE, String.class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = DynamicByteArray.class.getDeclaredMethod("putStringFromCharset", Long.TYPE, String.class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = DynamicByteArray.class.getDeclaredMethod("putStringFromAL32UTF8", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = DynamicByteArray.class.getDeclaredMethod("getStringFromAL32UTF8", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = DynamicByteArray.class.getDeclaredMethod("putStringFromUTF8", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = DynamicByteArray.class.getDeclaredMethod("getStringFromUTF8", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = DynamicByteArray.class.getDeclaredMethod("putStringFromAL16UTF16LE", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = DynamicByteArray.class.getDeclaredMethod("getStringFromAL16UTF16LE", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = DynamicByteArray.class.getDeclaredMethod("getCharsFromAL16UTF16LE", char[].class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = DynamicByteArray.class.getDeclaredMethod("putStringFromAL16UTF16", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = DynamicByteArray.class.getDeclaredMethod("getStringFromAL16UTF16", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = DynamicByteArray.class.getDeclaredMethod("getCharsFromAL16UTF16", char[].class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = DynamicByteArray.class.getDeclaredMethod("back", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = DynamicByteArray.class.getDeclaredMethod("peek", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = DynamicByteArray.class.getDeclaredMethod("next", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = DynamicByteArray.class.getDeclaredMethod("setGlobals", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = DynamicByteArray.class.getDeclaredMethod("putStringFromISOLatin1WithReplacement", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = DynamicByteArray.class.getDeclaredMethod("putStringFrom1ByteWithReplacement", Long.TYPE, String.class, char[].class, char[].class, Character.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = DynamicByteArray.class.getDeclaredMethod("putStringFrom1Byte", Long.TYPE, String.class, char[].class, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = DynamicByteArray.class.getDeclaredMethod("getStringFrom1Byte", Long.TYPE, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = DynamicByteArray.class.getDeclaredMethod("getCharsFrom1Byte", char[].class, Long.TYPE, Integer.TYPE, char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = DynamicByteArray.class.getDeclaredMethod("intToChar", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = DynamicByteArray.class.getDeclaredMethod("putAsciiString", Long.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = DynamicByteArray.class.getDeclaredMethod("getStringFromUS7ASCII", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = DynamicByteArray.class.getDeclaredMethod("putStringWithReplacement", Long.TYPE, String.class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = DynamicByteArray.class.getDeclaredMethod("putString", Long.TYPE, String.class, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = DynamicByteArray.class.getDeclaredMethod("getString", Long.TYPE, Integer.TYPE, CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = DynamicByteArray.class.getDeclaredMethod("getChars", Long.TYPE, Integer.TYPE, CharacterSet.class, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = DynamicByteArray.class.getDeclaredMethod("updateDigest", MessageDigest.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = DynamicByteArray.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE, CRC64.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = DynamicByteArray.class.getDeclaredMethod("free", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = DynamicByteArray.class.getDeclaredMethod("get", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = DynamicByteArray.class.getDeclaredMethod("put", Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = DynamicByteArray.class.getDeclaredMethod("get", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = DynamicByteArray.class.getDeclaredMethod("put", Long.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = DynamicByteArray.class.getDeclaredMethod("copyLeft", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = DynamicByteArray.class.getDeclaredMethod("marshalB1Array", T4CMAREngine.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = DynamicByteArray.class.getDeclaredMethod("unmarshalCLRforREFS", T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = DynamicByteArray.class.getDeclaredMethod("unmarshalBuffer", T4CMAREngine.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = DynamicByteArray.class.getDeclaredMethod("unmarshalCLR", T4CMAREngine.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = DynamicByteArray.class.getDeclaredMethod("unmarshalCLR", T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = DynamicByteArray.class.getDeclaredMethod("getCharsForNewString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = DynamicByteArray.class.getDeclaredMethod("grow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = DynamicByteArray.class.getDeclaredMethod("getCapacity", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = DynamicByteArray.class.getDeclaredMethod("length", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = DynamicByteArray.class.getDeclaredMethod("createDynamicByteArray", BlockSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        final char[][] tmp = new char[19][];
        AccessController.doPrivileged(new PrivilegedAction(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            public Object run() {
                JdbcCharacterConverters cc = CharacterConverterJDBC.getInstance(31);
                tmp[0] = DynamicByteArray.access$000(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[1] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[2] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[3] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(2);
                tmp[4] = DynamicByteArray.access$000(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[5] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[6] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[7] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(178);
                tmp[8] = DynamicByteArray.access$000(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[9] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[10] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[11] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(1);
                tmp[12] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[13] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[14] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                cc = CharacterConverterJDBC.getInstance(46);
                tmp[15] = DynamicByteArray.access$000(((CharacterConverter1Byte)cc).m_ucsChar);
                tmp[16] = ((CharacterConverter1Byte)cc).m_oraCharLevel1;
                tmp[17] = ((CharacterConverter1Byte)cc).m_oraCharLevel2;
                tmp[18] = new char[]{(char)((CharacterConverter1Byte)cc).m_oraCharReplacement};
                return null;
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(char[][].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
        ISO_LATIN_1_TO_JAVA = tmp[0];
        JAVA_TO_ISO_LATIN_1_LEVEL1 = tmp[1];
        JAVA_TO_ISO_LATIN_1_LEVEL2 = tmp[2];
        JAVA_TO_ISO_LATIN_1_REPLACEMENT = tmp[3][0];
        WE8DEC_TO_JAVA = tmp[4];
        JAVA_TO_WE8DEC_LEVEL1 = tmp[5];
        JAVA_TO_WE8DEC_LEVEL2 = tmp[6];
        JAVA_TO_WE8DEC_REPLACEMENT = tmp[7][0];
        WE8MSWIN1252_TO_JAVA = tmp[8];
        JAVA_TO_WE8MSWIN1252_LEVEL1 = tmp[9];
        JAVA_TO_WE8MSWIN1252_LEVEL2 = tmp[10];
        JAVA_TO_WE8MSWIN1252_REPLACEMENT = tmp[11][0];
        JAVA_TO_US7ASCII_LEVEL1 = tmp[12];
        JAVA_TO_US7ASCII_LEVEL2 = tmp[13];
        JAVA_TO_US7ASCII_REPLACEMENT = tmp[14][0];
        WE8ISO8859P15_TO_JAVA = tmp[15];
        JAVA_TO_WE8ISO8859P15_LEVEL1 = tmp[16];
        JAVA_TO_WE8ISO8859P15_LEVEL2 = tmp[17];
        JAVA_TO_WE8ISO8859P15_REPLACEMENT = tmp[18][0];
    }
}

