/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.core.lmx.CoreException;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumBinder;

class FloatBinder
extends VarnumBinder {
    double paramVal;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    FloatBinder(double x2) {
        this.paramVal = x2;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] b2 = null;
        int offset = 0;
        double val = this.paramVal;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            b2 = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b2 = bindBytes;
            offset = byteoffset + 1;
        }
        int len = 0;
        if (val == 0.0) {
            b2[offset] = -128;
            len = 1;
        } else if (val == Double.POSITIVE_INFINITY) {
            b2[offset] = -1;
            b2[offset + 1] = 101;
            len = 2;
        } else if (val == Double.NEGATIVE_INFINITY) {
            b2[offset] = 0;
            len = 1;
        } else {
            long bits;
            int rawExponent;
            int guess;
            boolean neg;
            boolean bl = neg = val < 0.0;
            if (neg) {
                val = -val;
            }
            if ((guess = ((rawExponent = (int)((bits = Double.doubleToLongBits(val)) >> 52 & 0x7FFL)) > 1023 ? 126 : 127) - (int)((double)(rawExponent - 1023) / 6.643856189774725)) < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val).fillInStackTrace();
            }
            if (guess > 192) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val).fillInStackTrace();
            }
            if (val > factorTable[guess]) {
                while (guess > 0 && val > factorTable[--guess]) {
                }
            } else {
                while (guess < 193 && val <= factorTable[guess + 1]) {
                    ++guess;
                }
            }
            if (val == factorTable[guess]) {
                if (guess < 65) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val).fillInStackTrace();
                }
                if (guess > 192) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val).fillInStackTrace();
                }
                if (neg) {
                    b2[offset] = (byte)(62 - (127 - guess));
                    b2[offset + 1] = 100;
                    b2[offset + 2] = 102;
                    len = 3;
                } else {
                    b2[offset] = (byte)(192 + (128 - guess));
                    b2[offset + 1] = 2;
                    len = 2;
                }
            } else {
                int nSignificantBits;
                if (guess < 64) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)3) + " trying to bind " + val).fillInStackTrace();
                }
                if (guess > 191) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, CoreException.getMessage((byte)2) + " trying to bind " + val).fillInStackTrace();
                }
                int fBits = Float.floatToIntBits((float)val);
                int fractBits = fBits & 0x7FFFFF;
                int binExp = fBits >> 23 & 0xFF;
                char[] digits = stmt.digits;
                if (binExp == 0) {
                    while ((long)(fractBits & 0x800000) == 0L) {
                        fractBits <<= 1;
                        --binExp;
                    }
                    nSignificantBits = 24 + binExp;
                    ++binExp;
                } else {
                    fractBits |= 0x800000;
                    nSignificantBits = 24;
                }
                len = this.dtoa(b2, offset, val, neg, true, digits, binExp -= 127, (long)fractBits << 29, nSignificantBits);
            }
        }
        if (bindUseDBA) {
            bindData.put(b2, 0, len);
            bindIndicators[indoffset] = 0;
            bindDataLengths[bindDataIndex] = len;
            stmt.lastBoundDataLengths[bindPosition] = len;
        } else {
            b2[byteoffset] = (byte)len;
            bindIndicators[indoffset] = 0;
        }
        bindIndicators[lenoffset] = (short)(len + 1);
        return localCheckSum;
    }

    static {
        try {
            $$$methodRef$$$1 = FloatBinder.class.getDeclaredConstructor(Double.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = FloatBinder.class.getDeclaredMethod("bind", OraclePreparedStatement.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class, char[].class, short[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, ByteArray.class, long[].class, int[].class, Integer.TYPE, Boolean.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

