/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 13;
    TimestampTzConverter tstzConverter;
    static int OFFSET_HOUR;
    static int OFFSET_MINUTE;
    static byte REGIONIDBIT;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    TimestamptzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.TIMESTAMPTZ, stmt, 13, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$16, null, stmt, max_len, form, external_type, forBind);
            }
            this.tstzConverter = null;
            this.init(stmt, 181, 181, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    TimestamptzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.TIMESTAMPTZ, stmt, 13, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$17, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.tstzConverter = null;
            this.init(stmt, 181, 181, form, false);
            this.initForDescribe(181, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean am2;
            Object regname;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$0, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$0, this, string);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$0, this, null);
                }
                return null;
            }
            int regionID = 0;
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
                regionID = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes));
                TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes)))) {
                    tzTab.updateTable(this.statement.connection, regionID);
                }
                regname = ZONEIDMAP.getRegion(regionID);
            } else {
                int off_hour = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
                int off_minute = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
                regname = "GMT" + (off_hour < 0 ? "" : "+") + off_hour + (off_minute < 10 ? ":0" : ":") + off_minute;
            }
            Calendar calUTC = (Calendar)this.statement.getGMTCalendar().clone();
            int year = this.oracleYear(this.tmpBytes);
            calUTC.set(1, year);
            calUTC.set(2, this.oracleMonth(this.tmpBytes));
            calUTC.set(5, this.oracleDay(this.tmpBytes));
            calUTC.set(11, this.oracleHour(this.tmpBytes));
            calUTC.set(12, this.oracleMin(this.tmpBytes));
            calUTC.set(13, this.oracleSec(this.tmpBytes));
            calUTC.set(14, 0);
            if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
                TIMEZONETAB tzTab = this.statement.connection.getTIMEZONETAB();
                int offset_gmt = tzTab.getOffset(calUTC, regionID);
                calUTC.add(14, offset_gmt);
            } else {
                calUTC.add(10, this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR);
                calUTC.add(12, this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
            }
            year = calUTC.get(1);
            int month = calUTC.get(2) + 1;
            int date = calUTC.get(5);
            int hour = calUTC.get(11);
            int min = calUTC.get(12);
            int sec = calUTC.get(13);
            boolean bl2 = am2 = hour < 12;
            if (((String)regname).length() > 3 && ((String)regname).startsWith("GMT")) {
                regname = ((String)regname).substring(3);
            }
            int nanos = this.oracleNanos(this.tmpBytes);
            String string = this.toText(year, month, date, hour, min, sec, nanos, am2, (String)regname);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$0, this, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$0, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Date getDate(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$1, this, n2);
            }
            Date date = this.tstzConverter.getDate((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$1, this, date);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$1, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Date getDate(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$2, this, n2, calendar);
            }
            Date date = this.getDate((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$2, this, date);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$2, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Time getTime(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$3, this, n2);
            }
            Time time = this.tstzConverter.getTime((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$3, this, time);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$3, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Time getTime(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$4, this, n2, calendar);
            }
            Time time = this.getTime((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$4, this, time);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$4, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$5, this, n2);
            }
            Timestamp timestamp = this.tstzConverter.getTimestamp((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$5, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$5, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$6, this, n2, calendar);
            }
            Timestamp timestamp = this.getTimestamp((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$6, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$6, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$7, this, n2);
            }
            Object object = this.tstzConverter.getObject((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$7, this, object);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$7, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$8, this, n2);
            }
            Datum datum = this.tstzConverter.getOracleObject((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$8, this, datum);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$8, this, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    DATE getDATE(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            TIMESTAMPTZ tstz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$9, this, n2);
            }
            if ((tstz = this.tstzConverter.getTIMESTAMPTZ((int)currentRow)) == null) {
                DATE dATE = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$9, this, dATE);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            DATE dATE = oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tstz.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$9, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$9, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            TIMESTAMPTZ tstz;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$10, this, n2);
            }
            if ((tstz = this.tstzConverter.getTIMESTAMPTZ((int)currentRow)) == null) {
                TIMESTAMP tIMESTAMP = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$10, this, tIMESTAMP);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$10, this, null);
                }
                return null;
            }
            TIMESTAMP tIMESTAMP = oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tstz.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$10, this, tIMESTAMP);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$10, this, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$11, this, n2);
            }
            TIMESTAMPTZ tIMESTAMPTZ = this.tstzConverter.getTIMESTAMPTZ((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$11, this, tIMESTAMPTZ);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$11, this, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    static int setHighOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$12, null, n2);
            }
            int n3 = (ID & 0x1FC0) >> 6;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$12, null, n3);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$12, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    static int setLowOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$13, null, n2);
            }
            int n3 = (ID & 0x3F) << 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$13, null, n3);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$13, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    static int getHighOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$14, null, n2);
            }
            int n3 = (ID & 0x7F) << 6;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$14, null, n3);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$14, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    static int getLowOrderbits(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int ID;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$15, null, n2);
            }
            int n3 = (ID & 0xFC) >> 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$15, null, n3);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$15, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TimestamptzAccessor.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$17 = TimestamptzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = TimestamptzAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = TimestamptzAccessor.class.getDeclaredMethod("getLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = TimestamptzAccessor.class.getDeclaredMethod("getHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = TimestamptzAccessor.class.getDeclaredMethod("setLowOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = TimestamptzAccessor.class.getDeclaredMethod("setHighOrderbits", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TimestamptzAccessor.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TimestamptzAccessor.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TimestamptzAccessor.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TimestamptzAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TimestamptzAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TimestamptzAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TimestamptzAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimestamptzAccessor.class.getDeclaredMethod("getTime", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimestamptzAccessor.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimestamptzAccessor.class.getDeclaredMethod("getDate", Integer.TYPE, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimestamptzAccessor.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimestamptzAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        OFFSET_HOUR = 20;
        OFFSET_MINUTE = 60;
        REGIONIDBIT = (byte)-128;
    }

    abstract class TimestampTzConverter {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;

        TimestampTzConverter() {
        }

        abstract Date getDate(int var1) throws SQLException;

        abstract Time getTime(int var1) throws SQLException;

        abstract Timestamp getTimestamp(int var1) throws SQLException;

        Object getObject(int currentRow) throws SQLException {
            return this.getTIMESTAMPTZ(currentRow);
        }

        Datum getOracleObject(int currentRow) throws SQLException {
            return this.getTIMESTAMPTZ(currentRow);
        }

        Object getObject(int currentRow, Map map) throws SQLException {
            return this.getTIMESTAMPTZ(currentRow);
        }

        abstract TIMESTAMPTZ getTIMESTAMPTZ(int var1) throws SQLException;

        static {
            try {
                $$$methodRef$$$3 = TimestampTzConverter.class.getDeclaredConstructor(TimestamptzAccessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = TimestampTzConverter.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = TimestampTzConverter.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = TimestampTzConverter.class.getDeclaredMethod("getObject", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    class GmtTimestampTzConverter
    extends TimestampTzConverter {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        GmtTimestampTzConverter() {
        }

        @Override
        Date getDate(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calUTC.set(1, year);
            calUTC.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            long millis = calUTC.getTimeInMillis();
            return new Date(millis);
        }

        @Override
        Time getTime(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calUTC.set(1, year);
            calUTC.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            return new Time(calUTC.getTimeInMillis());
        }

        @Override
        Timestamp getTimestamp(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calUTC.set(1, year);
            calUTC.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            long millis = calUTC.getTimeInMillis();
            Timestamp result = new Timestamp(millis);
            int nanos = TimestamptzAccessor.this.oracleNanos(TimestamptzAccessor.this.tmpBytes);
            result.setNanos(nanos);
            return result;
        }

        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(currentRow));
        }

        static {
            try {
                $$$methodRef$$$4 = GmtTimestampTzConverter.class.getDeclaredConstructor(TimestamptzAccessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = GmtTimestampTzConverter.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = GmtTimestampTzConverter.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = GmtTimestampTzConverter.class.getDeclaredMethod("getTime", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = GmtTimestampTzConverter.class.getDeclaredMethod("getDate", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    class OldTimestampTzConverter
    extends TimestampTzConverter {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        OldTimestampTzConverter() {
        }

        @Override
        Date getDate(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            cal.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            cal.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            cal.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            cal.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            cal.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                cal.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            return new Date(millis);
        }

        @Override
        Time getTime(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            cal.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            cal.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            cal.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            cal.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            cal.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(cal, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                cal.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            return new Time(millis);
        }

        @Override
        Timestamp getTimestamp(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            TimeZone zone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar cal = Calendar.getInstance(zone);
            Calendar calUTC = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(currentRow, TimestamptzAccessor.this.tmpBytes);
            int year = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            cal.set(1, year);
            cal.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            cal.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            cal.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            cal.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            cal.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            cal.set(14, 0);
            calUTC.set(1, year);
            calUTC.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calUTC.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int regionID = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tzTab = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tzTab.checkID(regionID += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tzTab.updateTable(TimestamptzAccessor.this.statement.connection, regionID);
                }
                int offset = tzTab.getOffset(calUTC, regionID);
                boolean sourceTimeInDST = zone.inDaylightTime(cal.getTime());
                boolean destinationTimeInDST = zone.inDaylightTime(new java.util.Date(cal.getTimeInMillis() + (long)offset));
                if (!sourceTimeInDST && destinationTimeInDST) {
                    cal.add(14, -1 * zone.getDSTSavings());
                } else if (sourceTimeInDST && !destinationTimeInDST) {
                    cal.add(14, zone.getDSTSavings());
                }
                cal.add(10, offset / 3600000);
                cal.add(12, offset % 3600000 / 60000);
            } else {
                cal.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                cal.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long millis = cal.getTimeInMillis();
            Timestamp result = new Timestamp(millis);
            int nanos = TimestamptzAccessor.this.oracleNanos(TimestamptzAccessor.this.tmpBytes);
            result.setNanos(nanos);
            return result;
        }

        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int currentRow) throws SQLException {
            if (TimestamptzAccessor.this.isUseLess || TimestamptzAccessor.this.isNull(currentRow)) {
                return null;
            }
            return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(currentRow));
        }

        static {
            try {
                $$$methodRef$$$4 = OldTimestampTzConverter.class.getDeclaredConstructor(TimestamptzAccessor.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = OldTimestampTzConverter.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = OldTimestampTzConverter.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = OldTimestampTzConverter.class.getDeclaredMethod("getTime", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = OldTimestampTzConverter.class.getDeclaredMethod("getDate", Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

