/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class CancelLock {
    private CancelState state;
    private OracleStatement statement;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    CancelLock(OracleStatement stmt) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null, stmt);
            }
            this.state = null;
            this.statement = null;
            this.statement = stmt;
            this.state = new CancelState();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CancelLock.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isIdle() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, new Object[0]);
                }
                CancelState cancelState = this.state;
                synchronized (cancelState) {
                    try {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : cancelState
                        bl2 = this.state.isIdle();
                        if (!bl) break block8;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : cancelState
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CancelLock.class, $$$methodRef$$$0, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isCanceled() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, new Object[0]);
                }
                CancelState cancelState = this.state;
                synchronized (cancelState) {
                    try {
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : cancelState
                        bl2 = this.state.isCanceled();
                        if (!bl) break block8;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl13 : MonitorExitStatement: MONITOREXIT : cancelState
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CancelLock.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterExecuting() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, new Object[0]);
            }
            CancelState cancelState = this.state;
            synchronized (cancelState) {
                try {
                    if (!$assertionsDisabled && !this.state.isIdle()) {
                        AssertionError assertionError = new AssertionError();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    this.state.setExecuting();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl17 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CancelLock.class, $$$methodRef$$$2, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitExecuting() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, new Object[0]);
            }
            while (true) {
                CancelState cancelState = this.state;
                synchronized (cancelState) {
                    try {
                        if (this.state.isExecuting()) {
                            this.state.setIdle();
                            break;
                        }
                        if (this.state.isCanceling()) {
                            try {
                                this.state.wait();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (Throwable throwable) {}
                            continue;
                        }
                        if (this.state.isCanceled()) {
                            if (this.statement != null && this.statement.connection.cancelInProgressFlag && bl) {
                                OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "Cancel still in progress ...");
                            }
                            this.state.setIdle();
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 8] lbl33 : MonitorExitStatement: MONITOREXIT : var1_2
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CancelLock.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean enterCanceling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            block7: {
                boolean bl3;
                boolean bl4;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, new Object[0]);
                }
                CancelState cancelState = this.state;
                // MONITORENTER : cancelState
                try {
                    if (!this.state.isExecuting()) break block7;
                    this.state.setCanceling();
                    // MONITOREXIT : cancelState
                    bl3 = bl4 = true;
                    if (!bl) return bl3;
                }
                catch (Throwable throwable) {
                    // MONITOREXIT : cancelState
                    Throwable throwable2 = throwable;
                    if (!bl) throw throwable2;
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, throwable2);
                    throw throwable2;
                }
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, null);
                return bl3;
            }
            // MONITOREXIT : cancelState
            boolean bl5 = bl2 = false;
            if (!bl) return bl5;
            ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, bl2);
            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, null);
            return bl5;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (!bl) throw throwable;
            ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CancelLock.class, $$$methodRef$$$4, this, throwable3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exitCanceling() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, new Object[0]);
            }
            CancelState cancelState = this.state;
            synchronized (cancelState) {
                try {
                    if (!$assertionsDisabled && !this.state.isCanceling()) {
                        AssertionError assertionError = new AssertionError();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    this.state.setCanceled();
                    this.state.notify();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl18 : MonitorExitStatement: MONITOREXIT : var1_2
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CancelLock.class, $$$methodRef$$$5, this, throwable3);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = CancelLock.class.getDeclaredConstructor(OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = CancelLock.class.getDeclaredMethod("exitCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = CancelLock.class.getDeclaredMethod("enterCanceling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = CancelLock.class.getDeclaredMethod("exitExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = CancelLock.class.getDeclaredMethod("enterExecuting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = CancelLock.class.getDeclaredMethod("isCanceled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = CancelLock.class.getDeclaredMethod("isIdle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

