/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NoSupportHAManager;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ServiceMember;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.simplefan.FanEventListener;
import oracle.simplefan.FanManager;
import oracle.simplefan.FanSubscription;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.HIGH_AVAILABILITY})
public class HAManager {
    private ConcurrentHashMap<String, Map<String, ServiceMember>> services;
    private ConcurrentHashMap<String, Map<String, ServiceMember>> hosts;
    private Map<String, Integer> cardinalities;
    private static final String FAN_SERVICE_NAME_PROPERTY = "serviceName";
    private FanManager fanMngr;
    private FanSubscription fanSubscription;
    static final ConcurrentHashMap<String, HAManager> allManagers;
    static final String FAN_CONFIG_PROPERTY = "oracle.jdbc.fanONSConfig";
    private Timer timer;
    private int drainIntervals;
    private final AtomicInteger remainingIntervals;
    private int targetDrainCountTotal;
    private int targetDrainCountPerInterval;
    private final AtomicInteger currentDrainTarget;
    private final AtomicInteger currentDrainCount;
    private TimerTask drainingTimerTask;
    private TimerTask delayedDrainingTimerTask;
    private static AtomicBoolean dependentJarsChecked;
    private static boolean allDependentJarsPresent;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_21:03:45_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;

    HAManager() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, HAManager.class, $$$methodRef$$$24, null, new Object[0]);
            }
            this.cardinalities = new HashMap<String, Integer>();
            this.fanMngr = null;
            this.fanSubscription = null;
            this.timer = null;
            this.drainIntervals = 0;
            this.remainingIntervals = new AtomicInteger();
            this.targetDrainCountTotal = 0;
            this.targetDrainCountPerInterval = 0;
            this.currentDrainTarget = new AtomicInteger();
            this.currentDrainCount = new AtomicInteger();
            this.drainingTimerTask = null;
            this.delayedDrainingTimerTask = null;
            this.services = new ConcurrentHashMap();
            this.hosts = new ConcurrentHashMap();
            this.timer = new Timer(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, HAManager.class, $$$methodRef$$$24, null);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, HAManager.class, $$$methodRef$$$24, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, HAManager.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    HAManager(String onsConfigStr) throws SQLException {
        this();
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, HAManager.class, $$$methodRef$$$25, null, onsConfigStr);
            }
            this.configure(onsConfigStr);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, HAManager.class, $$$methodRef$$$25, null);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, HAManager.class, $$$methodRef$$$25, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, HAManager.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    static HAManager getInstance(String string) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String onsConfigStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, HAManager.class, $$$methodRef$$$0, null, string);
            }
            HAManager hAManager = new HAManager(onsConfigStr);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, HAManager.class, $$$methodRef$$$0, null, hAManager);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, HAManager.class, $$$methodRef$$$0, null, null);
            }
            return hAManager;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, HAManager.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configure(String string) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void onsConfigStr;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, HAManager.class, $$$methodRef$$$1, this, string);
            }
            if (!$assertionsDisabled && (onsConfigStr == null || "".equals(onsConfigStr))) {
                AssertionError assertionError = new AssertionError((Object)("onsConfigStr: " + (String)onsConfigStr));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, HAManager.class, $$$methodRef$$$1, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (this.fanMngr == null) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "Creating FAN manager instance");
                }
                this.fanMngr = FanManager.getInstance();
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "Created FAN manager instance");
                }
                if (onsConfigStr != null && !"".equals(onsConfigStr)) {
                    Properties onsProps = new Properties();
                    onsProps.setProperty("onsRemoteConfig", (String)onsConfigStr);
                    this.fanMngr.configure(onsProps);
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "Configured FAN manager instance");
                    }
                }
            } else if (bl) {
                OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "FAN manager is not NULL, no-op");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, HAManager.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, HAManager.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, HAManager.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addService(String string) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentServiceName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, HAManager.class, $$$methodRef$$$2, this, string);
            }
            if (!$assertionsDisabled && (currentServiceName == null || "".equals(currentServiceName))) {
                AssertionError assertionError = new AssertionError((Object)("currentServiceName: " + (String)currentServiceName));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, HAManager.class, $$$methodRef$$$2, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (this.fanMngr != null) {
                Properties subscriptionProps = new Properties();
                subscriptionProps.setProperty(FAN_SERVICE_NAME_PROPERTY, (String)currentServiceName);
                this.fanSubscription = this.fanMngr.subscribe(subscriptionProps);
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "Created Fan subscription for service name: " + (String)currentServiceName);
                }
                FanEventListener fanListener = null;
                try {
                    Class<?> cls = Class.forName("oracle.jdbc.driver.HAFanListener");
                    Constructor<?> c2 = cls.getDeclaredConstructor(HAManager.class);
                    fanListener = (FanEventListener)c2.newInstance(this);
                }
                catch (Throwable t2) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "========= FAN listener creation error: \n" + this.getStackTraceString(t2));
                    }
                    SQLException sQLException = new SQLException("Metadata error: error while creating FAN listener");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, HAManager.class, $$$methodRef$$$2, this, sQLException);
                    }
                    throw sQLException;
                }
                this.fanSubscription.addListener(fanListener);
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "Created FAN listener");
                }
            } else if (bl) {
                OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "FAN manager is NULL, no-op");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, HAManager.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, HAManager.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, HAManager.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addConnection(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, HAManager.class, $$$methodRef$$$3, this, oracleConnection);
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "HA configured, checking HA subscriptions");
            }
            Properties props = oconn.getServerSessionInfo();
            String svc = HAManager.toLowerCase(props.getProperty("SERVICE_NAME"));
            String inst = HAManager.toLowerCase(props.getProperty("INSTANCE_NAME"));
            String db = HAManager.toLowerCase(props.getProperty("DATABASE_NAME"));
            String hst = HAManager.toLowerCase(props.getProperty("SERVER_HOST"));
            String memberKey = svc + "###" + inst + "###" + db + "###" + hst;
            ConcurrentHashMap<CallSite, ServiceMember> newMembers = new ConcurrentHashMap<CallSite, ServiceMember>();
            Map members = this.services.putIfAbsent(svc, newMembers);
            if (members == null) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "========= NEW service: " + svc + ", and member instance: " + inst);
                }
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "Creating HA subscriptions for service: " + svc);
                }
                this.addService(svc);
                ServiceMember member = new ServiceMember(svc, inst, db, hst);
                member.up();
                member.addConnection((OracleConnection)oconn);
                newMembers.put((CallSite)((Object)memberKey), member);
            } else {
                ServiceMember member;
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "========= Existing member instance: " + inst);
                }
                if ((member = (ServiceMember)members.get(memberKey)) != null) {
                    member.up();
                    member.addConnection((OracleConnection)oconn);
                } else {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "========= NEW member instance: " + inst);
                    }
                    member = new ServiceMember(svc, inst, db, hst);
                    member.up();
                    member.addConnection((OracleConnection)oconn);
                    members.put(memberKey, member);
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "========= Added new member instance to topology, new size = " + members.size());
                    }
                }
            }
            oconn.setHAManager(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, HAManager.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, HAManager.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, HAManager.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dropConnection(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, HAManager.class, $$$methodRef$$$4, this, oracleConnection);
            }
            Properties props = oconn.getServerSessionInfo();
            String svc = HAManager.toLowerCase(props.getProperty("SERVICE_NAME"));
            String inst = HAManager.toLowerCase(props.getProperty("INSTANCE_NAME"));
            String db = HAManager.toLowerCase(props.getProperty("DATABASE_NAME"));
            String hst = HAManager.toLowerCase(props.getProperty("SERVER_HOST"));
            String memberKey = svc + "###" + inst + "###" + db + "###" + hst;
            Map<String, ServiceMember> members = this.services.get(svc);
            if (members == null) {
                SQLException sQLException = new SQLException("Metadata error: no member instances for service");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, HAManager.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            ServiceMember member = members.get(memberKey);
            if (member == null) {
                SQLException sQLException = new SQLException("Metadata error: no member instance for service");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, HAManager.class, $$$methodRef$$$4, this, sQLException);
                }
                throw sQLException;
            }
            member.dropConnection((OracleConnection)oconn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, HAManager.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, HAManager.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, HAManager.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void plannedDown(String string, String string2, String string3, String string4, int n2) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            block22: {
                Map<String, ServiceMember> members;
                void drainTimeout;
                void evtHost;
                void evtDatabase;
                void evtInstance;
                void evtService;
                block20: {
                    block21: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, HAManager.class, $$$methodRef$$$5, this, string, string2, string3, string4, n2);
                        }
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned down, plannedDown(...), svc = " + (String)evtService + ", inst = " + (String)evtInstance + ", db = " + (String)evtDatabase + ", hst = " + (String)evtHost + ", drain_timeout = " + (int)drainTimeout);
                        }
                        if ((members = this.services.get(evtService)) != null) break block20;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned down, non-applicable FAN down-event for service: " + (String)evtService);
                        }
                        if (!bl) break block21;
                        ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, HAManager.class, $$$methodRef$$$5, this);
                        ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, HAManager.class, $$$methodRef$$$5, this, null);
                    }
                    return;
                }
                try {
                    if (evtInstance == null) {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned down, full-service down, database: " + (String)evtDatabase);
                        }
                        for (ServiceMember downMember : members.values()) {
                            if (downMember.getDatabase().equalsIgnoreCase((String)evtDatabase)) {
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned down, ONLY marking down member instance: " + downMember.getName());
                                }
                                downMember.down();
                                continue;
                            }
                            if (!bl) continue;
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned down, full-service down not-applicable to [" + downMember + "]");
                        }
                    } else {
                        String memberKey = (String)evtService + "###" + (String)evtInstance + "###" + (String)evtDatabase + "###" + (String)evtHost;
                        ServiceMember member = members.get(memberKey);
                        if (member != null) {
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned down, ONLY marking down member instance: " + member.getName());
                            }
                            member.down();
                            this.drainGracefully(member, members, (int)drainTimeout);
                        } else if (bl) {
                            OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned down, non-applicable FAN down-event for service: " + (String)evtService + " on instance: " + (String)evtInstance);
                        }
                    }
                }
                catch (Throwable t2) {
                    if (!bl) break block22;
                    OracleLog.debug($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "========= Planned-down error: \n" + this.getStackTraceString(t2));
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, HAManager.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, HAManager.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, HAManager.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drainGracefully(ServiceMember serviceMember, Map<String, ServiceMember> map, int n2) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void drainTimeout;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, HAManager.class, $$$methodRef$$$6, this, serviceMember, map, n2);
            }
            if (drainTimeout > 0) {
                void members;
                void member;
                this.drainIntervals = (drainTimeout + 10 - true) / 10;
                this.remainingIntervals.set(this.drainIntervals);
                this.targetDrainCountTotal = member.connCount;
                this.targetDrainCountPerInterval = (this.targetDrainCountTotal + this.drainIntervals - 1) / this.drainIntervals;
                this.currentDrainCount.set(0);
                this.currentDrainTarget.set(0);
                this.drainingTimerTask = new TimerTask(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        if (HAManager.access$000(HAManager.this).get() > 0) {
                            int left = HAManager.access$100(HAManager.this) - HAManager.access$200(HAManager.this).get();
                            int delta = Math.min(HAManager.access$300(HAManager.this), left);
                            HAManager.access$400(HAManager.this).addAndGet(delta);
                            HAManager.access$000(HAManager.this).decrementAndGet();
                        }
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(HAManager.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    }
                };
                boolean noOtherInstanceUp = true;
                for (ServiceMember m2 : members.values()) {
                    if (!m2.isUp()) continue;
                    noOtherInstanceUp = false;
                    break;
                }
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$6, Level.FINEST, this.getClass(), $$$methodRef$$$6, "========= Planned down, no other instance(s) up: " + noOtherInstanceUp);
                }
                if (noOtherInstanceUp) {
                    this.delayedDrainingTimerTask = this.drainingTimerTask;
                } else {
                    this.scheduleTimerTask(this.drainingTimerTask, this.drainIntervals);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, HAManager.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, HAManager.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, HAManager.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleTimerTask(TimerTask timerTask, int n2) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void task;
            void interval;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, HAManager.class, $$$methodRef$$$7, this, timerTask, n2);
            }
            if (interval > 0) {
                this.timer.schedule((TimerTask)task, 0L, (long)interval * 1000L);
            } else {
                this.timer.schedule((TimerTask)task, 0L);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, HAManager.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, HAManager.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, HAManager.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void unplannedDown(String string, String string2, String string3, String string4) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            block23: {
                Map<String, ServiceMember> members;
                void evtHost;
                void evtDatabase;
                void evtInstance;
                void evtService;
                block21: {
                    block22: {
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, HAManager.class, $$$methodRef$$$8, this, string, string2, string3, string4);
                        }
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, unplannedDown(...), svc = " + (String)evtService + ", inst = " + (String)evtInstance + ", db = " + (String)evtDatabase + ", hst = " + (String)evtHost);
                        }
                        if ((members = this.services.get(evtService)) != null) break block21;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, non-applicable FAN down-event for service: " + (String)evtService);
                        }
                        if (!bl) break block22;
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, HAManager.class, $$$methodRef$$$8, this);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, HAManager.class, $$$methodRef$$$8, this, null);
                    }
                    return;
                }
                try {
                    if (evtInstance == null) {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, full-service down, database: " + (String)evtDatabase);
                        }
                        for (ServiceMember downMember : members.values()) {
                            if (downMember.getDatabase().equalsIgnoreCase((String)evtDatabase)) {
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, marking down member instance: " + downMember.getName());
                                }
                                downMember.down();
                                downMember.cleanupConnections();
                                continue;
                            }
                            if (!bl) continue;
                            OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, full-service down not-applicable to [" + downMember + "]");
                        }
                    } else {
                        String memberKey;
                        ServiceMember member;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, member instance down");
                        }
                        if ((member = members.get(memberKey = (String)evtService + "###" + (String)evtInstance + "###" + (String)evtDatabase + "###" + (String)evtHost)) != null) {
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, marking down member instance: " + member.getName());
                            }
                            member.down();
                            member.cleanupConnections();
                        } else if (bl) {
                            OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned down, non-applicable FAN down-event for service: " + (String)evtService + " on instance: " + (String)evtInstance);
                        }
                    }
                }
                catch (Throwable t2) {
                    if (!bl) break block23;
                    OracleLog.debug($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "========= Unplanned-down error: \n" + this.getStackTraceString(t2));
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, HAManager.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, HAManager.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, HAManager.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void nodeDown(String string) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            block13: {
                Map<String, ServiceMember> members;
                block11: {
                    block12: {
                        void evtHost;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, HAManager.class, $$$methodRef$$$9, this, string);
                        }
                        members = this.hosts.get(evtHost);
                        if (members != null) break block11;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$9, Level.FINEST, this.getClass(), $$$methodRef$$$9, "========= Node down, non-applicable FAN down-event for node: " + (String)evtHost);
                        }
                        if (!bl) break block12;
                        ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, HAManager.class, $$$methodRef$$$9, this);
                        ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, HAManager.class, $$$methodRef$$$9, this, null);
                    }
                    return;
                }
                try {
                    for (ServiceMember downMember : members.values()) {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$9, Level.FINEST, this.getClass(), $$$methodRef$$$9, "========= Node down, marking down member instance: " + downMember.getName());
                        }
                        downMember.down();
                        downMember.cleanupConnections();
                    }
                }
                catch (Throwable t2) {
                    if (!bl) break block13;
                    OracleLog.debug($$$loggerRef$$$9, Level.FINEST, this.getClass(), $$$methodRef$$$9, "========= Node down error: \n" + this.getStackTraceString(t2));
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, HAManager.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, HAManager.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, HAManager.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void serviceUp(String string, String string2, String string3, String string4, int n2) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            block19: {
                void cardinality;
                void evtInstance;
                void evtService;
                block17: {
                    block18: {
                        block15: {
                            block16: {
                                if (bl) {
                                    ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this, string, string2, string3, string4, n2);
                                }
                                if (this.services.containsKey(evtService)) break block15;
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "========= Service up, non-applicable FAN up-event for service: " + (String)evtService);
                                }
                                if (!bl) break block16;
                                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this);
                                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this, null);
                            }
                            return;
                        }
                        if (evtInstance != null) break block17;
                        this.cardinalities.put((String)evtService, (int)cardinality);
                        if (!bl) break block18;
                        ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this);
                        ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this, null);
                    }
                    return;
                }
                try {
                    void evtHost;
                    void evtDatabase;
                    Map<String, ServiceMember> members = this.services.get(evtService);
                    String memberKey = (String)evtService + "###" + (String)evtInstance + "###" + (String)evtDatabase + "###" + (String)evtHost;
                    ServiceMember member = members.get(memberKey);
                    if (member != null) {
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "========= Service up, marking UP member instance: " + member.getName());
                        }
                        member.up();
                        this.cardinalities.put((String)evtService, (int)cardinality);
                        if (this.delayedDrainingTimerTask != null) {
                            this.scheduleTimerTask(this.drainingTimerTask, this.drainIntervals);
                        }
                    } else if (bl) {
                        OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "========= Service up, non-applicable FAN up-event for service: " + (String)evtService + " on instance: " + (String)evtInstance);
                    }
                }
                catch (Throwable t2) {
                    if (!bl) break block19;
                    OracleLog.debug($$$loggerRef$$$10, Level.FINEST, this.getClass(), $$$methodRef$$$10, "========= Service up error: \n" + this.getStackTraceString(t2));
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, HAManager.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isServiceMemberDown(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, HAManager.class, $$$methodRef$$$11, this, oracleConnection);
            }
            Properties props = oconn.getServerSessionInfo();
            String svc = HAManager.toLowerCase(props.getProperty("SERVICE_NAME"));
            String inst = HAManager.toLowerCase(props.getProperty("INSTANCE_NAME"));
            String db = HAManager.toLowerCase(props.getProperty("DATABASE_NAME"));
            String hst = HAManager.toLowerCase(props.getProperty("SERVER_HOST"));
            String memberKey = svc + "###" + inst + "###" + db + "###" + hst;
            Map<String, ServiceMember> members = this.services.get(svc);
            if (members != null) {
                ServiceMember member = members.get(memberKey);
                boolean bl2 = member.isDown();
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, HAManager.class, $$$methodRef$$$11, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, HAManager.class, $$$methodRef$$$11, this, null);
                }
                return bl2;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, HAManager.class, $$$methodRef$$$11, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, HAManager.class, $$$methodRef$$$11, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, HAManager.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkAndDrain(OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, HAManager.class, $$$methodRef$$$12, this, oracleConnection);
            }
            boolean justDrain = false;
            if (this.drainIntervals > 0) {
                if (this.remainingIntervals.get() == 0) {
                    if (this.drainingTimerTask != null) {
                        this.drainingTimerTask.cancel();
                    }
                    this.drainingTimerTask = null;
                    if (this.delayedDrainingTimerTask != null) {
                        this.delayedDrainingTimerTask.cancel();
                    }
                    this.delayedDrainingTimerTask = null;
                    this.drainIntervals = 0;
                    justDrain = true;
                } else {
                    justDrain = false;
                }
            } else {
                justDrain = true;
            }
            if (this.isServiceMemberDown((OracleConnection)oconn) && (justDrain || this.currentDrainCount.get() < this.currentDrainTarget.get())) {
                ((PhysicalConnection)oconn).closeConnectionSafely();
                this.currentDrainCount.incrementAndGet();
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$12, Level.FINEST, this.getClass(), $$$methodRef$$$12, "========= Cleaned up conn: " + (OracleConnection)oconn);
                }
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, HAManager.class, $$$methodRef$$$12, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, HAManager.class, $$$methodRef$$$12, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, HAManager.class, $$$methodRef$$$12, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, HAManager.class, $$$methodRef$$$12, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, HAManager.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void enableHAIfNecessary(String string, OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void oconn;
            boolean fanEnabled;
            block31: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, null, string, oracleConnection);
                }
                fanEnabled = true;
                if (dependentJarsChecked.compareAndSet(false, true)) {
                    try {
                        ClassLoader clsLoader = oconn.getClass().getClassLoader();
                        Class.forName("oracle.simplefan.FanManager", false, clsLoader);
                        Class.forName("oracle.ons.ONS", false, clsLoader);
                        allDependentJarsPresent = true;
                    }
                    catch (Throwable err) {
                        allDependentJarsPresent = false;
                        fanEnabled = false;
                        if (!bl) break block31;
                        OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= simplefan.jar or ons.jar is not on the classpath, HA is disabled, " + err);
                    }
                }
            }
            if (!allDependentJarsPresent) {
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= HA is explicitly disabled");
                }
            } else {
                String url;
                HAManager haManager = allManagers.get(url);
                if (haManager == null) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= " + url + ", Automatically determine whether to enable HA");
                    }
                    String explicitONSConfig = System.getProperty(FAN_CONFIG_PROPERTY);
                    short ver = oconn.getVersionNumber();
                    String onsConfig = null;
                    if (ver < 11100) {
                        fanEnabled = false;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= " + url + ", Pre-11.x DB, HA is disabled");
                        }
                    } else if (explicitONSConfig != null && !"".equals(explicitONSConfig)) {
                        fanEnabled = true;
                        onsConfig = explicitONSConfig;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= " + url + ", explicit ONS config provided, HA is enabled");
                        }
                    } else {
                        Properties connSig = oconn.getServerSessionInfo();
                        String autoONSConfig = connSig.getProperty("AUTH_ONS_CONFIG");
                        if (ver >= 12101) {
                            if (autoONSConfig == null) {
                                fanEnabled = false;
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= " + url + ", Single-instance 12.x DB, HA is disabled");
                                }
                            } else {
                                fanEnabled = true;
                                onsConfig = autoONSConfig;
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= " + url + ", RAC/GDS 12.x, HA is enabled");
                                }
                            }
                        } else {
                            fanEnabled = false;
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= " + url + ", DB 11.x with no ONS config provided, HA is disabled");
                            }
                        }
                    }
                    if (fanEnabled) {
                        try {
                            haManager = HAManager.getInstance(onsConfig);
                        }
                        catch (Throwable err) {
                            fanEnabled = false;
                            haManager = NoSupportHAManager.getInstance();
                            if (bl) {
                                OracleLog.debug($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, "========= " + url + ", ONS config failed, HA is disabled");
                            }
                        }
                    } else {
                        haManager = NoSupportHAManager.getInstance();
                    }
                    allManagers.putIfAbsent(url, haManager);
                }
                haManager.addConnection((OracleConnection)oconn);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, null);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, HAManager.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public static void shutdownAll() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, HAManager.class, $$$methodRef$$$14, null, new Object[0]);
            }
            for (HAManager mngr : allManagers.values()) {
                if (mngr == null) continue;
                mngr.close();
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$14, Level.FINEST, HAManager.class, $$$methodRef$$$14, "========= Closed all FAN subscriptions in Oracle JDBC driver");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, HAManager.class, $$$methodRef$$$14, null);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, HAManager.class, $$$methodRef$$$14, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, HAManager.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    public void close() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, HAManager.class, $$$methodRef$$$15, this, new Object[0]);
            }
            if (this.fanSubscription != null) {
                this.fanSubscription.close();
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$15, Level.FINEST, this.getClass(), $$$methodRef$$$15, "Closed FAN subscription on: " + this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, HAManager.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, HAManager.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, HAManager.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final String getStackTraceString(Throwable throwable) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void exc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, HAManager.class, $$$methodRef$$$16, this, throwable);
            }
            StringWriter stackTraceWriter = new StringWriter(1024);
            PrintWriter pw = new PrintWriter(stackTraceWriter);
            exc.printStackTrace(pw);
            String string = ((Object)stackTraceWriter).toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, HAManager.class, $$$methodRef$$$16, this, string);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, HAManager.class, $$$methodRef$$$16, this, null);
            }
            return string;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, HAManager.class, $$$methodRef$$$16, this, throwable3);
            }
            throw throwable2;
        }
    }

    private static String toLowerCase(String string) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            String s2;
            String string2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, HAManager.class, $$$methodRef$$$17, null, string);
            }
            String string3 = string2 = null == s2 ? null : s2.toLowerCase();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, HAManager.class, $$$methodRef$$$17, null, string2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, HAManager.class, $$$methodRef$$$17, null, null);
            }
            return string3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, HAManager.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    private static Logger logger() {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, HAManager.class, $$$methodRef$$$18, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.driver");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, HAManager.class, $$$methodRef$$$18, null, logger);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, HAManager.class, $$$methodRef$$$18, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, HAManager.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ AtomicInteger access$000(HAManager hAManager) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            HAManager x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, HAManager.class, $$$methodRef$$$19, null, hAManager);
            }
            AtomicInteger atomicInteger = x0.remainingIntervals;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, HAManager.class, $$$methodRef$$$19, null, atomicInteger);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, HAManager.class, $$$methodRef$$$19, null, null);
            }
            return atomicInteger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, HAManager.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ int access$100(HAManager hAManager) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            HAManager x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, HAManager.class, $$$methodRef$$$20, null, hAManager);
            }
            int n2 = x0.targetDrainCountTotal;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, HAManager.class, $$$methodRef$$$20, null, n2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, HAManager.class, $$$methodRef$$$20, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, HAManager.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ AtomicInteger access$200(HAManager hAManager) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            HAManager x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, HAManager.class, $$$methodRef$$$21, null, hAManager);
            }
            AtomicInteger atomicInteger = x0.currentDrainCount;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, HAManager.class, $$$methodRef$$$21, null, atomicInteger);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, HAManager.class, $$$methodRef$$$21, null, null);
            }
            return atomicInteger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, HAManager.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ int access$300(HAManager hAManager) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            HAManager x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, HAManager.class, $$$methodRef$$$22, null, hAManager);
            }
            int n2 = x0.targetDrainCountPerInterval;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, HAManager.class, $$$methodRef$$$22, null, n2);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, HAManager.class, $$$methodRef$$$22, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, HAManager.class, $$$methodRef$$$22, null, throwable2);
            }
            throw throwable;
        }
    }

    static /* synthetic */ AtomicInteger access$400(HAManager hAManager) {
        boolean bl = (0x40000000000000L & TraceControllerImpl.feature) != 0L;
        try {
            HAManager x0;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, HAManager.class, $$$methodRef$$$23, null, hAManager);
            }
            AtomicInteger atomicInteger = x0.currentDrainTarget;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, HAManager.class, $$$methodRef$$$23, null, atomicInteger);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, HAManager.class, $$$methodRef$$$23, null, null);
            }
            return atomicInteger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, HAManager.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$25 = HAManager.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = HAManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = HAManager.class.getDeclaredMethod("access$400", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = HAManager.class.getDeclaredMethod("access$300", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = HAManager.class.getDeclaredMethod("access$200", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = HAManager.class.getDeclaredMethod("access$100", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = HAManager.class.getDeclaredMethod("access$000", HAManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = HAManager.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = HAManager.class.getDeclaredMethod("toLowerCase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = HAManager.class.getDeclaredMethod("getStackTraceString", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = HAManager.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = HAManager.class.getDeclaredMethod("shutdownAll", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = HAManager.class.getDeclaredMethod("enableHAIfNecessary", String.class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = HAManager.class.getDeclaredMethod("checkAndDrain", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = HAManager.class.getDeclaredMethod("isServiceMemberDown", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = HAManager.class.getDeclaredMethod("serviceUp", String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = HAManager.class.getDeclaredMethod("nodeDown", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = HAManager.class.getDeclaredMethod("unplannedDown", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = HAManager.class.getDeclaredMethod("scheduleTimerTask", TimerTask.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = HAManager.class.getDeclaredMethod("drainGracefully", ServiceMember.class, Map.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = HAManager.class.getDeclaredMethod("plannedDown", String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = HAManager.class.getDeclaredMethod("dropConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = HAManager.class.getDeclaredMethod("addConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = HAManager.class.getDeclaredMethod("addService", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = HAManager.class.getDeclaredMethod("configure", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = HAManager.class.getDeclaredMethod("getInstance", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        allManagers = new ConcurrentHashMap();
        dependentJarsChecked = new AtomicBoolean(false);
        allDependentJarsPresent = true;
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.HAManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

