/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleOCIConnectionPool;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public abstract class OracleOCIConnection
extends T2CConnection {
    OracleOCIConnectionPool ociConnectionPool;
    boolean isPool;
    boolean aliasing;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public OracleOCIConnection(String ur, Properties info, Object ext) throws SQLException {
        this(ur, info, (OracleDriverExtension)ext);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null, ur, info, ext);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    OracleOCIConnection(String ur, Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null, ur, info, ext);
            }
            this.ociConnectionPool = null;
            this.isPool = false;
            this.aliasing = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$6, null, throwable2);
            }
            throw throwable;
        }
    }

    public synchronized byte[] getConnectionId() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] connId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, new Object[0]);
            }
            if ((connId = this.t2cGetConnectionId(this.m_nativeState)) == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254, "Cannot create a ByteArray for the connectionId").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, sQLException);
                }
                throw sQLException;
            }
            this.aliasing = true;
            byte[] byArray = connId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, null);
            }
            return connId;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void passwordChange(String string, @Blind String string2, @Blind String string3) throws SQLException, IOException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void newPassword;
            void oldPassword;
            void user;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, string, "*****", "*****");
            }
            this.ociPasswordChange((String)user, (String)oldPassword, (String)newPassword);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (this.lifecycle == 2 || this.lifecycle == 4 || this.aliasing) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, null);
                }
                return;
            }
            super.close();
            this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnectionPool(OracleOCIConnectionPool oracleOCIConnectionPool) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void cpool;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, oracleOCIConnectionPool);
            }
            this.ociConnectionPool = cpool;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void clearMetaData;
            void size;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, n2, bl);
            }
            super.setStmtCacheSize((int)size, (boolean)clearMetaData);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleOCIConnection.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$6 = OracleOCIConnection.class.getDeclaredConstructor(String.class, Properties.class, OracleDriverExtension.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleOCIConnection.class.getDeclaredConstructor(String.class, Properties.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleOCIConnection.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleOCIConnection.class.getDeclaredMethod("setConnectionPool", OracleOCIConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleOCIConnection.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleOCIConnection.class.getDeclaredMethod("passwordChange", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleOCIConnection.class.getDeclaredMethod("getConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

