/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class TimestampAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    TimestampAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.TIMESTAMP, stmt, 11, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$4, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 180, 180, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    TimestampAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.TIMESTAMP, stmt, 11, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$5, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 180, 180, form, false);
            this.initForDescribe(180, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$5, null);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$5, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            String result;
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$0, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                String string = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$0, this, string);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$0, this, null);
                }
                return null;
            }
            this.getBytesInternal((int)currentRow, this.tmpBytes);
            int len = this.getLength((int)currentRow);
            int year = this.oracleYear(this.tmpBytes);
            int nanos = -1;
            if (len == 11) {
                nanos = this.oracleNanos(this.tmpBytes);
            }
            int hour = this.oracleHour(this.tmpBytes);
            String string = result = this.toText(year, this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), hour, this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), nanos, hour < 12, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$0, this, string);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$0, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, n2);
            }
            if (this.isUseLess || this.isNull((int)currentRow)) {
                Object var3_3 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, var3_3);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, null);
                }
                return null;
            }
            if (this.externalType == 0) {
                if (this.statement.connection.j2ee13Compliant) {
                    Timestamp timestamp = this.getTimestamp((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, timestamp);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, null);
                    }
                    return timestamp;
                }
                TIMESTAMP tIMESTAMP = this.getTIMESTAMP((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, tIMESTAMP);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, null);
                }
                return tIMESTAMP;
            }
            switch (this.externalType) {
                case 93: {
                    Timestamp timestamp = this.getTimestamp((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, timestamp);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, null);
                    }
                    return timestamp;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$2, this, n2);
            }
            TIMESTAMP tIMESTAMP = this.getTIMESTAMP((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$2, this, tIMESTAMP);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$2, this, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$3, this, n2, map);
            }
            Object object = this.getObject((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$3, this, object);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$3, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TimestampAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$5 = TimestampAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TimestampAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TimestampAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TimestampAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TimestampAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TimestampAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

