/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionCacheManager;
import oracle.ons.Notification;
import oracle.ons.ONSException;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
class OracleFailoverEventHandlerThread
extends Thread {
    private Notification event;
    private OracleConnectionCacheManager cacheManager;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    OracleFailoverEventHandlerThread() throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$2, null, new Object[0]);
            }
            this.event = null;
            this.cacheManager = null;
            this.cacheManager = OracleConnectionCacheManager.getConnectionCacheManagerInstance();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$2, null);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$2, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void run() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$0, this, new Object[0]);
            }
            Subscriber sub = null;
            String eventStr = "(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")";
            while (this.cacheManager.failoverEnabledCacheExists()) {
                block15: {
                    block14: {
                        try {
                            sub = (Subscriber)AccessController.doPrivileged(new PrivilegedExceptionAction(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;

                                public Object run() {
                                    boolean bl = (0L & TraceControllerImpl.feature) != 0L;
                                    try {
                                        return new Subscriber("(%\"eventType=database/event/service\")|(%\"eventType=database/event/host\")", "", 30000L);
                                    }
                                    catch (SubscriptionException e2) {
                                        if (bl) {
                                            OracleLog.debug($$$loggerRef$$$0, Level.WARNING, this.getClass(), $$$methodRef$$$0, " exception " + e2.getMessage());
                                        }
                                        return null;
                                    }
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleFailoverEventHandlerThread.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                    try {
                                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                }
                            });
                        }
                        catch (PrivilegedActionException e2) {
                            if (!bl) break block14;
                            OracleLog.debug($$$loggerRef$$$0, Level.INFO, this.getClass(), $$$methodRef$$$0, "OracleFailoverEventHandlerThread.run()- PrivilegedActionException: " + e2.getMessage());
                        }
                    }
                    if (sub != null) {
                        try {
                            while (this.cacheManager.failoverEnabledCacheExists()) {
                                this.event = sub.receive(true);
                                if (this.event == null) continue;
                                this.handleEvent(this.event);
                            }
                        }
                        catch (ONSException e3) {
                            sub.close();
                            if (!bl) break block15;
                            OracleLog.debug($$$loggerRef$$$0, Level.INFO, this.getClass(), $$$methodRef$$$0, "OracleFailoverEventHandlerThread.run() - ONS Exception :" + e3.getMessage());
                        }
                    }
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ea) {
                    if (!bl) continue;
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleFailoverEventHandlerThread.run()- Got an InterruptedException:" + ea.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void handleEvent(Notification notification) {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$1, this, notification);
                }
                try {
                    void event;
                    int eventType = 0;
                    if (event.type().equalsIgnoreCase("database/event/service")) {
                        eventType = 256;
                    } else if (event.type().equalsIgnoreCase("database/event/host")) {
                        eventType = 512;
                    }
                    if (eventType != 0) {
                        this.cacheManager.verifyAndHandleEvent(eventType, event.body());
                    }
                }
                catch (SQLException e2) {
                    if (!bl) break block11;
                    this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleFailoverEventHandlerThread.handleEvent() - SQLException:" + e2.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleFailoverEventHandlerThread.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$2 = OracleFailoverEventHandlerThread.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleFailoverEventHandlerThread.class.getDeclaredMethod("handleEvent", Notification.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleFailoverEventHandlerThread.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

