/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleImplicitConnectionCache;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CONN_POOL})
class OracleFailoverWorkerThread
extends Thread {
    protected OracleImplicitConnectionCache implicitCache;
    protected int eventType;
    protected String eventServiceName;
    protected String instanceNameKey;
    protected String databaseNameKey;
    protected String hostNameKey;
    protected String status;
    protected int cardinality;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    OracleFailoverWorkerThread(OracleImplicitConnectionCache oicc, int eventType, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$1, null, oicc, eventType, instNameKey, dbUniqNameKey, hostNameKey, status, card);
            }
            this.implicitCache = null;
            this.eventType = 0;
            this.eventServiceName = null;
            this.instanceNameKey = null;
            this.databaseNameKey = null;
            this.hostNameKey = null;
            this.status = null;
            this.cardinality = 0;
            this.implicitCache = oicc;
            this.eventType = eventType;
            this.instanceNameKey = instNameKey;
            this.databaseNameKey = dbUniqNameKey;
            this.hostNameKey = hostNameKey;
            this.status = status;
            this.cardinality = card;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$1, null);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$1, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void run() {
        boolean bl = (0x4000000L & TraceControllerImpl.feature) != 0L;
        try {
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$0, this, new Object[0]);
                }
                try {
                    if (this.status != null) {
                        this.implicitCache.processFailoverEvent(this.eventType, this.instanceNameKey, this.databaseNameKey, this.hostNameKey, this.status, this.cardinality);
                    }
                }
                catch (Exception ex) {
                    if (!bl) break block8;
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleImplicitConnectionCache.OracleFailoverWorkerThread()\neventType=" + this.eventType + "\ninstanceName=" + this.instanceNameKey + "\ndatabaseName=" + this.databaseNameKey + "\nhostName=" + this.hostNameKey + "\nstatus=" + this.status + "\ncardinality=" + this.cardinality + "\n" + ex.getMessage());
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleFailoverWorkerThread.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$1 = OracleFailoverWorkerThread.class.getDeclaredConstructor(OracleImplicitConnectionCache.class, Integer.TYPE, String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleFailoverWorkerThread.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

