/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={Connection.class, OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
@ProxyLocale
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableConnection
extends NonTxnReplayableBase
implements Replayable,
ReplayableConnection {
    OracleConnectionBuilderImpl originalConnectionBuilder;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    public NonTxnReplayableConnection() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$21, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$21, null);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$21, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$21, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void args;
            void receiver;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$0, this, method, object, objectArray);
            }
            super.preForAll((Method)m2, receiver, (Object[])args);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={}), @Signature(name="rollback", args={Savepoint.class}), @Signature(name="setSavepoint", args={}), @Signature(name="setSavepoint", args={String.class}), @Signature(name="releaseSavepoint", args={Savepoint.class}), @Signature(name="oracleRollback", args={OracleSavepoint.class}), @Signature(name="oracleSetSavepoint", args={}), @Signature(name="oracleSetSavepoint", args={String.class}), @Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class})})
    protected void preForTxnControl(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            String methodName;
            FailoverManagerImpl.ReplayLifecycle lifecycle;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$1, this, method, object, objectArray);
            }
            if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$1, this);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$1, this, null);
                }
                return;
            }
            String string = methodName = m2 == null ? "NULL METHOD" : m2.getName();
            if (bl) {
                OracleLog.log($$$loggerRef$$$1, Level.FINER, this.getClass(), $$$methodRef$$$1, "On connection {0}, entering preForTxnControl({1})", new Object[]{this, methodName});
            }
            if (this.failoverMngr != null) {
                void args;
                void receiver;
                boolean disableReplayFlag = false;
                try {
                    oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
                    EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "On connection {0}, method {1}, transaction state: {2}", new Object[]{this, methodName, eocs});
                    }
                    if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                        disableReplayFlag = true;
                    }
                    if (disableReplayFlag) {
                        this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
                    }
                    super.preForAll((Method)m2, receiver, (Object[])args);
                }
                catch (SQLException sqlexc) {
                    try {
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$1, Level.WARNING, this.getClass(), $$$methodRef$$$1, "On connection {0}, could not get transaction state: {1}", new Object[]{this, sqlexc});
                        }
                        if (disableReplayFlag = true) {
                            this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
                        }
                        super.preForAll((Method)m2, receiver, (Object[])args);
                    }
                    catch (Throwable throwable) {
                        if (disableReplayFlag) {
                            this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
                        } else {
                            super.preForAll((Method)m2, receiver, (Object[])args);
                        }
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$1, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
            } else if (bl) {
                OracleLog.log($$$loggerRef$$$1, Level.SEVERE, this.getClass(), $$$methodRef$$$1, "On connection {0}, failover manager not set", this);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$1, Level.FINER, this.getClass(), $$$methodRef$$$1, "On connection {0}, exiting preForTxnControl()", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$2, this, method, object, objectArray);
            }
            if (bl) {
                void m2;
                OracleLog.log($$$loggerRef$$$2, Level.FINE, this.getClass(), $$$methodRef$$$2, "On connection {0}, preForClosure({1})", new Object[]{this, m2.getName()});
            }
            this.isClosedAndNoReplay = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$3, this, method, object, objectArray);
            }
            if (bl) {
                void m2;
                OracleLog.log($$$loggerRef$$$3, Level.FINE, this.getClass(), $$$methodRef$$$3, "On connection {0}, preForCancel({1})", new Object[]{this, m2.getName()});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected void postForAll(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$4, this, method);
            }
            this.postForAll((Method)m2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$5, this, method, object);
            }
            Object object2 = super.postForAll((Method)m2, result);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$5, this, object2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$5, this, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$6, this, method);
            }
            if (bl) {
                void m2;
                OracleLog.log($$$loggerRef$$$6, Level.FINE, this.getClass(), $$$methodRef$$$6, "On connection {0}, postForClosure({1})", new Object[]{this, m2.getName()});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$7, this, method);
            }
            if (bl) {
                void m2;
                OracleLog.log($$$loggerRef$$$7, Level.FINE, this.getClass(), $$$methodRef$$$7, "On connection {0}, postForCancel({1})", new Object[]{this, m2.getName()});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$8, this, method, sQLException);
            }
            super.onErrorVoidForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$9, this, method, sQLException);
            }
            Object object = super.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$9, this, object);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$9, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    /*
     * WARNING - void declaration
     */
    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void timeout;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$10, this, n2);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$10, Level.FINE, this.getClass(), $$$methodRef$$$10, "On connection {0}, entering setReplayInitiationTimeout({1})", new Object[]{this, (int)timeout});
            }
            this.failoverMngr.setReplayInitiationTimeout((int)timeout);
            if (bl) {
                OracleLog.log($$$loggerRef$$$10, Level.FINE, this.getClass(), $$$methodRef$$$10, "On connection {0}, exiting setReplayInitiationTimeout({1})", new Object[]{this, (int)timeout});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialize(OracleDataSource oracleDataSource, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void connBuilder;
            void rds;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$11, this, oracleDataSource, oracleConnectionBuilderImpl);
            }
            FailoverManagerImpl failoverMngr = (FailoverManagerImpl)FailoverManagerImpl.getFailoverManager(this, (OracleDataSource)rds);
            this.setFailoverManager(failoverMngr);
            this.originalConnectionBuilder = connBuilder;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void beginRequest() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$12, Level.FINE, this.getClass(), $$$methodRef$$$12, "On connection {0}, entering beginRequest()", this);
            }
            this.failoverMngr.beginRequest();
            if (bl) {
                OracleLog.log($$$loggerRef$$$12, Level.FINE, this.getClass(), $$$methodRef$$$12, "On connection {0}, exiting beginRequest()", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void endRequest() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$13, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$13, Level.FINE, this.getClass(), $$$methodRef$$$13, "On connection {0}, entering endRequest()", this);
            }
            this.failoverMngr.endRequest();
            if (bl) {
                OracleLog.log($$$loggerRef$$$13, Level.FINE, this.getClass(), $$$methodRef$$$13, "On connection {0}, exiting endRequest()", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void disableReplay() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$14, this, new Object[0]);
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$14, Level.FINE, this.getClass(), $$$methodRef$$$14, "On connection {0}, entering disableReplay()", this);
            }
            this.failoverMngr.disableReplay();
            if (bl) {
                OracleLog.log($$$loggerRef$$$14, Level.FINE, this.getClass(), $$$methodRef$$$14, "On connection {0}, exiting disableReplay()", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$14, this);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$14, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public ARRAY createARRAY(String string, Object object) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            ARRAY aRRAY;
            block15: {
                void typeName;
                Object[] elementsToUse;
                void elements;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$15, this, string, object);
                }
                if (elements != null && elements instanceof Object[]) {
                    Object[] arrElements = (Object[])elements;
                    if (arrElements.length > 0) {
                        Object[] _elementsToUse = new Object[arrElements.length];
                        int i2 = 0;
                        for (Object elem : arrElements) {
                            _elementsToUse[i2++] = elem instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)elem).getDelegate() : elem;
                        }
                        elementsToUse = _elementsToUse;
                    } else {
                        elementsToUse = elements;
                    }
                } else {
                    elementsToUse = elements;
                }
                Method m2 = null;
                try {
                    m2 = oracle.jdbc.internal.OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
                }
                catch (Exception exc) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$15, this, sQLException);
                    }
                    throw sQLException;
                }
                this.preForAll(m2, this, typeName, elementsToUse);
                try {
                    oracle.jdbc.internal.OracleConnection oconn = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
                    ARRAY result = oconn.createARRAY((String)typeName, elementsToUse);
                    aRRAY = (ARRAY)this.postForAll(m2, result);
                    if (!bl) break block15;
                }
                catch (SQLException sqlexc) {
                    ARRAY aRRAY2 = (ARRAY)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$15, this, aRRAY2);
                        ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$15, this, null);
                    }
                    return aRRAY2;
                }
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$15, this, aRRAY);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$15, this, null);
            }
            return aRRAY;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createOracleArray(String string, Object object) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void elements;
            void arrayTypeName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$16, this, string, object);
            }
            ARRAY aRRAY = this.createARRAY((String)arrayTypeName, elements);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$16, this, aRRAY);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$16, this, null);
            }
            return aRRAY;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Array array;
            block13: {
                void typeName;
                Object[] elementsToUse;
                void elements;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$17, this, string, objectArray);
                }
                if (elements != null && ((void)elements).length > 0) {
                    elementsToUse = new Object[((void)elements).length];
                    int i2 = 0;
                    for (void elem : elements) {
                        elementsToUse[i2++] = elem instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)elem).getDelegate() : elem;
                    }
                } else {
                    elementsToUse = elements;
                }
                Method m2 = null;
                try {
                    m2 = Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
                }
                catch (Exception exc) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot create Array instance");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$17, this, sQLException);
                    }
                    throw sQLException;
                }
                this.preForAll(m2, this, typeName, elementsToUse);
                try {
                    Connection oconn = (Connection)this.getDelegate();
                    Array result = oconn.createArrayOf((String)typeName, elementsToUse);
                    array = (Array)this.postForAll(m2, result);
                    if (!bl) break block13;
                }
                catch (SQLException sqlexc) {
                    Array array2 = (Array)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$17, this, array2);
                        ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$17, this, null);
                    }
                    return array2;
                }
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$17, this, array);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$17, this, null);
            }
            return array;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Struct struct;
            block13: {
                void typeName;
                Object[] attributesToUse;
                void attributes;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$18, this, string, objectArray);
                }
                if (attributes != null && ((void)attributes).length > 0) {
                    attributesToUse = new Object[((void)attributes).length];
                    int i2 = 0;
                    for (void attr : attributes) {
                        attributesToUse[i2++] = attr instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)attr).getDelegate() : attr;
                    }
                } else {
                    attributesToUse = attributes;
                }
                Method m2 = null;
                try {
                    m2 = Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
                }
                catch (Exception exc) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot create Struct instance");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$18, this, sQLException);
                    }
                    throw sQLException;
                }
                this.preForAll(m2, this, typeName, attributesToUse);
                try {
                    Connection oconn = (Connection)this.getDelegate();
                    Struct result = oconn.createStruct((String)typeName, attributesToUse);
                    struct = (Struct)this.postForAll(m2, result);
                    if (!bl) break block13;
                }
                catch (SQLException sqlexc) {
                    Struct struct2 = (Struct)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$18, this, struct2);
                        ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$18, this, null);
                    }
                    return struct2;
                }
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$18, this, struct);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$18, this, null);
            }
            return struct;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Blob createBlob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Clob createClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract NClob createNClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract SQLXML createSQLXML() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, String[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$19, this, clazz);
            }
            Object object = this.getDelegate();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$19, this, object);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$19, this, null);
            }
            return (T)object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public abstract Connection _getPC();

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection unwrap() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$20, this, new Object[0]);
            }
            OracleConnection oracleConnection = ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).unwrap();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$20, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$20, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableConnection.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$21 = NonTxnReplayableConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = NonTxnReplayableConnection.class.getDeclaredMethod("unwrap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = NonTxnReplayableConnection.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = NonTxnReplayableConnection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = NonTxnReplayableConnection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = NonTxnReplayableConnection.class.getDeclaredMethod("createOracleArray", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = NonTxnReplayableConnection.class.getDeclaredMethod("createARRAY", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = NonTxnReplayableConnection.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = NonTxnReplayableConnection.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = NonTxnReplayableConnection.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = NonTxnReplayableConnection.class.getDeclaredMethod("initialize", OracleDataSource.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = NonTxnReplayableConnection.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = NonTxnReplayableConnection.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableConnection.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableConnection.class.getDeclaredMethod("postForCancel", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableConnection.class.getDeclaredMethod("postForClosure", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableConnection.class.getDeclaredMethod("preForCancel", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableConnection.class.getDeclaredMethod("preForClosure", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableConnection.class.getDeclaredMethod("preForTxnControl", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableConnection.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

