/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import java.lang.reflect.Executable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.InvalidSyntaxException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;

public class Description
implements SchemaObject {
    public Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    protected SchemaObjectFactoryInterface f = null;
    public boolean sourceRoute = false;
    public boolean loadBalance = false;
    public boolean failover = true;
    public boolean keepAlive = false;
    public String SDU;
    public String TDU;
    public Vector protocolStacks = new Vector();
    public String sendBufSize;
    public String receiveBufSize;
    public String connectData;
    public String SID;
    public String server;
    public String failoverMode;
    public String instanceRole;
    public String serviceName;
    public String instanceName;
    public String handlerName;
    public String oracleHome;
    public String connectTimeout;
    public String transportTimeout;
    public String retryCount;
    public String authTypes;
    public String sslServerCertDN;
    protected String myWalletDirectory;
    public Vector authParams = new Vector();
    public Vector extraConnInfo = new Vector();
    public Vector extraInfo = new Vector();
    protected int delay = -1;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    public Description(SchemaObjectFactoryInterface f2) {
        this.f = f2;
    }

    @Override
    public int isA() {
        return 2;
    }

    @Override
    public String isA_String() {
        return "DESCRIPTION";
    }

    @Override
    public void initFromString(String s2) throws NLException, SOException {
        NVPair nvp = new NVFactory().createNVPair(s2);
        this.initFromNVPair(nvp);
    }

    @Override
    public void initFromNVPair(NVPair nvp) throws SOException {
        this.init();
        int listsize = nvp.getListSize();
        if (listsize == 0) {
            throw new SOException();
        }
        for (int i2 = 0; i2 < listsize; ++i2) {
            int j2;
            this.childnv = nvp.getListElement(i2);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ENABLE")) {
                this.keepAlive = this.childnv.getAtom().equalsIgnoreCase("broken");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("PROTOCOL_STACK")) {
                this.protocolStacks.addElement(this.childnv.toString());
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SDU")) {
                this.SDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TDU")) {
                this.TDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SEND_BUF_SIZE")) {
                this.sendBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RECV_BUF_SIZE")) {
                this.receiveBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_DATA")) {
                this.connectData = this.childnv.valueToString();
                int cdlistsize = this.childnv.getListSize();
                if (cdlistsize == 0) {
                    throw new SOException();
                }
                for (j2 = 0; j2 < cdlistsize; ++j2) {
                    NVPair cdlistnv = this.childnv.getListElement(j2);
                    if (cdlistnv.getName().equalsIgnoreCase("SID")) {
                        this.SID = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("SERVER")) {
                        this.server = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("SERVICE_NAME")) {
                        this.serviceName = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("INSTANCE_NAME")) {
                        this.instanceName = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("HANDLER_NAME")) {
                        this.handlerName = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("ORACLE_HOME")) {
                        this.oracleHome = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("FAILOVER_MODE")) {
                        this.failoverMode = this.childnv.getListElement(j2).toString();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("INSTANCE_ROLE")) {
                        this.instanceRole = cdlistnv.getAtom();
                        continue;
                    }
                    String param = cdlistnv.toString().trim();
                    param = param.substring(1, param.length() - 1);
                    this.extraConnInfo.addElement(param);
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_DELAY")) {
                this.delay = Integer.parseInt(this.childnv.getAtom());
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SECURITY")) {
                int slistsize = this.childnv.getListSize();
                if (slistsize == 0) {
                    throw new SOException();
                }
                for (j2 = 0; j2 < slistsize; ++j2) {
                    NVPair slistnv = this.childnv.getListElement(j2);
                    if (slistnv.getName().equalsIgnoreCase("AUTHENTICATION")) {
                        this.authTypes = slistnv.toString();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("ssl_server_cert_dn")) {
                        this.sslServerCertDN = slistnv.getAtom();
                        if (this.sslServerCertDN == null || !this.sslServerCertDN.startsWith("\"") || !this.sslServerCertDN.endsWith("\"")) continue;
                        this.sslServerCertDN = this.sslServerCertDN.substring(1, this.sslServerCertDN.length() - 1);
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("my_wallet_directory")) {
                        this.myWalletDirectory = slistnv.getAtom();
                        continue;
                    }
                    this.authParams.addElement(slistnv.toString());
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_TIMEOUT")) {
                this.connectTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TRANSPORT_CONNECT_TIMEOUT")) {
                this.transportTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_COUNT")) {
                this.retryCount = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("HS") && this.childnv.getAtom() == null) {
                try {
                    this.childnv.setAtom("OK");
                }
                catch (InvalidSyntaxException slistsize) {
                    // empty catch block
                }
            }
            String param = this.childnv.toString().trim();
            param = param.substring(1, param.length() - 1);
            this.extraInfo.addElement(param);
        }
    }

    @Override
    @DisableTrace
    public String toString() {
        int i2;
        Object s2 = new String("");
        String child = new String("");
        for (i2 = 0; i2 < this.children.size(); ++i2) {
            child = ((SchemaObject)this.children.elementAt(i2)).toString();
            if (child.equals("")) continue;
            s2 = (String)s2 + child;
        }
        if (!((String)s2).equals("") && this.sourceRoute) {
            s2 = (String)s2 + "(SOURCE_ROUTE=yes)";
        }
        if (!((String)s2).equals("") && this.loadBalance) {
            s2 = (String)s2 + "(LOAD_BALANCE=yes)";
        }
        if (!((String)s2).equals("") && !this.failover) {
            s2 = (String)s2 + "(FAILOVER=false)";
        }
        if (this.keepAlive) {
            s2 = (String)s2 + "(ENABLE=broken)";
        }
        if (this.SDU != null) {
            s2 = (String)s2 + "(SDU=" + this.SDU + ")";
        }
        if (this.TDU != null) {
            s2 = (String)s2 + "(TDU=" + this.TDU + ")";
        }
        if (this.sendBufSize != null) {
            s2 = (String)s2 + "(SEND_BUF_SIZE=" + this.sendBufSize + ")";
        }
        if (this.receiveBufSize != null) {
            s2 = (String)s2 + "(RECV_BUF_SIZE=" + this.receiveBufSize + ")";
        }
        if (this.protocolStacks.size() != 0) {
            for (i2 = 0; i2 < this.protocolStacks.size(); ++i2) {
                s2 = (String)s2 + (String)this.protocolStacks.elementAt(i2);
            }
        }
        if (this.SID != null || this.server != null || this.serviceName != null || this.instanceName != null || this.handlerName != null || this.extraConnInfo.size() != 0 || this.oracleHome != null) {
            s2 = (String)s2 + "(CONNECT_DATA=";
            if (this.SID != null) {
                s2 = (String)s2 + "(SID=" + this.SID + ")";
            }
            if (this.server != null) {
                s2 = (String)s2 + "(SERVER=" + this.server + ")";
            }
            if (this.serviceName != null) {
                s2 = (String)s2 + "(SERVICE_NAME=" + this.serviceName + ")";
            }
            if (this.instanceName != null) {
                s2 = (String)s2 + "(INSTANCE_NAME=" + this.instanceName + ")";
            }
            if (this.handlerName != null) {
                s2 = (String)s2 + "(HANDLER_NAME=" + this.handlerName + ")";
            }
            if (this.oracleHome != null) {
                s2 = (String)s2 + "(ORACLE_HOME=" + this.oracleHome + ")";
            }
            if (this.instanceRole != null) {
                s2 = (String)s2 + "(INSTANCE_ROLE=" + this.instanceRole + ")";
            }
            if (this.failoverMode != null) {
                s2 = (String)s2 + this.failoverMode;
            }
            for (i2 = 0; i2 < this.extraConnInfo.size(); ++i2) {
                s2 = (String)s2 + "(" + (String)this.extraConnInfo.elementAt(i2) + ")";
            }
            s2 = (String)s2 + ")";
        }
        if (this.authTypes != null || this.authParams.size() != 0) {
            s2 = (String)s2 + "(SECURITY=";
            if (this.authTypes != null) {
                s2 = (String)s2 + "(AUTHENTICATION=" + this.authTypes + ")";
            }
            for (i2 = 0; i2 < this.authParams.size(); ++i2) {
                s2 = (String)s2 + (String)this.authParams.elementAt(i2);
            }
            s2 = (String)s2 + ")";
        }
        for (i2 = 0; i2 < this.extraInfo.size(); ++i2) {
            s2 = (String)s2 + "(" + (String)this.extraInfo.elementAt(i2) + ")";
        }
        if (!((String)s2).equals("")) {
            s2 = "(DESCRIPTION=" + (String)s2 + ")";
        }
        return s2;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
        this.keepAlive = false;
        this.protocolStacks.removeAllElements();
        this.SDU = null;
        this.TDU = null;
        this.SID = null;
        this.server = null;
        this.serviceName = null;
        this.instanceName = null;
        this.handlerName = null;
        this.oracleHome = null;
        this.authTypes = null;
        this.sendBufSize = null;
        this.receiveBufSize = null;
        this.failoverMode = null;
        this.instanceRole = null;
        this.authParams.removeAllElements();
        this.extraConnInfo.removeAllElements();
        this.extraInfo.removeAllElements();
    }

    static {
        try {
            $$$methodRef$$$5 = Description.class.getDeclaredConstructor(SchemaObjectFactoryInterface.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = Description.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = Description.class.getDeclaredMethod("initFromNVPair", NVPair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = Description.class.getDeclaredMethod("initFromString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = Description.class.getDeclaredMethod("isA_String", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = Description.class.getDeclaredMethod("isA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

