/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class DataPacket
extends Packet
implements SQLnetDef {
    static final boolean DEBUG2 = false;
    protected int pktOffset;
    protected int dataFlags;
    protected boolean isBufferFull;
    protected boolean isBufferEmpty;
    protected int availableBytesToSend;
    protected int availableBytesToRead;
    protected int sessionIdSize;
    protected byte[] compressedDataBuffer;
    protected byte[] decompressedDataBuffer;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    public DataPacket(SessionAtts sAtts, int len) {
        super(sAtts, len, 6, (sAtts.poolEnabled ? 1 : 0) | (sAtts.isLargeSDU ? 32 : 0));
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, DataPacket.class, $$$methodRef$$$9, null, sAtts, len);
            }
            this.isBufferFull = false;
            this.isBufferEmpty = false;
            this.availableBytesToSend = 0;
            this.availableBytesToRead = 0;
            this.sessionIdSize = 0;
            this.initialize(len);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, DataPacket.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DataPacket.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, DataPacket.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public DataPacket(SessionAtts sAtts) {
        this(sAtts, sAtts.getSDU());
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, DataPacket.class, $$$methodRef$$$10, null, sAtts);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, DataPacket.class, $$$methodRef$$$10, null);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DataPacket.class, $$$methodRef$$$10, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, DataPacket.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void receive() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, DataPacket.class, $$$methodRef$$$0, this, new Object[0]);
            }
            super.receive();
            this.pktOffset = 10;
            this.dataOff = 10;
            this.dataLen = this.length - this.dataOff - (this.sAtts.poolEnabled ? 16 : 0);
            this.dataFlags = this.buffer[8] & 0xFF;
            this.dataFlags <<= 8;
            this.dataFlags |= this.buffer[9] & 0xFF;
            if (this.type == 6 && (this.dataFlags & 0x40) != 0) {
                this.sAtts.dataEOF = true;
            }
            if (this.type == 6 && 0 == this.dataLen) {
                this.type = 7;
            }
            if ((this.dataFlags & 0x400) != 0) {
                try {
                    int resultLength = this.sAtts.compressionCodec.decompress(this.buffer, 10, this.dataLen, this.decompressedDataBuffer);
                    System.arraycopy(this.decompressedDataBuffer, 0, this.buffer, 10, resultLength);
                    this.dataLen = resultLength;
                    this.length = this.dataLen + this.dataOff;
                }
                catch (DataFormatException ex) {
                    IOException iOException = (IOException)new IOException("Network Compression failure").initCause(ex);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, DataPacket.class, $$$methodRef$$$0, this, iOException);
                    }
                    throw iOException;
                }
            }
            if (this.sAtts.poolEnabled) {
                this.sAtts.timestampLastIO = System.currentTimeMillis();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, DataPacket.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DataPacket.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, DataPacket.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void send() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, DataPacket.class, $$$methodRef$$$1, this, new Object[0]);
            }
            this.send(0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, DataPacket.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DataPacket.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, DataPacket.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(int n2) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            int dataFlags;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, DataPacket.class, $$$methodRef$$$2, this, n2);
            }
            if (this.sAtts.networkCompressionEnabled && this.pktOffset > this.sAtts.networkCompressionThreshold) {
                try {
                    int resultLength = this.sAtts.compressionCodec.compress(this.buffer, 10, this.pktOffset - 10, this.compressedDataBuffer);
                    if (resultLength < this.pktOffset - 10) {
                        dataFlags |= 0x400;
                        System.arraycopy(this.compressedDataBuffer, 0, this.buffer, 10, resultLength);
                        this.pktOffset = resultLength + 10;
                    }
                }
                catch (DataFormatException ex) {
                    IOException iOException = (IOException)new IOException("Network Compression failure").initCause(ex);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, DataPacket.class, $$$methodRef$$$2, this, iOException);
                    }
                    throw iOException;
                }
            }
            this.buffer[8] = (byte)(dataFlags / 256);
            this.buffer[9] = (byte)(dataFlags % 256);
            this.setBufferLength(this.pktOffset);
            OutputStream outputStream = this.sAtts.ntOutputStream;
            synchronized (outputStream) {
                try {
                    if (bl) {
                        this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "Packet size=" + this.pktOffset + "\n" + this.dumpBytes(this.buffer, 0, this.pktOffset) + ", sessionTraceId=" + this.sAtts.traceId);
                    }
                    if (this.sAtts.poolEnabled) {
                        boolean bDoAgain;
                        int iAttempts = 20;
                        do {
                            bDoAgain = false;
                            try {
                                this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
                            }
                            catch (SocketException ea) {
                                if (bl) {
                                    this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "Got IOException(" + ea.getMessage() + ")\n sessionTraceId=" + this.sAtts.traceId);
                                }
                                if (ea.getMessage().startsWith("Connection reset") && --iAttempts > 0) {
                                    if (!this.sAtts.attemptingReconnect) {
                                        if (bl) {
                                            this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "Got IOException(" + ea.getMessage() + ")\nAttempting reconnect, sessionTraceId=" + this.sAtts.traceId);
                                        }
                                        this.sAtts.ns.reconnectIfRequired(false);
                                    }
                                    bDoAgain = true;
                                    continue;
                                }
                                SocketException socketException = ea;
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, DataPacket.class, $$$methodRef$$$2, this, socketException);
                                }
                                throw socketException;
                            }
                        } while (bDoAgain);
                    } else {
                        this.sAtts.ntOutputStream.write(this.buffer, 0, this.pktOffset);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl54 : MonitorExitStatement: MONITOREXIT : var2_5
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, DataPacket.class, $$$methodRef$$$2, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            this.pktOffset = 10;
            this.availableBytesToSend = 0;
            this.isBufferFull = false;
            if (this.sAtts.poolEnabled) {
                this.sAtts.timestampLastIO = System.currentTimeMillis();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, DataPacket.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DataPacket.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, DataPacket.class, $$$methodRef$$$2, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int putDataInBuffer(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            void bytes2copy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, DataPacket.class, $$$methodRef$$$3, this, byArray, n2, n3);
            }
            int n4 = bytes2copy = this.buffer.length - this.sessionIdSize - this.pktOffset <= len ? this.buffer.length - this.sessionIdSize - this.pktOffset : len;
            if (bytes2copy > 0) {
                void off;
                void userBuffer;
                System.arraycopy(userBuffer, (int)off, this.buffer, this.pktOffset, (int)bytes2copy);
                this.pktOffset += bytes2copy;
                this.isBufferFull = this.pktOffset == this.buffer.length - this.sessionIdSize;
                this.availableBytesToSend = this.dataOff < this.pktOffset ? this.pktOffset - this.dataOff : 0;
            }
            void var6_6 = bytes2copy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, DataPacket.class, $$$methodRef$$$3, this, (int)var6_6);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DataPacket.class, $$$methodRef$$$3, this, null);
            }
            return (int)var6_6;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, DataPacket.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long readLongLSB(int n2) throws BreakNetException, NetException, IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bufSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, DataPacket.class, $$$methodRef$$$4, this, n2);
            }
            long returnValue = 0L;
            void i2 = bufSize;
            int j2 = 0;
            while (i2 > 0) {
                returnValue |= ((long)this.buffer[this.pktOffset] & 0xFFL) << 8 * j2;
                --i2;
                ++j2;
                ++this.pktOffset;
                --this.availableBytesToRead;
            }
            long l2 = returnValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, DataPacket.class, $$$methodRef$$$4, this, l2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DataPacket.class, $$$methodRef$$$4, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, DataPacket.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long readLongMSB(int n2) throws BreakNetException, NetException, IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bufSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, DataPacket.class, $$$methodRef$$$5, this, n2);
            }
            long returnValue = 0L;
            void i2 = bufSize;
            while (i2 > 0) {
                returnValue |= ((long)this.buffer[this.pktOffset] & 0xFFL) << 8 * (i2 - true);
                --i2;
                ++this.pktOffset;
                --this.availableBytesToRead;
            }
            long l2 = returnValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, DataPacket.class, $$$methodRef$$$5, this, l2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DataPacket.class, $$$methodRef$$$5, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, DataPacket.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int getDataFromBuffer(byte[] byArray, int n2, int n3) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void len;
            int bytes2copy;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, DataPacket.class, $$$methodRef$$$6, this, byArray, n2, n3);
            }
            int n4 = bytes2copy = this.availableBytesToRead <= len ? this.availableBytesToRead : len;
            if (bytes2copy > 0) {
                void off;
                void userBuffer;
                System.arraycopy(this.buffer, this.pktOffset, userBuffer, (int)off, bytes2copy);
                this.pktOffset += bytes2copy;
                this.isBufferEmpty = this.pktOffset == this.length;
                this.availableBytesToRead -= bytes2copy;
            }
            int n5 = bytes2copy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, DataPacket.class, $$$methodRef$$$6, this, n5);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DataPacket.class, $$$methodRef$$$6, this, null);
            }
            return n5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, DataPacket.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setBufferLength(int n2) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, DataPacket.class, $$$methodRef$$$7, this, n2);
            }
            if (this.sAtts.poolEnabled) {
                System.arraycopy(this.sAtts.sessionId, 0, this.buffer, this.pktOffset, 16);
                length += 16;
                this.pktOffset += 16;
            }
            if (this.sAtts.isLargeSDU) {
                this.buffer[3] = (byte)(length & 0xFF);
                this.buffer[2] = (byte)(length >> 8 & 0xFF);
                this.buffer[1] = (byte)(length >> 16 & 0xFF);
                this.buffer[0] = (byte)(length >> 24 & 0xFF);
            } else {
                this.buffer[0] = (byte)(length / 256);
                this.buffer[1] = (byte)(length % 256);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, DataPacket.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DataPacket.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, DataPacket.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void initialize(int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bufferSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, DataPacket.class, $$$methodRef$$$8, this, n2);
            }
            this.pktOffset = 10;
            this.dataOff = 10;
            this.dataLen = bufferSize - this.dataOff;
            this.dataFlags = 0;
            int n3 = this.sessionIdSize = this.sAtts.poolEnabled ? 16 : 0;
            if (this.sAtts.networkCompressionEnabled) {
                this.compressedDataBuffer = new byte[this.sdu];
                this.decompressedDataBuffer = new byte[this.sdu];
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, DataPacket.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DataPacket.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, DataPacket.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$10 = DataPacket.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$9 = DataPacket.class.getDeclaredConstructor(SessionAtts.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$8 = DataPacket.class.getDeclaredMethod("initialize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$7 = DataPacket.class.getDeclaredMethod("setBufferLength", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$6 = DataPacket.class.getDeclaredMethod("getDataFromBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$5 = DataPacket.class.getDeclaredMethod("readLongMSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$4 = DataPacket.class.getDeclaredMethod("readLongLSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$3 = DataPacket.class.getDeclaredMethod("putDataInBuffer", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$2 = DataPacket.class.getDeclaredMethod("send", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$1 = DataPacket.class.getDeclaredMethod("send", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
        try {
            $$$methodRef$$$0 = DataPacket.class.getDeclaredMethod("receive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.net.ns");
    }
}

