/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.net.nt.SocketChannelWrapper;

public class WSSSocketChannel
extends SocketChannelWrapper {
    private static final byte WS_OPCODE_CONTINUE = 0;
    private static final byte WS_OPCODE_TEXTDATA = 1;
    private static final byte WS_OPCODE_BINARYDATA = 2;
    private static final byte WS_OPCODE_CLOSE = 8;
    private static final byte WS_OPCODE_PING = 9;
    private static final byte WS_OPCODE_PONG = 10;
    private static final int HANDSHAKE_RESPONSE_BUFFER_SIZE = 1024;
    private static final byte MASK_BYTE_OPCODE = 15;
    private static final byte MASK_BYTE_FIN = -127;
    public static final byte[] WS_DUMMY_MASK_KEY;
    private ByteBuffer payloadBuffer = ByteBuffer.allocate(this.bufferSize);
    private boolean isClosed = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public WSSSocketChannel(SocketChannel socketChannel, String uri, String server, int port, String authUser, String authPwd) throws IOException {
        super(socketChannel);
        this.payloadBuffer.limit(0);
        this.doWSHandShake(uri, server, port, authUser, authPwd);
    }

    @Override
    public int read(ByteBuffer dstBuffer) throws IOException {
        int initialPosition = dstBuffer.position();
        if (!this.payloadBuffer.hasRemaining()) {
            this.readFromSocket();
        }
        while (this.payloadBuffer.hasRemaining() && dstBuffer.hasRemaining()) {
            dstBuffer.put(this.payloadBuffer.get());
        }
        return dstBuffer.position() - initialPosition;
    }

    @Override
    public int write(ByteBuffer srcBuffer) throws IOException {
        int payloadLength = srcBuffer.remaining();
        if (payloadLength > 0) {
            WSFrame.writeFrame(this.socketChannel, new WSBinaryFrame(srcBuffer));
        }
        return payloadLength;
    }

    @Override
    public void setBufferSize(int newBufferSize) {
        if (this.bufferSize == newBufferSize) {
            return;
        }
        this.bufferSize = newBufferSize;
        ByteBuffer newPayloadBuffer = ByteBuffer.allocate(newBufferSize);
        if (this.payloadBuffer.hasRemaining()) {
            newPayloadBuffer.put(this.payloadBuffer);
        }
        newPayloadBuffer.flip();
        this.payloadBuffer = newPayloadBuffer;
    }

    private void doWSHandShake(String uri, String host, int port, String authUser, String authPwd) throws IOException {
        WSHandshakeHelper handShakeHelper = new WSHandshakeHelper(uri, null, host, port, authUser, authPwd);
        handShakeHelper.sendHandshakeData(this.socketChannel);
        handShakeHelper.receiveHandshakeResponse(this.socketChannel);
    }

    private void readFromSocket() throws IOException {
        WSFrame.readFrame(this.socketChannel, this.payloadBuffer);
    }

    @Override
    public void disconnect() {
        try {
            if (!this.isClosed && this.socketChannel != null && this.socketChannel.isOpen()) {
                WSCloseFrame closeFrame = new WSCloseFrame();
                WSFrame.writeFrame(this.socketChannel, closeFrame);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isClosed = true;
        try {
            if (this.socketChannel instanceof SocketChannelWrapper) {
                ((SocketChannelWrapper)this.socketChannel).disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            $$$methodRef$$$6 = WSSSocketChannel.class.getDeclaredConstructor(SocketChannel.class, String.class, String.class, Integer.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = WSSSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = WSSSocketChannel.class.getDeclaredMethod("readFromSocket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = WSSSocketChannel.class.getDeclaredMethod("doWSHandShake", String.class, String.class, Integer.TYPE, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = WSSSocketChannel.class.getDeclaredMethod("setBufferSize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = WSSSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = WSSSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        WS_DUMMY_MASK_KEY = new byte[]{0, 0, 0, 0};
    }

    private static class WSBinaryFrame
    extends WSFrame {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        private WSBinaryFrame(WSHeader header, ByteBuffer payloadBuffer, SocketChannel sc) {
            super(header, payloadBuffer, sc);
        }

        private WSBinaryFrame(ByteBuffer payloadBuffer) {
            this.payloadBuffer = payloadBuffer;
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            WSHeader.access$802(this.header, WS_DUMMY_MASK_KEY);
            this.header.opCode = (byte)2;
            this.header.payloadLength = this.payloadBuffer.remaining();
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
        }

        static {
            try {
                $$$methodRef$$$5 = WSBinaryFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSBinaryFrame.class.getDeclaredConstructor(ByteBuffer.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSBinaryFrame.class.getDeclaredConstructor(ByteBuffer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSBinaryFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSBinaryFrame.class.getDeclaredMethod("readPayload", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSBinaryFrame.class.getDeclaredMethod("prepareForWrite", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static class WSCloseFrame
    extends WSFrame {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;

        private WSCloseFrame(WSHeader header, ByteBuffer payloadBuffer, SocketChannel sc) {
            super(header, payloadBuffer, sc);
        }

        private WSCloseFrame() {
        }

        @Override
        void prepareForWrite() throws IOException {
            this.header = new WSHeader();
            this.header.isFinalChunk = true;
            this.header.isPayloadMasked = true;
            WSHeader.access$802(this.header, WS_DUMMY_MASK_KEY);
            this.header.opCode = (byte)8;
            this.header.payloadLength = 0;
        }

        @Override
        void readPayload() throws IOException {
            this.readPayloadFromSocket();
            short errorCode = this.payloadBuffer.getShort();
            throw new IOException("WebSocket : Connection closed. (Error code : " + errorCode + ")");
        }

        static {
            try {
                $$$methodRef$$$5 = WSCloseFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSCloseFrame.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSCloseFrame.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSCloseFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSCloseFrame.class.getDeclaredMethod("readPayload", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSCloseFrame.class.getDeclaredMethod("prepareForWrite", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static abstract class WSFrame {
        protected WSHeader header;
        protected ByteBuffer payloadBuffer;
        protected SocketChannel socketChannel;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;

        private WSFrame(WSHeader header, ByteBuffer payloadBuffer, SocketChannel sc) {
            this.header = header;
            this.payloadBuffer = payloadBuffer;
            this.socketChannel = sc;
        }

        private WSFrame() {
        }

        static WSFrame readFrame(SocketChannel socketChannel, ByteBuffer payloadBuffer) throws IOException {
            WSHeader wsHeader = new WSHeader();
            wsHeader.read(socketChannel);
            WSFrame frame = null;
            switch (wsHeader.opCode) {
                case 0: 
                case 2: {
                    frame = new WSBinaryFrame(wsHeader, payloadBuffer, socketChannel);
                    break;
                }
                case 8: {
                    frame = new WSCloseFrame(wsHeader, payloadBuffer, socketChannel);
                    break;
                }
                default: {
                    throw new IOException("Websocket : Invalid frame type : " + wsHeader.opCode);
                }
            }
            frame.readPayload();
            frame.maskOrUnmaskPayload();
            return frame;
        }

        static void writeFrame(SocketChannel socketChannel, WSFrame wsFrame) throws IOException {
            wsFrame.prepareForWrite();
            wsFrame.header.write(socketChannel);
            wsFrame.maskOrUnmaskPayload();
            if (wsFrame.payloadBuffer != null) {
                while (wsFrame.payloadBuffer.hasRemaining()) {
                    socketChannel.write(wsFrame.payloadBuffer);
                }
            }
        }

        private void maskOrUnmaskPayload() {
            if (this.header.isPayloadMasked) {
                int intialPosition;
                for (int i2 = intialPosition = this.payloadBuffer.position(); i2 < this.payloadBuffer.limit(); ++i2) {
                    byte maskedByte = this.payloadBuffer.get(i2);
                    maskedByte = (byte)(maskedByte ^ this.header.maskingKey[i2 % 4]);
                    this.payloadBuffer.put(i2, maskedByte);
                }
                this.payloadBuffer.rewind();
                this.payloadBuffer.position(intialPosition);
            }
        }

        protected void readPayloadFromSocket() throws IOException {
            this.payloadBuffer.clear();
            this.payloadBuffer.limit(this.header.payloadLength);
            if (this.header.payloadLength <= 0) {
                return;
            }
            while (this.payloadBuffer.hasRemaining()) {
                this.socketChannel.read(this.payloadBuffer);
            }
            this.payloadBuffer.flip();
        }

        abstract void readPayload() throws IOException;

        abstract void prepareForWrite() throws IOException;

        static {
            try {
                $$$methodRef$$$7 = WSFrame.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WSFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WSFrame.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSFrame.class.getDeclaredConstructor(WSHeader.class, ByteBuffer.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSFrame.class.getDeclaredMethod("readPayloadFromSocket", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSFrame.class.getDeclaredMethod("maskOrUnmaskPayload", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSFrame.class.getDeclaredMethod("writeFrame", SocketChannel.class, WSFrame.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSFrame.class.getDeclaredMethod("readFrame", SocketChannel.class, ByteBuffer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static class WSHeader {
        private boolean isFinalChunk;
        private byte opCode;
        private int payloadLength;
        private boolean isPayloadMasked;
        private byte[] maskingKey;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;

        private WSHeader() {
        }

        void read(SocketChannel socketChannel) throws IOException {
            ByteBuffer headerBuffer = ByteBuffer.allocate(14);
            headerBuffer.limit(2);
            while (headerBuffer.hasRemaining()) {
                socketChannel.read(headerBuffer);
            }
            headerBuffer.flip();
            byte firstByte = headerBuffer.get();
            byte secondByte = headerBuffer.get();
            this.isFinalChunk = (firstByte & 0x80) != 0;
            this.opCode = (byte)(firstByte & 0xF);
            this.isPayloadMasked = (secondByte & 0x80) != 0;
            this.payloadLength = (byte)(0x7F & secondByte);
            this.readRemainingHeaderBytes(socketChannel, headerBuffer);
            if (this.payloadLength == 126) {
                this.payloadLength = headerBuffer.getShort() & 0xFFFF;
            } else if (this.payloadLength >= 127) {
                this.payloadLength = (int)headerBuffer.getLong();
            }
            if (this.isPayloadMasked) {
                this.maskingKey = new byte[4];
                headerBuffer.get(this.maskingKey);
            }
        }

        private void readRemainingHeaderBytes(SocketChannel socketChannel, ByteBuffer headerBuffer) throws IOException {
            int neededHeaderBytes = 2;
            if (this.payloadLength == 126) {
                neededHeaderBytes += 2;
            } else if (this.payloadLength >= 127) {
                neededHeaderBytes += 8;
            }
            if (this.isPayloadMasked) {
                neededHeaderBytes += 4;
            }
            headerBuffer.position(2);
            headerBuffer.limit(neededHeaderBytes);
            while (headerBuffer.hasRemaining()) {
                socketChannel.read(headerBuffer);
            }
            headerBuffer.flip();
            headerBuffer.position(2);
        }

        private void write(SocketChannel socketChannel) throws IOException {
            ByteBuffer headerBuffer = ByteBuffer.allocate(14);
            byte firstByte = this.opCode;
            if (this.isFinalChunk) {
                firstByte = (byte)(firstByte | 0x80);
            }
            byte secondByte = 0;
            if (this.isPayloadMasked) {
                secondByte = -128;
            }
            headerBuffer.put(firstByte);
            if (this.payloadLength > 65535) {
                secondByte = (byte)(secondByte | 0x7F);
                headerBuffer.put(secondByte);
                headerBuffer.putLong(this.payloadLength);
            } else if (this.payloadLength >= 126) {
                secondByte = (byte)(secondByte | 0x7E);
                headerBuffer.put(secondByte);
                headerBuffer.putShort((short)this.payloadLength);
            } else {
                secondByte = (byte)(secondByte | this.payloadLength & 0x7F);
                headerBuffer.put(secondByte);
            }
            if (this.isPayloadMasked) {
                headerBuffer.put(this.maskingKey);
            }
            headerBuffer.flip();
            socketChannel.write(headerBuffer);
        }

        static /* synthetic */ byte[] access$802(WSHeader x0, byte[] x1) {
            x0.maskingKey = x1;
            return x1;
        }

        static {
            try {
                $$$methodRef$$$14 = WSHeader.class.getDeclaredConstructor(1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = WSHeader.class.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = WSHeader.class.getDeclaredMethod("access$902", WSHeader.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = WSHeader.class.getDeclaredMethod("access$302", WSHeader.class, Byte.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = WSHeader.class.getDeclaredMethod("access$802", WSHeader.class, byte[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = WSHeader.class.getDeclaredMethod("access$702", WSHeader.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = WSHeader.class.getDeclaredMethod("access$1202", WSHeader.class, Boolean.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = WSHeader.class.getDeclaredMethod("access$900", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WSHeader.class.getDeclaredMethod("access$800", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WSHeader.class.getDeclaredMethod("access$700", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSHeader.class.getDeclaredMethod("access$600", WSHeader.class, SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSHeader.class.getDeclaredMethod("access$300", WSHeader.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSHeader.class.getDeclaredMethod("write", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSHeader.class.getDeclaredMethod("readRemainingHeaderBytes", SocketChannel.class, ByteBuffer.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSHeader.class.getDeclaredMethod("read", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }

    private static class WSHandshakeHelper {
        private final byte[] MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.UTF_8);
        private final int SWITCHING_PROTOCOLS = 101;
        private final Pattern PAT_STATUS_LINE = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
        private final Pattern PAT_HEADER = Pattern.compile("([^:]+):\\s*(.*)");
        private final String uri;
        private final String queryParam;
        private final String host;
        private final int port;
        private final String key;
        private final String httpBasicAuthKey;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;

        WSHandshakeHelper(String uri, String queryParam, String host, int port, String authUser, String authPwd) {
            this.uri = uri;
            this.queryParam = queryParam;
            this.host = host;
            this.port = port;
            this.key = this.genRandomKey();
            this.httpBasicAuthKey = authUser != null && authPwd != null ? this.getHTTPAuthHeader(authUser, authPwd) : null;
        }

        void sendHandshakeData(SocketChannel socketChannel) throws IOException {
            ByteBuffer handShakeRequestBuffer = ByteBuffer.wrap(this.generateUpgradeRequest().getBytes(StandardCharsets.ISO_8859_1));
            while (handShakeRequestBuffer.hasRemaining()) {
                socketChannel.write(handShakeRequestBuffer);
            }
        }

        void receiveHandshakeResponse(SocketChannel socketChannel) throws IOException {
            ByteBuffer resBuffer = ByteBuffer.allocate(1024);
            socketChannel.read(resBuffer);
            resBuffer.flip();
            String response = new String(resBuffer.array(), resBuffer.arrayOffset(), resBuffer.limit(), StandardCharsets.ISO_8859_1);
            BufferedReader responseReader = new BufferedReader(new StringReader(response));
            String currentLine = responseReader.readLine();
            this.validateStatus(currentLine);
            Properties responseHeaders = new Properties();
            currentLine = responseReader.readLine();
            while (currentLine != null && currentLine.trim().length() > 0) {
                this.parseHeader(currentLine, responseHeaders);
                currentLine = responseReader.readLine();
            }
            this.validateResponseHeaders(responseHeaders);
        }

        private String generateUpgradeRequest() {
            StringBuilder request = new StringBuilder();
            request.append("GET ");
            if (this.uri != null && this.uri.length() > 0) {
                if (!this.uri.startsWith("/")) {
                    request.append("/");
                }
                request.append(this.uri);
            } else {
                request.append("/");
            }
            if (this.queryParam != null && this.queryParam.length() != 0) {
                request.append("?").append(this.queryParam);
            }
            request.append(" HTTP/1.1\r\n");
            request.append("Host: ").append(this.host);
            if (this.port > 0) {
                request.append(':').append(this.port);
            }
            request.append("\r\n");
            request.append("Upgrade: websocket\r\n");
            request.append("Connection: Upgrade\r\n");
            request.append("Sec-WebSocket-Key: ").append(this.key).append("\r\n");
            request.append("Sec-WebSocket-Version: 13\r\n");
            request.append("Sec-WebSocket-Protocol: sqlnet\r\n");
            if (this.httpBasicAuthKey != null) {
                request.append("Authorization: " + this.httpBasicAuthKey + "\r\n");
            }
            request.append("Pragma: no-cache\r\n");
            request.append("Cache-Control: no-cache\r\n");
            request.append("\r\n");
            return request.toString();
        }

        private void validateStatus(String statusLine) throws IOException {
            Matcher matcher = this.PAT_STATUS_LINE.matcher(statusLine);
            if (!matcher.matches()) {
                throw new IOException("WebSocket: Unexpected HTTP response status line [" + statusLine + "]");
            }
            int statusCode = Integer.parseInt(matcher.group(1));
            String statusReason = matcher.group(2);
            if (statusCode != 101) {
                throw new IOException("WebSocket: Unable to upgrade to websocket protocol [" + statusCode + " : " + statusReason + "]");
            }
        }

        private void validateResponseHeaders(Properties responseHeaders) throws IOException {
            byte[] responseHash;
            String connection = responseHeaders.getProperty("Connection");
            if (!"upgrade".equalsIgnoreCase(connection)) {
                throw new IOException("WebSocket: value of the header Connection is  " + connection + " (expected 'upgrade')");
            }
            String upgrade = responseHeaders.getProperty("Upgrade");
            if (!"websocket".equalsIgnoreCase(upgrade)) {
                throw new IOException("WebSocket: value of the header Upgrade is  " + connection + " (expected 'websocket')");
            }
            String respHashStr = responseHeaders.getProperty("Sec-WebSocket-Accept");
            byte[] byArray = responseHash = respHashStr == null ? null : respHashStr.getBytes(StandardCharsets.ISO_8859_1);
            if (responseHash == null || responseHash.length < 20) {
                throw new IOException("Invalid Sec-WebSocket-Accept hash");
            }
            byte[] expectedHash = this.expectedAcceptHash(this.key);
            for (int i2 = 0; i2 < 20; ++i2) {
                if (responseHash[i2] == expectedHash[i2]) continue;
                throw new IOException("Sec-WebSocket-Accept hash does not match");
            }
        }

        private String getHTTPAuthHeader(String user, String pwd) {
            String auth = user + ":" + pwd;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.ISO_8859_1));
            String authHeader = "Basic " + new String(encodedAuth, StandardCharsets.ISO_8859_1);
            return authHeader;
        }

        private void parseHeader(String headerLine, Properties headerProperties) {
            Matcher matcher = this.PAT_HEADER.matcher(headerLine);
            if (matcher.matches()) {
                headerProperties.setProperty(matcher.group(1), matcher.group(2));
            }
        }

        private final String genRandomKey() {
            byte[] bytes = new byte[16];
            ThreadLocalRandom.current().nextBytes(bytes);
            return Base64.getEncoder().encodeToString(bytes);
        }

        private final byte[] expectedAcceptHash(String requestKey) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                md.update(this.key.getBytes(StandardCharsets.UTF_8));
                md.update(this.MAGIC);
                return Base64.getEncoder().encode(md.digest());
            }
            catch (NoSuchAlgorithmException e2) {
                throw new RuntimeException(e2);
            }
        }

        static {
            try {
                $$$methodRef$$$9 = WSHandshakeHelper.class.getDeclaredConstructor(String.class, String.class, String.class, Integer.TYPE, String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = WSHandshakeHelper.class.getDeclaredMethod("expectedAcceptHash", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = WSHandshakeHelper.class.getDeclaredMethod("genRandomKey", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = WSHandshakeHelper.class.getDeclaredMethod("parseHeader", String.class, Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = WSHandshakeHelper.class.getDeclaredMethod("getHTTPAuthHeader", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = WSHandshakeHelper.class.getDeclaredMethod("validateResponseHeaders", Properties.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = WSHandshakeHelper.class.getDeclaredMethod("validateStatus", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = WSHandshakeHelper.class.getDeclaredMethod("generateUpgradeRequest", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = WSHandshakeHelper.class.getDeclaredMethod("receiveHandshakeResponse", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = WSHandshakeHelper.class.getDeclaredMethod("sendHandshakeData", SocketChannel.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

