/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NLParamParser;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.resolver.NamingAdapterInterface;
import oracle.net.resolver.TNSFile;

public class TNSNamesNamingAdapter
implements NamingAdapterInterface {
    private String tnsDir;
    private long nextPollTime;
    private ArrayList<TNSFile> tnsFiles;
    private static final String TNSFILE = "tnsnames.ora";
    private static final long REFRESH_INTERVAL = 0L;
    private static final int MAX_DEPTH = 5;
    private static final Pattern regexp;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public TNSNamesNamingAdapter(String tnsAdmin) {
        this.tnsDir = tnsAdmin;
        this.resetAttr();
    }

    private void resetAttr() {
        this.tnsFiles = new ArrayList(3);
        this.nextPollTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String resolve(String connId) throws NetException {
        NVPair nvp = null;
        TNSNamesNamingAdapter tNSNamesNamingAdapter = this;
        synchronized (tNSNamesNamingAdapter) {
            TNSFile tnsFile;
            this.checkAndReload();
            Iterator<TNSFile> iterator = this.tnsFiles.iterator();
            while (iterator.hasNext() && (nvp = (tnsFile = iterator.next()).getEntries().getNLPListElement(connId)) == null) {
            }
        }
        if (nvp == null) {
            throw new NetException(122, "\"" + connId + "\"");
        }
        return nvp.valueToString();
    }

    private void loadFiles() throws NetException {
        File f2 = new File(this.tnsDir, TNSFILE);
        String filename = f2.getAbsolutePath();
        this.loadFiles(filename, 0);
    }

    private void loadFiles(String filename, int depth) throws NetException {
        if (depth >= 5) {
            return;
        }
        File f2 = new File(filename);
        if (!f2.isFile() || !f2.canRead()) {
            return;
        }
        try {
            NLParamParser tnsEntriesHdl = new NLParamParser(filename, 1);
            this.tnsFiles.add(new TNSFile(filename, f2.lastModified(), tnsEntriesHdl));
            NVPair nvpIFile = tnsEntriesHdl.getNLPListElement("ifile");
            if (nvpIFile != null) {
                ArrayList<String> iFiles = this.getIFile(filename);
                for (String iFile : iFiles) {
                    this.loadFiles(iFile, depth + 1);
                }
            }
        }
        catch (IOException ioex) {
            return;
        }
        catch (NLException nLException) {
            // empty catch block
        }
    }

    private ArrayList<String> getIFile(String filename) throws IOException {
        FileReader fr = new FileReader(filename);
        BufferedReader br = new BufferedReader(fr);
        Matcher pmatch = regexp.matcher("");
        ArrayList<String> iFiles = new ArrayList<String>(2);
        String currentLine = null;
        while ((currentLine = br.readLine()) != null) {
            pmatch.reset(currentLine);
            if (!pmatch.find()) continue;
            String iFile = pmatch.group(2);
            File f2 = new File(iFile = iFile.trim());
            if (!f2.isAbsolute()) {
                f2 = new File(this.tnsDir, iFile);
                iFile = f2.getAbsolutePath();
            }
            iFiles.add(iFile);
        }
        return iFiles;
    }

    private void checkAndReload() throws NetException {
        long currTime = System.currentTimeMillis();
        if (currTime > this.nextPollTime) {
            this.nextPollTime = currTime + 0L;
            this.reloadFiles();
        }
    }

    private void reloadFiles() throws NetException {
        if (this.tnsFiles.isEmpty()) {
            this.loadFiles();
        } else {
            for (TNSFile tnsFile : this.tnsFiles) {
                long modifiedTime = tnsFile.getLastModifiedTime();
                String fileName = tnsFile.getFileName();
                File f2 = new File(fileName);
                if (f2.isFile() && f2.canRead() && f2.lastModified() == modifiedTime) continue;
                this.resetAttr();
                this.loadFiles();
                break;
            }
        }
    }

    static {
        try {
            $$$methodRef$$$7 = TNSNamesNamingAdapter.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TNSNamesNamingAdapter.class.getDeclaredMethod("reloadFiles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TNSNamesNamingAdapter.class.getDeclaredMethod("checkAndReload", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TNSNamesNamingAdapter.class.getDeclaredMethod("getIFile", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TNSNamesNamingAdapter.class.getDeclaredMethod("loadFiles", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TNSNamesNamingAdapter.class.getDeclaredMethod("loadFiles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TNSNamesNamingAdapter.class.getDeclaredMethod("resolve", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TNSNamesNamingAdapter.class.getDeclaredMethod("resetAttr", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        regexp = Pattern.compile("^(IFILE\\s*=\\s*)(.*)", 2);
    }
}

