/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleTimestamp;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class TIMESTAMP
extends Datum
implements Serializable,
OracleTimestamp {
    static final int CENTURY_DEFAULT = 119;
    static final int DECADE_DEFAULT = 100;
    static final int MONTH_DEFAULT = 1;
    static final int DAY_DEFAULT = 1;
    static final int DECADE_INIT = 170;
    static final int JAVA_YEAR = 1970;
    static final int JAVA_MONTH = 0;
    static final int JAVA_DATE = 1;
    public static final int SIZE_DATE = 7;
    public static final int SIZE_TIMESTAMP = 11;
    public static final int SIZE_TIMESTAMP_NOFRAC = 7;
    static final int SIZE_TIMESTAMPTZ = 13;
    static final int MINYEAR = -4712;
    static final int MAXYEAR = 9999;
    static final int JANMONTH = 1;
    static final int DECMONTH = 12;
    static final int MINDAYS = 1;
    static final int MAXDAYS = 31;
    static final int MINHOURS = 1;
    static final int MAXHOURS = 24;
    static final int MINMINUTES = 1;
    static final int MAXMINUTES = 60;
    static final int MINSECONDS = 1;
    static final int MAXSECONDS = 60;
    static final int[] daysInMonth;
    static final long serialVersionUID = -7964732752952728545L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$28, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$28, null);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$28, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(byte[] timestamp) {
        super(timestamp);
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$29, null, new Object[]{timestamp});
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$29, null);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$29, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$29, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null, time);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$30, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$31, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(TIMESTAMP.toBytes(timestamp));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null, timestamp);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$32, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(Timestamp timestamp, Calendar cal) {
        super(TIMESTAMP.toBytes(timestamp, cal));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null, timestamp, cal);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$33, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(DATE date) {
        super(TIMESTAMP.toBytes(date));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null, date);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$34, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int getNanos(byte[] byArray, int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void off;
            byte[] buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, byArray, n2);
            }
            int nanos = (buffer[off] & 0xFF) << 24;
            nanos |= (buffer[off + true] & 0xFF) << 16;
            nanos |= (buffer[off + 2] & 0xFF) << 8;
            int n3 = nanos |= buffer[off + 3] & 0xFF & 0xFF;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, n3);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public TIMESTAMP(String str) {
        super(TIMESTAMP.toBytes(str));
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null, str);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$35, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Date toDate(byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] timestamp;
            int arrlength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, new Object[]{byArray});
            }
            int[] result = (arrlength = timestamp.length) == 11 ? new int[11] : new int[7];
            for (int i2 = 0; i2 < timestamp.length; ++i2) {
                result[i2] = timestamp[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar cal = Calendar.getInstance();
            cal.set(1, year);
            cal.set(2, result[2] - 1);
            cal.set(5, result[3]);
            cal.set(11, result[4] - 1);
            cal.set(12, result[5] - 1);
            cal.set(13, result[6] - 1);
            int tsmillis = 0;
            if (arrlength == 11) {
                tsmillis = TIMESTAMP.getNanos(timestamp, 7) / 1000000;
            }
            cal.set(14, tsmillis);
            long millis = cal.getTimeInMillis();
            Date date = new Date(millis);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, date);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Time toTime(byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] timestamp;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, new Object[]{byArray});
            }
            int hour = timestamp[4] & 0xFF;
            int minute = timestamp[5] & 0xFF;
            int second = timestamp[6] & 0xFF;
            Calendar cal = Calendar.getInstance();
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, hour - 1);
            cal.set(12, minute - 1);
            cal.set(13, second - 1);
            cal.set(14, 0);
            Time time = new Time(cal.getTime().getTime());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, time);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    public static Timestamp toTimestamp(byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] timestamp;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, new Object[]{byArray});
            }
            Timestamp timestamp2 = TIMESTAMP.toTimestamp(timestamp, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, timestamp2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, null);
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Timestamp toTimestamp(byte[] byArray, Calendar calendar) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            byte[] timestamp;
            int arrlength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, byArray, calendar);
            }
            int[] result = (arrlength = timestamp.length) == 11 ? new int[11] : new int[7];
            for (int i2 = 0; i2 < timestamp.length; ++i2) {
                result[i2] = timestamp[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.clear();
            cal1.set(1, year);
            cal1.set(2, result[2] - 1);
            cal1.set(5, result[3]);
            cal1.set(11, result[4] - 1);
            cal1.set(12, result[5] - 1);
            cal1.set(13, result[6] - 1);
            cal1.set(14, 0);
            long millis = cal1.getTime().getTime();
            Timestamp ts = new Timestamp(millis);
            int nanos = 0;
            if (arrlength == 11) {
                nanos = TIMESTAMP.getNanos(timestamp, 7);
            }
            ts.setNanos(nanos);
            Timestamp timestamp2 = ts;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, timestamp2);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, null);
            }
            return timestamp2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    public static DATE toDATE(byte[] byArray) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] timestamp;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, new Object[]{byArray});
            }
            byte[] date = new byte[7];
            System.arraycopy(timestamp, 0, date, 0, 7);
            DATE dATE = new DATE(date);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, dATE);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, new Object[0]);
            }
            Timestamp timestamp = TIMESTAMP.toTimestamp(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Timestamp timestampValue(Calendar calendar) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, calendar);
            }
            Timestamp timestamp = TIMESTAMP.toTimestamp(this.getBytes(), (Calendar)cal);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public static String toString(byte[] bytes) {
        int[] result = new int[bytes.length];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            result[i2] = bytes[i2] < 0 ? bytes[i2] + 256 : bytes[i2];
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        int month = result[2];
        int day = result[3];
        int hours = result[4] - 1;
        int minutes = result[5] - 1;
        int seconds = result[6] - 1;
        int nanos = 0;
        if (bytes.length > 7) {
            nanos = TIMESTAMP.getNanos(bytes, 7);
        }
        return TIMESTAMPTZ.toString(year, month, day, hours, minutes, seconds, nanos, null);
    }

    @Override
    public byte[] toBytes() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, new Object[0]);
            }
            byte[] byArray = this.getBytes();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Time time) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Time time2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, time);
            }
            if (time2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, null);
                }
                return null;
            }
            byte[] result = new byte[7];
            Calendar cal = Calendar.getInstance();
            cal.setTime(time2);
            result[0] = 119;
            result[1] = -86;
            result[2] = 1;
            result[3] = 1;
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Date date) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Date date2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, date);
            }
            if (date2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, null);
                }
                return null;
            }
            byte[] result = new byte[7];
            Calendar cal = Calendar.getInstance();
            cal.setTime(date2);
            int year = TIMESTAMP.getOracleYear(cal);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal.get(2) + 1);
            result[3] = (byte)cal.get(5);
            if (!OracleDriver.getSystemPropertyDateZeroTime()) {
                result[4] = (byte)(cal.get(11) + 1);
                result[5] = (byte)(cal.get(12) + 1);
                result[6] = (byte)(cal.get(13) + 1);
            } else {
                result[4] = 1;
                result[5] = 1;
                result[6] = 1;
            }
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$10, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(Timestamp timestamp) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Timestamp timestamp2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, timestamp);
            }
            byte[] byArray = TIMESTAMP.toBytes(timestamp2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cal;
            Timestamp timestamp2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, timestamp, calendar);
            }
            if (timestamp2 == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, null);
                }
                return null;
            }
            int nanos = timestamp2.getNanos();
            byte[] result = nanos == 0 ? new byte[7] : new byte[11];
            Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
            cal1.setTime(timestamp2);
            int year = TIMESTAMP.getOracleYear(cal1);
            result[0] = (byte)(year / 100 + 100);
            result[1] = (byte)(year % 100 + 100);
            result[2] = (byte)(cal1.get(2) + 1);
            result[3] = (byte)cal1.get(5);
            result[4] = (byte)(cal1.get(11) + 1);
            result[5] = (byte)(cal1.get(12) + 1);
            result[6] = (byte)(cal1.get(13) + 1);
            if (nanos != 0) {
                result[7] = (byte)(nanos >> 24);
                result[8] = (byte)(nanos >> 16 & 0xFF);
                result[9] = (byte)(nanos >> 8 & 0xFF);
                result[10] = (byte)(nanos & 0xFF);
            }
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(DATE dATE) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            DATE date;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, dATE);
            }
            if (date == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, byArray);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, null);
                }
                return null;
            }
            byte[] result = new byte[7];
            System.arraycopy(date.getBytes(), 0, result, 0, 7);
            byte[] byArray = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$13, null, throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] toBytes(String string) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            String str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, string);
            }
            byte[] byArray = TIMESTAMP.toBytes(Timestamp.valueOf(str));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, new Object[0]);
            }
            Timestamp timestamp = this.timestampValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object makeJdbcArray(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void arraySize;
            Timestamp[] ts;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, n2);
            }
            Timestamp[] timestampArray = ts = new Timestamp[arraySize];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, timestampArray);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, null);
            }
            return ts;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isConvertibleTo(Class clazz) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void cls;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, clazz);
            }
            if (cls.getName().compareTo("java.sql.Date") == 0 || cls.getName().compareTo("java.sql.Time") == 0 || cls.getName().compareTo("java.sql.Timestamp") == 0 || cls.getName().compareTo("java.lang.String") == 0) {
                boolean bl2 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, null);
                }
                return true;
            }
            boolean bl3 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, bl3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static TIMESTAMP TimeZoneConvert(Connection connection, TIMESTAMP tIMESTAMP, TimeZone timeZone, TimeZone timeZone2) throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void tz2;
            void tz1;
            void tstamp;
            byte[] timestamp;
            int arrlength;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, connection, tIMESTAMP, timeZone, timeZone2);
            }
            int[] result = (arrlength = (timestamp = tstamp.getBytes()).length) == 11 ? new int[11] : new int[7];
            for (int i2 = 0; i2 < arrlength; ++i2) {
                result[i2] = timestamp[i2] & 0xFF;
            }
            int year = TIMESTAMP.getJavaYear(result[0], result[1]);
            int month = result[2] - 1;
            int day = result[3];
            int hours = result[4] - 1;
            int minutes = result[5] - 1;
            int seconds = result[6] - 1;
            Calendar cal1 = Calendar.getInstance((TimeZone)tz1);
            cal1.set(1, year);
            cal1.set(2, month);
            cal1.set(5, day);
            cal1.set(11, hours);
            cal1.set(12, minutes);
            cal1.set(13, seconds);
            cal1.set(14, 0);
            long millis = cal1.getTimeInMillis();
            Timestamp ts = new Timestamp(millis);
            int nanos = 0;
            if (arrlength == 11) {
                nanos = TIMESTAMP.getNanos(timestamp, 7);
            }
            ts.setNanos(nanos);
            Calendar cal2 = Calendar.getInstance((TimeZone)tz2);
            TIMESTAMP tIMESTAMP2 = new TIMESTAMP(ts, cal2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, tIMESTAMP2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, null);
            }
            return tIMESTAMP2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String stringValue() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, new Object[0]);
            }
            String string = TIMESTAMP.toString(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, string);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    @DisableTrace
    public String toString() {
        return this.stringValue();
    }

    public static int getOracleYear(Calendar calendar) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            Calendar cal;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, calendar);
            }
            int year = cal.get(1);
            if (cal.get(0) == 0) {
                year = -year;
            }
            if (year < -4712 || year > 9999) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid year value");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, illegalArgumentException);
                }
                throw illegalArgumentException;
            }
            int n2 = year;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, n2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Date dateValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, new Object[0]);
            }
            Date date = TIMESTAMP.toDate(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, date);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Time timeValue() throws SQLException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, new Object[0]);
            }
            Time time = TIMESTAMP.toTime(this.getBytes());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, time);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int getJavaYear(int n2, int n3) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void decade;
            int cent;
            int year;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, n2, n3);
            }
            if ((year = (cent - 100) * 100 + (decade - 100)) < 0) {
                ++year;
            }
            int n4 = year;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, n4);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$23, null, throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] initTimestamp() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, new Object[0]);
            }
            byte[] tmp = new byte[11];
            tmp[0] = 119;
            tmp[1] = -86;
            tmp[2] = 1;
            tmp[3] = 1;
            tmp[4] = 1;
            tmp[5] = 1;
            tmp[6] = 1;
            byte[] byArray = tmp;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, null);
            }
            return tmp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isLeapYear(int n2) {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            void y2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, n2);
            }
            boolean bl3 = y2 % 4 == false && (y2 <= 1582 ? y2 != -4712 : y2 % 100 != false || y2 % 400 == false) ? true : (bl2 = false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    private boolean isValid() {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] ts;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, new Object[0]);
            }
            if ((ts = this.getBytes()).length != 11 && ts.length != 7) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            int year = ((ts[0] & 0xFF) - 100) * 100 + ((ts[1] & 0xFF) - 100);
            if (year < -4712 || year > 9999) {
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            if (year == 0) {
                boolean bl4 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl4);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            int month = ts[2] & 0xFF;
            if (month < 1 || month > 12) {
                boolean bl5 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl5);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            int day = ts[3] & 0xFF;
            if (day < 1 || day > 31) {
                boolean bl6 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl6);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            if (!(day <= daysInMonth[month - 1] || this.isLeapYear(year) && month == 2 && day == 29)) {
                boolean bl7 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl7);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            if (year == 1582 && month == 10 && day >= 5 && day < 15) {
                boolean bl8 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl8);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            int hour = ts[4] & 0xFF;
            if (hour < 1 || hour > 24) {
                boolean bl9 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl9);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            int minutes = ts[5] & 0xFF;
            if (minutes < 1 || minutes > 60) {
                boolean bl10 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl10);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            int seconds = ts[6] & 0xFF;
            if (seconds < 1 || seconds > 60) {
                boolean bl11 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl11);
                    ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
                }
                return false;
            }
            boolean bl12 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, bl12);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = (0x800000000L & TraceControllerImpl.feature) != 0L;
        try {
            void in;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$27, this, objectInputStream);
            }
            in.defaultReadObject();
            if (!this.isValid()) {
                IOException iOException = new IOException("Invalid TIMESTAMP");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$27, this, iOException);
                }
                throw iOException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, TIMESTAMP.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$35 = TIMESTAMP.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = TIMESTAMP.class.getDeclaredConstructor(DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = TIMESTAMP.class.getDeclaredConstructor(Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = TIMESTAMP.class.getDeclaredConstructor(Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = TIMESTAMP.class.getDeclaredConstructor(Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = TIMESTAMP.class.getDeclaredConstructor(Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = TIMESTAMP.class.getDeclaredConstructor(byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = TIMESTAMP.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = TIMESTAMP.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = TIMESTAMP.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = TIMESTAMP.class.getDeclaredMethod("isLeapYear", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = TIMESTAMP.class.getDeclaredMethod("initTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = TIMESTAMP.class.getDeclaredMethod("getJavaYear", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = TIMESTAMP.class.getDeclaredMethod("timeValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = TIMESTAMP.class.getDeclaredMethod("dateValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = TIMESTAMP.class.getDeclaredMethod("getOracleYear", Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = TIMESTAMP.class.getDeclaredMethod("stringValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = TIMESTAMP.class.getDeclaredMethod("TimeZoneConvert", Connection.class, TIMESTAMP.class, TimeZone.class, TimeZone.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = TIMESTAMP.class.getDeclaredMethod("isConvertibleTo", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = TIMESTAMP.class.getDeclaredMethod("makeJdbcArray", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = TIMESTAMP.class.getDeclaredMethod("toJdbc", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = TIMESTAMP.class.getDeclaredMethod("toBytes", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = TIMESTAMP.class.getDeclaredMethod("toBytes", DATE.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = TIMESTAMP.class.getDeclaredMethod("toBytes", Timestamp.class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = TIMESTAMP.class.getDeclaredMethod("toBytes", Timestamp.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = TIMESTAMP.class.getDeclaredMethod("toBytes", Date.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = TIMESTAMP.class.getDeclaredMethod("toBytes", Time.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = TIMESTAMP.class.getDeclaredMethod("toBytes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = TIMESTAMP.class.getDeclaredMethod("timestampValue", Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = TIMESTAMP.class.getDeclaredMethod("timestampValue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = TIMESTAMP.class.getDeclaredMethod("toDATE", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = TIMESTAMP.class.getDeclaredMethod("toTimestamp", byte[].class, Calendar.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = TIMESTAMP.class.getDeclaredMethod("toTimestamp", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = TIMESTAMP.class.getDeclaredMethod("toTime", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = TIMESTAMP.class.getDeclaredMethod("toDate", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = TIMESTAMP.class.getDeclaredMethod("getNanos", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    }
}

