/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ShortBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AggregateByteArray;
import oracle.jdbc.driver.BfileAccessor;
import oracle.jdbc.driver.BinaryDoubleAccessor;
import oracle.jdbc.driver.BinaryFloatAccessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.BlobAccessor;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.ClobAccessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateAccessor;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.IntervaldsAccessor;
import oracle.jdbc.driver.IntervalymAccessor;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.NamedTypeAccessor;
import oracle.jdbc.driver.NumberAccessor;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OutRawAccessor;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.driver.RawAccessor;
import oracle.jdbc.driver.RefTypeAccessor;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.RowidAccessor;
import oracle.jdbc.driver.T2CCharByteArray;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CLongAccessor;
import oracle.jdbc.driver.T2CLongRawAccessor;
import oracle.jdbc.driver.T2CPlsqlIndexTableAccessor;
import oracle.jdbc.driver.T2CResultSetAccessor;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.driver.T2CVarcharAccessor;
import oracle.jdbc.driver.TimestampAccessor;
import oracle.jdbc.driver.TimestampltzAccessor;
import oracle.jdbc.driver.TimestamptzAccessor;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CPreparedStatement
extends OraclePreparedStatement {
    T2CConnection t2cConnection;
    int userResultSetType;
    int userResultSetConcur;
    static int T2C_EXTEND_BUFFER;
    long[] t2cOutput;
    long[] t2cOutputUpdateCountArray;
    int[] t2cOutputUpdateCountArraySize;
    static final int T2C_OUTPUT_USE_NIO = 5;
    static final int T2C_OUTPUT_STMT_LOB_PREFETCH_SIZE = 6;
    static final int T2C_OUTPUT_USE_OCI_DEFAULT_DEFINE_OFFSET = 7;
    static final boolean T2CDEBUG = false;
    int extractedCharOffset;
    int extractedByteOffset;
    int savedRowPrefetch;
    int OCIPrefetch;
    static final byte T2C_LOB_PREFETCH_SIZE_THIS_COLUMN_OFFSET = 0;
    static final byte T2C_LOB_PREFETCH_LOB_LENGTH_OFFSET = 1;
    static final byte T2C_LOB_PREFETCH_FORM_OFFSET = 2;
    static final byte T2C_LOB_PREFETCH_CHUNK_OFFSET = 3;
    static final byte T2C_LOB_PREFETCH_DATA_OFFSET = 4;
    byte[] lobPrefetchTempBytes;
    boolean needToRetainRows;
    byte[] returnParamBytes;
    char[] returnParamChars;
    short[] returnParamIndicators;
    int returnParamRowBytes;
    int returnParamRowChars;
    static int PREAMBLE_PER_POSITION;
    SQLException updateDataException;
    int lastProcessedCell;
    static final int PROCESS_DEFINE_DYNAMIC_COLUMNS = 16;
    static final int PROCESS_DEFINE_DEFAULT_COLUMNS = 32;
    static final int PROCESS_ADT_OUT_BINDS = 64;
    int lastProcessedAccessorIndex;
    int accessorsProcessed;
    int previousMode;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;

    T2CPreparedStatement(T2CConnection conn, String sqlText, int batchValue, int rowPrefetchValue, int UserResultSetType, int UserResultSetConcur) throws SQLException {
        super(conn, sqlText, batchValue, rowPrefetchValue, UserResultSetType, UserResultSetConcur);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$50, null, conn, sqlText, batchValue, rowPrefetchValue, UserResultSetType, UserResultSetConcur);
            }
            this.t2cConnection = null;
            this.userResultSetType = -1;
            this.userResultSetConcur = -1;
            this.t2cOutput = new long[10];
            this.t2cOutputUpdateCountArray = null;
            this.t2cOutputUpdateCountArraySize = new int[1];
            this.savedRowPrefetch = 0;
            this.OCIPrefetch = 1;
            this.needToRetainRows = false;
            this.updateDataException = null;
            this.lastProcessedCell = 0;
            this.lastProcessedAccessorIndex = 0;
            this.accessorsProcessed = 0;
            this.previousMode = 0;
            this.userResultSetType = UserResultSetType;
            this.userResultSetConcur = UserResultSetConcur;
            this.t2cConnection = conn;
            if (this.t2cConnection.useOCIDefaultDefines) {
                this.savedRowPrefetch = this.rowPrefetch;
                this.OCIPrefetch = this.rowPrefetch;
                this.rowPrefetch = 1;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$50, null);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    T2CPreparedStatement(T2CConnection conn, String sqlText, Properties stmtProps) throws SQLException {
        super((PhysicalConnection)conn, sqlText, stmtProps);
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$51, null, conn, sqlText, stmtProps);
            }
            this.t2cConnection = null;
            this.userResultSetType = -1;
            this.userResultSetConcur = -1;
            this.t2cOutput = new long[10];
            this.t2cOutputUpdateCountArray = null;
            this.t2cOutputUpdateCountArraySize = new int[1];
            this.savedRowPrefetch = 0;
            this.OCIPrefetch = 1;
            this.needToRetainRows = false;
            this.updateDataException = null;
            this.lastProcessedCell = 0;
            this.lastProcessedAccessorIndex = 0;
            this.accessorsProcessed = 0;
            this.previousMode = 0;
            if (stmtProps != null) {
                String tProp = stmtProps.getProperty("result_set_type");
                if (tProp != null) {
                    this.userResultSetType = Integer.parseInt(tProp);
                }
                if ((tProp = stmtProps.getProperty("result_set_concurrency")) != null) {
                    this.userResultSetConcur = Integer.parseInt(tProp);
                }
            }
            this.t2cConnection = conn;
            if (this.t2cConnection.useOCIDefaultDefines) {
                this.savedRowPrefetch = this.rowPrefetch;
                this.OCIPrefetch = this.rowPrefetch;
                this.rowPrefetch = 1;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$51, null);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$51, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getPrefetchInternal(boolean bl) {
        boolean bl2 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            int ret_val;
            void statement;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$0, this, bl);
            }
            if (!this.t2cConnection.useOCIDefaultDefines) {
                int n2 = super.getPrefetchInternal((boolean)statement);
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$0, this, n2);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$0, this, null);
                }
                return n2;
            }
            int n3 = ret_val = statement != false ? this.defaultRowPrefetch : this.savedRowPrefetch;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$0, this, n3);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$0, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setPrefetchInternal(int n2, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void statement;
            void setRowPrefetch;
            void new_value;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$1, this, n2, bl, bl2);
            }
            int localRowPrefetch = this.rowPrefetch;
            super.setPrefetchInternal((int)new_value, (boolean)setRowPrefetch, (boolean)statement);
            if (this.t2cConnection.useOCIDefaultDefines && localRowPrefetch != this.rowPrefetch) {
                this.savedRowPrefetch = this.rowPrefetch;
                this.OCIPrefetch = this.rowPrefetch;
                this.rowPrefetch = 1;
            }
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void prepareForNewResults(boolean bl, boolean bl2, boolean bl3) throws SQLException {
        boolean bl4 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void clearImplicitResults;
            void clearStreamList;
            void resetPrefetch;
            if (bl4) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$2, this, bl, bl2, bl3);
            }
            super.prepareForNewResults((boolean)resetPrefetch, (boolean)clearStreamList, (boolean)clearImplicitResults);
            if (this.t2cConnection.useOCIDefaultDefines && this.rowPrefetchChanged) {
                this.savedRowPrefetch = this.rowPrefetch;
                this.OCIPrefetch = this.rowPrefetch;
                this.rowPrefetch = 1;
            }
            if (bl4) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl4) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void prepareAccessors() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$3, this, new Object[0]);
            }
            super.prepareAccessors();
            if (this.rowPrefetchChanged) {
                this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
            }
            if (this.t2cConnection.useOCIDefaultDefines && this.hasStream) {
                this.savedRowPrefetch = 1;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String bytes2String(byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void offset;
            void bytes;
            void size;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$4, this, byArray, n2, n3);
            }
            byte[] tmp = new byte[size];
            System.arraycopy(bytes, (int)offset, tmp, 0, (int)size);
            String string = this.connection.conversion.CharBytesToString(tmp, (int)size);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$4, this, string);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$4, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    void processDescribeData() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$5, this, new Object[0]);
            }
            this.described = true;
            this.describedWithNames = true;
            if (this.numberOfDefinePositions < 1) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$5, this);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$5, this, null);
                }
                return;
            }
            if (this.accessors == null || this.numberOfDefinePositions > this.accessors.length) {
                this.accessors = new Accessor[this.numberOfDefinePositions];
            }
            int currentShort = this.t2cConnection.queryMetaData1Offset;
            int currentChar = this.t2cConnection.queryMetaData2Offset;
            short[] s2 = this.t2cConnection.queryMetaData1;
            byte[] c2 = this.t2cConnection.queryMetaData2;
            int i2 = 0;
            while (i2 < this.numberOfDefinePositions) {
                Accessor accessor;
                short accessorType = s2[currentShort + 0];
                short maxLength = s2[currentShort + 1];
                short maxCharLength = s2[currentShort + 11];
                boolean nullable = s2[currentShort + 2] != 0;
                short precision = s2[currentShort + 3];
                short scale = s2[currentShort + 4];
                int flags = 0;
                long contflag = 0L;
                int totalElems = 0;
                short formOfUse = s2[currentShort + 5];
                short columnNameLen = s2[currentShort + 6];
                String columnName = this.bytes2String(c2, currentChar, columnNameLen);
                short schemaNameLen = s2[currentShort + 12];
                short typeNameLen = s2[currentShort + 13];
                boolean columnInvisible = s2[currentShort + 14] != 0;
                boolean columnJSON = s2[currentShort + 15] != 0;
                String schemaName = null;
                String typeName = null;
                OracleTypeADT otype = null;
                currentChar += columnNameLen;
                if (typeNameLen > 0) {
                    schemaName = this.bytes2String(c2, currentChar, schemaNameLen);
                    typeName = this.bytes2String(c2, currentChar += schemaNameLen, typeNameLen);
                    currentChar += typeNameLen;
                    typeName = PhysicalConnection.needToQuoteIdentifier(schemaName) || PhysicalConnection.needToQuoteIdentifier(typeName) ? String.format("\"%s\".\"%s\"", schemaName, typeName) : schemaName + "." + typeName;
                    otype = new OracleTypeADT(typeName, (Connection)this.connection);
                    otype.tdoCState = ((long)s2[currentShort + 7] & 0xFFFFL) << 48 | ((long)s2[currentShort + 8] & 0xFFFFL) << 32 | ((long)s2[currentShort + 9] & 0xFFFFL) << 16 | (long)s2[currentShort + 10] & 0xFFFFL;
                }
                if ((accessor = this.accessors[i2]) == null || accessor.defineType == 0 || accessor.describeType != 0 && accessor.describeType != accessorType) {
                    accessor = this.allocateAccessorForDefines(i2, accessorType, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, maxCharLength, otype, typeName);
                    if (this.accessors[i2] != null) {
                        accessor.rowLength = this.accessors[i2].rowLength;
                        accessor.rowOffset = this.accessors[i2].rowOffset;
                        accessor.rowNull = this.accessors[i2].rowNull;
                        accessor.rowMetadata = this.accessors[i2].rowMetadata;
                    }
                } else {
                    accessor.initForDescribe(accessorType, maxLength, nullable, flags, precision, scale, contflag, totalElems, formOfUse, typeName);
                }
                accessor.describeOtype = otype;
                accessor.columnName = columnName;
                accessor.columnInvisible = columnInvisible;
                accessor.columnJSON = columnJSON;
                this.accessors[i2] = accessor;
                ++i2;
                currentShort += 16;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Accessor allocateAccessorForDefines(int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, long l2, int n8, short s2, int n9, OracleTypeADT oracleTypeADT, String string) throws SQLException {
        boolean bl2 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            Accessor accessor;
            void accessorType;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$6, this, n2, n3, n4, bl, n5, n6, n7, l2, n8, s2, n9, oracleTypeADT, string);
            }
            switch (accessorType) {
                case 1: {
                    void maxCharLength;
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new VarcharAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse, (int)maxCharLength);
                    break;
                }
                case 96: {
                    void maxCharLength;
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new CharAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse, (int)maxCharLength);
                    break;
                }
                case 2: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new NumberAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 23: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new RawAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 100: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new BinaryFloatAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 101: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new BinaryDoubleAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 8: {
                    void index;
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new T2CLongAccessor(this, (int)(index + true), (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    this.rowPrefetch = 1;
                    this.OCIPrefetch = 1;
                    this.savedRowPrefetch = 1;
                    break;
                }
                case 24: {
                    void index;
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new T2CLongRawAccessor(this, (int)(index + true), (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    this.rowPrefetch = 1;
                    this.savedRowPrefetch = 1;
                    this.OCIPrefetch = 1;
                    break;
                }
                case 104: {
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new RowidAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, 1);
                    break;
                }
                case 102: 
                case 116: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    if (this.sqlKind.isPlsqlOrCall()) {
                        accessor = new T2CResultSetAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                        break;
                    }
                    accessor = new ResultSetAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 12: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new DateAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 180: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new TimestampAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 181: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new TimestamptzAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 231: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new TimestampltzAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 182: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new IntervalymAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 183: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new IntervaldsAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 112: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new ClobAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 113: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new BlobAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 114: {
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new BfileAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse);
                    break;
                }
                case 109: {
                    void otype;
                    void typeName;
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new NamedTypeAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse, (String)typeName, (OracleType)otype);
                    break;
                }
                case 111: {
                    void otype;
                    void typeName;
                    void formOfUse;
                    void totalElems;
                    void contflag;
                    void scale;
                    void precision;
                    void flags;
                    void nullable;
                    void maxLength;
                    accessor = new RefTypeAccessor(this, (int)maxLength, (boolean)nullable, (int)flags, (int)precision, (int)scale, (long)contflag, (int)totalElems, (short)formOfUse, (String)typeName, (OracleType)otype);
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown or unimplemented accessor type: " + (int)accessorType).fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$6, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            Accessor accessor2 = accessor;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$6, this, accessor2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$6, this, null);
            }
            return accessor2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void executeForDescribe() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean try_again;
            int rowsToFetch;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$7, this, new Object[0]);
            }
            this.t2cOutput[0] = 0L;
            this.t2cOutput[2] = 0L;
            this.t2cOutput[7] = this.t2cConnection.useOCIDefaultDefines ? 1 : 0;
            this.lobPrefetchMetaData = null;
            boolean need_to_describe = !this.described;
            boolean executed = false;
            int n2 = rowsToFetch = this.t2cConnection.useOCIDefaultDefines ? this.savedRowPrefetch : this.rowPrefetch;
            if (!$assertionsDisabled && rowsToFetch <= 0) {
                AssertionError assertionError = new AssertionError((Object)("rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")"));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$7, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.validRows = 0L;
            do {
                try_again = false;
                if (this.connection.endToEndAnyChanged) {
                    this.pushEndToEndValues();
                    this.connection.endToEndAnyChanged = false;
                }
                byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
                int status = 0;
                try {
                    this.resetStateBeforeFetch();
                    if (this.sqlObject.getSqlKind().isDML() && this.numberOfBoundRows > 0) {
                        this.t2cOutputUpdateCountArray = new long[this.numberOfBoundRows];
                        this.t2cOutputUpdateCountArraySize[0] = this.numberOfBoundRows;
                    } else {
                        this.t2cOutputUpdateCountArray = null;
                        this.t2cOutputUpdateCountArraySize[0] = 0;
                    }
                    status = T2CStatement.t2cParseExecuteDescribe(this, this.c_state, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, false, this.needToParse, need_to_describe, executed, array_sql, array_sql.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), rowsToFetch, this.OCIPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, this.ibtBindIndicators, this.ibtBindIndicatorOffset, this.ibtBindIndicatorSize, this.ibtBindBytes, this.ibtBindChars, this.ibtBindByteOffset, this.ibtBindCharOffset, this.returnParamMeta, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, this.preparedByteBinds, this.preparedCharBinds, this.accessors, this.binders, this.t2cOutput, this.t2cOutputUpdateCountArray, this.t2cOutputUpdateCountArraySize, this.t2cConnection.plsqlCompilerWarnings);
                }
                catch (IOException iox) {
                    try {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 266).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$7, this, sQLException);
                        }
                        throw sQLException;
                    }
                    catch (Throwable throwable) {
                        if (this.t2cOutputUpdateCountArraySize[0] > 0) {
                            this.batchRowsUpdatedArray = new long[this.t2cOutputUpdateCountArraySize[0]];
                            System.arraycopy(this.t2cOutputUpdateCountArray, 0, this.batchRowsUpdatedArray, 0, this.t2cOutputUpdateCountArraySize[0]);
                        } else if (this.batchRowsUpdatedArray != null) {
                            this.batchRowsUpdatedArray = new long[0];
                        }
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$7, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                if (this.t2cOutputUpdateCountArraySize[0] > 0) {
                    this.batchRowsUpdatedArray = new long[this.t2cOutputUpdateCountArraySize[0]];
                    System.arraycopy(this.t2cOutputUpdateCountArray, 0, this.batchRowsUpdatedArray, 0, this.t2cOutputUpdateCountArraySize[0]);
                } else if (this.batchRowsUpdatedArray != null) {
                    this.batchRowsUpdatedArray = new long[0];
                }
                if (this.bindIndicators != null) {
                    this.setLengthForOutAccessors();
                }
                this.validRows = this.t2cOutput[1];
                if (status == -1 || status == -4) {
                    this.t2cConnection.checkError(status, this.c_state, this.sqlObject);
                } else if (status == T2C_EXTEND_BUFFER) {
                    status = this.t2cConnection.queryMetaData1Size * 2;
                }
                if (this.t2cOutput[3] != 0L) {
                    this.foundPlsqlCompilerWarning();
                } else if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
                }
                this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
                this.needToParse = false;
                executed = true;
                if (this.sqlKind.isSELECT()) {
                    this.numberOfDefinePositions = status;
                    if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size) {
                        try_again = true;
                        executed = true;
                        this.t2cConnection.reallocateQueryMetaData(this.numberOfDefinePositions, this.numberOfDefinePositions * 8);
                    }
                } else {
                    this.numberOfDefinePositions = 0;
                    this.validRows = status;
                }
                if (!this.sqlKind.isPlsqlOrCall()) continue;
                this.checkForImplicitResultSets();
            } while (try_again);
            this.isAllFetched = false;
            this.processDescribeData();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$7, this, throwable3);
            }
            throw throwable;
        }
    }

    void checkForImplicitResultSets() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$8, this, new Object[0]);
            }
            int status = 0;
            status = T2CStatement.t2cGetImplicitResultSetCount(this, this.c_state);
            if (status > 0) {
                int implicitResultSetCount;
                this.implicitResultSetStatements = new ArrayDeque(implicitResultSetCount);
                for (implicitResultSetCount = status; implicitResultSetCount != 0; --implicitResultSetCount) {
                    OracleStatement newstmt = this.connection.createImplicitResultSetStatement(this);
                    ((T2CStatement)newstmt).doDescribe(true);
                    ((T2CStatement)newstmt).prepareAccessors();
                }
                this.implicitResultSetIterator = this.implicitResultSetStatements.iterator();
            } else if (status != 0) {
                this.t2cConnection.checkError(status);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    void pushEndToEndValues() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$9, this, new Object[0]);
            }
            T2CConnection c2 = this.t2cConnection;
            byte[] e2e_action = null;
            byte[] e2e_clientid = null;
            byte[] e2e_ecid = null;
            byte[] e2e_module = null;
            byte[] e2e_dbop = null;
            if (c2.endToEndValues != null) {
                if (c2.endToEndHasChanged[0]) {
                    String action = c2.endToEndValues[0];
                    e2e_action = action != null ? DBConversion.stringToDriverCharBytes(action, c2.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                    c2.endToEndHasChanged[0] = false;
                }
                if (c2.endToEndHasChanged[1]) {
                    String clientid = c2.endToEndValues[1];
                    e2e_clientid = clientid != null ? DBConversion.stringToDriverCharBytes(clientid, c2.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                    c2.endToEndHasChanged[1] = false;
                }
                if (c2.endToEndHasChanged[2]) {
                    String ecid = c2.endToEndValues[2];
                    e2e_ecid = ecid != null ? DBConversion.stringToDriverCharBytes(ecid, c2.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                    c2.endToEndHasChanged[2] = false;
                }
                if (c2.endToEndHasChanged[3]) {
                    String module = c2.endToEndValues[3];
                    e2e_module = module != null ? DBConversion.stringToDriverCharBytes(module, c2.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                    c2.endToEndHasChanged[3] = false;
                }
                if (c2.endToEndHasChanged[4]) {
                    String dbop = c2.endToEndValues[4];
                    e2e_module = dbop != null ? DBConversion.stringToDriverCharBytes(dbop, c2.m_clientCharacterSet) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                    c2.endToEndHasChanged[4] = false;
                }
                T2CStatement.t2cEndToEndUpdate(this.c_state, e2e_action, e2e_action == null ? -1 : e2e_action.length, e2e_clientid, e2e_clientid == null ? -1 : e2e_clientid.length, e2e_ecid, e2e_ecid == null ? -1 : e2e_ecid.length, e2e_module, e2e_module == null ? -1 : e2e_module.length, e2e_dbop, e2e_dbop == null ? -1 : e2e_dbop.length, c2.endToEndECIDSequenceNumber);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void executeForRows(boolean bl) throws SQLException {
        boolean bl2 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void executed_for_describe;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$10, this, bl);
            }
            if (this.connection.endToEndAnyChanged) {
                this.pushEndToEndValues();
                this.connection.endToEndAnyChanged = false;
            }
            if (executed_for_describe == false) {
                if (this.numberOfDefinePositions > 0) {
                    this.doDefineExecuteFetch();
                } else {
                    this.executeForDescribe();
                }
            } else if (this.numberOfDefinePositions > 0) {
                this.doDefineFetch();
            }
            if (this.returnParamMeta != null) {
                this.fetchDmlReturnParams();
            }
            this.needToPrepareDefineBuffer = false;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    void setupForDefine() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$11, this, new Object[0]);
            }
            if (this.numberOfDefinePositions > this.t2cConnection.queryMetaData1Size) {
                int n2 = this.numberOfDefinePositions / 100 + 1;
                this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * n2, this.t2cConnection.queryMetaData2Size * n2 * 8);
            }
            short[] s2 = this.t2cConnection.queryMetaData1;
            int currentShort = this.t2cConnection.queryMetaData1Offset;
            int i2 = 0;
            while (i2 < this.numberOfDefinePositions) {
                Accessor currentAccessor = this.accessors[i2];
                if (currentAccessor == null) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$11, this, sQLException);
                    }
                    throw sQLException;
                }
                s2[currentShort + 0] = (short)currentAccessor.defineType;
                if (!this.described && currentAccessor.charLength > 0 && currentAccessor.formOfUse == 1) {
                    int charLength = currentAccessor.charLength;
                    int byteLength = charLength + 1;
                    s2[currentShort + 11] = 0;
                    s2[currentShort + 1] = (short)byteLength;
                } else {
                    s2[currentShort + 11] = (short)currentAccessor.charLength;
                    s2[currentShort + 1] = (short)currentAccessor.byteLength;
                }
                s2[currentShort + 5] = currentAccessor.formOfUse;
                if (currentAccessor.internalOtype != null) {
                    long tdo = ((OracleTypeADT)currentAccessor.internalOtype).getTdoCState();
                    s2[currentShort + 7] = (short)((tdo & 0xFFFF000000000000L) >> 48);
                    s2[currentShort + 8] = (short)((tdo & 0xFFFF00000000L) >> 32);
                    s2[currentShort + 9] = (short)((tdo & 0xFFFF0000L) >> 16);
                    s2[currentShort + 10] = (short)(tdo & 0xFFFFL);
                }
                switch (currentAccessor.internalType) {
                    case 112: 
                    case 113: {
                        if (currentAccessor.lobPrefetchSizeForThisColumn == -1) {
                            currentAccessor.setPrefetchLength(this.defaultLobPrefetchSize);
                        }
                        s2[currentShort + 7] = (short)currentAccessor.lobPrefetchSizeForThisColumn;
                    }
                }
                ++i2;
                currentShort += 16;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void configureBindData() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$12, this, new Object[0]);
            }
            if (this.outBindAccessors == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$12, this);
                    ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$12, this, null);
                }
                return;
            }
            AggregateByteArray _bindData = (AggregateByteArray)this.bindData;
            T2CCharByteArray _bindChars = (T2CCharByteArray)_bindData.extension;
            AggregateByteArray _bindIbtBytes = (AggregateByteArray)_bindChars.extension;
            T2CCharByteArray _bindIbtChars = (T2CCharByteArray)_bindIbtBytes.extension;
            if (this.bindBytes != null) {
                _bindData.setBytes(this.bindBytes);
            } else {
                _bindData.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
            }
            if (this.bindChars != null) {
                _bindChars.setChars(this.bindChars);
            } else {
                _bindChars.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
            }
            if (this.ibtBindBytes != null) {
                _bindIbtBytes.setBytes(this.ibtBindBytes);
            } else {
                _bindIbtBytes.setBytes(PhysicalConnection.EMPTY_BYTE_ARRAY);
            }
            if (this.ibtBindChars != null) {
                _bindIbtChars.setChars(this.ibtBindChars);
            } else {
                _bindIbtChars.setChars(PhysicalConnection.EMPTY_CHAR_ARRAY);
            }
            _bindChars.setDBConversion(this.connection.conversion);
            _bindIbtChars.setDBConversion(this.connection.conversion);
            int bindBytesLength = this.bindBytes == null ? 0 : this.bindBytes.length;
            int bindCharsLength = this.bindChars == null ? 0 : this.bindChars.length;
            int ibtBindBytesLength = this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length;
            int ibtBindCharsLength = this.ibtBindChars == null ? 0 : this.ibtBindChars.length;
            Accessor a2 = null;
            int lengthPrefix = 0;
            for (int columnNumber = 0; columnNumber < this.numberOfBindPositions; ++columnNumber) {
                a2 = this.outBindAccessors[columnNumber];
                if (a2 == null) continue;
                int offset = 0;
                int dataLength = a2.byteLength;
                if (a2.defineType == 998) {
                    PlsqlIndexTableAccessor a1 = (PlsqlIndexTableAccessor)a2;
                    offset += bindBytesLength + bindCharsLength;
                    offset += a1.ibtBindInfo.ibtValueIndex;
                    switch (a1.ibtBindInfo.element_internal_type) {
                        case 9: {
                            offset += ibtBindBytesLength;
                            break;
                        }
                    }
                    a2.setOffset(0, offset);
                    continue;
                }
                offset = a2.columnDataOffset;
                if (a2.charLength > 0) {
                    offset += bindBytesLength;
                    dataLength = a2.charLength;
                }
                lengthPrefix = a2.defineType == 15 ? 2 : (a2.externalType == -8 ? (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK ? 1 : 2) : (a2.defineType == 6 || a2.defineType == 9 ? 1 : 0));
                for (int rowNumber = 0; rowNumber < this.binders.length; ++rowNumber) {
                    int len = this.bindIndicators[a2.lengthIndex] - lengthPrefix & Short.MAX_VALUE;
                    a2.setOffset(rowNumber, offset += dataLength * rowNumber + lengthPrefix);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initializePlsqlIndexByTableAccessor(Accessor accessor, int n2) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void indOffset;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$13, this, accessor, n2);
            }
            ((T2CPlsqlIndexTableAccessor)accessor).ibtMetaIndex = indOffset - 8;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    @DefaultLevel(value=Logging.FINEST)
    Object[] getLobPrefetchMetaData() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$14, this, new Object[0]);
            }
            Object[] lobPrefetchMetaData = null;
            Object isPrefetchEnabled = null;
            int[] lobPrefetchSizeForThisColumnArray = null;
            int noOfLobColumnsWithPrefetch = 0;
            int lastStreamColumnIndex = 0;
            if (this.accessors != null) {
                int i2;
                block9: for (i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                    switch (this.accessors[i2].internalType) {
                        case 8: 
                        case 24: {
                            lastStreamColumnIndex = i2;
                            continue block9;
                        }
                        case 112: 
                        case 113: {
                            if (lobPrefetchSizeForThisColumnArray == null) {
                                lobPrefetchSizeForThisColumnArray = new int[this.accessors.length];
                            }
                            if (this.accessors[i2].lobPrefetchSizeForThisColumn != -1) {
                                ++noOfLobColumnsWithPrefetch;
                                lobPrefetchSizeForThisColumnArray[i2] = this.accessors[i2].lobPrefetchSizeForThisColumn;
                                continue block9;
                            }
                            lobPrefetchSizeForThisColumnArray[i2] = -1;
                        }
                    }
                }
                if (noOfLobColumnsWithPrefetch > 0) {
                    if (lobPrefetchMetaData == null || this.rowPrefetchChanged) {
                        lobPrefetchMetaData = new Object[]{null, new long[this.rowPrefetch * noOfLobColumnsWithPrefetch], new byte[this.accessors.length], new int[this.accessors.length], new Object[this.rowPrefetch * noOfLobColumnsWithPrefetch]};
                    }
                    for (i2 = 0; i2 < lastStreamColumnIndex; ++i2) {
                        switch (this.accessors[i2].internalType) {
                            case 112: 
                            case 113: {
                                this.accessors[i2].setPrefetchLength(-1);
                                lobPrefetchSizeForThisColumnArray[i2] = -1;
                            }
                        }
                    }
                    lobPrefetchMetaData[0] = lobPrefetchSizeForThisColumnArray;
                }
            }
            Object[] objectArray = lobPrefetchMetaData;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$14, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$14, this, null);
            }
            return lobPrefetchMetaData;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    void processLobPrefetchMetaData(Object[] objectArray) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void lobPrefetchMetaData;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$15, this, new Object[]{objectArray});
            }
            int lobColumnCount = 0;
            int noOfRowsFetched = (int)this.validRows == -2 ? 1 : (int)this.validRows;
            byte[] prefetchedDataFormOfUse = (byte[])lobPrefetchMetaData[2];
            int[] prefetchedChunkSize = (int[])lobPrefetchMetaData[3];
            long[] prefetchedLength = (long[])lobPrefetchMetaData[1];
            Object[] prefetchedData = (Object[])lobPrefetchMetaData[4];
            int[] lobPrefetchSizeForThisColumnArray = (int[])lobPrefetchMetaData[0];
            if (this.accessors != null) {
                block5: for (int col = 0; col < this.numberOfDefinePositions; ++col) {
                    switch (this.accessors[col].internalType) {
                        case 112: 
                        case 113: {
                            if (this.accessors[col].lobPrefetchSizeForThisColumn < 0) continue block5;
                            LobCommonAccessor accessor = (LobCommonAccessor)this.accessors[col];
                            if (accessor.prefetchedDataLength == null || accessor.prefetchedDataLength.length < this.rowPrefetch) {
                                if (accessor.internalType == 112) {
                                    ((ClobAccessor)accessor).prefetchedDataFormOfUse = new int[this.rowPrefetch];
                                }
                                accessor.prefetchedChunkSize = new int[this.rowPrefetch];
                                accessor.prefetchedDataLength = new int[this.rowPrefetch];
                                accessor.prefetchedLength = new long[this.rowPrefetch];
                                accessor.prefetchedDataOffset = new long[this.rowPrefetch];
                            }
                            int offset = noOfRowsFetched * lobColumnCount;
                            int rowOffset = this.needToRetainRows ? this.storedRowCount : 0;
                            for (int row = 0; row < noOfRowsFetched; ++row) {
                                int dataLength;
                                accessor.prefetchedChunkSize[rowOffset + row] = prefetchedChunkSize[col];
                                accessor.prefetchedLength[rowOffset + row] = prefetchedLength[offset + row];
                                if (accessor.internalType == 112) {
                                    ((ClobAccessor)accessor).prefetchedDataFormOfUse[rowOffset + row] = prefetchedDataFormOfUse[col];
                                }
                                accessor.prefetchedDataLength[row] = 0;
                                if (lobPrefetchSizeForThisColumnArray[col] <= 0 || prefetchedLength[offset + row] <= 0L) continue;
                                byte[] b2 = (byte[])prefetchedData[offset + row];
                                int n2 = dataLength = b2 == null ? 0 : b2.length;
                                if (dataLength > 0) {
                                    accessor.setPrefetchedDataOffset(rowOffset + row);
                                    accessor.rowData.put(b2, 0, dataLength);
                                }
                                accessor.prefetchedDataLength[rowOffset + row] = dataLength;
                            }
                            ++lobColumnCount;
                            continue block5;
                        }
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    int getRowsToFetch() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$16, this, new Object[0]);
            }
            int rowsToFetch = -1;
            if (this.hasStream) {
                rowsToFetch = 1;
                if (this.t2cConnection.useOCIDefaultDefines) {
                    this.savedRowPrefetch = 1;
                } else {
                    this.rowPrefetch = 1;
                }
            } else {
                rowsToFetch = this.t2cConnection.useOCIDefaultDefines ? (this.maxRows > 0L && this.maxRows == (long)this.storedRowCount ? 0 : this.rowPrefetch) : (this.maxRows > 0L && this.maxRows < (long)(this.rowPrefetch + this.storedRowCount) ? (this.storedRowCount < 1 && this.maxRows < (long)this.rowPrefetch ? (int)this.maxRows : (int)Math.min((long)this.rowPrefetch, this.maxRows - (long)this.storedRowCount)) : this.rowPrefetch);
            }
            int n2 = rowsToFetch;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$16, this, n2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$16, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @DefaultLevel(value=Logging.FINEST)
    void doDefineFetch() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$17, this, new Object[0]);
            }
            int rowsToFetch = this.getRowsToFetch();
            this.validRows = 0L;
            if (!this.needToPrepareDefineBuffer) {
                Error error = new Error("doDefineFetch called when needToPrepareDefineBuffer=false " + this.sqlObject.getSql(this.processEscapes, this.convertNcharLiterals));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$17, this, error);
                }
                throw error;
            }
            if (!$assertionsDisabled && rowsToFetch <= 0) {
                AssertionError assertionError = new AssertionError((Object)("rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")"));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$17, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (rowsToFetch > 0) {
                this.setupForDefine();
                this.t2cOutput[2] = 0L;
                this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
                this.t2cOutput[6] = this.defaultLobPrefetchSize;
                if (this.connection.useNio) {
                    this.resetNioAttributesBeforeFetch();
                    this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
                }
                if (this.lobPrefetchMetaData == null) {
                    this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
                }
                this.resetStateBeforeFetch();
                this.validRows = T2CStatement.t2cDefineFetch(this, this.c_state, rowsToFetch, this.OCIPrefetch, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
                if (this.validRows == -1L || this.validRows == -4L) {
                    this.t2cConnection.checkError((int)this.validRows);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
                }
                if (this.connection.useNio && (this.validRows > 0L || this.validRows == -2L)) {
                    this.extractNioDefineBuffers(0);
                }
                if (this.isFetchStreams && this.validRows == -2L) {
                    this.copyStreamDataIntoDBA(0);
                }
                if (this.lobPrefetchMetaData != null) {
                    this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
                }
            }
            boolean bl2 = this.isAllFetched = rowsToFetch < 1 || this.validRows >= 0L && this.validRows < (long)rowsToFetch;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void copyStreamDataIntoDBA(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$18, this, n2);
            }
            if (!($assertionsDisabled || this.isFetchStreams && this.validRows == -2L)) {
                AssertionError assertionError = new AssertionError((Object)("isFetchStreams: " + this.isFetchStreams + "isScrollable(): " + this.realRsetType.isScrollable() + ", isUpdatable(): " + this.realRsetType.isUpdatable() + ", validRows=" + this.validRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$18, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.checkValidRowsStatus();
            if (this.accessors != null) {
                block6: for (Accessor a2 : this.accessors) {
                    if (a2 == null) continue;
                    switch (a2.internalType) {
                        case 8: {
                            void row;
                            ((T2CLongAccessor)a2).copyStreamDataIntoDBA((int)row);
                            continue block6;
                        }
                        case 24: {
                            void row;
                            ((T2CLongRawAccessor)a2).copyStreamDataIntoDBA((int)row);
                        }
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void allocateNioBuffersIfRequired(int n2, int n3, int n4) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void byteSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$19, this, n2, n3, n4);
            }
            if (this.nioBuffers == null) {
                this.nioBuffers = new ByteBuffer[4];
            }
            if (byteSize > 0) {
                if (this.nioBuffers[0] == null || this.nioBuffers[0].capacity() < byteSize) {
                    this.nioBuffers[0] = ByteBuffer.allocateDirect((int)byteSize);
                } else if (this.nioBuffers[0] != null) {
                    this.nioBuffers[0].rewind();
                }
            }
            if ((charSize *= 2) > 0) {
                void charSize;
                if (this.nioBuffers[1] == null || this.nioBuffers[1].capacity() < charSize) {
                    this.nioBuffers[1] = ByteBuffer.allocateDirect((int)charSize);
                } else if (this.nioBuffers[1] != null) {
                    this.nioBuffers[1].rewind();
                }
            }
            if ((indSize *= 2) > 0) {
                void indSize;
                if (this.nioBuffers[2] == null || this.nioBuffers[2].capacity() < indSize) {
                    this.nioBuffers[2] = ByteBuffer.allocateDirect((int)indSize);
                } else if (this.nioBuffers[2] != null) {
                    this.nioBuffers[2].rewind();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    void doDefineExecuteFetch() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$20, this, new Object[0]);
            }
            short[] queryMetaData1 = null;
            if (this.needToPrepareDefineBuffer || this.needToParse) {
                this.setupForDefine();
                queryMetaData1 = this.t2cConnection.queryMetaData1;
            }
            this.t2cOutput[0] = 0L;
            this.t2cOutput[2] = 0L;
            byte[] array_sql = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
            this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
            this.t2cOutput[6] = this.defaultLobPrefetchSize;
            this.t2cOutput[7] = this.t2cConnection.useOCIDefaultDefines ? 1 : 0;
            if (this.connection.useNio) {
                this.resetNioAttributesBeforeFetch();
                this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
            }
            if (this.lobPrefetchMetaData == null) {
                this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
            }
            int rowsToFetch = this.getRowsToFetch();
            if (!$assertionsDisabled && rowsToFetch <= 0) {
                AssertionError assertionError = new AssertionError((Object)("rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")"));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$20, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.validRows = 0L;
            try {
                this.resetStateBeforeFetch();
                this.validRows = T2CStatement.t2cDefineExecuteFetch(this, this.c_state, this.numberOfDefinePositions, this.numberOfBindPositions, this.numberOfBindRowsAllocated, this.firstRowInBatch, false, this.needToParse, array_sql, array_sql.length, T2CStatement.convertSqlKindEnumToByte(this.sqlKind), rowsToFetch, this.OCIPrefetch, this.batch, this.bindIndicators, this.bindIndicatorOffset, this.bindBytes, this.bindChars, this.bindByteOffset, this.bindCharOffset, queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.preparedByteBinds, this.preparedCharBinds, this.accessors, this.binders, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
                if (this.bindIndicators != null) {
                    this.setLengthForOutAccessors();
                }
            }
            catch (IOException iox) {
                this.validRows = 0L;
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iox).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$20, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$20, this, sQLException);
                }
                throw sQLException;
            }
            if (this.validRows == -1L) {
                this.t2cConnection.checkError((int)this.validRows);
            }
            if (this.t2cOutput[2] != 0L) {
                this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
            }
            this.connection.endToEndECIDSequenceNumber = (short)this.t2cOutput[4];
            if (this.connection.useNio && (this.validRows > 0L || this.validRows == -2L)) {
                this.extractNioDefineBuffers(0);
            }
            if (this.isFetchStreams && this.validRows == -2L) {
                this.copyStreamDataIntoDBA(0);
            }
            if (this.lobPrefetchMetaData != null) {
                this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
            }
            this.isAllFetched = rowsToFetch < 1 || this.validRows >= 0L && this.validRows < (long)rowsToFetch;
            this.needToParse = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fetch(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void retainRows;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$21, this, n2, bl);
            }
            this.needToRetainRows = retainRows;
            int rowsToFetch = this.getRowsToFetch();
            if (!$assertionsDisabled && rowsToFetch <= 0) {
                AssertionError assertionError = new AssertionError((Object)("rowsToFetch < 1 (rowsToFetch=" + rowsToFetch + ", maxRows=" + this.maxRows + ", rowPrefetch=" + this.rowPrefetch + ", savedRowPrefetch=" + this.savedRowPrefetch + ")"));
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$21, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            this.validRows = 0L;
            if (rowsToFetch > 0 && this.numberOfDefinePositions > 0) {
                if (this.needToPrepareDefineBuffer) {
                    this.doDefineFetch();
                    this.needToPrepareDefineBuffer = false;
                } else {
                    this.t2cOutput[2] = 0L;
                    this.t2cOutput[5] = this.connection.useNio ? 1 : 0;
                    this.t2cOutput[6] = this.defaultLobPrefetchSize;
                    if (this.connection.useNio) {
                        this.resetNioAttributesBeforeFetch();
                        this.allocateNioBuffersIfRequired(this.defineChars == null ? 0 : this.defineChars.length, this.defineBytes == null ? 0 : this.defineBytes.length, this.defineIndicators == null ? 0 : this.defineIndicators.length);
                    }
                    if (this.lobPrefetchMetaData == null) {
                        this.lobPrefetchMetaData = this.getLobPrefetchMetaData();
                    }
                    this.resetStateBeforeFetch();
                    this.validRows = T2CStatement.t2cFetch(this, this.c_state, this.needToPrepareDefineBuffer, rowsToFetch, this.OCIPrefetch, this.accessors, this.t2cOutput, this.nioBuffers, this.lobPrefetchMetaData);
                    if (this.validRows == -1L || this.validRows == -4L) {
                        this.t2cConnection.checkError((int)this.validRows);
                    }
                    if (this.t2cOutput[2] != 0L) {
                        this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
                    }
                    if (this.lobPrefetchMetaData != null) {
                        this.processLobPrefetchMetaData(this.lobPrefetchMetaData);
                    }
                    if (this.connection.useNio && (this.validRows > 0L || this.validRows == -2L)) {
                        this.extractNioDefineBuffers(0);
                    }
                    if (this.isFetchStreams && this.validRows == -2L) {
                        void firstRow;
                        this.copyStreamDataIntoDBA((int)firstRow);
                    }
                }
            }
            this.isAllFetched = rowsToFetch < 1 || this.validRows >= 0L && this.validRows < (long)rowsToFetch;
            this.needToRetainRows = false;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    void resetNioAttributesBeforeFetch() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$22, this, new Object[0]);
            }
            this.extractedCharOffset = 0;
            this.extractedByteOffset = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$22, this);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$22, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void extractNioDefineBuffers(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$23, this, n2);
            }
            if (this.accessors == null || this.defineIndicators == null || columnIndex == this.numberOfDefinePositions) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$23, this);
                    ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$23, this, null);
                }
                return;
            }
            int sizeToCopyBytes = 0;
            int sizeToCopyChars = 0;
            int sizeToCopyIndicators = 0;
            int lengthOffset = 0;
            int indOffset = 0;
            if (!this.hasStream) {
                sizeToCopyBytes = this.defineBytes != null ? this.defineBytes.length : 0;
                sizeToCopyChars = this.defineChars != null ? this.defineChars.length : 0;
                sizeToCopyIndicators = this.defineIndicators.length;
            } else {
                if (this.numberOfDefinePositions > columnIndex) {
                    indOffset = this.accessors[columnIndex].indicatorIndex;
                    lengthOffset = this.accessors[columnIndex].lengthIndex;
                }
                block5: for (void i2 = columnIndex; i2 < this.numberOfDefinePositions; ++i2) {
                    switch (this.accessors[i2].internalType) {
                        case 8: 
                        case 24: {
                            break block5;
                        }
                        default: {
                            sizeToCopyBytes += this.accessors[i2].byteLength;
                            sizeToCopyChars += this.accessors[i2].charLength;
                            ++sizeToCopyIndicators;
                            continue block5;
                        }
                    }
                }
            }
            ByteBuffer b2 = this.nioBuffers[0];
            if (b2 != null && this.defineBytes != null && sizeToCopyBytes > 0) {
                b2.position(this.extractedByteOffset);
                b2.get(this.defineBytes, this.extractedByteOffset, sizeToCopyBytes);
                this.extractedByteOffset += sizeToCopyBytes;
            }
            if (this.nioBuffers[1] != null && this.defineChars != null) {
                b2 = this.nioBuffers[1].order(ByteOrder.LITTLE_ENDIAN);
                CharBuffer c2 = b2.asCharBuffer();
                if (sizeToCopyChars > 0) {
                    c2.position(this.extractedCharOffset);
                    c2.get(this.defineChars, this.extractedCharOffset, sizeToCopyChars);
                    this.extractedCharOffset += sizeToCopyChars;
                }
            }
            if (this.nioBuffers[2] != null) {
                b2 = this.nioBuffers[2].order(ByteOrder.LITTLE_ENDIAN);
                ShortBuffer s2 = b2.asShortBuffer();
                if (this.hasStream) {
                    if (sizeToCopyIndicators > 0) {
                        s2.position(indOffset);
                        s2.get(this.defineIndicators, indOffset, sizeToCopyIndicators);
                        s2.position(lengthOffset);
                        s2.get(this.defineIndicators, lengthOffset, sizeToCopyIndicators);
                    }
                } else {
                    s2.get(this.defineIndicators);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$23, this);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$23, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void doClose() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$24, this, new Object[0]);
            }
            if (this.defineBytes != null) {
                this.defineBytes = null;
            }
            if (this.defineChars != null) {
                this.defineChars = null;
            }
            if (this.defineIndicators != null) {
                this.defineIndicators = null;
            }
            int returnCode = T2CStatement.t2cCloseStatement(this.c_state);
            this.nioBuffers = null;
            if (returnCode != 0) {
                this.t2cConnection.checkError(returnCode);
            }
            this.t2cOutput = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$24, this);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$24, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void closeQuery() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$25, this, new Object[0]);
            }
            this.connection.registerHeartbeat();
            this.connection.needLine();
            if (this.streamList != null) {
                while (this.nextStream != null) {
                    try {
                        this.nextStream.close();
                    }
                    catch (IOException exc) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$25, this, sQLException);
                        }
                        throw sQLException;
                    }
                    this.nextStream = this.nextStream.nextStream;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$25, this);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$25, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @DefaultLevel(value=Logging.FINEST)
    void closeUsedStreams(int n2) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$26, this, n2);
            }
            while (this.nextStream != null && this.nextStream.columnIndex < 1 + this.offsetOfFirstUserColumn + columnIndex) {
                try {
                    if (bl) {
                        this.debug($$$loggerRef$$$26, Level.FINEST, $$$methodRef$$$26, "closeUsedStream(" + (1 + this.offsetOfFirstUserColumn) + (int)columnIndex + ") closing " + this.nextStream + " at index " + this.nextStream.columnIndex);
                    }
                    this.nextStream.close();
                }
                catch (IOException exc) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), exc).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$26, this, sQLException);
                    }
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
            if (this.nextStream != null) {
                try {
                    this.nextStream.needBytes();
                }
                catch (IOException e2) {
                    this.interalCloseOnIOException(e2);
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e2).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$26, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$26, this);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$26, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    void interalCloseOnIOException(IOException iOException) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$27, this, iOException);
            }
            this.closed = true;
            if (this.currentResultSet != null) {
                this.currentResultSet.closed = true;
            }
            this.doClose();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$27, this);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$27, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    void fetchDmlReturnParams() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$28, this, new Object[0]);
            }
            this.rowsDmlReturned = T2CStatement.t2cGetRowsDmlReturned(this.c_state);
            if (this.rowsDmlReturned != 0) {
                this.allocateDmlReturnStorage();
                this.resetStateBeforeFetch();
                int status = T2CStatement.t2cFetchDmlReturnParams(this.c_state, this, this.accessors, this.returnParamBytes, this.returnParamChars, this.returnParamIndicators);
                if (status == -1 || status == -4) {
                    this.t2cConnection.checkError(status);
                }
                if (this.t2cOutput[2] != 0L) {
                    this.sqlWarning = this.t2cConnection.checkError(1, this.sqlWarning);
                }
                if (this.connection.useNio && (status > 0 || status == -2)) {
                    this.extractNioDefineBuffers(0);
                }
            }
            AggregateByteArray _bindData = (AggregateByteArray)this.bindData;
            if (this.returnParamBytes != null) {
                _bindData.setBytes(this.returnParamBytes);
            }
            ((T2CCharByteArray)_bindData.extension).setChars(this.returnParamChars);
            ((T2CCharByteArray)_bindData.extension).setDBConversion(this.connection.conversion);
            int bindBytesLength = this.returnParamBytes == null ? 0 : this.returnParamBytes.length;
            int nullIndex = 0;
            int lenIndex = this.numReturnParams * this.rowsDmlReturned;
            int byteOffset = 0;
            int charOffset = bindBytesLength;
            int returnParamCount = 0;
            for (int aIndex = 0; aIndex < this.numberOfBindPositions; ++aIndex) {
                Accessor accessor = this.accessors[aIndex];
                if (accessor == null) continue;
                accessor.setCapacity(this.rowsDmlReturned);
                for (int rowNumber = 0; rowNumber < this.rowsDmlReturned; ++rowNumber) {
                    if (accessor.internalType == 109 || accessor.internalType == 111) {
                        ++returnParamCount;
                        continue;
                    }
                    int len = this.returnParamIndicators[lenIndex++];
                    boolean isNull = this.returnParamIndicators[nullIndex++] == -1;
                    int lenPrefix = 0;
                    if (accessor.internalType == 104) {
                        lenPrefix = 2;
                    } else if (accessor.defineType == 6 || accessor.defineType == 9 || accessor.defineType == 1) {
                        lenPrefix = 1;
                    }
                    if (accessor.charLength > 0) {
                        accessor.setOffset(rowNumber, charOffset + lenPrefix);
                        charOffset += accessor.charLength;
                    } else {
                        accessor.setOffset(rowNumber, byteOffset + lenPrefix);
                        byteOffset += accessor.byteLength;
                    }
                    if (isNull || len == 0) {
                        accessor.setLengthAndNull(rowNumber, 0);
                        continue;
                    }
                    if (accessor.internalType == 1) {
                        len /= 2;
                    }
                    accessor.setLengthAndNull(rowNumber, len);
                }
            }
            this.returnParamsFetched = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$28, this);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$28, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void processDmlReturningBind() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$29, this, new Object[0]);
            }
            super.processDmlReturningBind();
            this.returnParamRowBytes = 0;
            this.returnParamRowChars = 0;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) continue;
                if (accessor.charLength > 0) {
                    this.returnParamRowChars += accessor.charLength;
                    continue;
                }
                this.returnParamRowBytes += accessor.byteLength;
            }
            this.returnParamMeta[1] = this.returnParamRowBytes;
            this.returnParamMeta[2] = this.returnParamRowChars;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$29, this);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$29, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void allocateDmlReturnStorage() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$30, this, new Object[0]);
            }
            if (this.rowsDmlReturned == 0) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$30, this);
                    ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$30, this, null);
                }
                return;
            }
            int totalBytes = this.returnParamRowBytes * this.rowsDmlReturned;
            int totalChars = this.returnParamRowChars * this.rowsDmlReturned;
            int indicatorLength = 2 * this.numReturnParams * this.rowsDmlReturned;
            this.returnParamBytes = new byte[totalBytes];
            this.returnParamChars = new char[totalChars];
            this.returnParamIndicators = new short[indicatorLength];
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                Accessor accessor = this.accessors[i2];
                if (accessor == null) continue;
                accessor.setCapacity(this.rowsDmlReturned);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$30, this);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$30, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    void cleanupReturnParameterBuffers() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$31, this, new Object[0]);
            }
            this.returnParamBytes = null;
            this.returnParamChars = null;
            this.returnParamIndicators = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$31, this);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$31, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void initializeIndicatorSubRange() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$32, this, new Object[0]);
            }
            this.bindIndicatorSubRange = this.numberOfBindPositions * PREAMBLE_PER_POSITION;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$32, this);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$32, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int calculateIndicatorSubRangeSize() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$33, this, new Object[0]);
            }
            int n2 = this.numberOfBindPositions * PREAMBLE_PER_POSITION;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$33, this, n2);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$33, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    short getInoutIndicator(int n2) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bindPosition;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$34, this, n2);
            }
            short s2 = this.bindIndicators[bindPosition * PREAMBLE_PER_POSITION];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$34, this, s2);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$34, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    void resetStateBeforeFetch() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$35, this, new Object[0]);
            }
            this.lastProcessedCell = 0;
            this.lastProcessedAccessorIndex = 0;
            this.accessorsProcessed = 0;
            this.previousMode = 0;
            if (this.rowData != null) {
                if (this.needToRetainRows) {
                    this.rowData.setPosition(this.rowData.length());
                } else {
                    this.rowData.reset();
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$35, this);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$35, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int updateData(int n2, int n3, int n4, int[] nArray, byte[] byArray) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$36, this, n2, n3, n4, nArray, byArray);
            }
            try {
                void mode;
                if (this.previousMode != mode) {
                    this.accessorsProcessed = 0;
                }
                this.previousMode = mode;
                int offset = 0;
                int rowNumber = 0;
                int colNumber = 0;
                int len = 0;
                boolean isNull = false;
                switch (mode) {
                    case 16: 
                    case 32: {
                        void buffer;
                        void columnMetaData;
                        int numberOfCells;
                        for (int cellIndex = 0; cellIndex < numberOfCells; ++cellIndex) {
                            rowNumber = columnMetaData[cellIndex * 4 + 0];
                            colNumber = columnMetaData[cellIndex * 4 + 1];
                            len = columnMetaData[cellIndex * 4 + 2];
                            isNull = columnMetaData[cellIndex * 4 + 3] == -1;
                            Accessor a2 = this.accessors[colNumber];
                            a2.setOffset((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber);
                            if (len > 0) {
                                switch (a2.defineType) {
                                    case 1: 
                                    case 23: 
                                    case 96: 
                                    case 104: {
                                        offset += 2;
                                        len -= 2;
                                        break;
                                    }
                                    case 6: {
                                        ++offset;
                                        --len;
                                    }
                                }
                                this.rowData.put((byte[])buffer, offset, len);
                                offset += len;
                            }
                            a2.setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber, len);
                            ++this.accessorsProcessed;
                            ++this.lastProcessedCell;
                        }
                        break;
                    }
                    case 64: {
                        void buffer;
                        void columnMetaData;
                        int numberOfCells;
                        int columnOffset = 0;
                        Accessor[] outOrReturnDmlAccessors = null;
                        if (this.outBindAccessors != null) {
                            columnOffset = (this.bindBytes == null ? 0 : this.bindBytes.length) + (this.bindChars == null ? 0 : this.bindChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
                            outOrReturnDmlAccessors = this.outBindAccessors;
                        } else {
                            columnOffset = (this.returnParamBytes == null ? 0 : this.returnParamBytes.length) + (this.returnParamChars == null ? 0 : this.returnParamChars.length) + (this.ibtBindBytes == null ? 0 : this.ibtBindBytes.length) + (this.ibtBindChars == null ? 0 : this.ibtBindChars.length);
                            outOrReturnDmlAccessors = this.accessors;
                        }
                        if (!$assertionsDisabled && outOrReturnDmlAccessors == null) {
                            AssertionError assertionError = new AssertionError((Object)"No OUT binds or Return Parameters");
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$36, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$36, this, (Throwable)((Object)assertionError));
                            }
                            throw assertionError;
                        }
                        ByteArray adtByteArray = this.bindData;
                        while (adtByteArray instanceof AggregateByteArray && (adtByteArray = ((AggregateByteArray)adtByteArray).extension) != null) {
                        }
                        columnOffset = (int)((long)columnOffset + adtByteArray.getPosition());
                        int accessorIndexForOutBinds = this.accessorsProcessed;
                        for (int cellIndex = 0; cellIndex < numberOfCells; ++cellIndex) {
                            rowNumber = columnMetaData[cellIndex * 4 + 0];
                            colNumber = columnMetaData[cellIndex * 4 + 1];
                            len = columnMetaData[cellIndex * 4 + 2];
                            isNull = columnMetaData[cellIndex * 4 + 3] == -1;
                            Accessor a3 = outOrReturnDmlAccessors[colNumber];
                            a3.setOffset((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber, columnOffset);
                            adtByteArray.put((byte[])buffer, offset, len);
                            a3.setLengthAndNull((this.needToRetainRows ? this.storedRowCount : 0) + rowNumber, len);
                            offset += len;
                            columnOffset += len;
                            ++this.lastProcessedCell;
                        }
                        break;
                    }
                }
            }
            catch (SQLException ea) {
                this.updateDataException = ea;
                int n5 = -3;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$36, this, n5);
                    ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$36, this, null);
                }
                return -3;
            }
            int n6 = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$36, this, n6);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$36, this, null);
            }
            return 0;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    final boolean bit(long l2, long l3) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void mask;
            void value;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$37, this, l2, l3);
            }
            boolean bl3 = bl2 = (value & mask) == value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$37, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$37, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String toHex(byte[] byArray, int n2) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            byte[] value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, byArray, n2);
            }
            if (value == null) {
                String string = "null";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, string);
                    ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, null);
                }
                return "null";
            }
            if (length > value.length) {
                String string = "byte array not long enough";
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, string);
                    ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, null);
                }
                return "byte array not long enough";
            }
            String result = "0:";
            int len = length;
            for (int i2 = 0; i2 < len; ++i2) {
                if (i2 != 0 && i2 % 10 == 0) {
                    result = result + "\n" + i2 + ": ";
                }
                result = result + OracleLog.toHex(value[i2]) + " ";
            }
            String string = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, string);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$38, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void locationToPutBytes(Accessor accessor, int n2, int n3) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            void row;
            void acc;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$39, this, accessor, n2, n3);
            }
            acc.setOffset((int)row, this.allocateRowDataSpace((int)length));
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$39, this);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$39, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    long allocateRowDataSpace(int n2) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$40, this, n2);
            }
            long l2 = this.rowData.length();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$40, this, l2);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$40, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        boolean bl2 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void col_index;
            void form;
            void max_len;
            void external_type;
            void typeName;
            void forBind;
            void internal_type;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, n2, n3, n4, n5, s2, string, bl);
            }
            Accessor result = null;
            switch (internal_type) {
                case 102: 
                case 116: {
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, sQLException);
                        }
                        throw sQLException;
                    }
                    T2CResultSetAccessor t2CResultSetAccessor = result = new T2CResultSetAccessor(this, (int)max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, t2CResultSetAccessor);
                        ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, null);
                    }
                    return t2CResultSetAccessor;
                }
                case 8: {
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (forBind != false) {
                        VarcharAccessor varcharAccessor = new VarcharAccessor(this, (int)max_len, (short)form, (int)external_type, (boolean)forBind);
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, varcharAccessor);
                            ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, null);
                        }
                        return varcharAccessor;
                    }
                    T2CLongAccessor t2CLongAccessor = new T2CLongAccessor(this, (int)col_index, (int)max_len, (short)form, (int)external_type);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, t2CLongAccessor);
                        ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, null);
                    }
                    return t2CLongAccessor;
                }
                case 1: {
                    if (forBind == false) break;
                    if (typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, sQLException);
                        }
                        throw sQLException;
                    }
                    Accessor accessor = result = new T2CVarcharAccessor(this, (int)max_len, (short)form, (int)external_type, (boolean)forBind);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, accessor);
                        ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, null);
                    }
                    return accessor;
                }
                case 24: {
                    if (forBind != false && typeName != null) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + (int)external_type).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (forBind != false) {
                        OutRawAccessor outRawAccessor = new OutRawAccessor(this, (int)max_len, (short)form, (int)external_type);
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, outRawAccessor);
                            ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, null);
                        }
                        return outRawAccessor;
                    }
                    T2CLongRawAccessor t2CLongRawAccessor = new T2CLongRawAccessor(this, (int)col_index, (int)max_len, (short)form, (int)external_type);
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, t2CLongRawAccessor);
                        ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, null);
                    }
                    return t2CLongRawAccessor;
                }
            }
            Accessor accessor = super.allocateAccessor((int)internal_type, (int)external_type, (int)col_index, (int)max_len, (short)form, (String)typeName, (boolean)forBind);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, accessor);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, null);
            }
            return accessor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    void prepareBindPreambles(int n2, int n3) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$42, this, n2, n3);
            }
            int preambleSize = this.calculateIndicatorSubRangeSize();
            int currentPreambleIndex = this.bindIndicatorSubRange - preambleSize;
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int inout;
                OracleTypeADT otype;
                Binder binder = this.lastBinders[i2];
                if (binder == this.theReturnParamBinder) {
                    otype = (OracleTypeADT)this.accessors[i2].internalOtype;
                    inout = 0;
                } else {
                    OracleTypeADT oracleTypeADT = otype = this.binders[this.firstRowInBatch] == null ? null : this.getOtype(this.binders[this.firstRowInBatch][i2]);
                    if (this.outBindAccessors == null) {
                        inout = 0;
                    } else {
                        Accessor accessor = this.outBindAccessors[i2];
                        if (accessor == null) {
                            inout = 0;
                        } else if (binder == this.theOutBinder) {
                            inout = 1;
                            if (otype == null) {
                                otype = (OracleTypeADT)accessor.internalOtype;
                            }
                        } else {
                            inout = 2;
                        }
                    }
                    inout = binder.updateInoutIndicatorValue((short)inout);
                }
                this.bindIndicators[currentPreambleIndex++] = inout;
                if (otype != null) {
                    long tdo = otype.getTdoCState();
                    this.bindIndicators[currentPreambleIndex + 0] = (short)(tdo >> 48 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 1] = (short)(tdo >> 32 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 2] = (short)(tdo >> 16 & 0xFFFFL);
                    this.bindIndicators[currentPreambleIndex + 3] = (short)(tdo & 0xFFFFL);
                }
                currentPreambleIndex += 4;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$42, this);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$42, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    void releaseBuffers() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$43, this, new Object[0]);
            }
            super.releaseBuffers();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$43, this);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$43, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    void setLengthForOutAccessors() throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$44, this, new Object[0]);
            }
            if (this.outBindAccessors == null) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$44, this);
                    ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$44, this, null);
                }
                return;
            }
            Accessor a2 = null;
            for (int columnNumber = 0; columnNumber < this.numberOfBindPositions; ++columnNumber) {
                a2 = this.outBindAccessors[columnNumber];
                if (a2 == null || a2.defineType == 998 || a2.defineType == 111 || a2.defineType == 109) continue;
                for (int rowNumber = 0; rowNumber < this.binders.length; ++rowNumber) {
                    int length;
                    boolean isNull = a2.rowSpaceIndicator[a2.indicatorIndex + rowNumber] == -1;
                    int n2 = length = isNull ? 0 : a2.rowSpaceIndicator[a2.lengthIndex + rowNumber] & 0xFFFF;
                    if (this.sqlKind != OracleStatement.SqlKind.CALL_BLOCK && a2.externalType == -8) {
                        a2.setLengthAndNull(rowNumber, length);
                        continue;
                    }
                    if (a2.defineType == 9 || a2.defineType == 1) {
                        a2.setLengthAndNull(rowNumber, length / 2);
                        continue;
                    }
                    if (a2.defineType == 109 || a2.defineType == 111) continue;
                    a2.setLengthAndNull(rowNumber, length);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$44, this);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$44, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void doDescribe(boolean bl) throws SQLException {
        boolean bl2 = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean try_again;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$45, this, bl);
            }
            if (this.closed) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$45, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$45, this, sQLException);
                }
                throw sQLException;
            }
            if (this.described) {
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$45, this);
                    ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$45, this, null);
                }
                return;
            }
            if (!this.isOpen) {
                this.connection.open(this);
                this.isOpen = true;
            }
            do {
                try_again = false;
                boolean needToExecute = this.sqlKind.isSELECT() && this.needToParse && (!this.described || !this.serverCursor);
                byte[] array_sql = needToExecute ? this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals) : PhysicalConnection.EMPTY_BYTE_ARRAY;
                this.numberOfDefinePositions = T2CStatement.t2cDescribe(this.c_state, this.t2cConnection.queryMetaData1, this.t2cConnection.queryMetaData2, this.t2cConnection.queryMetaData1Offset, this.t2cConnection.queryMetaData2Offset, this.t2cConnection.queryMetaData1Size, this.t2cConnection.queryMetaData2Size, array_sql, array_sql.length, needToExecute);
                if (!this.described) {
                    this.described = true;
                }
                if (this.numberOfDefinePositions == -1) {
                    this.t2cConnection.checkError(this.numberOfDefinePositions);
                }
                if (this.numberOfDefinePositions != T2C_EXTEND_BUFFER) continue;
                try_again = true;
                this.t2cConnection.reallocateQueryMetaData(this.t2cConnection.queryMetaData1Size * 2, this.t2cConnection.queryMetaData2Size * 2);
            } while (try_again);
            this.processDescribeData();
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$45, this);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$45, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$45, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void configureRowData() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$46, this, new Object[0]);
            }
            this.rowData = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
            DynamicByteArray adtByteArray = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
            T2CCharByteArray ibtBindCharsArray = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, (ByteArray)adtByteArray);
            AggregateByteArray ibtBindBytesArray = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, ibtBindCharsArray);
            T2CCharByteArray bindCharArray = new T2CCharByteArray(PhysicalConnection.EMPTY_CHAR_ARRAY, (ByteArray)ibtBindBytesArray);
            this.bindData = new AggregateByteArray(PhysicalConnection.EMPTY_BYTE_ARRAY, bindCharArray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean isThinDriver() {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$47, this, new Object[0]);
            }
            boolean bl2 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$47, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$47, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void resetBindersToNull(int n2) {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$48, this, n2);
            }
            if (this.binders != null) {
                for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    for (int rowInBuffers = 0; rowInBuffers < this.numberOfBoundRows; ++rowInBuffers) {
                        void first_row_to_be_bound;
                        void rowInBinders = first_row_to_be_bound + rowInBuffers;
                        this.binders[rowInBinders][bindPos] = null;
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$48, this);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$48, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$48, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void setupBindBuffers(int n2, int n3) throws SQLException {
        boolean bl = (0x2000000L & TraceControllerImpl.feature) != 0L;
        try {
            void number_of_rows_to_be_bound;
            block62: {
                block63: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, n2, n3);
                    }
                    if (!$assertionsDisabled && this.bindUseDBA) {
                        AssertionError assertionError = new AssertionError((Object)"bindUseDBA is true for T2C or T2S driver.");
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, (Throwable)((Object)assertionError));
                        }
                        throw assertionError;
                    }
                    if (this.bindIndicators == null) {
                        this.allocBinds((int)number_of_rows_to_be_bound);
                    }
                    if (this.numberOfBindPositions != 0) break block62;
                    if (number_of_rows_to_be_bound != false) {
                        this.numberOfBoundRows = number_of_rows_to_be_bound;
                        this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
                        this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
                    }
                    if (!bl) break block63;
                    ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this);
                    ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, null);
                }
                return;
            }
            try {
                void first_row_to_be_bound;
                int per_position_metadata_offset;
                this.preparedAllBinds = this.currentBatchNeedToPrepareBinds;
                this.preparedByteBinds = false;
                this.preparedCharBinds = false;
                this.currentBatchNeedToPrepareBinds = false;
                this.numberOfBoundRows = number_of_rows_to_be_bound;
                this.bindIndicators[this.bindIndicatorSubRange + 3] = (short)((this.numberOfBoundRows & 0xFFFF0000) >> 16);
                this.bindIndicators[this.bindIndicatorSubRange + 4] = (short)(this.numberOfBoundRows & 0xFFFF);
                int number_of_rows_to_be_set_up = this.bindBufferCapacity;
                if (this.numberOfBoundRows > this.bindBufferCapacity) {
                    number_of_rows_to_be_set_up = this.numberOfBoundRows;
                    this.preparedAllBinds = true;
                }
                if (this.currentBatchBindAccessors != null) {
                    if (this.outBindAccessors == null) {
                        this.outBindAccessors = new Accessor[this.numberOfBindPositions];
                    }
                    for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                        Accessor accessor;
                        this.outBindAccessors[bindPos] = accessor = this.currentBatchBindAccessors[bindPos];
                        if (accessor == null) continue;
                        int bytelen = accessor.byteLength;
                        int charlen = accessor.charLength;
                        if (this.currentBatchByteLens[bindPos] < bytelen) {
                            this.currentBatchByteLens[bindPos] = bytelen;
                        }
                        if (charlen != 0 && this.currentBatchCharLens[bindPos] >= charlen) continue;
                        this.currentBatchCharLens[bindPos] = charlen;
                    }
                }
                int row_charlen = 0;
                int row_bytelen = 0;
                int metadata_offset = per_position_metadata_offset = this.bindIndicatorSubRange + 5;
                if (this.preparedAllBinds) {
                    this.preparedByteBinds = true;
                    this.preparedCharBinds = true;
                    Binder[] firstRankBinders = this.binders[first_row_to_be_bound];
                    for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                        short type;
                        Binder binder = firstRankBinders[bindPos];
                        int bytelen = this.currentBatchByteLens[bindPos];
                        int charlen = this.currentBatchCharLens[bindPos];
                        if (binder == this.theOutBinder) {
                            Accessor accessor = this.currentBatchBindAccessors[bindPos];
                            type = (short)accessor.defineType;
                        } else {
                            type = binder.type;
                        }
                        row_bytelen += bytelen;
                        row_charlen += charlen;
                        this.bindIndicators[metadata_offset + 0] = type;
                        this.bindIndicators[metadata_offset + 1] = (short)bytelen;
                        this.bindIndicators[metadata_offset + 2] = (short)charlen;
                        this.bindIndicators[metadata_offset + 9] = this.currentBatchFormOfUse[bindPos];
                        metadata_offset += 10;
                    }
                } else if (this.preparedByteBinds | this.preparedCharBinds) {
                    for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                        int bytelen = this.currentBatchByteLens[bindPos];
                        int charlen = this.currentBatchCharLens[bindPos];
                        row_bytelen += bytelen;
                        row_charlen += charlen;
                        this.bindIndicators[metadata_offset + 1] = (short)bytelen;
                        this.bindIndicators[metadata_offset + 2] = (short)charlen;
                        metadata_offset += 10;
                    }
                } else {
                    for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                        boolean wasLastBindNull;
                        int bytePitchOffset = metadata_offset + 1;
                        int charPitchOffset = metadata_offset + 2;
                        int bytelen = this.currentBatchByteLens[bindPos];
                        int charlen = this.currentBatchCharLens[bindPos];
                        int oldbytelen = this.bindIndicators[bytePitchOffset];
                        int oldcharlen = this.bindIndicators[charPitchOffset];
                        int ind_offset = (this.bindIndicators[metadata_offset + 5] << 16) + (this.bindIndicators[metadata_offset + 6] & 0xFFFF);
                        boolean bl2 = wasLastBindNull = this.bindIndicators[ind_offset] == -1;
                        if (wasLastBindNull && bytelen > 1) {
                            this.preparedByteBinds = true;
                        }
                        if (oldbytelen >= bytelen && !this.preparedByteBinds) {
                            this.currentBatchByteLens[bindPos] = oldbytelen;
                            row_bytelen += oldbytelen;
                        } else {
                            this.bindIndicators[bytePitchOffset] = (short)bytelen;
                            row_bytelen += bytelen;
                            this.preparedByteBinds = true;
                        }
                        if (wasLastBindNull && charlen > 1) {
                            this.preparedCharBinds = true;
                        }
                        if (oldcharlen >= charlen && !this.preparedCharBinds) {
                            this.currentBatchCharLens[bindPos] = oldcharlen;
                            row_charlen += oldcharlen;
                        } else {
                            this.bindIndicators[charPitchOffset] = (short)charlen;
                            row_charlen += charlen;
                            this.preparedCharBinds = true;
                        }
                        metadata_offset += 10;
                    }
                }
                if (this.preparedByteBinds | this.preparedCharBinds) {
                    this.initializeBindSubRanges(this.numberOfBoundRows, number_of_rows_to_be_set_up);
                }
                if (this.preparedByteBinds) {
                    int total_bytelen = this.bindByteSubRange + row_bytelen * number_of_rows_to_be_set_up;
                    if (this.lastBoundNeeded || total_bytelen > this.totalBindByteLength) {
                        this.bindByteOffset = 0;
                        this.bindBytes = this.connection.getByteBuffer(total_bytelen);
                        this.totalBindByteLength = total_bytelen;
                    }
                    this.bindBufferCapacity = number_of_rows_to_be_set_up;
                    this.bindIndicators[this.bindIndicatorSubRange + 1] = (short)((this.bindBufferCapacity & 0xFFFF0000) >> 16);
                    this.bindIndicators[this.bindIndicatorSubRange + 2] = (short)(this.bindBufferCapacity & 0xFFFF);
                }
                if (this.preparedCharBinds) {
                    int total_charlen = this.bindCharSubRange + row_charlen * this.bindBufferCapacity;
                    if (this.lastBoundNeeded || total_charlen > this.totalBindCharLength) {
                        this.bindCharOffset = 0;
                        this.bindChars = this.connection.getCharBuffer(total_charlen);
                        this.totalBindCharLength = total_charlen;
                    }
                    this.bindByteSubRange += this.bindByteOffset;
                    this.bindCharSubRange += this.bindCharOffset;
                }
                int byteoffset = this.bindByteSubRange;
                int charoffset = this.bindCharSubRange;
                int indoffset = this.indicatorsOffset;
                int lenoffset = this.valueLengthsOffset;
                metadata_offset = per_position_metadata_offset;
                if (this.preparedByteBinds | this.preparedCharBinds) {
                    int valueoffset;
                    int bytelen;
                    int bindPos;
                    if (this.currentBatchBindAccessors == null) {
                        for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                            bytelen = this.currentBatchByteLens[bindPos];
                            int charlen = this.currentBatchCharLens[bindPos];
                            valueoffset = charlen == 0 ? byteoffset : charoffset;
                            this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                            this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                            byteoffset += bytelen * this.bindBufferCapacity;
                            charoffset += charlen * this.bindBufferCapacity;
                            metadata_offset += 10;
                        }
                    } else {
                        for (bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                            bytelen = this.currentBatchByteLens[bindPos];
                            int charlen = this.currentBatchCharLens[bindPos];
                            valueoffset = charlen == 0 ? byteoffset : charoffset;
                            this.bindIndicators[metadata_offset + 3] = (short)(valueoffset >> 16);
                            this.bindIndicators[metadata_offset + 4] = (short)(valueoffset & 0xFFFF);
                            Accessor accessor = this.currentBatchBindAccessors[bindPos];
                            if (accessor != null) {
                                if (charlen > 0) {
                                    accessor.columnDataOffset = charoffset;
                                    accessor.charLength = charlen;
                                } else {
                                    accessor.columnDataOffset = byteoffset;
                                    accessor.byteLength = bytelen;
                                }
                                accessor.lengthIndex = lenoffset;
                                accessor.indicatorIndex = indoffset;
                                accessor.rowSpaceIndicator = this.bindIndicators;
                                accessor.setCapacity(this.bindBufferCapacity);
                            }
                            byteoffset += bytelen * this.bindBufferCapacity;
                            charoffset += charlen * this.bindBufferCapacity;
                            indoffset += this.numberOfBindRowsAllocated;
                            lenoffset += this.numberOfBindRowsAllocated;
                            metadata_offset += 10;
                        }
                    }
                    byteoffset = this.bindByteSubRange;
                    charoffset = this.bindCharSubRange;
                    indoffset = this.indicatorsOffset;
                    lenoffset = this.valueLengthsOffset;
                    metadata_offset = per_position_metadata_offset;
                }
                int unused_rows = this.bindBufferCapacity - this.numberOfBoundRows;
                int lastrow_in_buffers = this.numberOfBoundRows - 1;
                int lastrow_in_binders = lastrow_in_buffers + first_row_to_be_bound;
                Binder[] lastRowBinders = this.binders[lastrow_in_binders];
                if (this.hasIbtBind) {
                    this.processPlsqlIndexTabBinds((int)first_row_to_be_bound);
                }
                if (this.numReturnParams > 0 && (this.accessors == null || this.accessors.length < this.numReturnParams)) {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 173).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, sQLException);
                    }
                    throw sQLException;
                }
                if (this.numReturnParams > 0) {
                    this.processDmlReturningBind();
                }
                boolean clearPriorBindValues = !this.sqlKind.isPlsqlOrCall() || this.currentRowBindAccessors == null;
                this.localCheckSum = this.checkSum;
                for (int bindPos = 0; bindPos < this.numberOfBindPositions; ++bindPos) {
                    int bytelen = this.currentBatchByteLens[bindPos];
                    int charlen = this.currentBatchCharLens[bindPos];
                    short formOfUse = this.currentBatchFormOfUse[bindPos];
                    this.lastBinders[bindPos] = lastRowBinders[bindPos];
                    this.lastBoundByteLens[bindPos] = bytelen;
                    for (int rowInBuffers = 0; rowInBuffers < this.numberOfBoundRows; ++rowInBuffers) {
                        void rowInBinders = first_row_to_be_bound + rowInBuffers;
                        int bindDataIndex = rowInBuffers * this.numberOfBindPositions + bindPos;
                        if (bl) {
                            OracleLog.debug($$$loggerRef$$$49, Level.FINEST, this.getClass(), $$$methodRef$$$49, "rowInBinders: " + (int)rowInBinders + " bindPos: " + bindPos + " binders[rowInBinders][bindPos]" + this.binders[rowInBinders][bindPos].getClass().getName());
                        }
                        try {
                            this.localCheckSum = this.binders[rowInBinders][bindPos].bind(this, bindPos, rowInBuffers, (int)rowInBinders, this.bindBytes, this.bindChars, this.bindIndicators, bytelen, charlen, byteoffset, charoffset, lenoffset + rowInBuffers, indoffset + rowInBuffers, clearPriorBindValues, this.localCheckSum, this.bindData, this.bindDataOffsets, this.bindDataLengths, bindDataIndex, this.bindUseDBA, formOfUse);
                            if (this.userStream != null) {
                                this.userStream[rowInBuffers][bindPos] = null;
                            }
                            byteoffset += bytelen;
                            charoffset += charlen;
                            continue;
                        }
                        catch (SQLException se) {
                            SQLException sQLException = se;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                    if (this.bindChecksumListener != null) {
                        boolean contFlag = this.bindChecksumListener.shouldContinue(this.checkSum);
                        this.bindChecksumListener = null;
                        if (!contFlag) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 290).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                    this.lastBoundByteOffsets[bindPos] = byteoffset - bytelen;
                    this.lastBoundCharOffsets[bindPos] = charoffset - charlen;
                    this.lastBoundInds[bindPos] = this.bindIndicators[indoffset + lastrow_in_buffers];
                    this.lastBoundLens[bindPos] = this.bindIndicators[lenoffset + lastrow_in_buffers];
                    this.lastBoundByteLens[bindPos] = 0;
                    this.lastBoundCharLens[bindPos] = 0;
                    byteoffset += unused_rows * bytelen;
                    charoffset += unused_rows * charlen;
                    indoffset += this.numberOfBindRowsAllocated;
                    lenoffset += this.numberOfBindRowsAllocated;
                    metadata_offset += 10;
                }
                this.checkSum = this.localCheckSum;
                this.lastBoundBytes = this.bindBytes;
                this.lastBoundByteOffset = this.bindByteOffset;
                this.lastBoundChars = this.bindChars;
                this.lastBoundCharOffset = this.bindCharOffset;
                if (this.parameterStream != null) {
                    this.lastBoundStream = this.parameterStream[first_row_to_be_bound + this.numberOfBoundRows - true];
                }
                int[] tmpByteLens = this.currentBatchByteLens;
                this.currentBatchByteLens = this.lastBoundByteLens;
                this.lastBoundByteLens = tmpByteLens;
                int[] tmpCharLens = this.currentBatchCharLens;
                this.currentBatchCharLens = this.lastBoundCharLens;
                this.lastBoundCharLens = tmpCharLens;
                if (bl) {
                    OracleLog.debug($$$loggerRef$$$49, Level.FINEST, this.getClass(), $$$methodRef$$$49, "lastBoundNeeded set false point 4");
                }
                this.lastBoundNeeded = false;
                this.prepareBindPreambles(this.numberOfBoundRows, this.bindBufferCapacity);
                this.configureBindData();
                this.checkSum = this.localCheckSum;
                this.localCheckSum = 0L;
            }
            catch (NullPointerException e2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89, null, (Throwable)e2).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, T2CPreparedStatement.class, $$$methodRef$$$49, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$51 = T2CPreparedStatement.class.getDeclaredConstructor(T2CConnection.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$50 = T2CPreparedStatement.class.getDeclaredConstructor(T2CConnection.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$49 = T2CPreparedStatement.class.getDeclaredMethod("setupBindBuffers", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$48 = T2CPreparedStatement.class.getDeclaredMethod("resetBindersToNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$47 = T2CPreparedStatement.class.getDeclaredMethod("isThinDriver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$46 = T2CPreparedStatement.class.getDeclaredMethod("configureRowData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$45 = T2CPreparedStatement.class.getDeclaredMethod("doDescribe", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$44 = T2CPreparedStatement.class.getDeclaredMethod("setLengthForOutAccessors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$43 = T2CPreparedStatement.class.getDeclaredMethod("releaseBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$42 = T2CPreparedStatement.class.getDeclaredMethod("prepareBindPreambles", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$41 = T2CPreparedStatement.class.getDeclaredMethod("allocateAccessor", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Short.TYPE, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$40 = T2CPreparedStatement.class.getDeclaredMethod("allocateRowDataSpace", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$39 = T2CPreparedStatement.class.getDeclaredMethod("locationToPutBytes", Accessor.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$38 = T2CPreparedStatement.class.getDeclaredMethod("toHex", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$37 = T2CPreparedStatement.class.getDeclaredMethod("bit", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$36 = T2CPreparedStatement.class.getDeclaredMethod("updateData", Integer.TYPE, Integer.TYPE, Integer.TYPE, int[].class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$35 = T2CPreparedStatement.class.getDeclaredMethod("resetStateBeforeFetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$34 = T2CPreparedStatement.class.getDeclaredMethod("getInoutIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$33 = T2CPreparedStatement.class.getDeclaredMethod("calculateIndicatorSubRangeSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$32 = T2CPreparedStatement.class.getDeclaredMethod("initializeIndicatorSubRange", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$31 = T2CPreparedStatement.class.getDeclaredMethod("cleanupReturnParameterBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$30 = T2CPreparedStatement.class.getDeclaredMethod("allocateDmlReturnStorage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = T2CPreparedStatement.class.getDeclaredMethod("processDmlReturningBind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = T2CPreparedStatement.class.getDeclaredMethod("fetchDmlReturnParams", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T2CPreparedStatement.class.getDeclaredMethod("interalCloseOnIOException", IOException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T2CPreparedStatement.class.getDeclaredMethod("closeUsedStreams", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T2CPreparedStatement.class.getDeclaredMethod("closeQuery", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T2CPreparedStatement.class.getDeclaredMethod("doClose", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T2CPreparedStatement.class.getDeclaredMethod("extractNioDefineBuffers", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T2CPreparedStatement.class.getDeclaredMethod("resetNioAttributesBeforeFetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T2CPreparedStatement.class.getDeclaredMethod("fetch", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T2CPreparedStatement.class.getDeclaredMethod("doDefineExecuteFetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T2CPreparedStatement.class.getDeclaredMethod("allocateNioBuffersIfRequired", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T2CPreparedStatement.class.getDeclaredMethod("copyStreamDataIntoDBA", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T2CPreparedStatement.class.getDeclaredMethod("doDefineFetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T2CPreparedStatement.class.getDeclaredMethod("getRowsToFetch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T2CPreparedStatement.class.getDeclaredMethod("processLobPrefetchMetaData", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T2CPreparedStatement.class.getDeclaredMethod("getLobPrefetchMetaData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T2CPreparedStatement.class.getDeclaredMethod("initializePlsqlIndexByTableAccessor", Accessor.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T2CPreparedStatement.class.getDeclaredMethod("configureBindData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T2CPreparedStatement.class.getDeclaredMethod("setupForDefine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T2CPreparedStatement.class.getDeclaredMethod("executeForRows", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T2CPreparedStatement.class.getDeclaredMethod("pushEndToEndValues", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T2CPreparedStatement.class.getDeclaredMethod("checkForImplicitResultSets", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T2CPreparedStatement.class.getDeclaredMethod("executeForDescribe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T2CPreparedStatement.class.getDeclaredMethod("allocateAccessorForDefines", Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, OracleTypeADT.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T2CPreparedStatement.class.getDeclaredMethod("processDescribeData", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T2CPreparedStatement.class.getDeclaredMethod("bytes2String", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T2CPreparedStatement.class.getDeclaredMethod("prepareAccessors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T2CPreparedStatement.class.getDeclaredMethod("prepareForNewResults", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T2CPreparedStatement.class.getDeclaredMethod("setPrefetchInternal", Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T2CPreparedStatement.class.getDeclaredMethod("getPrefetchInternal", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        T2C_EXTEND_BUFFER = -3;
        PREAMBLE_PER_POSITION = 5;
    }
}

