/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.resolver.EnvVariableResolver;

public class LDAPSSLSocketFactory
extends SSLSocketFactory {
    static final ThreadLocal<Properties> connectionProperties;
    private static SSLSocketFactory defaultFactory;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    public static SocketFactory getDefault() {
        return new LDAPSSLSocketFactory();
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return defaultFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return defaultFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s2, String host, int port, boolean autoClose) throws IOException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(s2, host, port, autoClose), sslProperties);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(host, port), sslProperties);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(host, port), sslProperties);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(host, port, localHost, localPort), sslProperties);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Properties sslProperties = this.getSSLProperties(connectionProperties.get());
        return this.initializeSSLSocket((SSLSocket)this.getSSLSocketFactory(sslProperties).createSocket(address, port, localAddress, localPort), sslProperties);
    }

    private SSLSocketFactory getSSLSocketFactory(Properties sslProperties) throws IOException {
        return CustomSSLSocketFactory.getSSLSocketFactory(sslProperties);
    }

    private Properties getSSLProperties(Properties userProperties) {
        Enumeration<Object> e2 = userProperties.keys();
        Properties sslProps = new Properties();
        while (e2.hasMoreElements()) {
            String propertyValue;
            String propertyKey = (String)e2.nextElement();
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.walletLocation")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.walletLocation");
                sslProps.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(propertyValue, userProperties));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.walletPassword")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.walletPassword");
                sslProps.put((Object)16, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.supportedVersions")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.supportedVersions");
                sslProps.put((Object)6, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.supportedCiphers")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.supportedCiphers");
                sslProps.put((Object)7, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyStore")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.keyStore");
                sslProps.put((Object)8, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyStoreType")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.keyStoreType");
                sslProps.put((Object)9, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyStorePassword")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.keyStorePassword");
                sslProps.put((Object)10, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustStore")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.trustStore");
                sslProps.put((Object)11, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustStoreType")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.trustStoreType");
                sslProps.put((Object)12, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustStorePassword")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.trustStorePassword");
                sslProps.put((Object)13, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.keyManagerFactory.algorithm")) {
                propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
                sslProps.put((Object)14, propertyValue);
                continue;
            }
            if (!propertyKey.equalsIgnoreCase("oracle.net.ldap.ssl.trustManagerFactory.algorithm")) continue;
            propertyValue = userProperties.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
            sslProps.put((Object)15, propertyValue);
        }
        return sslProps;
    }

    private Socket initializeSSLSocket(SSLSocket sslSocket, Properties sslProps) {
        String supportedProtocolsStr = (String)sslProps.get(6);
        if (supportedProtocolsStr != null && !supportedProtocolsStr.trim().isEmpty()) {
            String[] supportedProtocols = supportedProtocolsStr.split(",");
            sslSocket.setEnabledProtocols(supportedProtocols);
        } else {
            sslSocket.setEnabledProtocols(sslSocket.getSupportedProtocols());
        }
        String supportedCiphersStr = (String)sslProps.get(7);
        if (supportedCiphersStr != null && !supportedCiphersStr.trim().isEmpty()) {
            String[] supportedCiphers = supportedCiphersStr.split(",");
            sslSocket.setEnabledCipherSuites(supportedCiphers);
        } else {
            sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
        }
        return sslSocket;
    }

    static {
        try {
            $$$methodRef$$$11 = LDAPSSLSocketFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LDAPSSLSocketFactory.class.getDeclaredMethod("initializeSSLSocket", SSLSocket.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LDAPSSLSocketFactory.class.getDeclaredMethod("getSSLProperties", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LDAPSSLSocketFactory.class.getDeclaredMethod("getSSLSocketFactory", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", InetAddress.class, Integer.TYPE, InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", String.class, Integer.TYPE, InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", InetAddress.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LDAPSSLSocketFactory.class.getDeclaredMethod("createSocket", Socket.class, String.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LDAPSSLSocketFactory.class.getDeclaredMethod("getSupportedCipherSuites", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LDAPSSLSocketFactory.class.getDeclaredMethod("getDefaultCipherSuites", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LDAPSSLSocketFactory.class.getDeclaredMethod("getDefault", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        connectionProperties = new ThreadLocal();
        defaultFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }
}

