/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.aq.AQMessage;
import oracle.jdbc.aq.AQNotificationRegistration;
import oracle.jdbc.dcn.DatabaseChangeRegistration;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.sql.ARRAY;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.DATE;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

@DisableTrace
public class OracleConnectionWrapper
implements oracle.jdbc.OracleConnection {
    protected oracle.jdbc.OracleConnection connection;
    private Map<Class, Object> proxies = new HashMap<Class, Object>(3);
    private static Map<Class, Class> proxyClasses = new HashMap<Class, Class>();

    public OracleConnectionWrapper() {
    }

    public OracleConnectionWrapper(oracle.jdbc.OracleConnection toBeWrapped) {
        this.connection = toBeWrapped;
        toBeWrapped.setWrapper(this);
    }

    @Override
    public oracle.jdbc.OracleConnection unwrap() {
        return this.connection;
    }

    @Override
    public OracleConnection physicalConnectionWithin() {
        return this.connection.physicalConnectionWithin();
    }

    public String getDatabaseTimeZone() throws SQLException {
        return this.physicalConnectionWithin().getDatabaseTimeZone();
    }

    @Override
    public void setWrapper(oracle.jdbc.OracleConnection wrapper) {
        this.connection.setWrapper(wrapper);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.connection.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public boolean isProxySession() {
        return this.connection.isProxySession();
    }

    @Override
    public void openProxySession(int mode, Properties prop) throws SQLException {
        this.connection.openProxySession(mode, prop);
    }

    @Override
    public void archive(int mode, int aseq, String acstext) throws SQLException {
        this.connection.archive(mode, aseq, acstext);
    }

    @Override
    public boolean getAutoClose() throws SQLException {
        return this.connection.getAutoClose();
    }

    @Override
    public CallableStatement getCallWithKey(String key) throws SQLException {
        return this.connection.getCallWithKey(key);
    }

    @Override
    public int getDefaultExecuteBatch() {
        return this.connection.getDefaultExecuteBatch();
    }

    @Override
    public int getDefaultRowPrefetch() {
        return this.connection.getDefaultRowPrefetch();
    }

    @Override
    public Object getDescriptor(String sql_name) {
        return this.connection.getDescriptor(sql_name);
    }

    @Override
    public String[] getEndToEndMetrics() throws SQLException {
        return this.connection.getEndToEndMetrics();
    }

    @Override
    public short getEndToEndECIDSequenceNumber() throws SQLException {
        return this.connection.getEndToEndECIDSequenceNumber();
    }

    @Override
    public boolean getIncludeSynonyms() {
        return this.connection.getIncludeSynonyms();
    }

    @Override
    public boolean getRestrictGetTables() {
        return this.connection.getRestrictGetTables();
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        return this.connection.getImplicitCachingEnabled();
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        return this.connection.getExplicitCachingEnabled();
    }

    @Override
    public Object getJavaObject(String sql_name) throws SQLException {
        return this.connection.getJavaObject(sql_name);
    }

    @Override
    public boolean getRemarksReporting() {
        return this.connection.getRemarksReporting();
    }

    @Override
    public String getSQLType(Object obj) throws SQLException {
        return this.connection.getSQLType(obj);
    }

    @Override
    public int getStmtCacheSize() {
        return this.connection.getStmtCacheSize();
    }

    @Override
    public int getStatementCacheSize() throws SQLException {
        return this.connection.getStatementCacheSize();
    }

    @Override
    public PreparedStatement getStatementWithKey(String key) throws SQLException {
        return this.connection.getStatementWithKey(key);
    }

    @Override
    public short getStructAttrCsId() throws SQLException {
        return this.connection.getStructAttrCsId();
    }

    @Override
    public String getUserName() throws SQLException {
        return this.connection.getUserName();
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        return this.connection.getCurrentSchema();
    }

    @Override
    public boolean getUsingXAFlag() {
        return this.connection.getUsingXAFlag();
    }

    @Override
    public boolean getXAErrorFlag() {
        return this.connection.getXAErrorFlag();
    }

    @Override
    public OracleSavepoint oracleSetSavepoint() throws SQLException {
        return this.connection.oracleSetSavepoint();
    }

    @Override
    public OracleSavepoint oracleSetSavepoint(String name) throws SQLException {
        return this.connection.oracleSetSavepoint(name);
    }

    @Override
    public void oracleRollback(OracleSavepoint savepoint) throws SQLException {
        this.connection.oracleRollback(savepoint);
    }

    @Override
    public void oracleReleaseSavepoint(OracleSavepoint savepoint) throws SQLException {
        this.connection.oracleReleaseSavepoint(savepoint);
    }

    @Override
    public int pingDatabase() throws SQLException {
        return this.connection.pingDatabase();
    }

    @Override
    public int pingDatabase(int timeOut) throws SQLException {
        return this.connection.pingDatabase(timeOut);
    }

    @Override
    public void purgeExplicitCache() throws SQLException {
        this.connection.purgeExplicitCache();
    }

    @Override
    public void purgeImplicitCache() throws SQLException {
        this.connection.purgeImplicitCache();
    }

    @Override
    public void putDescriptor(String sql_name, Object desc) throws SQLException {
        this.connection.putDescriptor(sql_name, desc);
    }

    @Override
    public void registerSQLType(String sql_name, Class java_class) throws SQLException {
        this.connection.registerSQLType(sql_name, java_class);
    }

    @Override
    public void registerSQLType(String sql_name, String java_class_name) throws SQLException {
        this.connection.registerSQLType(sql_name, java_class_name);
    }

    @Override
    public void setAutoClose(boolean autoClose) throws SQLException {
        this.connection.setAutoClose(autoClose);
    }

    @Override
    public void setDefaultExecuteBatch(int batch) throws SQLException {
        this.connection.setDefaultExecuteBatch(batch);
    }

    @Override
    public void setDefaultRowPrefetch(int value) throws SQLException {
        this.connection.setDefaultRowPrefetch(value);
    }

    @Override
    public void setEndToEndMetrics(String[] metrics, short sequenceNumber) throws SQLException {
        this.connection.setEndToEndMetrics(metrics, sequenceNumber);
    }

    @Override
    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        this.connection.setExplicitCachingEnabled(cache);
    }

    @Override
    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        this.connection.setImplicitCachingEnabled(cache);
    }

    @Override
    public void setIncludeSynonyms(boolean synonyms) {
        this.connection.setIncludeSynonyms(synonyms);
    }

    @Override
    public void setRemarksReporting(boolean reportRemarks) {
        this.connection.setRemarksReporting(reportRemarks);
    }

    @Override
    public void setRestrictGetTables(boolean restrict) {
        this.connection.setRestrictGetTables(restrict);
    }

    @Override
    public void setStmtCacheSize(int size) throws SQLException {
        this.connection.setStmtCacheSize(size);
    }

    @Override
    public void setStatementCacheSize(int size) throws SQLException {
        this.connection.setStatementCacheSize(size);
    }

    @Override
    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        this.connection.setStmtCacheSize(size, clearMetaData);
    }

    @Override
    public void setUsingXAFlag(boolean value) {
        this.connection.setUsingXAFlag(value);
    }

    @Override
    public void setXAErrorFlag(boolean value) {
        this.connection.setXAErrorFlag(value);
    }

    @Override
    public void shutdown(OracleConnection.DatabaseShutdownMode mode) throws SQLException {
        this.connection.shutdown(mode);
    }

    @Override
    public void startup(String startup_str, int mode) throws SQLException {
        this.connection.startup(startup_str, mode);
    }

    @Override
    public void startup(OracleConnection.DatabaseStartupMode mode) throws SQLException {
        this.connection.startup(mode);
    }

    @Override
    public void startup(OracleConnection.DatabaseStartupMode mode, String pfileName) throws SQLException {
        this.connection.startup(mode, pfileName);
    }

    @Override
    public PreparedStatement prepareStatementWithKey(String key) throws SQLException {
        return this.connection.prepareStatementWithKey(key);
    }

    @Override
    public CallableStatement prepareCallWithKey(String key) throws SQLException {
        return this.connection.prepareCallWithKey(key);
    }

    @Override
    public void setCreateStatementAsRefCursor(boolean value) {
        this.connection.setCreateStatementAsRefCursor(value);
    }

    @Override
    public boolean getCreateStatementAsRefCursor() {
        return this.connection.getCreateStatementAsRefCursor();
    }

    @Override
    public void setSessionTimeZone(String regionName) throws SQLException {
        this.connection.setSessionTimeZone(regionName);
    }

    @Override
    public String getSessionTimeZone() {
        return this.connection.getSessionTimeZone();
    }

    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        return this.connection.getSessionTimeZoneOffset();
    }

    @Override
    public Connection _getPC() {
        return this.connection._getPC();
    }

    @Override
    public boolean isLogicalConnection() {
        return this.connection.isLogicalConnection();
    }

    @Override
    public void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        this.connection.registerTAFCallback(cbk, obj);
    }

    @Override
    public Properties getProperties() {
        return this.connection.getProperties();
    }

    @Override
    public void close(Properties connAttr) throws SQLException {
        this.connection.close(connAttr);
    }

    @Override
    public void close(int opt) throws SQLException {
        this.connection.close(opt);
    }

    @Override
    public void applyConnectionAttributes(Properties connAttr) throws SQLException {
        this.connection.applyConnectionAttributes(connAttr);
    }

    @Override
    public Properties getConnectionAttributes() throws SQLException {
        return this.connection.getConnectionAttributes();
    }

    @Override
    public Properties getUnMatchedConnectionAttributes() throws SQLException {
        return this.connection.getUnMatchedConnectionAttributes();
    }

    @Override
    public void registerConnectionCacheCallback(OracleConnectionCacheCallback occc, Object userObj, int cbkFlag) throws SQLException {
        this.connection.registerConnectionCacheCallback(occc, userObj, cbkFlag);
    }

    @Override
    public void setConnectionReleasePriority(int priority) throws SQLException {
        this.connection.setConnectionReleasePriority(priority);
    }

    @Override
    public int getConnectionReleasePriority() throws SQLException {
        return this.connection.getConnectionReleasePriority();
    }

    @Override
    public void setPlsqlWarnings(String setting) throws SQLException {
        this.connection.setPlsqlWarnings(setting);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.connection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.connection.getHoldability();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        return this.connection.setSavepoint();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        return this.connection.setSavepoint(name);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.connection.rollback(savepoint);
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.connection.releaseSavepoint(savepoint);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.connection.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.connection.prepareStatement(sql, columnIndexes);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.connection.prepareStatement(sql, columnNames);
    }

    @Override
    public ARRAY createARRAY(String typeName, Object elements) throws SQLException {
        return this.connection.createARRAY(typeName, elements);
    }

    @Override
    public Array createOracleArray(String arrayTypeName, Object elements) throws SQLException {
        return this.connection.createOracleArray(arrayTypeName, elements);
    }

    @Override
    public BINARY_DOUBLE createBINARY_DOUBLE(double value) throws SQLException {
        return this.connection.createBINARY_DOUBLE(value);
    }

    @Override
    public BINARY_FLOAT createBINARY_FLOAT(float value) throws SQLException {
        return this.connection.createBINARY_FLOAT(value);
    }

    @Override
    public DATE createDATE(Date value) throws SQLException {
        return this.connection.createDATE(value);
    }

    @Override
    public DATE createDATE(Time value) throws SQLException {
        return this.connection.createDATE(value);
    }

    @Override
    public DATE createDATE(Timestamp value) throws SQLException {
        return this.connection.createDATE(value);
    }

    @Override
    public DATE createDATE(Date value, Calendar cal) throws SQLException {
        return this.connection.createDATE(value, cal);
    }

    @Override
    public DATE createDATE(Time value, Calendar cal) throws SQLException {
        return this.connection.createDATE(value, cal);
    }

    @Override
    public DATE createDATE(Timestamp value, Calendar cal) throws SQLException {
        return this.connection.createDATE(value, cal);
    }

    @Override
    public DATE createDATE(String value) throws SQLException {
        return this.connection.createDATE(value);
    }

    @Override
    public INTERVALDS createINTERVALDS(String value) throws SQLException {
        return this.connection.createINTERVALDS(value);
    }

    @Override
    public INTERVALYM createINTERVALYM(String value) throws SQLException {
        return this.connection.createINTERVALYM(value);
    }

    @Override
    public NUMBER createNUMBER(boolean value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(byte value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(short value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(int value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(long value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(float value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(double value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(BigDecimal value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(BigInteger value) throws SQLException {
        return this.connection.createNUMBER(value);
    }

    @Override
    public NUMBER createNUMBER(String value, int scale) throws SQLException {
        return this.connection.createNUMBER(value, scale);
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Date value) throws SQLException {
        return this.connection.createTIMESTAMP(value);
    }

    @Override
    public TIMESTAMP createTIMESTAMP(DATE value) throws SQLException {
        return this.connection.createTIMESTAMP(value);
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Time value) throws SQLException {
        return this.connection.createTIMESTAMP(value);
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Timestamp value) throws SQLException {
        return this.connection.createTIMESTAMP(value);
    }

    @Override
    public TIMESTAMP createTIMESTAMP(Timestamp value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMP(value, cal);
    }

    @Override
    public TIMESTAMP createTIMESTAMP(String value) throws SQLException {
        return this.connection.createTIMESTAMP(value);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Date value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value, cal);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Time value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value, cal);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value, cal);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(Timestamp value, ZoneId tzid) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value, tzid);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(String value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value, cal);
    }

    @Override
    public TIMESTAMPTZ createTIMESTAMPTZ(DATE value) throws SQLException {
        return this.connection.createTIMESTAMPTZ(value);
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Date value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPLTZ(value, cal);
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Time value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPLTZ(value, cal);
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(Timestamp value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPLTZ(value, cal);
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(String value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPLTZ(value, cal);
    }

    @Override
    public TIMESTAMPLTZ createTIMESTAMPLTZ(DATE value, Calendar cal) throws SQLException {
        return this.connection.createTIMESTAMPLTZ(value, cal);
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.connection.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.connection.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.connection.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.connection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.connection.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.connection.createStruct(typeName, attributes);
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.connection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.connection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.connection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.connection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.connection.getClientInfo();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this) || this.connection.isWrapperFor(iface);
        }
        throw (SQLException)DatabaseError.createSqlException(null, 177).fillInStackTrace();
    }

    protected <T> T proxyFor(Object obj, Class<T> iface) throws SQLException {
        try {
            Object proxy = this.proxies.get(iface);
            if (proxy == null) {
                Class<?> proxyClass = proxyClasses.get(iface);
                if (proxyClass == null) {
                    proxyClass = Proxy.getProxyClass(iface.getClassLoader(), iface);
                    proxyClasses.put(iface, proxyClass);
                }
                proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(new CloseInvocationHandler(this));
                this.proxies.put(iface, proxy);
            }
            return (T)proxy;
        }
        catch (Exception e2) {
            throw (SQLException)DatabaseError.createSqlException(null, 1, "Cannot construct proxy").fillInStackTrace();
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface()) {
            if (iface.isInstance(this)) {
                return (T)this;
            }
            return this.proxyFor(this.connection.unwrap(iface), iface);
        }
        throw (SQLException)DatabaseError.createSqlException(null, 177).fillInStackTrace();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.connection.abort(executor);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.connection.getNetworkTimeout();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.connection.getSchema();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.connection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.connection.setSchema(schema);
    }

    @Override
    public DatabaseChangeRegistration registerDatabaseChangeNotification(Properties options) throws SQLException {
        return this.connection.registerDatabaseChangeNotification(options);
    }

    @Override
    public DatabaseChangeRegistration getDatabaseChangeRegistration(int regid) throws SQLException {
        return this.connection.getDatabaseChangeRegistration(regid);
    }

    @Override
    public void unregisterDatabaseChangeNotification(DatabaseChangeRegistration registration) throws SQLException {
        this.connection.unregisterDatabaseChangeNotification(registration);
    }

    @Override
    public void unregisterDatabaseChangeNotification(int registrationId, String host, int tcpport) throws SQLException {
        this.connection.unregisterDatabaseChangeNotification(registrationId, host, tcpport);
    }

    @Override
    public void unregisterDatabaseChangeNotification(int registrationId) throws SQLException {
        this.connection.unregisterDatabaseChangeNotification(registrationId);
    }

    @Override
    public void unregisterDatabaseChangeNotification(long registrationId, String callback) throws SQLException {
        this.connection.unregisterDatabaseChangeNotification(registrationId, callback);
    }

    @Override
    public AQNotificationRegistration[] registerAQNotification(String[] name, Properties[] options, Properties globaloptions) throws SQLException {
        return this.connection.registerAQNotification(name, options, globaloptions);
    }

    @Override
    public void unregisterAQNotification(AQNotificationRegistration registration) throws SQLException {
        this.connection.unregisterAQNotification(registration);
    }

    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, byte[] tdo) throws SQLException {
        return this.connection.dequeue(queueName, opt, tdo);
    }

    @Override
    public AQMessage dequeue(String queueName, AQDequeueOptions opt, String typeName) throws SQLException {
        return this.connection.dequeue(queueName, opt, typeName);
    }

    @Override
    public void enqueue(String queueName, AQEnqueueOptions opt, AQMessage mesg) throws SQLException {
        this.connection.enqueue(queueName, opt, mesg);
    }

    @Override
    public void commit(EnumSet<OracleConnection.CommitOption> flags) throws SQLException {
        this.connection.commit(flags);
    }

    @Override
    public void cancel() throws SQLException {
        this.connection.cancel();
    }

    @Override
    public void abort() throws SQLException {
        this.connection.abort();
    }

    @Override
    public TypeDescriptor[] getAllTypeDescriptorsInCurrentSchema() throws SQLException {
        return this.connection.getAllTypeDescriptorsInCurrentSchema();
    }

    @Override
    public TypeDescriptor[] getTypeDescriptorsFromListInCurrentSchema(String[] typeNames) throws SQLException {
        return this.connection.getTypeDescriptorsFromListInCurrentSchema(typeNames);
    }

    @Override
    public TypeDescriptor[] getTypeDescriptorsFromList(String[][] schemaAndTypeNamePairs) throws SQLException {
        return this.connection.getTypeDescriptorsFromList(schemaAndTypeNamePairs);
    }

    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        return this.connection.getDataIntegrityAlgorithmName();
    }

    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        return this.connection.getEncryptionAlgorithmName();
    }

    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        return this.connection.getAuthenticationAdaptorName();
    }

    @Override
    public boolean isUsable() {
        return this.connection.isUsable();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public void setDefaultTimeZone(TimeZone tz) throws SQLException {
        this.connection.setDefaultTimeZone(tz);
    }

    @Override
    public TimeZone getDefaultTimeZone() throws SQLException {
        return this.connection.getDefaultTimeZone();
    }

    @Override
    public void setApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        this.connection.setApplicationContext(nameSpace, attribute, value);
    }

    @Override
    public void clearAllApplicationContext(String nameSpace) throws SQLException {
        this.connection.clearAllApplicationContext(nameSpace);
    }

    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        this.connection.addLogicalTransactionIdEventListener(listener);
    }

    @Override
    public void addLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener, Executor executor) throws SQLException {
        this.connection.addLogicalTransactionIdEventListener(listener, executor);
    }

    @Override
    public void removeLogicalTransactionIdEventListener(LogicalTransactionIdEventListener listener) throws SQLException {
        this.connection.removeLogicalTransactionIdEventListener(listener);
    }

    @Override
    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        return this.connection.getLogicalTransactionId();
    }

    @Override
    public boolean needToPurgeStatementCache() throws SQLException {
        return this.connection.needToPurgeStatementCache();
    }

    @Override
    public boolean attachServerConnection() throws SQLException {
        return this.connection.attachServerConnection();
    }

    @Override
    public void detachServerConnection(String tag) throws SQLException {
        this.connection.detachServerConnection(tag);
    }

    @Override
    public boolean isDRCPEnabled() throws SQLException {
        return this.connection.isDRCPEnabled();
    }

    @Override
    public boolean isDRCPMultitagEnabled() throws SQLException {
        return this.connection.isDRCPMultitagEnabled();
    }

    @Override
    public String getDRCPReturnTag() throws SQLException {
        return this.connection.getDRCPReturnTag();
    }

    @Override
    public String getDRCPPLSQLCallbackName() throws SQLException {
        return this.connection.getDRCPPLSQLCallbackName();
    }

    @Override
    public void beginRequest() throws SQLException {
        this.connection.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.connection.endRequest();
    }

    @Override
    public void setShardingKey(OracleShardingKey key, OracleShardingKey superKey) throws SQLException {
        this.connection.setShardingKey(key, superKey);
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey key, OracleShardingKey superKey, int timeout) throws SQLException {
        return this.connection.setShardingKeyIfValid(key, superKey, timeout);
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, int timeout) throws SQLException {
        return this.connection.setShardingKeyIfValid(shardingKey, timeout);
    }

    @Override
    public void setShardingKey(OracleShardingKey shardingKey) throws SQLException {
        this.connection.setShardingKey(shardingKey);
    }

    @Override
    public OracleConnection.DRCPState getDRCPState() throws SQLException {
        return this.connection.getDRCPState();
    }

    @Override
    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        return this.connection.isValid(effort, timeout);
    }

    @Override
    public String getEncryptionProviderName() throws SQLException {
        return this.connection.getEncryptionProviderName();
    }

    @Override
    public String getChecksumProviderName() throws SQLException {
        return this.connection.getChecksumProviderName();
    }

    protected class CloseInvocationHandler
    implements InvocationHandler {
        private OracleConnectionWrapper wrapper;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;

        protected CloseInvocationHandler(OracleConnectionWrapper wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.wrapper, args);
            }
            catch (IllegalArgumentException e2) {
                return method.invoke((Object)this.wrapper.connection, args);
            }
        }

        static {
            try {
                $$$methodRef$$$1 = CloseInvocationHandler.class.getDeclaredConstructor(OracleConnectionWrapper.class, OracleConnectionWrapper.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = CloseInvocationHandler.class.getDeclaredMethod("invoke", Object.class, Method.class, Object[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

