/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.BFILE;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class BfileAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 530;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    BfileAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.BFILE, stmt, 530, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, BfileAccessor.class, $$$methodRef$$$8, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 114, 114, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, BfileAccessor.class, $$$methodRef$$$8, null);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, BfileAccessor.class, $$$methodRef$$$8, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, BfileAccessor.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    BfileAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.BFILE, stmt, 530, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, BfileAccessor.class, $$$methodRef$$$9, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 114, 114, form, false);
            this.initForDescribe(114, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, BfileAccessor.class, $$$methodRef$$$9, null);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, BfileAccessor.class, $$$methodRef$$$9, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, BfileAccessor.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BfileAccessor.class, $$$methodRef$$$0, this, n2);
            }
            BFILE bFILE = this.getBFILE((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BfileAccessor.class, $$$methodRef$$$0, this, bFILE);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BfileAccessor.class, $$$methodRef$$$0, this, null);
            }
            return bFILE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BfileAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BfileAccessor.class, $$$methodRef$$$1, this, n2, map);
            }
            BFILE bFILE = this.getBFILE((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BfileAccessor.class, $$$methodRef$$$1, this, bFILE);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BfileAccessor.class, $$$methodRef$$$1, this, null);
            }
            return bFILE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BfileAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BfileAccessor.class, $$$methodRef$$$2, this, n2);
            }
            BFILE bFILE = this.getBFILE((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BfileAccessor.class, $$$methodRef$$$2, this, bFILE);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BfileAccessor.class, $$$methodRef$$$2, this, null);
            }
            return bFILE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BfileAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    BFILE getBFILE(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, BfileAccessor.class, $$$methodRef$$$3, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                BFILE bFILE = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BfileAccessor.class, $$$methodRef$$$3, this, bFILE);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BfileAccessor.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            BFILE result = new BFILE(this.statement.connection, this.getBytesInternal((int)currentRow));
            if (this.isPrefetched()) {
                result.setLength(this.getPrefetchedLength((int)currentRow));
            }
            BFILE bFILE = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BfileAccessor.class, $$$methodRef$$$3, this, bFILE);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BfileAccessor.class, $$$methodRef$$$3, this, null);
            }
            return bFILE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BfileAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            BFILE file;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, BfileAccessor.class, $$$methodRef$$$4, this, n2);
            }
            if ((file = this.getBFILE((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BfileAccessor.class, $$$methodRef$$$4, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BfileAccessor.class, $$$methodRef$$$4, this, null);
                }
                return null;
            }
            InputStream inputStream = file.asciiStreamValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BfileAccessor.class, $$$methodRef$$$4, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BfileAccessor.class, $$$methodRef$$$4, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BfileAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            BFILE file;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, BfileAccessor.class, $$$methodRef$$$5, this, n2);
            }
            if ((file = this.getBFILE((int)currentRow)) == null) {
                Reader reader = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BfileAccessor.class, $$$methodRef$$$5, this, reader);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BfileAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            Reader reader = file.characterStreamValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BfileAccessor.class, $$$methodRef$$$5, this, reader);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BfileAccessor.class, $$$methodRef$$$5, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BfileAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            BFILE file;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, BfileAccessor.class, $$$methodRef$$$6, this, n2);
            }
            if ((file = this.getBFILE((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, BfileAccessor.class, $$$methodRef$$$6, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BfileAccessor.class, $$$methodRef$$$6, this, null);
                }
                return null;
            }
            InputStream inputStream = file.getBinaryStream();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, BfileAccessor.class, $$$methodRef$$$6, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BfileAccessor.class, $$$methodRef$$$6, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BfileAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBytes(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            BFILE lob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, n2);
            }
            if ((lob = this.getBFILE((int)currentRow)) == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, null);
                }
                return null;
            }
            InputStream r2 = lob.getBinaryStream();
            int size = 4096;
            int length = 0;
            ByteArrayOutputStream w2 = new ByteArrayOutputStream(size);
            byte[] buffer = new byte[size];
            try {
                while ((length = r2.read(buffer)) != -1) {
                    w2.write(buffer, 0, length);
                }
            }
            catch (IOException ex) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ex).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            catch (IndexOutOfBoundsException x2) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            byte[] byArray = w2.toByteArray();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BfileAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$9 = BfileAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = BfileAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = BfileAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = BfileAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = BfileAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = BfileAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BfileAccessor.class.getDeclaredMethod("getBFILE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BfileAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BfileAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BfileAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

