/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.BLOB;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class BlobAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    BlobAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        super(Representation.BLOB, stmt, 4000, forBind);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, BlobAccessor.class, $$$methodRef$$$11, null, stmt, max_len, form, external_type, forBind);
            }
            this.init(stmt, 113, 113, form, forBind);
            this.initForDataAccess(external_type, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, BlobAccessor.class, $$$methodRef$$$11, null);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, BlobAccessor.class, $$$methodRef$$$11, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, BlobAccessor.class, $$$methodRef$$$11, null, throwable2);
            }
            throw throwable;
        }
    }

    BlobAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.BLOB, stmt, 4000, false);
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, BlobAccessor.class, $$$methodRef$$$12, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form);
            }
            this.init(stmt, 113, 113, form, false);
            this.initForDescribe(113, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
            this.initForDataAccess(0, max_len, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, BlobAccessor.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, BlobAccessor.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, BlobAccessor.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, BlobAccessor.class, $$$methodRef$$$0, this, n2);
            }
            BLOB bLOB = this.getBLOB((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, BlobAccessor.class, $$$methodRef$$$0, this, bLOB);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlobAccessor.class, $$$methodRef$$$0, this, null);
            }
            return bLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, BlobAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2, Map map) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, BlobAccessor.class, $$$methodRef$$$1, this, n2, map);
            }
            BLOB bLOB = this.getBLOB((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, BlobAccessor.class, $$$methodRef$$$1, this, bLOB);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlobAccessor.class, $$$methodRef$$$1, this, null);
            }
            return bLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, BlobAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, BlobAccessor.class, $$$methodRef$$$2, this, n2);
            }
            BLOB bLOB = this.getBLOB((int)currentRow);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, BlobAccessor.class, $$$methodRef$$$2, this, bLOB);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlobAccessor.class, $$$methodRef$$$2, this, null);
            }
            return bLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, BlobAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    BLOB getBLOB(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, BlobAccessor.class, $$$methodRef$$$3, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                BLOB bLOB = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BlobAccessor.class, $$$methodRef$$$3, this, bLOB);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BlobAccessor.class, $$$methodRef$$$3, this, null);
                }
                return null;
            }
            BLOB result = new BLOB(this.statement.connection, this.getBytesInternal((int)currentRow));
            if (this.isPrefetched()) {
                result.setActivePrefetch(true);
                result.setLength(this.getPrefetchedLength((int)currentRow));
                result.setChunkSize(this.getPrefetchedChunkSize((int)currentRow));
                result.setPrefetchedData(this.getPrefetchedData((int)currentRow));
            }
            if (result.isTemporary()) {
                this.statement.connection.addTemporaryLob(result);
            }
            BLOB bLOB = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, BlobAccessor.class, $$$methodRef$$$3, this, bLOB);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BlobAccessor.class, $$$methodRef$$$3, this, null);
            }
            return bLOB;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, BlobAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getAsciiStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            BLOB blob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, BlobAccessor.class, $$$methodRef$$$4, this, n2);
            }
            if ((blob = this.getBLOB((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BlobAccessor.class, $$$methodRef$$$4, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BlobAccessor.class, $$$methodRef$$$4, this, null);
                }
                return null;
            }
            if (blob.isTemporary()) {
                this.statement.addToTempLobsToFree(blob);
            }
            InputStream inputStream = blob.asciiStreamValue();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, BlobAccessor.class, $$$methodRef$$$4, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BlobAccessor.class, $$$methodRef$$$4, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, BlobAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Reader getCharacterStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            BLOB blob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, BlobAccessor.class, $$$methodRef$$$5, this, n2);
            }
            if ((blob = this.getBLOB((int)currentRow)) == null) {
                Reader reader = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BlobAccessor.class, $$$methodRef$$$5, this, reader);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BlobAccessor.class, $$$methodRef$$$5, this, null);
                }
                return null;
            }
            if (blob.isTemporary()) {
                this.statement.addToTempLobsToFree(blob);
            }
            Reader reader = blob.characterStreamValue(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, BlobAccessor.class, $$$methodRef$$$5, this, reader);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BlobAccessor.class, $$$methodRef$$$5, this, null);
            }
            return reader;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, BlobAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    InputStream getBinaryStream(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            BLOB blob;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, BlobAccessor.class, $$$methodRef$$$6, this, n2);
            }
            if ((blob = this.getBLOB((int)currentRow)) == null) {
                InputStream inputStream = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, BlobAccessor.class, $$$methodRef$$$6, this, inputStream);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BlobAccessor.class, $$$methodRef$$$6, this, null);
                }
                return null;
            }
            if (blob.isTemporary()) {
                this.statement.addToTempLobsToFree(blob);
            }
            InputStream inputStream = blob.getBinaryStream(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, BlobAccessor.class, $$$methodRef$$$6, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BlobAccessor.class, $$$methodRef$$$6, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, BlobAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte[] getBytes(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, n2);
            }
            if (this.isNull((int)currentRow)) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, null);
                }
                return null;
            }
            if (this.isPrefetched() && this.getPrefetchedLength((int)currentRow) > Integer.MAX_VALUE) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, sQLException);
                }
                throw sQLException;
            }
            if (this.isPrefetched() && (long)this.getPrefetchedDataLength((int)currentRow) == this.getPrefetchedLength((int)currentRow)) {
                byte[] byArray = this.getPrefetchedData((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, null);
                }
                return byArray;
            }
            BLOB blob = this.getBLOB((int)currentRow);
            if (blob == null) {
                byte[] byArray = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, byArray);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, null);
                }
                return null;
            }
            if (blob.isTemporary()) {
                this.statement.addToTempLobsToFree(blob);
            }
            byte[] byArray = blob.getBytes(1L, (int)blob.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, BlobAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    String getString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, BlobAccessor.class, $$$methodRef$$$8, this, n2);
            }
            this.unimpl("getString/getNString");
            String string = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, BlobAccessor.class, $$$methodRef$$$8, this, string);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, BlobAccessor.class, $$$methodRef$$$8, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, BlobAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    String getNString(int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, BlobAccessor.class, $$$methodRef$$$9, this, n2);
            }
            this.unimpl("getNString");
            String string = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, BlobAccessor.class, $$$methodRef$$$9, this, string);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, BlobAccessor.class, $$$methodRef$$$9, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, BlobAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, BlobAccessor.class, $$$methodRef$$$10, this, l2, n2);
            }
            this.unimpl("updateChecksum");
            long l3 = -1L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, BlobAccessor.class, $$$methodRef$$$10, this, l3);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, BlobAccessor.class, $$$methodRef$$$10, this, null);
            }
            return -1L;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, BlobAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = BlobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = BlobAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = BlobAccessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = BlobAccessor.class.getDeclaredMethod("getNString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = BlobAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = BlobAccessor.class.getDeclaredMethod("getBytes", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = BlobAccessor.class.getDeclaredMethod("getBinaryStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = BlobAccessor.class.getDeclaredMethod("getCharacterStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = BlobAccessor.class.getDeclaredMethod("getAsciiStream", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = BlobAccessor.class.getDeclaredMethod("getBLOB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = BlobAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = BlobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = BlobAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

