/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DiagnosabilityMXBean;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.runtime.TraceController;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DisableTrace
public class OracleDiagnosabilityMBean
extends StandardMBean
implements DiagnosabilityMXBean {
    private final TraceController tc = new TraceControllerImpl();

    public OracleDiagnosabilityMBean() {
        super(DiagnosabilityMXBean.class, true);
    }

    @Override
    public boolean getLoggingEnabled() {
        return OracleLog.isEnabled();
    }

    @Override
    public void setLoggingEnabled(boolean enable) {
        OracleLog.setTrace(enable);
    }

    @Override
    public boolean stateManageable() {
        return false;
    }

    @Override
    public boolean statisticsProvider() {
        return false;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return DatabaseError.findMessage("DiagnosabilityMBeanDescription", (Object)this);
    }

    @Override
    protected String getDescription(MBeanConstructorInfo info) {
        return DatabaseError.findMessage("DiagnosabilityMBeanConstructor()", (Object)this);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String n2 = info.getName();
        if (n2.equals("LoggingEnabled")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanLoggingEnabledDescription", (Object)this);
        }
        if (n2.equals("stateManageable")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStateManageableDescription", (Object)this);
        }
        if (n2.equals("statisticsProvider")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStatisticsProviderDescription", (Object)this);
        }
        if (n2.equals("TraceController")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanTraceControllerDescription", (Object)this);
        }
        if (n2.equals("suspend")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanSuspendDescription", (Object)this);
        }
        if (n2.equals("resume")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanResumeDescription", (Object)this);
        }
        if (n2.equals("trace")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanTraceDescription", (Object)this);
        }
        Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Got a request to describe an unexpected  Attribute: " + n2);
        return super.getDescription(info);
    }

    @Override
    public TraceController getTraceController() {
        return this.tc;
    }

    public void trace(boolean enable, Feature ... features) {
        this.tc.trace(enable, features);
    }

    @Override
    public void suspend() {
        this.tc.suspend();
    }

    @Override
    public void resume() {
        this.tc.resume();
    }

    @Override
    public void trace(boolean enable, String feature) {
        for (Feature f2 : this.tc.getSupportedFeatures()) {
            if (0 != f2.toString().compareToIgnoreCase(feature)) continue;
            this.tc.trace(enable, f2);
            return;
        }
        throw new IllegalArgumentException("unknown \"" + feature + "\", supported: " + Arrays.toString((Object[])this.tc.getSupportedFeatures()));
    }
}

