/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.jdbc.pool.OraclePooledConnection;

@DefaultLogger(value="oracle.jdbc")
class OracleImplicitConnectionCacheThread
extends Thread {
    private OracleImplicitConnectionCache implicitCache = null;
    protected boolean timeToLive = true;
    protected boolean isSleeping = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    OracleImplicitConnectionCacheThread(OracleImplicitConnectionCache oicc) throws SQLException {
        this.implicitCache = oicc;
    }

    @Override
    public void run() {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        long threadTTLTimeout = 0L;
        long threadInactivityTimeout = 0L;
        long threadAbandonedTimeout = 0L;
        while (this.timeToLive) {
            try {
                if (bl) {
                    this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleImplicitConnectionCacheThread running...");
                }
                if (this.timeToLive && (threadTTLTimeout = (long)this.implicitCache.getCacheTimeToLiveTimeout()) > 0L) {
                    this.runTimeToLiveTimeout(threadTTLTimeout);
                }
                if (this.timeToLive && (threadInactivityTimeout = (long)this.implicitCache.getCacheInactivityTimeout()) > 0L) {
                    this.runInactivityTimeout();
                }
                if (this.timeToLive && (threadAbandonedTimeout = (long)this.implicitCache.getCacheAbandonedTimeout()) > 0L) {
                    this.runAbandonedTimeout(threadAbandonedTimeout);
                }
                if (this.timeToLive) {
                    block11: {
                        this.isSleeping = true;
                        try {
                            if (bl) {
                                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleImplicitConnectionCacheThread sleeping...");
                            }
                            OracleImplicitConnectionCacheThread.sleep(this.implicitCache.getCachePropertyCheckInterval() * 1000);
                        }
                        catch (InterruptedException ie) {
                            if (!bl) break block11;
                            this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleImplicitConnectionCacheThread.run() - InterruptedException" + ie.getMessage());
                        }
                    }
                    this.isSleeping = false;
                }
                if (this.implicitCache != null && (threadTTLTimeout > 0L || threadInactivityTimeout > 0L || threadAbandonedTimeout > 0L)) continue;
                this.timeToLive = false;
            }
            catch (SQLException e2) {
                if (!bl) continue;
                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleImplicitConnectionCacheThread.run() - SQL Exceoption " + e2.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void runTimeToLiveTimeout(long l2) throws SQLException {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        long connCurrTime = 0L;
        long connStartTime = 0L;
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection pc = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                int sz = this.implicitCache.checkedOutConnectionList.size();
                for (int k2 = 0; k2 < sz; ++k2) {
                    void threadTTLTimeout;
                    pc = (OraclePooledConnection)ObjArr[k2];
                    Connection conn = pc.getLogicalHandle();
                    if (conn == null) continue;
                    connStartTime = ((OracleConnection)conn).getStartTime();
                    connCurrTime = System.currentTimeMillis();
                    if (connCurrTime - connStartTime <= threadTTLTimeout * 1000L) continue;
                    if (bl) {
                        this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleImplicitConnectionCacheThread.runTimeToLiveTimeout():TTL Timeout expired... Executing cancel()/close()");
                    }
                    try {
                        this.implicitCache.closeCheckedOutConnection(pc, true);
                        continue;
                    }
                    catch (SQLException e2) {
                        if (!bl) continue;
                        this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleImplicitConnectionCacheThread.runTimeToLiveTimeout() - while closeCheckedOutConnection - SQLException:" + e2.getMessage());
                    }
                }
            }
        }
    }

    private void runInactivityTimeout() {
        block2: {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try {
                this.implicitCache.doForEveryCachedConnection(4);
            }
            catch (SQLException e2) {
                if (!bl) break block2;
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleImplicitConnectionCacheThread.runInactivityTimeout() - while doForEveryCachedConnection - SQLException:" + e2.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void runAbandonedTimeout(long l2) throws SQLException {
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (this.implicitCache.getNumberOfCheckedOutConnections() > 0) {
            OraclePooledConnection pc = null;
            OracleImplicitConnectionCache oracleImplicitConnectionCache = this.implicitCache;
            synchronized (oracleImplicitConnectionCache) {
                Object[] ObjArr = this.implicitCache.checkedOutConnectionList.toArray();
                for (int k2 = 0; k2 < ObjArr.length; ++k2) {
                    void abandonedTimeout;
                    pc = (OraclePooledConnection)ObjArr[k2];
                    OracleConnection conn = (OracleConnection)pc.getLogicalHandle();
                    if (conn == null) continue;
                    OracleConnectionCacheCallback occc = conn.getConnectionCacheCallbackObj();
                    if ((long)(conn.getHeartbeatNoChangeCount() * this.implicitCache.getCachePropertyCheckInterval()) <= abandonedTimeout) continue;
                    if (bl) {
                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "OracleImplicitConnectionCacheThread.runAbandonedTimeout():Abandoned Timeout expired...Executing cancel()/close()");
                    }
                    try {
                        boolean closeCheckedOutConnection = true;
                        if (occc != null && (conn.getConnectionCacheCallbackFlag() == 4 || conn.getConnectionCacheCallbackFlag() == 1)) {
                            closeCheckedOutConnection = occc.handleAbandonedConnection(conn, conn.getConnectionCacheCallbackPrivObj());
                        }
                        if (!closeCheckedOutConnection) continue;
                        this.implicitCache.closeCheckedOutConnection(pc, true);
                        this.implicitCache.checkedOutConnectionList.remove(pc);
                        this.implicitCache.storeCacheConnection(pc.cachedConnectionAttributes, pc);
                        continue;
                    }
                    catch (SQLException e2) {
                        if (!bl) continue;
                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "OracleImplicitConnectionCacheThread.runAbandonedTimeout() - while closeCheckedOutConnection -  SQLException:" + e2.getMessage());
                    }
                }
            }
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$4 = OracleImplicitConnectionCacheThread.class.getDeclaredConstructor(OracleImplicitConnectionCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("runAbandonedTimeout", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("runInactivityTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("runTimeToLiveTimeout", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleImplicitConnectionCacheThread.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

