/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.jdbc.proxy.MethodSignature;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.GetProxy;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

class AnnotationsRegistry {
    private Map<Class, Value> ifacesToAnnotatedSuperclasses = new HashMap<Class, Value>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;

    AnnotationsRegistry() {
    }

    void register(Class ... classes) {
        for (Class clazz : classes) {
            if (clazz.isInterface()) {
                throw SyntaxError.mustBeClass(clazz);
            }
            Value value = new Value(clazz);
            for (Class iface : value.getIfacesToProxy()) {
                this.ifacesToAnnotatedSuperclasses.put(iface, value);
            }
        }
    }

    Value get(Class iface) {
        if (null == iface) {
            return null;
        }
        return this.ifacesToAnnotatedSuperclasses.get(iface);
    }

    Set<Class> keySet() {
        return this.ifacesToAnnotatedSuperclasses.keySet();
    }

    Collection<Value> values() {
        return this.ifacesToAnnotatedSuperclasses.values();
    }

    boolean containsKey(Object key) {
        return this.ifacesToAnnotatedSuperclasses.containsKey(key);
    }

    static {
        try {
            $$$methodRef$$$5 = AnnotationsRegistry.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AnnotationsRegistry.class.getDeclaredMethod("containsKey", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AnnotationsRegistry.class.getDeclaredMethod("values", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AnnotationsRegistry.class.getDeclaredMethod("keySet", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AnnotationsRegistry.class.getDeclaredMethod("get", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AnnotationsRegistry.class.getDeclaredMethod("register", Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static class Value {
        private final Class superclass;
        private final List<Class> ifacesToProxy = new ArrayList<Class>();
        private final MethodSpecific.Pres pres = new MethodSpecific.Pres();
        private final MethodSpecific.VoidPosts voidPosts = new MethodSpecific.VoidPosts();
        private final MethodSpecific.ReturningPosts returningPosts = new MethodSpecific.ReturningPosts();
        private final MethodSpecific.VoidOnErrors voidOnErrors = new MethodSpecific.VoidOnErrors();
        private final MethodSpecific.ReturningOnErrors returningOnErrors = new MethodSpecific.ReturningOnErrors();
        private final Rest rest;
        private Method methodGetCreator = null;
        private Method methodGetDelegate = null;
        private Method methodGetProxy = null;
        private Method methodSetDelegate = null;
        private boolean isProxyLocale = false;
        private ProxyResultPolicy proxyResultPolicy = ProxyResultPolicy.CACHE;
        private Class proxyAccessIface = null;
        private Method proxyAccessGetter = null;
        private Method proxyAccessSetter = null;
        private Method pre = null;
        private Method voidPost = null;
        private Method returningPost = null;
        private Map<Class, Method> voidOnErrorsMap = new HashMap<Class, Method>();
        private Map<Class, Method> returningOnErrorsMap = new HashMap<Class, Method>();
        private static final Class[] listOfMethodOperators;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;
        private static Executable $$$methodRef$$$30;
        private static Logger $$$loggerRef$$$30;
        private static Executable $$$methodRef$$$31;
        private static Logger $$$loggerRef$$$31;
        private static Executable $$$methodRef$$$32;
        private static Logger $$$loggerRef$$$32;
        private static Executable $$$methodRef$$$33;
        private static Logger $$$loggerRef$$$33;
        private static Executable $$$methodRef$$$34;
        private static Logger $$$loggerRef$$$34;
        private static Executable $$$methodRef$$$35;
        private static Logger $$$loggerRef$$$35;
        private static Executable $$$methodRef$$$36;
        private static Logger $$$loggerRef$$$36;
        private static Executable $$$methodRef$$$37;
        private static Logger $$$loggerRef$$$37;

        Value(Class superclass) {
            this.superclass = superclass;
            this.rest = this.parseAnnotations();
        }

        private void parseAnnotationTypeProxyResult() {
            if (this.superclass.isAnnotationPresent(ProxyResult.class)) {
                ProxyResult proxyResult = this.superclass.getAnnotation(ProxyResult.class);
                this.proxyResultPolicy = proxyResult.value();
            }
        }

        private void parseAnnotationProxyLocale() {
            if (this.superclass.isAnnotationPresent(ProxyLocale.class)) {
                this.isProxyLocale = true;
            }
        }

        private void parseAnnotationProxyFor() {
            if (this.superclass.isAnnotationPresent(ProxyFor.class)) {
                ProxyFor proxyFor = this.superclass.getAnnotation(ProxyFor.class);
                for (Class clazz : proxyFor.value()) {
                    if (!clazz.isInterface()) {
                        throw SyntaxError.mustBeIface(clazz);
                    }
                    this.ifacesToProxy.add(clazz);
                }
            } else {
                throw SyntaxError.noProxyForClass(this.superclass);
            }
        }

        private boolean isProxyAccessGetter(Method method) {
            if (!Object.class.equals(method.getReturnType())) {
                return false;
            }
            if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                return false;
            }
            return Arrays.deepEquals(new Class[0], method.getExceptionTypes());
        }

        private boolean isProxyAccessSetter(Method method) {
            if (!Void.TYPE.equals(method.getReturnType())) {
                return false;
            }
            if (!Arrays.deepEquals(new Class[]{Object.class}, method.getParameterTypes())) {
                return false;
            }
            return Arrays.deepEquals(new Class[0], method.getExceptionTypes());
        }

        private void parseAnnotationProxyAccess() {
            if (this.superclass.isAnnotationPresent(ProxyAccess.class)) {
                this.proxyAccessIface = this.superclass.getAnnotation(ProxyAccess.class).value();
                if (!this.proxyAccessIface.isInterface()) {
                    throw SyntaxError.mustBeIface(this.proxyAccessIface);
                }
                if (0 != this.proxyAccessIface.getInterfaces().length) {
                    throw SyntaxError.mustNotImplementIfaces(this.proxyAccessIface);
                }
                Method[] methods = this.proxyAccessIface.getMethods();
                if (2 != methods.length) {
                    throw SyntaxError.wrongProxyAccessIface(this.proxyAccessIface);
                }
                if (this.isProxyAccessGetter(methods[0]) && this.isProxyAccessSetter(methods[1])) {
                    this.proxyAccessGetter = methods[0];
                    this.proxyAccessSetter = methods[1];
                } else if (this.isProxyAccessGetter(methods[1]) && this.isProxyAccessSetter(methods[0])) {
                    this.proxyAccessGetter = methods[1];
                    this.proxyAccessSetter = methods[0];
                } else {
                    throw SyntaxError.wrongProxyAccessIface(this.proxyAccessIface);
                }
            }
        }

        private void checkIsSingle(Method method, Class operator) {
            for (Class op : listOfMethodOperators) {
                if (op.equals(operator) || !method.isAnnotationPresent(op)) continue;
                throw SyntaxError.onlyOneAllowed;
            }
        }

        private void parseAnnotationPre(Method method) {
            if (method.isAnnotationPresent(Pre.class)) {
                this.checkIsSingle(method, Pre.class);
                if (!Arrays.deepEquals(new Class[]{Method.class, Object.class, Object[].class}, method.getParameterTypes())) {
                    throw SyntaxError.wrongPre;
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongPre;
                }
                if (method.isAnnotationPresent(Methods.class)) {
                    for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                        this.pres.put(new MethodSignature(signature.name(), signature.args(), null), method);
                    }
                } else {
                    if (null != this.pre) {
                        throw SyntaxError.onlyOneMethodslessAllowed;
                    }
                    this.pre = method;
                }
            }
        }

        private Class doAutoBoxing(Class clazz) {
            if (Boolean.TYPE.equals(clazz)) {
                return Boolean.class;
            }
            if (Character.TYPE.equals(clazz)) {
                return Character.class;
            }
            if (Byte.TYPE.equals(clazz)) {
                return Byte.class;
            }
            if (Short.TYPE.equals(clazz)) {
                return Short.class;
            }
            if (Integer.TYPE.equals(clazz)) {
                return Integer.class;
            }
            if (Long.TYPE.equals(clazz)) {
                return Long.class;
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.class;
            }
            if (Double.TYPE.equals(clazz)) {
                return Double.class;
            }
            return clazz;
        }

        private void checkReturnTypesMismatch(MethodSignature methodSignature, Method methodInterceptor) {
            Method methodInterceptee = null;
            Class interceptorReturnType = this.doAutoBoxing(methodInterceptor.getReturnType());
            for (Class iface : this.getIfacesToProxy()) {
                try {
                    methodInterceptee = iface.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes());
                    Class intercepteeReturnType = this.doAutoBoxing(methodInterceptee.getReturnType());
                    if (Void.TYPE.equals(intercepteeReturnType)) continue;
                    interceptorReturnType.asSubclass(intercepteeReturnType);
                }
                catch (NoSuchMethodException intercepteeReturnType) {
                }
                catch (ClassCastException e2) {
                    throw SyntaxError.returnTypeMismatch(methodInterceptor, methodInterceptee);
                }
            }
        }

        private void checkReturnTypesMismatch(Method methodInterceptor) {
            Class interceptorReturnType = this.doAutoBoxing(methodInterceptor.getReturnType());
            for (Class iface : this.getIfacesToProxy()) {
                for (Method methodInterceptee : iface.getDeclaredMethods()) {
                    Class intercepteeReturnType = this.doAutoBoxing(methodInterceptee.getReturnType());
                    if (Void.TYPE.equals(intercepteeReturnType)) continue;
                    try {
                        intercepteeReturnType.asSubclass(interceptorReturnType);
                    }
                    catch (ClassCastException e2) {
                        throw SyntaxError.returnTypeMismatch(methodInterceptor, methodInterceptee);
                    }
                }
            }
        }

        private void parseAnnotationPost(Method method) {
            if (method.isAnnotationPresent(Post.class)) {
                this.checkIsSingle(method, Post.class);
                Class<?> returnType = method.getReturnType();
                Object[] parameterTypes = method.getParameterTypes();
                Class<?>[] exceptionTypes = method.getExceptionTypes();
                if (Void.TYPE.equals(returnType) && Arrays.deepEquals(new Class[]{Method.class}, parameterTypes)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            this.voidPosts.put(new MethodSignature(signature.name(), signature.args(), null), method);
                        }
                    } else {
                        if (null != this.voidPost) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                        this.voidPost = method;
                    }
                } else if (!Void.TYPE.equals(returnType) && Arrays.deepEquals(new Class[]{Method.class, returnType}, parameterTypes)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args(), null);
                            this.checkReturnTypesMismatch(methodSignature, method);
                            this.returningPosts.put(methodSignature, method);
                        }
                    } else {
                        this.checkReturnTypesMismatch(method);
                        if (null != this.returningPost) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                        this.returningPost = method;
                    }
                } else {
                    throw SyntaxError.wrongPost;
                }
            }
        }

        private void parseAnnotationOnError(Method method) {
            if (method.isAnnotationPresent(OnError.class)) {
                this.checkIsSingle(method, OnError.class);
                Class<?> returnType = method.getReturnType();
                Object[] parameterTypes = method.getParameterTypes();
                Object[] exceptionTypes = method.getExceptionTypes();
                OnError onError = method.getAnnotation(OnError.class);
                Class exceptionClass = onError.value();
                if (Arrays.deepEquals(new Class[]{Method.class, exceptionClass}, parameterTypes) && Arrays.deepEquals(new Class[]{exceptionClass}, exceptionTypes) && Void.TYPE.equals(returnType)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args(), null);
                            HashMap<Class, Method> onErrorsMap = (HashMap<Class, Method>)this.voidOnErrors.get(methodSignature);
                            if (null == onErrorsMap) {
                                onErrorsMap = new HashMap<Class, Method>();
                                this.voidOnErrors.put(methodSignature, onErrorsMap);
                            }
                            if (null == onErrorsMap.put(exceptionClass, method)) continue;
                            throw SyntaxError.onlyOneOnErrorExceptionTypeAllowed;
                        }
                    } else if (null != this.voidOnErrorsMap.put(exceptionClass, method)) {
                        throw SyntaxError.onlyOneMethodslessAllowed;
                    }
                } else if (Arrays.deepEquals(new Class[]{Method.class, exceptionClass}, parameterTypes) && Arrays.deepEquals(new Class[]{exceptionClass}, exceptionTypes) && !Void.TYPE.equals(returnType)) {
                    if (method.isAnnotationPresent(Methods.class)) {
                        for (Signature signature : method.getAnnotation(Methods.class).signatures()) {
                            MethodSignature methodSignature = new MethodSignature(signature.name(), signature.args(), null);
                            this.checkReturnTypesMismatch(methodSignature, method);
                            HashMap<Class, Method> onErrorsMap = (HashMap<Class, Method>)this.returningOnErrors.get(methodSignature);
                            if (null == onErrorsMap) {
                                onErrorsMap = new HashMap<Class, Method>();
                                this.returningOnErrors.put(methodSignature, onErrorsMap);
                            }
                            if (null == onErrorsMap.put(exceptionClass, method)) continue;
                            throw SyntaxError.onlyOneOnErrorExceptionTypeAllowed;
                        }
                    } else {
                        this.checkReturnTypesMismatch(method);
                        if (null != this.returningOnErrorsMap.put(exceptionClass, method)) {
                            throw SyntaxError.onlyOneMethodslessAllowed;
                        }
                    }
                } else {
                    throw SyntaxError.wrongOnError;
                }
            }
        }

        private void parseAnnotationGetCreator(Method method) {
            if (method.isAnnotationPresent(GetCreator.class)) {
                this.checkIsSingle(method, GetCreator.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongGetCreatorMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongGetCreatorMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                    throw SyntaxError.wrongGetCreator;
                }
                if (!Object.class.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetCreator;
                }
                this.methodGetCreator = method;
            }
        }

        private void parseAnnotationGetProxy(Method method) {
            if (method.isAnnotationPresent(GetProxy.class)) {
                this.checkIsSingle(method, GetProxy.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongGetProxyMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongGetProxyMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[]{Object.class, Object.class}, method.getParameterTypes())) {
                    throw SyntaxError.wrongGetProxy;
                }
                if (!Object.class.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetProxy;
                }
                this.methodGetProxy = method;
            }
        }

        private void parseAnnotationGetDelegate(Method method) {
            if (method.isAnnotationPresent(GetDelegate.class)) {
                this.checkIsSingle(method, GetDelegate.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongGetDelegateMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongGetDelegateMustBeAbstract;
                }
                if (!Arrays.deepEquals(new Class[0], method.getParameterTypes())) {
                    throw SyntaxError.wrongGetDelegate;
                }
                if (Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongGetDelegate;
                }
                this.methodGetDelegate = method;
            }
        }

        private void parseAnnotationSetDelegate(Method method) {
            if (method.isAnnotationPresent(SetDelegate.class)) {
                this.checkIsSingle(method, SetDelegate.class);
                if (method.isAnnotationPresent(Methods.class)) {
                    throw SyntaxError.wrongMethodsContext;
                }
                int modifier = method.getModifiers();
                if (!Modifier.isProtected(modifier)) {
                    throw SyntaxError.wrongSetDelegateMustBeProtected;
                }
                if (!Modifier.isAbstract(modifier)) {
                    throw SyntaxError.wrongSetDelegateMustBeAbstract;
                }
                if (1 != method.getParameterTypes().length) {
                    throw SyntaxError.wrongSetDelegate;
                }
                if (!Void.TYPE.equals(method.getReturnType())) {
                    throw SyntaxError.wrongSetDelegate;
                }
                this.methodSetDelegate = method;
            }
        }

        private Rest parseAnnotations() {
            this.parseAnnotationProxyFor();
            this.parseAnnotationProxyAccess();
            this.parseAnnotationProxyLocale();
            this.parseAnnotationTypeProxyResult();
            for (Method method : this.superclass.getDeclaredMethods()) {
                this.parseAnnotationPre(method);
                this.parseAnnotationPost(method);
                this.parseAnnotationOnError(method);
                this.parseAnnotationGetCreator(method);
                this.parseAnnotationGetProxy(method);
                this.parseAnnotationGetDelegate(method);
                this.parseAnnotationSetDelegate(method);
            }
            if (null != this.proxyAccessIface) {
                for (Class ifaceToProxy : this.ifacesToProxy) {
                    try {
                        ifaceToProxy.asSubclass(this.proxyAccessIface);
                    }
                    catch (ClassCastException e2) {
                        throw SyntaxError.mustExtendProxyAccessIface(ifaceToProxy, this.proxyAccessIface);
                    }
                }
            }
            return new Rest(this.pre, this.voidPost, this.returningPost, this.voidOnErrorsMap, this.returningOnErrorsMap);
        }

        boolean belongsToIfaceToProxy(Class ifaceToProxy, MethodSignature methodSignature) {
            for (Class iface : this.ifacesToProxy) {
                try {
                    ifaceToProxy.asSubclass(iface);
                    if (!this.isMethodDeclared(iface, methodSignature)) continue;
                    return true;
                }
                catch (ClassCastException classCastException) {
                }
            }
            return false;
        }

        private boolean isMethodDeclared(Class iface, MethodSignature methodSignature) {
            try {
                if (null != iface.getDeclaredMethod(methodSignature.getName(), methodSignature.getParameterTypes())) {
                    return true;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            for (Class<?> subiface : iface.getInterfaces()) {
                if (!this.isMethodDeclared(subiface, methodSignature)) continue;
                return true;
            }
            return false;
        }

        Method getMethodPre(Class ifaceToProxy, MethodSignature methodSignature) {
            Method methodSpecificPre = (Method)this.pres.get(methodSignature);
            if (null != methodSpecificPre) {
                return methodSpecificPre;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getPre() : null;
        }

        Method getMethodVoidPost(Class ifaceToProxy, MethodSignature methodSignature) {
            Method methodSpecificVoidPost = (Method)this.voidPosts.get(methodSignature);
            if (null != methodSpecificVoidPost) {
                return methodSpecificVoidPost;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getVoidPost() : null;
        }

        Method getMethodReturningPost(Class ifaceToProxy, MethodSignature methodSignature) {
            Method methodSpecificReturningPost = (Method)this.returningPosts.get(methodSignature);
            if (null != methodSpecificReturningPost) {
                return methodSpecificReturningPost;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getReturningPost() : null;
        }

        Map<Class, Method> getMapVoidOnError(Class ifaceToProxy, MethodSignature methodSignature) {
            Map methodSpecificVoidOnErrorsMap = (Map)this.voidOnErrors.get(methodSignature);
            if (null != methodSpecificVoidOnErrorsMap) {
                return methodSpecificVoidOnErrorsMap;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getVoidOnError() : null;
        }

        Map<Class, Method> getMapReturningOnError(Class ifaceToProxy, MethodSignature methodSignature) {
            Map methodSpecificReturningOnErrorsMap = (Map)this.returningOnErrors.get(methodSignature);
            if (null != methodSpecificReturningOnErrorsMap) {
                return methodSpecificReturningOnErrorsMap;
            }
            return this.belongsToIfaceToProxy(ifaceToProxy, methodSignature) ? this.rest.getReturningOnError() : null;
        }

        Method getMethodGetCreator() {
            return this.methodGetCreator;
        }

        Method getMethodGetDelegate() {
            return this.methodGetDelegate;
        }

        Method getMethodGetProxy() {
            return this.methodGetProxy;
        }

        Method getMethodSetDelegate() {
            return this.methodSetDelegate;
        }

        List<Class> getIfacesToProxy() {
            return this.ifacesToProxy;
        }

        Class getSuperclass() {
            return this.superclass;
        }

        boolean isProxyLocale() {
            return this.isProxyLocale;
        }

        ProxyResultPolicy getProxyResultPolicy() {
            return this.proxyResultPolicy;
        }

        ProxyResultPolicy getProxyResultPolicy(Method m2) {
            Method method;
            try {
                method = this.superclass.getDeclaredMethod(m2.getName(), m2.getParameterTypes());
            }
            catch (NoSuchMethodException e2) {
                return this.proxyResultPolicy;
            }
            if (method.isAnnotationPresent(ProxyResult.class)) {
                ProxyResult proxyResult = method.getAnnotation(ProxyResult.class);
                return proxyResult.value();
            }
            return this.proxyResultPolicy;
        }

        Class getProxyAccessIface() {
            return this.proxyAccessIface;
        }

        Method getProxyAccessGetter() {
            return this.proxyAccessGetter;
        }

        Method getProxyAccessSetter() {
            return this.proxyAccessSetter;
        }

        static {
            try {
                $$$methodRef$$$37 = Value.class.getDeclaredConstructor(Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$36 = Value.class.getDeclaredMethod("getProxyAccessSetter", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$35 = Value.class.getDeclaredMethod("getProxyAccessGetter", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$34 = Value.class.getDeclaredMethod("getProxyAccessIface", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$33 = Value.class.getDeclaredMethod("getProxyResultPolicy", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$32 = Value.class.getDeclaredMethod("getProxyResultPolicy", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$31 = Value.class.getDeclaredMethod("isProxyLocale", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$30 = Value.class.getDeclaredMethod("getSuperclass", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$29 = Value.class.getDeclaredMethod("getIfacesToProxy", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$28 = Value.class.getDeclaredMethod("getMethodSetDelegate", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$27 = Value.class.getDeclaredMethod("getMethodGetProxy", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$26 = Value.class.getDeclaredMethod("getMethodGetDelegate", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$25 = Value.class.getDeclaredMethod("getMethodGetCreator", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$24 = Value.class.getDeclaredMethod("getMapReturningOnError", Class.class, MethodSignature.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$23 = Value.class.getDeclaredMethod("getMapVoidOnError", Class.class, MethodSignature.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$22 = Value.class.getDeclaredMethod("getMethodReturningPost", Class.class, MethodSignature.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$21 = Value.class.getDeclaredMethod("getMethodVoidPost", Class.class, MethodSignature.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$20 = Value.class.getDeclaredMethod("getMethodPre", Class.class, MethodSignature.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$19 = Value.class.getDeclaredMethod("isMethodDeclared", Class.class, MethodSignature.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$18 = Value.class.getDeclaredMethod("belongsToIfaceToProxy", Class.class, MethodSignature.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$17 = Value.class.getDeclaredMethod("parseAnnotations", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$16 = Value.class.getDeclaredMethod("parseAnnotationSetDelegate", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = Value.class.getDeclaredMethod("parseAnnotationGetDelegate", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = Value.class.getDeclaredMethod("parseAnnotationGetProxy", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = Value.class.getDeclaredMethod("parseAnnotationGetCreator", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = Value.class.getDeclaredMethod("parseAnnotationOnError", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = Value.class.getDeclaredMethod("parseAnnotationPost", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = Value.class.getDeclaredMethod("checkReturnTypesMismatch", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = Value.class.getDeclaredMethod("checkReturnTypesMismatch", MethodSignature.class, Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = Value.class.getDeclaredMethod("doAutoBoxing", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = Value.class.getDeclaredMethod("parseAnnotationPre", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = Value.class.getDeclaredMethod("checkIsSingle", Method.class, Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = Value.class.getDeclaredMethod("parseAnnotationProxyAccess", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = Value.class.getDeclaredMethod("isProxyAccessSetter", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = Value.class.getDeclaredMethod("isProxyAccessGetter", Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = Value.class.getDeclaredMethod("parseAnnotationProxyFor", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = Value.class.getDeclaredMethod("parseAnnotationProxyLocale", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = Value.class.getDeclaredMethod("parseAnnotationTypeProxyResult", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            listOfMethodOperators = new Class[]{Pre.class, Post.class, OnError.class, GetCreator.class, GetDelegate.class, GetProxy.class, SetDelegate.class};
        }

        private static class Rest {
            private final Method pre;
            private final Method voidPost;
            private final Method returningPost;
            private final Map<Class, Method> voidOnErrorsMap;
            private final Map<Class, Method> returningOnErrorsMap;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;

            Rest(Method pre, Method voidPost, Method returningPost, Map<Class, Method> voidOnErrorsMap, Map<Class, Method> returningOnErrorsMap) {
                this.pre = pre;
                this.voidPost = voidPost;
                this.returningPost = returningPost;
                this.voidOnErrorsMap = voidOnErrorsMap;
                this.returningOnErrorsMap = returningOnErrorsMap;
            }

            Method getPre() {
                return this.pre;
            }

            Map<Class, Method> getReturningOnError() {
                return this.returningOnErrorsMap;
            }

            Method getReturningPost() {
                return this.returningPost;
            }

            Map<Class, Method> getVoidOnError() {
                return this.voidOnErrorsMap;
            }

            Method getVoidPost() {
                return this.voidPost;
            }

            static {
                try {
                    $$$methodRef$$$5 = Rest.class.getDeclaredConstructor(Method.class, Method.class, Method.class, Map.class, Map.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$4 = Rest.class.getDeclaredMethod("getVoidPost", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$3 = Rest.class.getDeclaredMethod("getVoidOnError", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = Rest.class.getDeclaredMethod("getReturningPost", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = Rest.class.getDeclaredMethod("getReturningOnError", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = Rest.class.getDeclaredMethod("getPre", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        }

        private static class MethodSpecific<T> {
            private final Map<MethodSignature, T> ref = new HashMap<MethodSignature, T>();
            private final String annotationType;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            private MethodSpecific(String annotationType) {
                this.annotationType = annotationType;
            }

            void put(MethodSignature methodSignature, T t2) {
                if (null != this.ref.put(methodSignature, t2)) {
                    throw SyntaxError.annotationDefinedMoreThanOnce(this.annotationType);
                }
            }

            T get(MethodSignature methodSignature) {
                return this.ref.get(methodSignature);
            }

            static {
                try {
                    $$$methodRef$$$3 = MethodSpecific.class.getDeclaredConstructor(String.class, 1.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$2 = MethodSpecific.class.getDeclaredConstructor(String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = MethodSpecific.class.getDeclaredMethod("get", MethodSignature.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = MethodSpecific.class.getDeclaredMethod("put", MethodSignature.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }

            static final class ReturningOnErrors
            extends MethodSpecific<Map<Class, Method>> {
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;

                ReturningOnErrors() {
                    super("Returning @OnError");
                }

                static {
                    try {
                        $$$methodRef$$$0 = ReturningOnErrors.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            }

            static final class VoidOnErrors
            extends MethodSpecific<Map<Class, Method>> {
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;

                VoidOnErrors() {
                    super("Void @OnError");
                }

                static {
                    try {
                        $$$methodRef$$$0 = VoidOnErrors.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            }

            static final class ReturningPosts
            extends MethodSpecific<Method> {
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;

                ReturningPosts() {
                    super("Returning @Post");
                }

                static {
                    try {
                        $$$methodRef$$$0 = ReturningPosts.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            }

            static final class VoidPosts
            extends MethodSpecific<Method> {
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;

                VoidPosts() {
                    super("Void @Post");
                }

                static {
                    try {
                        $$$methodRef$$$0 = VoidPosts.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            }

            static final class Pres
            extends MethodSpecific<Method> {
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;

                Pres() {
                    super("@Pre");
                }

                static {
                    try {
                        $$$methodRef$$$0 = Pres.class.getDeclaredConstructor(new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            }
        }
    }

    private static class SyntaxError
    extends RuntimeException {
        private static final SyntaxError onlyOneAllowed;
        private static final SyntaxError onlyOneMethodslessAllowed;
        private static final SyntaxError wrongMethodsContext;
        private static final SyntaxError wrongPre;
        private static final SyntaxError wrongPost;
        private static final SyntaxError wrongOnError;
        private static final SyntaxError onlyOneOnErrorExceptionTypeAllowed;
        private static final SyntaxError wrongGetCreator;
        private static final SyntaxError wrongGetCreatorMustBeProtected;
        private static final SyntaxError wrongGetCreatorMustBeAbstract;
        private static final SyntaxError wrongGetDelegate;
        private static final SyntaxError wrongGetDelegateMustBeProtected;
        private static final SyntaxError wrongGetDelegateMustBeAbstract;
        private static final SyntaxError wrongGetProxy;
        private static final SyntaxError wrongGetProxyMustBeProtected;
        private static final SyntaxError wrongGetProxyMustBeAbstract;
        private static final SyntaxError wrongSetDelegate;
        private static final SyntaxError wrongSetDelegateMustBeProtected;
        private static final SyntaxError wrongSetDelegateMustBeAbstract;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;
        private static Executable $$$methodRef$$$14;
        private static Logger $$$loggerRef$$$14;
        private static Executable $$$methodRef$$$15;
        private static Logger $$$loggerRef$$$15;
        private static Executable $$$methodRef$$$16;
        private static Logger $$$loggerRef$$$16;
        private static Executable $$$methodRef$$$17;
        private static Logger $$$loggerRef$$$17;
        private static Executable $$$methodRef$$$18;
        private static Logger $$$loggerRef$$$18;
        private static Executable $$$methodRef$$$19;
        private static Logger $$$loggerRef$$$19;
        private static Executable $$$methodRef$$$20;
        private static Logger $$$loggerRef$$$20;
        private static Executable $$$methodRef$$$21;
        private static Logger $$$loggerRef$$$21;
        private static Executable $$$methodRef$$$22;
        private static Logger $$$loggerRef$$$22;
        private static Executable $$$methodRef$$$23;
        private static Logger $$$loggerRef$$$23;
        private static Executable $$$methodRef$$$24;
        private static Logger $$$loggerRef$$$24;
        private static Executable $$$methodRef$$$25;
        private static Logger $$$loggerRef$$$25;
        private static Executable $$$methodRef$$$26;
        private static Logger $$$loggerRef$$$26;
        private static Executable $$$methodRef$$$27;
        private static Logger $$$loggerRef$$$27;
        private static Executable $$$methodRef$$$28;
        private static Logger $$$loggerRef$$$28;
        private static Executable $$$methodRef$$$29;
        private static Logger $$$loggerRef$$$29;
        private static Executable $$$methodRef$$$30;
        private static Logger $$$loggerRef$$$30;
        private static Executable $$$methodRef$$$31;
        private static Logger $$$loggerRef$$$31;
        private static Executable $$$methodRef$$$32;
        private static Logger $$$loggerRef$$$32;
        private static Executable $$$methodRef$$$33;
        private static Logger $$$loggerRef$$$33;
        private static Executable $$$methodRef$$$34;
        private static Logger $$$loggerRef$$$34;
        private static Executable $$$methodRef$$$35;
        private static Logger $$$loggerRef$$$35;

        SyntaxError(String message) {
            super(message);
        }

        private static SyntaxError mustBeClass(Class clazz) {
            return new SyntaxError(clazz.getName() + " must be an abstract or concrete class");
        }

        private static SyntaxError mustBeIface(Class clazz) {
            return new SyntaxError(clazz.getName() + " must be an interface");
        }

        private static SyntaxError mustNotImplementIfaces(Class clazz) {
            return new SyntaxError(clazz.getName() + " must not implement interfaces");
        }

        private static SyntaxError wrongProxyAccessIface(Class clazz) {
            return new SyntaxError(clazz.getName() + " wrong @ProxyAccess argument.  Must contain an interface with a simple getter and a simple setter and nothing else, like:\npublic interface Proxyable<T> {\n  void setProxy(T proxy);\n  T getProxy();\n}");
        }

        private static SyntaxError annotationDefinedMoreThanOnce(String annotation) {
            return new SyntaxError(annotation + " is defined more than once for the same method");
        }

        private static SyntaxError mustExtendProxyAccessIface(Class ifaceToProxy, Class proxyAccessIface) {
            return new SyntaxError(ifaceToProxy.getName() + " must extends @ProxyAccess interface " + proxyAccessIface.getName());
        }

        private static SyntaxError noProxyForClass(Class clazz) {
            return new SyntaxError("no @ProxyFor for class " + clazz.getName());
        }

        private static SyntaxError returnTypeMismatch(Method methodInterceptor, Method methodInterceptee) {
            return new SyntaxError("interceptor " + methodInterceptor.getName() + " and interceptee " + methodInterceptee.getName() + ": have different return types (" + methodInterceptor.getReturnType().getName() + " and " + methodInterceptee.getReturnType().getName() + ")");
        }

        static {
            try {
                $$$methodRef$$$35 = SyntaxError.class.getDeclaredConstructor(String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$34 = SyntaxError.class.getDeclaredMethod("access$2700", Class.class, Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$33 = SyntaxError.class.getDeclaredMethod("access$2600", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$32 = SyntaxError.class.getDeclaredMethod("access$2500", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$31 = SyntaxError.class.getDeclaredMethod("access$2400", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$30 = SyntaxError.class.getDeclaredMethod("access$2300", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$29 = SyntaxError.class.getDeclaredMethod("access$2200", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$28 = SyntaxError.class.getDeclaredMethod("access$2100", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$27 = SyntaxError.class.getDeclaredMethod("access$2000", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$26 = SyntaxError.class.getDeclaredMethod("access$1900", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$25 = SyntaxError.class.getDeclaredMethod("access$1800", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$24 = SyntaxError.class.getDeclaredMethod("access$1700", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$23 = SyntaxError.class.getDeclaredMethod("access$1600", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$22 = SyntaxError.class.getDeclaredMethod("access$1500", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$21 = SyntaxError.class.getDeclaredMethod("access$1400", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$20 = SyntaxError.class.getDeclaredMethod("access$1300", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$19 = SyntaxError.class.getDeclaredMethod("access$1200", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$18 = SyntaxError.class.getDeclaredMethod("access$1100", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$17 = SyntaxError.class.getDeclaredMethod("access$1000", Method.class, Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$16 = SyntaxError.class.getDeclaredMethod("access$900", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$15 = SyntaxError.class.getDeclaredMethod("access$800", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$14 = SyntaxError.class.getDeclaredMethod("access$700", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$13 = SyntaxError.class.getDeclaredMethod("access$600", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$12 = SyntaxError.class.getDeclaredMethod("access$500", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$11 = SyntaxError.class.getDeclaredMethod("access$400", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$10 = SyntaxError.class.getDeclaredMethod("access$300", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$9 = SyntaxError.class.getDeclaredMethod("access$200", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$8 = SyntaxError.class.getDeclaredMethod("access$000", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$7 = SyntaxError.class.getDeclaredMethod("returnTypeMismatch", Method.class, Method.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$6 = SyntaxError.class.getDeclaredMethod("noProxyForClass", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$5 = SyntaxError.class.getDeclaredMethod("mustExtendProxyAccessIface", Class.class, Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$4 = SyntaxError.class.getDeclaredMethod("annotationDefinedMoreThanOnce", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$3 = SyntaxError.class.getDeclaredMethod("wrongProxyAccessIface", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$2 = SyntaxError.class.getDeclaredMethod("mustNotImplementIfaces", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = SyntaxError.class.getDeclaredMethod("mustBeIface", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = SyntaxError.class.getDeclaredMethod("mustBeClass", Class.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            onlyOneAllowed = new SyntaxError("only one @Pre/@Post/@OnError/@GetDelegate/@SetDelegate/@GetCreator/@GetProxy allowed");
            onlyOneMethodslessAllowed = new SyntaxError("only one @Methods-less @Pre/@Post/@OnError allowed");
            wrongMethodsContext = new SyntaxError("wrong context for @Methods");
            wrongPre = new SyntaxError("wrong @Pre");
            wrongPost = new SyntaxError("wrong @Post");
            wrongOnError = new SyntaxError("wrong @OnError");
            onlyOneOnErrorExceptionTypeAllowed = new SyntaxError("only one @OnError Exception type allowed for a given method");
            wrongGetCreator = new SyntaxError("wrong @GetCreator");
            wrongGetCreatorMustBeProtected = new SyntaxError("wrong @GetCreator: must be protected");
            wrongGetCreatorMustBeAbstract = new SyntaxError("wrong @GetCreator: must be abstract");
            wrongGetDelegate = new SyntaxError("wrong @GetDelegate");
            wrongGetDelegateMustBeProtected = new SyntaxError("wrong @GetDelegate: must be protected");
            wrongGetDelegateMustBeAbstract = new SyntaxError("wrong @GetDelegate: must be abstract");
            wrongGetProxy = new SyntaxError("wrong @GetProxy");
            wrongGetProxyMustBeProtected = new SyntaxError("wrong @GetProxy: must be protected");
            wrongGetProxyMustBeAbstract = new SyntaxError("wrong @GetProxy: must be abstract");
            wrongSetDelegate = new SyntaxError("wrong @SetDelegate");
            wrongSetDelegateMustBeProtected = new SyntaxError("wrong @SetDelegate: must be protected");
            wrongSetDelegateMustBeAbstract = new SyntaxError("wrong @SetDelegate: must be abstract");
        }
    }
}

