/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version;
    private boolean needStackingForCommitRollbackPrepare;
    private static String xa_start_816;
    private static String xa_start_post_816;
    private static String xa_end_816;
    private static String xa_end_post_816;
    private static String xa_commit_816;
    private static String xa_commit_post_816;
    private static String xa_prepare_816;
    private static String xa_prepare_post_816;
    private static String xa_rollback_816;
    private static String xa_rollback_post_816;
    private static String xa_forget_816;
    private static String xa_forget_post_816;
    boolean isTransLoose;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    public OracleXAResource() {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, null, new Object[0]);
            }
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, null);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleXAResource.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleXAResource(Connection pm_conn, OracleXAConnection xaconn) throws XAException {
        super(pm_conn, xaconn);
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, null, pm_conn, xaconn);
            }
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            SQLException savedSqe = null;
            try {
                this.m_version = ((OracleConnection)pm_conn).getVersionNumber();
                this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
            }
            catch (SQLException sqe) {
                if (bl) {
                    this.debug($$$loggerRef$$$16, Level.FINEST, $$$methodRef$$$16, "OracleXAResource(pm_conn, xaconn): getVersionNumber() -- SQLException");
                }
                savedSqe = sqe;
                this.m_version = (short)-1;
            }
            if (this.m_version < 8170) {
                if (bl) {
                    this.debug($$$loggerRef$$$16, Level.FINEST, $$$methodRef$$$16, "OracleXAResource(pm_conn): Java XA not supported for this server version");
                }
                XAException xAException = (XAException)DatabaseError.createXAException(String.format("Unsupported database version %d", this.m_version), -6).initCause(savedSqe);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, null, xAException);
                }
                throw xAException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleXAResource.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void start(Xid xid, int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection physicalConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, xid, n2);
            }
            try {
                if (this.connection instanceof ReplayableConnection) {
                    ((ReplayableConnection)((Object)this.connection)).disableReplay();
                    physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                } else {
                    physicalConnection = this.connection;
                }
            }
            catch (SQLException sqle) {
                physicalConnection = this.connection;
                this.checkError(sqle, -3);
            }
            Connection connection = physicalConnection;
            synchronized (connection) {
                try {
                    int returnVal = -1;
                    try {
                        int flag;
                        void xid2;
                        if (xid2 == null) {
                            if (bl) {
                                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleXAResource.start(): XAER_INVAL: xid is null");
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, xAException);
                            }
                            throw xAException;
                        }
                        int isolFlag = flag & 0xFF00;
                        int otherFlag = (flag &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
                        if (((flag &= 0xFFFEFFFF) & 0x820000A) != flag || otherFlag != 0 && (otherFlag & 0x10000) != 65536) {
                            if (bl) {
                                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleXAResource.start(): XAER_INVAL: invalid flag");
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, xAException);
                            }
                            throw xAException;
                        }
                        if ((isolFlag & 0xFF00) != 0 && isolFlag != 256 && isolFlag != 512 && isolFlag != 1024) {
                            if (bl) {
                                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleXAResource.start(): XAER_INVAL: invalid Isolation flag");
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, xAException);
                            }
                            throw xAException;
                        }
                        if ((flag & 0x8200000) != 0 && ((isolFlag & 0xFF00) != 0 || (otherFlag & 0x10000) != 0)) {
                            if (bl) {
                                this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleXAResource.start(): XAER_INVAL: Isolation flags not allowed for JOIN/RESUME");
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, xAException);
                            }
                            throw xAException;
                        }
                        flag |= isolFlag | otherFlag;
                        this.saveAndAlterAutoCommitModeForGlobalTransaction();
                        try {
                            returnVal = this.doStart((Xid)xid2, flag);
                        }
                        catch (SQLException sqle) {
                            this.checkError(sqle, -3);
                        }
                        if (bl) {
                            this.debug($$$loggerRef$$$0, Level.FINEST, $$$methodRef$$$0, "OracleXAResource.start(): return status returnVal = " + returnVal);
                        }
                        this.checkError(returnVal);
                        boolean[] isLocallySuspended = new boolean[]{false};
                        super.createOrUpdateXid((Xid)xid2, false, isLocallySuspended);
                    }
                    catch (XAException ea) {
                        this.restoreAutoCommitModeForGlobalTransaction();
                        XAException xAException = ea;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, xAException);
                        }
                        throw xAException;
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl72 : MonitorExitStatement: MONITOREXIT : var4_6
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleXAResource.class, $$$methodRef$$$0, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doStart(Xid xid, int n2) throws XAException, SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, xid, n2);
            }
            int returnVal = -1;
            CallableStatement cstmt = null;
            try {
                void flag;
                void xid2;
                cstmt = this.connection.prepareCall(xa_start_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid2.getFormatId());
                cstmt.setBytes(3, xid2.getGlobalTransactionId());
                cstmt.setBytes(4, xid2.getBranchQualifier());
                cstmt.setInt(5, this.timeout);
                cstmt.setInt(6, (int)flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                try {
                    returnVal = s2.getErrorCode();
                    if (bl) {
                        this.debug($$$loggerRef$$$1, Level.FINEST, $$$methodRef$$$1, "OracleXAResource.start() returnVal=" + returnVal);
                    }
                    if (returnVal == 0) {
                        XAException xAException = (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, xAException);
                        }
                        throw xAException;
                    }
                    SQLException sQLException = s2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    cstmt = null;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            cstmt = null;
            int n3 = returnVal;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleXAResource.class, $$$methodRef$$$1, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void end(Xid xid, int n2) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection physicalConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, xid, n2);
            }
            try {
                if (this.connection instanceof ReplayableConnection) {
                    ((ReplayableConnection)((Object)this.connection)).disableReplay();
                    physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                } else {
                    physicalConnection = this.connection;
                }
            }
            catch (SQLException sqle) {
                physicalConnection = this.connection;
                this.checkError(sqle, -3);
            }
            Connection connection = physicalConnection;
            synchronized (connection) {
                try {
                    int returnVal = -1;
                    boolean isTMSUCCESS = false;
                    boolean isTMFAIL = false;
                    try {
                        void flag;
                        void xid2;
                        if (xid2 == null) {
                            if (bl) {
                                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleXAResource.end(): XAER_INVAL: xid is null");
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, xAException);
                            }
                            throw xAException;
                        }
                        int validFlags = 638582786;
                        if ((flag & validFlags) != flag) {
                            if (bl) {
                                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleXAResource.end(): XAER_INVAL: invalid flag");
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, xAException);
                            }
                            throw xAException;
                        }
                        Xid stackedXid = null;
                        isTMSUCCESS = (flag & 0x4000000) != 0;
                        boolean bl2 = isTMFAIL = (flag & 0x20000000) != 0;
                        if (isTMSUCCESS || isTMFAIL) {
                            stackedXid = super.suspendStacked((Xid)xid2);
                        }
                        try {
                            boolean isLocallySuspended = false;
                            if (isTMSUCCESS || isTMFAIL) {
                                isLocallySuspended = this.isXidSuspended((Xid)xid2);
                                if (isLocallySuspended) {
                                    super.resumeStacked((Xid)xid2);
                                }
                                this.removeXidFromList((Xid)xid2);
                            } else if (flag == 0x2000000) {
                                boolean[] flags = new boolean[]{false};
                                super.createOrUpdateXid((Xid)xid2, true, flags);
                                isLocallySuspended = flags[0];
                            }
                            returnVal = this.doEnd((Xid)xid2, (int)flag, isLocallySuspended);
                        }
                        catch (SQLException sqle) {
                            this.checkError(sqle, -3);
                        }
                        if (stackedXid != null) {
                            super.resumeStacked(stackedXid);
                        } else if (this.isXidListEmpty()) {
                            this.exitGlobalTxnMode();
                            this.activeXid = null;
                        }
                        if (bl) {
                            this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleXAResource.end(): return status returnVal = " + returnVal);
                        }
                        this.checkError(returnVal);
                        if (isTMSUCCESS && flag != 0x4000000 || isTMFAIL && flag != 0x20000000) {
                            if (bl) {
                                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "OracleXAResource.end(): XAER_INVAL: The flag combines TMSUCCESS or TMFAIL with other flags: " + (int)flag);
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, xAException);
                            }
                            throw xAException;
                        }
                    }
                    catch (Throwable throwable) {
                        this.restoreAutoCommitModeForGlobalTransaction();
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, throwable2);
                        }
                        throw throwable2;
                    }
                    this.restoreAutoCommitModeForGlobalTransaction();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 9] lbl86 : MonitorExitStatement: MONITOREXIT : var4_6
                    Throwable throwable3 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, throwable3);
                    }
                    throw throwable3;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable4 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleXAResource.class, $$$methodRef$$$2, this, throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException, SQLException {
        boolean bl2 = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, xid, n2, bl);
            }
            CallableStatement cstmt = null;
            int returnVal = -1;
            try {
                void flag;
                void xid2;
                cstmt = this.connection.prepareCall(xa_end_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid2.getFormatId());
                cstmt.setBytes(3, xid2.getGlobalTransactionId());
                cstmt.setBytes(4, xid2.getBranchQualifier());
                cstmt.setInt(5, (int)flag);
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                try {
                    returnVal = s2.getErrorCode();
                    if (bl2) {
                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "OracleXAResource.end() returnVal=" + returnVal);
                    }
                    if (returnVal == 0) {
                        XAException xAException = (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, xAException);
                        }
                        throw xAException;
                    }
                    SQLException sQLException = s2;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    cstmt = null;
                    Throwable throwable2 = throwable;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            cstmt = null;
            int n3 = returnVal;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, n3);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleXAResource.class, $$$methodRef$$$3, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        boolean bl2 = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection physicalConnection;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, xid, bl);
            }
            try {
                if (this.connection instanceof ReplayableConnection) {
                    ((ReplayableConnection)((Object)this.connection)).disableReplay();
                    physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                } else {
                    physicalConnection = this.connection;
                }
            }
            catch (SQLException sqle) {
                physicalConnection = this.connection;
                this.checkError(sqle, -3);
            }
            Connection connection = physicalConnection;
            synchronized (connection) {
                try {
                    void xid2;
                    if (xid2 == null) {
                        if (bl2) {
                            this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "OracleXAResource.commit(): XAER_INVAL: xid is null");
                        }
                        XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, xAException);
                        }
                        throw xAException;
                    }
                    Xid stackedXid = null;
                    if (this.needStackingForCommitRollbackPrepare) {
                        stackedXid = super.suspendStacked((Xid)xid2);
                    } else {
                        this.removeXidFromList((Xid)xid2);
                        if (this.activeXid == null) {
                            this.exitGlobalTxnMode();
                        }
                    }
                    try {
                        try {
                            void onePhase;
                            this.doCommit((Xid)xid2, (boolean)onePhase);
                        }
                        catch (SQLException sqle) {
                            this.checkError(sqle, -3);
                        }
                    }
                    catch (XAException xae) {
                        if (xae.errorCode == -7) {
                            if (bl2) {
                                this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "OracleXAResource.commit(): Error during commit is fatal so, close the connection.");
                            }
                            try {
                                physicalConnection.close();
                            }
                            catch (SQLException ea) {
                                if (bl2) {
                                    this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "OracleXAResource.commit(): connection.close yielded: " + ea.getMessage());
                                }
                            }
                        } else if (this.needStackingForCommitRollbackPrepare) {
                            super.resumeStacked(stackedXid);
                        }
                        XAException xAException = xae;
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, xAException);
                        }
                        throw xAException;
                    }
                    if (this.needStackingForCommitRollbackPrepare) {
                        super.resumeStacked(stackedXid);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 11] lbl63 : MonitorExitStatement: MONITOREXIT : var4_6
                    Throwable throwable2 = throwable;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleXAResource.class, $$$methodRef$$$4, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doCommit(Xid xid, boolean bl) throws XAException, SQLException {
        boolean bl2 = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, xid, bl);
            }
            CallableStatement cstmt = null;
            try {
                void onePhase;
                void xid2;
                cstmt = this.connection.prepareCall(xa_commit_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid2.getFormatId());
                cstmt.setBytes(3, xid2.getGlobalTransactionId());
                cstmt.setBytes(4, xid2.getBranchQualifier());
                cstmt.setInt(5, onePhase != false ? 1 : 0);
                cstmt.execute();
                int returnVal2332 = cstmt.getInt(1);
                this.checkError(returnVal2332, -7);
            }
            catch (SQLException s2) {
                try {
                    int returnVal = s2.getErrorCode();
                    if (bl2) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "OracleXAResource.commit() returnVal=" + returnVal);
                    }
                    if (returnVal == 0) {
                        XAException xAException = (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, xAException);
                        }
                        throw xAException;
                    }
                    SQLException sQLException = s2;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    cstmt = null;
                    Throwable throwable2 = throwable;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException returnVal2332) {
                // empty catch block
            }
            cstmt = null;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleXAResource.class, $$$methodRef$$$5, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block35: {
                Connection physicalConnection;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, xid);
                }
                try {
                    if (this.connection instanceof ReplayableConnection) {
                        ((ReplayableConnection)((Object)this.connection)).disableReplay();
                        physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                    } else {
                        physicalConnection = this.connection;
                    }
                }
                catch (SQLException sqle) {
                    physicalConnection = this.connection;
                    this.checkError(sqle, -3);
                }
                Connection connection = physicalConnection;
                synchronized (connection) {
                    try {
                        void xid2;
                        int returnVal = 0;
                        if (xid2 == null) {
                            if (bl) {
                                this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "OracleXAResource.prepare(): XAER_INVAL: xid is null");
                            }
                            XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, xAException);
                            }
                            throw xAException;
                        }
                        Xid stackedXid = null;
                        if (this.needStackingForCommitRollbackPrepare) {
                            stackedXid = super.suspendStacked((Xid)xid2);
                        }
                        try {
                            try {
                                returnVal = this.doPrepare((Xid)xid2);
                                if (returnVal != 0 && returnVal != 3) {
                                    int x_e;
                                    if (bl) {
                                        this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "OracleXAResource.prepare(): return status returnVal = " + returnVal);
                                    }
                                    if ((x_e = OracleXAException.errorConvert(returnVal)) != 0 && x_e != 3) {
                                        XAException xAException = (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), returnVal).fillInStackTrace();
                                        if (bl) {
                                            ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, xAException);
                                        }
                                        throw xAException;
                                    }
                                    returnVal = x_e;
                                }
                            }
                            catch (SQLException sqle) {
                                this.checkError(sqle, -3);
                            }
                        }
                        catch (XAException xaex) {
                            block34: {
                                if (xaex.errorCode == -7) {
                                    if (bl) {
                                        this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "OracleXAResource.commit(): Error during commit is fatal so, close the connection.");
                                    }
                                    try {
                                        physicalConnection.close();
                                    }
                                    catch (SQLException ea) {
                                        if (bl) {
                                            this.debug($$$loggerRef$$$6, Level.FINEST, $$$methodRef$$$6, "OracleXAResource.commit(): connection.close yielded: " + ea.getMessage());
                                        }
                                        break block34;
                                    }
                                }
                                if (this.needStackingForCommitRollbackPrepare) {
                                    super.resumeStacked(stackedXid);
                                }
                            }
                            XAException xAException = xaex;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, xAException);
                            }
                            throw xAException;
                        }
                        if (this.needStackingForCommitRollbackPrepare) {
                            super.resumeStacked(stackedXid);
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 6] lbl66 : MonitorExitStatement: MONITOREXIT : connection
                        n2 = returnVal;
                        if (!bl) break block35;
                    }
                    catch (Throwable throwable) {
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 11] lbl71 : MonitorExitStatement: MONITOREXIT : connection
                        Throwable throwable2 = throwable;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, throwable2);
                        }
                        throw throwable2;
                    }
                }
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleXAResource.class, $$$methodRef$$$6, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, xid);
            }
            int returnVal = 0;
            CallableStatement cstmt = null;
            try {
                void xid2;
                cstmt = this.connection.prepareCall(xa_prepare_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid2.getFormatId());
                cstmt.setBytes(3, xid2.getGlobalTransactionId());
                cstmt.setBytes(4, xid2.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                try {
                    int errorCode = s2.getErrorCode();
                    if (bl) {
                        this.debug($$$loggerRef$$$7, Level.FINEST, $$$methodRef$$$7, "OracleXAResource.prepare() errorCode=" + errorCode);
                    }
                    if (errorCode == 0) {
                        XAException xAException = (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, xAException);
                        }
                        throw xAException;
                    }
                    SQLException sQLException = s2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    cstmt = null;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            cstmt = null;
            int n2 = returnVal;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, n2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleXAResource.class, $$$methodRef$$$7, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void forget(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection physicalConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, xid);
            }
            try {
                if (this.connection instanceof ReplayableConnection) {
                    ((ReplayableConnection)((Object)this.connection)).disableReplay();
                    physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                } else {
                    physicalConnection = this.connection;
                }
            }
            catch (SQLException sqle) {
                physicalConnection = this.connection;
                this.checkError(sqle, -3);
            }
            Connection connection = physicalConnection;
            synchronized (connection) {
                try {
                    void xid2;
                    int returnVal = 0;
                    if (xid2 == null) {
                        if (bl) {
                            this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "OracleXAResource.forget(): XAER_INVAL: xid is null");
                        }
                        XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, xAException);
                        }
                        throw xAException;
                    }
                    this.removeXidFromList((Xid)xid2);
                    try {
                        returnVal = this.doForget((Xid)xid2);
                    }
                    catch (SQLException sqle) {
                        this.checkError(sqle, -3);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$8, Level.FINEST, $$$methodRef$$$8, "OracleXAResource.forget(): return status returnVal = " + returnVal);
                    }
                    this.checkError(returnVal);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl39 : MonitorExitStatement: MONITOREXIT : var3_5
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleXAResource.class, $$$methodRef$$$8, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doForget(Xid xid) throws XAException, SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, xid);
            }
            int returnVal = 0;
            CallableStatement cstmt = null;
            try {
                void xid2;
                cstmt = this.connection.prepareCall(xa_forget_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid2.getFormatId());
                cstmt.setBytes(3, xid2.getGlobalTransactionId());
                cstmt.setBytes(4, xid2.getBranchQualifier());
                cstmt.execute();
                returnVal = cstmt.getInt(1);
            }
            catch (SQLException s2) {
                try {
                    returnVal = s2.getErrorCode();
                    if (bl) {
                        this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "OracleXAResource.forget() returnVal=" + returnVal);
                    }
                    if (returnVal == 0) {
                        XAException xAException = (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, xAException);
                        }
                        throw xAException;
                    }
                    SQLException sQLException = s2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    cstmt = null;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            cstmt = null;
            int n2 = returnVal;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, n2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleXAResource.class, $$$methodRef$$$9, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection physicalConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, xid);
            }
            try {
                if (this.connection instanceof ReplayableConnection) {
                    ((ReplayableConnection)((Object)this.connection)).disableReplay();
                    physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                } else {
                    physicalConnection = this.connection;
                }
            }
            catch (SQLException sqle) {
                physicalConnection = this.connection;
                this.checkError(sqle, -3);
            }
            Connection connection = physicalConnection;
            synchronized (connection) {
                try {
                    void xid2;
                    int returnVal = 0;
                    if (xid2 == null) {
                        if (bl) {
                            this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "OracleXAResource.rollback(): XAER_INVAL: xid is null");
                        }
                        XAException xAException = (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, xAException);
                        }
                        throw xAException;
                    }
                    Xid stackedXid = null;
                    if (this.needStackingForCommitRollbackPrepare) {
                        stackedXid = super.suspendStacked((Xid)xid2);
                    } else {
                        this.removeXidFromList((Xid)xid2);
                        if (this.activeXid == null) {
                            this.exitGlobalTxnMode();
                        }
                    }
                    try {
                        this.doRollback((Xid)xid2);
                    }
                    catch (SQLException sqle) {
                        this.checkError(sqle, -3);
                    }
                    if (this.needStackingForCommitRollbackPrepare) {
                        super.resumeStacked(stackedXid);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "OracleXAResource.rollback(): return status returnVal = " + returnVal);
                    }
                    this.checkError(returnVal);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 7] lbl47 : MonitorExitStatement: MONITOREXIT : var3_5
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleXAResource.class, $$$methodRef$$$10, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRollback(Xid xid) throws XAException, SQLException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, xid);
            }
            CallableStatement cstmt = null;
            try {
                void xid2;
                cstmt = this.connection.prepareCall(xa_rollback_post_816);
                cstmt.registerOutParameter(1, 2);
                cstmt.setInt(2, xid2.getFormatId());
                cstmt.setBytes(3, xid2.getGlobalTransactionId());
                cstmt.setBytes(4, xid2.getBranchQualifier());
                cstmt.execute();
                int returnVal2332 = cstmt.getInt(1);
                if (bl) {
                    this.debug($$$loggerRef$$$11, Level.FINEST, $$$methodRef$$$11, "OracleXAResource.doRollback() returnVal=" + returnVal2332);
                }
                this.checkError(returnVal2332, -7);
            }
            catch (SQLException s2) {
                try {
                    int errorCode = s2.getErrorCode();
                    if (errorCode == 0) {
                        XAException xAException = (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, xAException);
                        }
                        throw xAException;
                    }
                    SQLException sQLException = s2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, sQLException);
                    }
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    try {
                        if (cstmt != null) {
                            cstmt.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    cstmt = null;
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            try {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
            catch (SQLException returnVal2332) {
                // empty catch block
            }
            cstmt = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleXAResource.class, $$$methodRef$$$11, this, throwable3);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void doTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            Connection physicalConnection;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this, n2, n3, stringArray, xidArray);
            }
            try {
                if (this.connection instanceof ReplayableConnection) {
                    ((ReplayableConnection)((Object)this.connection)).disableReplay();
                    physicalConnection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
                } else {
                    physicalConnection = this.connection;
                }
            }
            catch (SQLException sqle) {
                physicalConnection = this.connection;
                this.checkError(sqle, -3);
            }
            Connection connection = physicalConnection;
            synchronized (connection) {
                try {
                    void xids;
                    void dbnames;
                    void action;
                    void nsites;
                    this.doDoTwoPhaseAction((int)nsites, (int)action, (String[])dbnames, (Xid[])xids);
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 3, 5] lbl23 : MonitorExitStatement: MONITOREXIT : var6_8
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this, throwable2);
                    }
                    throw throwable2;
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleXAResource.class, $$$methodRef$$$12, this, throwable3);
            }
            throw throwable;
        }
    }

    protected int doDoTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleXAResource.class, $$$methodRef$$$13, this, n2, n3, stringArray, xidArray);
            }
            XAException xAException = (XAException)DatabaseError.createXAException(-6).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, OracleXAResource.class, $$$methodRef$$$13, this, xAException);
            }
            throw xAException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleXAResource.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    private static byte[] getSerializedBytes(Xid xid) {
        boolean bl = (0x8000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] byArray;
            block8: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, null, xid);
                }
                try {
                    Xid xid2;
                    byArray = Util.serializeObject(xid2);
                    if (!bl) break block8;
                }
                catch (IOException ioe) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, "OracleXAResource.getSerializedBytes() got exception: " + ioe);
                    }
                    byte[] byArray2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, null, byArray2);
                        ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, null, byArray);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, null, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleXAResource.class, $$$methodRef$$$14, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$16 = OracleXAResource.class.getDeclaredConstructor(Connection.class, OracleXAConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleXAResource.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleXAResource.class.getDeclaredMethod("getSerializedBytes", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleXAResource.class.getDeclaredMethod("doDoTwoPhaseAction", Integer.TYPE, Integer.TYPE, String[].class, Xid[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleXAResource.class.getDeclaredMethod("doTwoPhaseAction", Integer.TYPE, Integer.TYPE, String[].class, Xid[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleXAResource.class.getDeclaredMethod("doRollback", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleXAResource.class.getDeclaredMethod("rollback", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleXAResource.class.getDeclaredMethod("doForget", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleXAResource.class.getDeclaredMethod("forget", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleXAResource.class.getDeclaredMethod("doPrepare", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleXAResource.class.getDeclaredMethod("prepare", Xid.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleXAResource.class.getDeclaredMethod("doCommit", Xid.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleXAResource.class.getDeclaredMethod("commit", Xid.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleXAResource.class.getDeclaredMethod("doEnd", Xid.class, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleXAResource.class.getDeclaredMethod("end", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleXAResource.class.getDeclaredMethod("doStart", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleXAResource.class.getDeclaredMethod("start", Xid.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
        xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
        xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
        xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
        xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
        xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
        xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
        xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
        xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
        xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
        xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
        xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    }
}

