/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.io.PrintStream;
import java.lang.reflect.Executable;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.InvalidSyntaxException;

public final class NVPair {
    public static int RHS_NONE;
    public static int RHS_ATOM;
    public static int RHS_LIST;
    public static int LIST_REGULAR;
    public static int LIST_COMMASEP;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    private String _linesep = System.getProperty("line.separator");
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;

    public NVPair(String name) {
        this._name = name;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String name, String atom) throws InvalidSyntaxException {
        this(name);
        this.setAtom(atom);
    }

    public NVPair(String name, NVPair child) {
        this(name);
        this.addListElement(child);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public NVPair getParent() {
        return this._parent;
    }

    private void _setParent(NVPair parent) {
        this._parent = parent;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public int getListType() {
        return this._listType;
    }

    public void setListType(int type) {
        this._listType = type;
    }

    public String getAtom() {
        return this._atom;
    }

    public void setAtom(String atom) throws InvalidSyntaxException {
        if (this._name.indexOf("COMMENT") == -1 && this.containsComment(atom)) {
            Object[] local = new Object[]{"#", this.getName()};
            throw new InvalidSyntaxException("UnexpectedChar-04603", local);
        }
        this._rhsType = RHS_ATOM;
        this._atom = atom;
        this._list = null;
    }

    private boolean containsComment(String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (str.charAt(i2) != '#') continue;
            if (i2 != 0) {
                if (str.charAt(i2 - 1) == '\\') continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public NVPair getListElement(int pos) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(pos);
    }

    public void addListElement(NVPair pair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(pair);
        pair._setParent(this);
    }

    public void removeListElement(int pos) {
        if (this._list != null) {
            this._list.removeElementAt(pos);
            if (this.getListSize() == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    private String space(int count) {
        String blank_str = new String("");
        for (int i2 = 0; i2 < count; ++i2) {
            blank_str = blank_str + " ";
        }
        return blank_str;
    }

    public String trimValueToString() {
        String tmpStr = this.valueToString().trim();
        return tmpStr.substring(1, tmpStr.length() - 1);
    }

    public String valueToString() {
        String out;
        block3: {
            block4: {
                block2: {
                    out = "";
                    if (this._rhsType != RHS_ATOM) break block2;
                    out = out + this._atom;
                    break block3;
                }
                if (this._rhsType != RHS_LIST) break block3;
                if (this._listType != LIST_REGULAR) break block4;
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    out = out + this.getListElement(i2).toString();
                }
                break block3;
            }
            if (this._listType != LIST_COMMASEP) break block3;
            for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                NVPair listElem = this.getListElement(i3);
                out = out + listElem.getName();
                if (i3 == this.getListSize() - 1) continue;
                out = out + ", ";
            }
        }
        return out;
    }

    @DisableTrace
    public String toString() {
        String out = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            out = out + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    out = out + this.getListElement(i2).toString();
                }
            } else if (this._listType == LIST_COMMASEP) {
                out = out + " (";
                for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                    NVPair listElem = this.getListElement(i3);
                    out = out + listElem.getName();
                    if (i3 == this.getListSize() - 1) continue;
                    out = out + ", ";
                }
                out = out + ")";
            }
        }
        out = out + ")";
        return out;
    }

    @DisableTrace
    public String toString(int level, boolean enable) {
        String out = "";
        String temp = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                String rhs = "";
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    rhs = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? rhs + this.getListElement(i2).toString(level + 1, false) : rhs + this.getListElement(i2).toString(level + 1, true);
                }
                if (!rhs.equals("")) {
                    out = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? out + this.space(level * 2) + "(" + this._name + " = " : out + this.space(level * 2) + "(" + this._name + " =" + this._linesep;
                    out = out + rhs;
                    out = temp.equalsIgnoreCase("ADDRESS") || temp.equalsIgnoreCase("RULE") ? out + ")" + this._linesep : (level == 0 ? out + ")" : (level == 1 ? out + this.space(level * 2) + ")" : out + this.space(level * 2) + ")" + this._linesep));
                }
            } else if (this._listType == LIST_COMMASEP) {
                out = out + "(" + this._name + "= (";
                for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                    NVPair listElem = this.getListElement(i3);
                    out = out + listElem.getName();
                    if (i3 == this.getListSize() - 1) continue;
                    out = out + ", ";
                }
                out = out + "))";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (level == 0) {
                if (temp.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    out = out + "(" + this._atom + ")";
                } else {
                    out = out + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (temp.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                out = out + this._atom + this._linesep;
            } else if (!enable) {
                out = out + "(" + this._name + " = " + this._atom + ")";
            } else {
                out = out + this.space(level * 2) + "(" + this._name + " = " + this._atom + ")";
                out = out + this._linesep;
            }
        }
        return out;
    }

    public String modifyCommentString(String str) {
        String str1 = "";
        for (int offset = 0; offset < str.length(); ++offset) {
            char current_char = str.charAt(offset);
            switch (current_char) {
                case '\\': {
                    if (str.charAt(offset + 1) != '(' && str.charAt(offset + 1) != '=' && str.charAt(offset + 1) != ')' && str.charAt(offset + 1) != ',' && str.charAt(offset + 1) != '\\') break;
                }
            }
            int n2 = ++offset;
            str1 = str1 + str.charAt(n2);
        }
        return str1;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintStream pout) {
        if (this._rhsType == RHS_ATOM) {
            pout.println("          (" + this._name + " = " + this._atom + ")");
        } else if (this._rhsType == RHS_LIST) {
            for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                this.getListElement(i2).println(pout);
            }
        }
    }

    static {
        try {
            $$$methodRef$$$22 = NVPair.class.getDeclaredConstructor(String.class, NVPair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = NVPair.class.getDeclaredConstructor(String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = NVPair.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = NVPair.class.getDeclaredMethod("println", PrintStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = NVPair.class.getDeclaredMethod("println", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = NVPair.class.getDeclaredMethod("modifyCommentString", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = NVPair.class.getDeclaredMethod("valueToString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = NVPair.class.getDeclaredMethod("trimValueToString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = NVPair.class.getDeclaredMethod("space", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NVPair.class.getDeclaredMethod("removeListElement", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NVPair.class.getDeclaredMethod("addListElement", NVPair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NVPair.class.getDeclaredMethod("getListElement", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NVPair.class.getDeclaredMethod("getListSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NVPair.class.getDeclaredMethod("containsComment", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NVPair.class.getDeclaredMethod("setAtom", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NVPair.class.getDeclaredMethod("getAtom", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NVPair.class.getDeclaredMethod("setListType", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NVPair.class.getDeclaredMethod("getListType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NVPair.class.getDeclaredMethod("getRHSType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NVPair.class.getDeclaredMethod("_setParent", NVPair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NVPair.class.getDeclaredMethod("getParent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NVPair.class.getDeclaredMethod("setName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NVPair.class.getDeclaredMethod("getName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        RHS_NONE = 0;
        RHS_ATOM = 1;
        RHS_LIST = 2;
        LIST_REGULAR = 3;
        LIST_COMMASEP = 4;
    }
}

