/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.dms.instrument.NounIntf;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EnvVariableResolver;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class ConnStrategy {
    static final boolean DEBUG = false;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    private int lastRetryConnectDescription = 0;
    private final Properties userProp;
    private ConnectDescription currentDescription;
    private ArrayList<ConnectDescription> descriptionList = new ArrayList(4);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public ConnStrategy(Properties up) {
        this.osuser = up.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = up.getProperty("oracle.jdbc.v$session.program");
        DownHostsCache.DOWN_HOSTS_TIMEOUT = Integer.parseInt(up.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT"));
        this.userProp = up;
        this.createSocketOptions(up);
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(Properties up) {
        String propertyKey = null;
        String propertyValue = null;
        boolean tcpNoDelayParam = false;
        Enumeration<Object> e2 = up.keys();
        while (e2.hasMoreElements()) {
            propertyKey = (String)e2.nextElement();
            if (propertyKey.equalsIgnoreCase("TCP.NODELAY")) {
                tcpNoDelayParam = true;
                propertyValue = up.getProperty("TCP.NODELAY").toUpperCase();
                if (propertyValue.equals("NO")) {
                    this.socketOptions.put((Object)0, "NO");
                    continue;
                }
                this.socketOptions.put((Object)0, "YES");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.READ_TIMEOUT");
                this.socketOptions.put((Object)3, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.CONNECT_TIMEOUT");
                this.socketOptions.put((Object)2, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(propertyValue, false, 0)));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                propertyValue = up.getProperty("oracle.net.ssl_server_dn_match");
                this.socketOptions.put((Object)4, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_server_cert_dn")) {
                propertyValue = up.getProperty("oracle.net.ssl_server_cert_dn");
                this.socketOptions.put((Object)28, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_location")) {
                propertyValue = up.getProperty("oracle.net.wallet_location");
                this.socketOptions.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(propertyValue, up));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.wallet_password")) {
                propertyValue = up.getProperty("oracle.net.wallet_password");
                this.socketOptions.put((Object)16, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_version")) {
                propertyValue = up.getProperty("oracle.net.ssl_version");
                this.socketOptions.put((Object)6, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                propertyValue = up.getProperty("oracle.net.ssl_cipher_suites");
                this.socketOptions.put((Object)7, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStore");
                this.socketOptions.put((Object)8, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStoreType");
                this.socketOptions.put((Object)9, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                propertyValue = up.getProperty("javax.net.ssl.keyStorePassword");
                this.socketOptions.put((Object)10, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStore");
                this.socketOptions.put((Object)11, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStoreType");
                this.socketOptions.put((Object)12, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                propertyValue = up.getProperty("javax.net.ssl.trustStorePassword");
                this.socketOptions.put((Object)13, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                propertyValue = up.getProperty("ssl.keyManagerFactory.algorithm");
                this.socketOptions.put((Object)14, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                propertyValue = up.getProperty("FORCE_DNS_LOAD_BALANCING");
                this.socketOptions.put((Object)18, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.keepAlive")) {
                propertyValue = up.getProperty("oracle.net.keepAlive");
                if (Boolean.parseBoolean(propertyValue)) {
                    this.socketOptions.put((Object)1, "YES");
                    continue;
                }
                this.socketOptions.put((Object)1, "NO");
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.useNio")) {
                propertyValue = up.getProperty("oracle.jdbc.useNio");
                this.socketOptions.put((Object)20, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetLocalIPForMsgq")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
                this.socketOptions.put((Object)21, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqTransport")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetMsgqTransport");
                this.socketOptions.put((Object)22, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqBusyWait")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
                this.socketOptions.put((Object)23, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.jdbc.javaNetMsgqKernelWait")) {
                propertyValue = up.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
                this.socketOptions.put((Object)24, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.OUTBOUND_CONNECT_TIMEOUT")) {
                propertyValue = up.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
                this.socketOptions.put((Object)25, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(propertyValue, true, 0)));
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.websocketUser")) {
                propertyValue = up.getProperty("oracle.net.websocketUser");
                this.socketOptions.put((Object)26, propertyValue);
                continue;
            }
            if (propertyKey.equalsIgnoreCase("oracle.net.websocketPassword")) {
                propertyValue = up.getProperty("oracle.net.websocketPassword");
                this.socketOptions.put((Object)27, propertyValue);
                continue;
            }
            if (!propertyKey.equalsIgnoreCase("oracle.net.ssl_certificate_alias")) continue;
            propertyValue = up.getProperty("oracle.net.ssl_certificate_alias");
            this.socketOptions.put((Object)29, propertyValue);
        }
        if (!tcpNoDelayParam && !this.reuseOpt) {
            this.socketOptions.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean keepAlive) {
        if (keepAlive) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt && !this.socketOptions.containsKey(1)) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF() {
        this.socketOptions.put((Object)18, "true");
    }

    public boolean hasMoreOptions() {
        int cOptsSize = 0;
        for (ConnectDescription desc : this.descriptionList) {
            cOptsSize += desc.getConnectOptions().size();
        }
        return this.nextOptToTry < cOptsSize;
    }

    public ConnOption execute(boolean startNewOCTOInterruptTask, NounIntf dmsParent) throws NetException {
        IOException causeException = null;
        for (int d2 = this.lastRetryConnectDescription; d2 < this.descriptionList.size(); ++d2) {
            ConnectDescription desc = this.descriptionList.get(d2);
            ArrayList<ConnOption> cOpts = desc.getConnectOptions();
            DownHostsCache.getInstance().reorderAddresses(cOpts);
            if (desc.getTransportConnectTimeout() >= 0) {
                this.socketOptions.put((Object)2, Integer.toString(desc.getTransportConnectTimeout()));
            }
            int outboundConnectTimeout = 0;
            if (desc.getConnectTimeout() >= 0) {
                outboundConnectTimeout = desc.getConnectTimeout();
            } else if (this.socketOptions.get(25) != null) {
                try {
                    outboundConnectTimeout = Integer.parseInt((String)this.socketOptions.get(25));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.sdu = desc.getSdu();
            this.tdu = desc.getTdu();
            this.retryCount = desc.getRetryCount();
            if (this.retryCount < 0) {
                this.retryCount = 0;
            }
            this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
            int delay = desc.getDelayInMillis();
            for (int i2 = this.lastRetryCounter; i2 <= this.retryCount; ++i2) {
                while (this.nextOptToTry < cOpts.size()) {
                    try {
                        this.copt = cOpts.get(this.nextOptToTry);
                        if (outboundConnectTimeout > 0 && startNewOCTOInterruptTask) {
                            TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, outboundConnectTimeout, Thread.currentThread());
                        }
                        if (this.copt.walletDirectory != null) {
                            this.socketOptions.put((Object)5, EnvVariableResolver.resolveFilePath(this.copt.walletDirectory, this.userProp));
                        }
                        if (this.copt.sslServerCertDN == null) {
                            this.copt.sslServerCertDN = (String)this.socketOptions.get(28);
                        }
                        if (this.copt.sslServerCertDN != null && this.socketOptions.get(4) == null) {
                            this.socketOptions.put((Object)4, "TRUE");
                        }
                        this.copt.connect(this.socketOptions, dmsParent);
                        this.copt.sdu = this.sdu;
                        this.copt.tdu = this.tdu;
                        this.optFound = true;
                        if (!this.copt.nt.hasMoreInetAddresses()) {
                            ++this.nextOptToTry;
                        }
                        this.lastRetryCounter = i2;
                        this.lastRetryConnectDescription = d2;
                        return this.copt;
                    }
                    catch (IOException err) {
                        DownHostsCache.getInstance().markDownHost(this.copt);
                        ++this.nextOptToTry;
                        if (outboundConnectTimeout > 0) {
                            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
                        }
                        causeException = err;
                    }
                }
                this.nextOptToTry = 0;
                if (delay <= 0 || i2 >= this.retryCount) continue;
                try {
                    Thread.sleep(delay);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.lastRetryCounter = 0;
        }
        if (causeException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(causeException);
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.descriptionList = null;
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.copt.isConnectionSocketKeepAlive();
    }

    public ConnectDescription newConnectDescription() {
        this.currentDescription = new ConnectDescription();
        return this.currentDescription;
    }

    public ConnectDescription currentDescription() {
        return this.currentDescription;
    }

    public void closeDescription() {
        this.descriptionList.add(this.currentDescription);
        this.currentDescription = null;
    }

    public List<ConnectDescription> getAllDescriptions() {
        return this.descriptionList;
    }

    static {
        try {
            $$$methodRef$$$15 = ConnStrategy.class.getDeclaredConstructor(Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ConnStrategy.class.getDeclaredMethod("getAllDescriptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ConnStrategy.class.getDeclaredMethod("closeDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ConnStrategy.class.getDeclaredMethod("currentDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ConnStrategy.class.getDeclaredMethod("newConnectDescription", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ConnStrategy.class.getDeclaredMethod("isConnectionSocketKeepAlive", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ConnStrategy.class.getDeclaredMethod("getOption", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ConnStrategy.class.getDeclaredMethod("clearElements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ConnStrategy.class.getDeclaredMethod("optAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ConnStrategy.class.getDeclaredMethod("execute", Boolean.TYPE, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ConnStrategy.class.getDeclaredMethod("hasMoreOptions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ConnStrategy.class.getDeclaredMethod("addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ConnStrategy.class.getDeclaredMethod("addSocketOptions", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ConnStrategy.class.getDeclaredMethod("createSocketOptions", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ConnStrategy.class.getDeclaredMethod("getProgramName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ConnStrategy.class.getDeclaredMethod("getOSUsername", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

