/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.SocketChannelWrapper;

public class SSLSocketChannel
extends SocketChannelWrapper {
    private final SSLEngine sslEngine;
    private ByteBuffer localUnwrapBuffer;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private boolean isClosed = false;
    private boolean isHandshakeDone = false;
    private final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;

    public SSLSocketChannel(SocketChannel channel, SSLEngine engine) throws IOException {
        super(channel);
        this.socketChannel = channel;
        this.sslEngine = engine;
        this.initializeBuffers();
    }

    @Override
    public int read(ByteBuffer dstBuffer) throws IOException {
        int readBytesCount;
        if (this.isClosed()) {
            return -1;
        }
        if (dstBuffer == null || !dstBuffer.hasRemaining()) {
            return 0;
        }
        if (!this.isHandshakeDone) {
            this.doSSLHandshake();
        }
        if ((readBytesCount = this.readFromLocalUnwrapBuffer(dstBuffer)) == 0) {
            int dstBufferInitialPosition = dstBuffer.position();
            this.fillAndUnwrap(dstBuffer);
            readBytesCount = dstBuffer.position() - dstBufferInitialPosition;
        }
        return readBytesCount;
    }

    @Override
    public int write(ByteBuffer srcBuffer) throws IOException {
        if (this.isClosed()) {
            throw new ClosedChannelException();
        }
        if (!this.isHandshakeDone) {
            this.doSSLHandshake();
        }
        if (!this.writeToSocket()) {
            return 0;
        }
        int initialPosition = srcBuffer.position();
        this.wrapAndWriteToSocket(srcBuffer);
        if (this.writeBuffer.hasRemaining() && !srcBuffer.hasRemaining()) {
            boolean flushSuccessful = false;
            for (int attemptCount = 0; !flushSuccessful && attemptCount < 10; ++attemptCount) {
                flushSuccessful = this.writeToSocket();
            }
            if (!flushSuccessful) {
                throw new IOException("Unable to write to the socket");
            }
        }
        return initialPosition - srcBuffer.position();
    }

    private void wrapAndWriteToSocket(ByteBuffer srcBuffer) throws IOException {
        boolean wrapSuccessful = false;
        while (srcBuffer.hasRemaining()) {
            SSLEngineResult result = this.wrap(srcBuffer);
            if (result.getStatus() != SSLEngineResult.Status.OK) {
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    if (wrapSuccessful) {
                        if (!this.flushWriteBuffer()) break;
                        this.writeBuffer.clear();
                        continue;
                    }
                    throw new IOException("Write error '" + (Object)((Object)result.getStatus()) + '\'');
                }
                this.shutdown();
                throw new IOException("Write error '" + (Object)((Object)result.getStatus()) + '\'');
            }
            wrapSuccessful = true;
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.runTasks();
        }
        this.flushWriteBuffer();
    }

    private boolean flushWriteBuffer() throws IOException {
        this.writeBuffer.flip();
        return this.writeToSocket();
    }

    public boolean hasRemaining() {
        return this.readBuffer.hasRemaining() || this.localUnwrapBuffer.hasRemaining();
    }

    private boolean fillAndUnwrap(ByteBuffer dstBuffer) throws IOException {
        boolean unwrapSuccessful;
        boolean readFromSocket;
        SSLEngineResult wrapResult = null;
        boolean useLocalUnwrapBuffer = false;
        boolean bl = readFromSocket = !this.readBuffer.hasRemaining();
        while (wrapResult == null || wrapResult.getStatus() != SSLEngineResult.Status.OK) {
            if (readFromSocket) {
                if (this.fillReadBuffer()) {
                    readFromSocket = false;
                } else {
                    return false;
                }
            }
            if ((wrapResult = useLocalUnwrapBuffer ? this.unwrapToLocalBuffer() : this.unwrapData(dstBuffer)).getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                if (useLocalUnwrapBuffer) {
                    throw new IOException("Read error '" + (Object)((Object)wrapResult.getStatus()) + '\'');
                }
                useLocalUnwrapBuffer = true;
                readFromSocket = false;
                continue;
            }
            if (wrapResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            readFromSocket = true;
        }
        boolean bl2 = unwrapSuccessful = wrapResult != null && wrapResult.getStatus() == SSLEngineResult.Status.OK;
        if (unwrapSuccessful && useLocalUnwrapBuffer) {
            this.readFromLocalUnwrapBuffer(dstBuffer);
        }
        return unwrapSuccessful;
    }

    private SSLEngineResult unwrapToLocalBuffer() throws IOException {
        assert (!this.localUnwrapBuffer.hasRemaining());
        this.localUnwrapBuffer.clear();
        SSLEngineResult result = this.unwrapData(this.localUnwrapBuffer);
        this.localUnwrapBuffer.flip();
        return result;
    }

    private boolean fillReadBuffer() throws IOException {
        if (this.readBuffer.hasRemaining()) {
            this.readBuffer.compact();
        } else {
            this.readBuffer.clear();
        }
        int readBytes = this.readFromSocket();
        this.readBuffer.flip();
        return readBytes > 0;
    }

    private SSLEngineResult unwrapData(ByteBuffer dstBuffer) throws IOException {
        SSLEngineResult result = this.unwrap(this.readBuffer, dstBuffer);
        if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
            this.shutdown();
            throw new IOException("Read error '" + (Object)((Object)result.getStatus()) + '\'');
        }
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.runTasks();
        }
        return result;
    }

    private void shutdown() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            if (!this.sslEngine.isOutboundDone()) {
                this.sslEngine.closeOutbound();
                this.wrap(this.EMPTY_BUFFER);
                this.writeBuffer.flip();
                this.writeToSocket();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.closeUnderlyingChannel();
    }

    private void closeUnderlyingChannel() {
        try {
            if (this.socketChannel instanceof SocketChannelWrapper) {
                ((SocketChannelWrapper)this.socketChannel).disconnect();
            } else {
                this.socketChannel.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int readFromLocalUnwrapBuffer(ByteBuffer dstBuffer) {
        if (!this.localUnwrapBuffer.hasRemaining()) {
            return 0;
        }
        int bytesToCopy = Math.min(this.localUnwrapBuffer.remaining(), dstBuffer.remaining());
        for (int i2 = 0; i2 < bytesToCopy; ++i2) {
            dstBuffer.put(this.localUnwrapBuffer.get());
        }
        return bytesToCopy;
    }

    private void initializeBuffers() throws SSLException {
        SSLSession sslSession = this.sslEngine.getSession();
        this.localUnwrapBuffer = ByteBuffer.allocate(sslSession.getApplicationBufferSize());
        this.readBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.writeBuffer = ByteBuffer.allocate(sslSession.getPacketBufferSize());
        this.localUnwrapBuffer.limit(0);
        this.readBuffer.limit(0);
        this.writeBuffer.limit(0);
    }

    private void doSSLHandshake() throws IOException {
        if (this.isHandshakeDone) {
            return;
        }
        this.sslEngine.beginHandshake();
        SSLEngineResult.HandshakeStatus handShakeStatus = this.sslEngine.getHandshakeStatus();
        block6: while (!this.isHandshakeDone && !this.isClosed) {
            switch (handShakeStatus) {
                case NEED_TASK: {
                    handShakeStatus = this.runTasks();
                    continue block6;
                }
                case NEED_UNWRAP: {
                    handShakeStatus = this.unwrapHandshakeMessage();
                    continue block6;
                }
                case NEED_WRAP: {
                    handShakeStatus = this.wrapHandshakeMessage();
                    continue block6;
                }
                case FINISHED: {
                    this.isHandshakeDone = true;
                    continue block6;
                }
            }
            throw new IllegalStateException("Unexpected handshake status '" + (Object)((Object)handShakeStatus) + '\'');
        }
    }

    private SSLEngineResult.HandshakeStatus wrapHandshakeMessage() throws IOException {
        SSLEngineResult result = this.wrap(this.EMPTY_BUFFER);
        SSLEngineResult.HandshakeStatus handShakeStatus = result.getHandshakeStatus();
        if (result.getStatus() != SSLEngineResult.Status.OK) {
            throw new IOException("Handshake failed : " + (Object)((Object)result.getStatus()));
        }
        this.writeBuffer.flip();
        this.writeToSocket();
        return handShakeStatus;
    }

    private SSLEngineResult.HandshakeStatus unwrapHandshakeMessage() throws IOException {
        SSLEngineResult.HandshakeStatus handShakeStatus;
        SSLEngineResult result;
        if (!this.readBuffer.hasRemaining()) {
            this.readBuffer.clear();
            while (this.readFromSocket() == 0) {
            }
            this.readBuffer.flip();
        }
        do {
            this.localUnwrapBuffer.clear();
            result = this.unwrap(this.readBuffer, this.localUnwrapBuffer);
            handShakeStatus = result.getHandshakeStatus();
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                this.readBuffer.compact();
                this.readBuffer.flip();
                this.localUnwrapBuffer.flip();
                continue;
            }
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                this.readBuffer.compact();
                if (this.readBuffer.position() == this.readBuffer.capacity()) {
                    throw new IOException("Handshake failed : SSL packet is too big to hold in the read buffer");
                }
                while (this.readFromSocket() == 0) {
                }
                this.readBuffer.flip();
                continue;
            }
            throw new IOException("Handshake failed : " + (Object)((Object)result.getStatus()));
        } while (result.getStatus() != SSLEngineResult.Status.OK);
        return handShakeStatus;
    }

    private SSLEngineResult unwrap(ByteBuffer srcBuffer, ByteBuffer destbuffer) throws IOException {
        try {
            return this.sslEngine.unwrap(srcBuffer, destbuffer);
        }
        catch (Exception e2) {
            throw (IOException)new IOException("IO Error " + e2.getMessage()).initCause(e2);
        }
    }

    private SSLEngineResult wrap(ByteBuffer srcBuffer) throws IOException {
        try {
            assert (!this.writeBuffer.hasRemaining());
            this.writeBuffer.clear();
            return this.sslEngine.wrap(srcBuffer, this.writeBuffer);
        }
        catch (Exception e2) {
            throw (IOException)new IOException("IO Error " + e2.getMessage()).initCause(e2);
        }
    }

    private int readFromSocket() throws IOException {
        if (!this.readBuffer.hasRemaining()) {
            throw new IOException("IO Error : No room left in the read buffer");
        }
        try {
            int bytesRead = this.socketChannel.read(this.readBuffer);
            if (bytesRead < 0) {
                throw new IOException("Connection closed");
            }
            return bytesRead;
        }
        catch (IOException x2) {
            try {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.shutdown();
            throw x2;
        }
    }

    private boolean writeToSocket() throws IOException {
        try {
            this.socketChannel.write(this.writeBuffer);
            return !this.writeBuffer.hasRemaining();
        }
        catch (IOException x2) {
            this.shutdown();
            throw x2;
        }
    }

    private boolean isClosed() throws IOException {
        return this.isClosed || !this.socketChannel.isOpen() || this.socketChannel.socket().isInputShutdown() || this.socketChannel.socket().isOutputShutdown();
    }

    private SSLEngineResult.HandshakeStatus runTasks() throws IOException {
        try {
            Runnable runnable;
            while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
                runnable.run();
            }
            return this.sslEngine.getHandshakeStatus();
        }
        catch (Exception e2) {
            throw (IOException)new IOException("IO Error " + e2.getMessage()).initCause(e2);
        }
    }

    @Override
    void disconnect() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.shutdown();
    }

    @DisableTrace
    public String toString() {
        return "SSLSocketChannel[" + this.socket().toString() + "]";
    }

    static {
        try {
            $$$methodRef$$$23 = SSLSocketChannel.class.getDeclaredConstructor(SocketChannel.class, SSLEngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = SSLSocketChannel.class.getDeclaredMethod("disconnect", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = SSLSocketChannel.class.getDeclaredMethod("runTasks", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = SSLSocketChannel.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = SSLSocketChannel.class.getDeclaredMethod("writeToSocket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = SSLSocketChannel.class.getDeclaredMethod("readFromSocket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = SSLSocketChannel.class.getDeclaredMethod("wrap", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = SSLSocketChannel.class.getDeclaredMethod("unwrap", ByteBuffer.class, ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = SSLSocketChannel.class.getDeclaredMethod("unwrapHandshakeMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = SSLSocketChannel.class.getDeclaredMethod("wrapHandshakeMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = SSLSocketChannel.class.getDeclaredMethod("doSSLHandshake", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SSLSocketChannel.class.getDeclaredMethod("initializeBuffers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SSLSocketChannel.class.getDeclaredMethod("readFromLocalUnwrapBuffer", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SSLSocketChannel.class.getDeclaredMethod("closeUnderlyingChannel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SSLSocketChannel.class.getDeclaredMethod("shutdown", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SSLSocketChannel.class.getDeclaredMethod("unwrapData", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SSLSocketChannel.class.getDeclaredMethod("fillReadBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SSLSocketChannel.class.getDeclaredMethod("unwrapToLocalBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SSLSocketChannel.class.getDeclaredMethod("fillAndUnwrap", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SSLSocketChannel.class.getDeclaredMethod("hasRemaining", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SSLSocketChannel.class.getDeclaredMethod("flushWriteBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SSLSocketChannel.class.getDeclaredMethod("wrapAndWriteToSocket", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SSLSocketChannel.class.getDeclaredMethod("write", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SSLSocketChannel.class.getDeclaredMethod("read", ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

