/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.AssociativeArrayEntry;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.COLLECTION_METADATA})
public class ArrayDescriptor
extends TypeDescriptor
implements OracleTypeMetaData.Array,
Serializable {
    public static final int TYPE_VARRAY = 3;
    public static final int TYPE_NESTED_TABLE = 2;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_ALL = 1;
    public static final int CACHE_LAST = 2;
    static final long serialVersionUID = 3838105394346513809L;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;

    /*
     * WARNING - void declaration
     */
    public static ArrayDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            String name;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, string, connection);
            }
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(name, (Connection)conn, false, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, arrayDescriptor);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void force;
            oracle.jdbc.OracleConnection conn;
            String name;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, string, connection, bl, bl2);
            }
            if (name == null || name.length() == 0 || conn == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(60, "ArrayDescriptor.createDescriptor: Invalid argument, 'name' should not be an empty string and 'conn' should not be null.").fillInStackTrace();
                if (bl3) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, sQLException);
                }
                throw sQLException;
            }
            conn = ConcreteProxyUtil.unwrapConnectionProxy(conn);
            SQLName sqlName = new SQLName(name, conn);
            String qualifiedName = sqlName.getName();
            ArrayDescriptor descriptor = null;
            if (force == false) {
                descriptor = (ArrayDescriptor)conn.getDescriptor(qualifiedName);
            }
            if (descriptor == null) {
                void recurse;
                short dbVersion = conn.physicalConnectionWithin().getVersionNumber();
                descriptor = dbVersion >= 12000 ? new ArrayDescriptor(name, (Connection)conn) : new ArrayDescriptor(sqlName, (Connection)conn);
                if (recurse != false) {
                    descriptor.initNamesRecursively();
                }
                conn.putDescriptor(qualifiedName, descriptor);
            }
            ArrayDescriptor arrayDescriptor = descriptor;
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, arrayDescriptor);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            SQLName sqlName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, sQLName, connection);
            }
            ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(sqlName, (Connection)conn, false, false);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, arrayDescriptor);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        boolean bl3 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void force;
            SQLName sqlName;
            oracle.jdbc.OracleConnection conn;
            if (bl3) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, sQLName, connection, bl, bl2);
            }
            conn = ConcreteProxyUtil.unwrapConnectionProxy(conn);
            String qualifiedName = sqlName.getName();
            ArrayDescriptor descriptor = null;
            if (force == false) {
                descriptor = (ArrayDescriptor)conn.getDescriptor(qualifiedName);
            }
            if (descriptor == null) {
                void recurse;
                descriptor = new ArrayDescriptor(sqlName, (Connection)conn);
                if (recurse != false) {
                    descriptor.initNamesRecursively();
                }
                conn.putDescriptor(qualifiedName, descriptor);
            }
            ArrayDescriptor arrayDescriptor = descriptor;
            if (bl3) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, arrayDescriptor);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl3) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    public static ArrayDescriptor createDescriptor(OracleTypeCOLLECTION oracleTypeCOLLECTION) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleTypeCOLLECTION otype;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, oracleTypeCOLLECTION);
            }
            String fullName = otype.getFullName();
            oracle.jdbc.OracleConnection conn = otype.getConnection();
            ArrayDescriptor descriptor = (ArrayDescriptor)(conn = ConcreteProxyUtil.unwrapConnectionProxy(conn)).getDescriptor(fullName);
            if (descriptor == null) {
                SQLName sqlName = new SQLName(otype.getSchemaName(), otype.getSimpleName(), otype.getConnection());
                descriptor = new ArrayDescriptor(sqlName, otype, (Connection)conn);
                conn.putDescriptor(fullName, descriptor);
            }
            ArrayDescriptor arrayDescriptor = descriptor;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, arrayDescriptor);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void conn;
            void tds;
            void version;
            void typoid;
            SQLName sqlName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, sQLName, byArray, n2, byArray2, oracleConnection);
            }
            OracleTypeADT interimPickler = new OracleTypeADT(sqlName, (byte[])typoid, (int)version, (byte[])tds, (OracleConnection)conn);
            interimPickler.init((byte[])tds, (OracleConnection)conn);
            OracleTypeCOLLECTION pickler = (OracleTypeCOLLECTION)interimPickler.cleanup();
            ArrayDescriptor arrayDescriptor = new ArrayDescriptor(sqlName, pickler, (Connection)conn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, arrayDescriptor);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, null);
            }
            return arrayDescriptor;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$5, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(String name, Connection conn) throws SQLException {
        super((short)122, name, conn);
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, name, conn);
            }
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null);
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$48, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$48, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(SQLName sqlName, Connection conn) throws SQLException {
        super((short)122, sqlName, conn);
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null, sqlName, conn);
            }
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null);
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$49, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$49, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(SQLName sqlName, OracleTypeCOLLECTION type, Connection conn) throws SQLException {
        super((short)122, sqlName, type, conn);
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, sqlName, type, conn);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null);
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$50, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$50, null, throwable2);
            }
            throw throwable;
        }
    }

    public ArrayDescriptor(OracleTypeCOLLECTION type, Connection conn) throws SQLException {
        super((short)122, type, conn);
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null, type, conn);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null);
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$51, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$51, null, throwable2);
            }
            throw throwable;
        }
    }

    ArrayDescriptor(byte[] _toid, int _toidVersion, Connection conn) throws SQLException {
        super((short)122);
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null, _toid, _toidVersion, conn);
            }
            this.toid = _toid;
            this.toidVersion = _toidVersion;
            this.setPhysicalConnectionOf(conn);
            this.initPickler();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null);
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$52, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$52, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            OracleTypeMetaData.Kind kind = OracleTypeMetaData.Kind.ARRAY;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, (Object)kind);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, null);
            }
            return kind;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, new Object[0]);
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getElementType().getTypeCode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, n2);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getBaseName() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, new Object[0]);
            }
            String ret = null;
            switch (this.getBaseType()) {
                case 12: {
                    ret = "VARCHAR";
                    break;
                }
                case 1: {
                    ret = "CHAR";
                    break;
                }
                case -9: {
                    ret = "NVARCHAR";
                    break;
                }
                case -15: {
                    ret = "NCHAR";
                    break;
                }
                case -2: {
                    ret = "RAW";
                    break;
                }
                case 6: {
                    ret = "FLOAT";
                    break;
                }
                case 2: {
                    ret = "NUMBER";
                    break;
                }
                case 8: {
                    ret = "DOUBLE";
                    break;
                }
                case 3: {
                    ret = "DECIMAL";
                    break;
                }
                case 91: {
                    ret = "DATE";
                    break;
                }
                case 93: {
                    ret = "TIMESTAMP";
                    break;
                }
                case -101: {
                    ret = "TIMESTAMP WITH TIME ZONE";
                    break;
                }
                case -102: {
                    ret = "TIMESTAMP WITH LOCAL TIME ZONE";
                    break;
                }
                case 2004: {
                    ret = "BLOB";
                    break;
                }
                case 2005: {
                    ret = "CLOB";
                    break;
                }
                case 2011: {
                    ret = "NCLOB";
                    break;
                }
                case -13: {
                    ret = "BFILE";
                    break;
                }
                case 2002: 
                case 2003: 
                case 2007: 
                case 2008: {
                    OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    ret = otype.getFullName();
                    break;
                }
                case 2006: {
                    OracleNamedType otype = (OracleNamedType)((OracleTypeCOLLECTION)this.pickler).getElementType();
                    ret = "REF " + ((OracleTypeREF)otype).getFullName();
                    break;
                }
                case 100: {
                    ret = "BINARY_FLOAT";
                    break;
                }
                case 101: {
                    ret = "BINARY_DOUBLE";
                    break;
                }
                case -104: {
                    ret = "INTERVALDS";
                    break;
                }
                case -103: {
                    ret = "INTERVALYM";
                    break;
                }
                default: {
                    ret = null;
                }
            }
            String string = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, string);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleTypeCOLLECTION getOracleTypeCOLLECTION() {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, new Object[0]);
            }
            OracleTypeCOLLECTION oracleTypeCOLLECTION = (OracleTypeCOLLECTION)this.pickler;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, oracleTypeCOLLECTION);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, null);
            }
            return oracleTypeCOLLECTION;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public OracleTypeMetaData.ArrayStorage getArrayStorage() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, new Object[0]);
            }
            OracleTypeMetaData.ArrayStorage arrayStorage = OracleTypeMetaData.ArrayStorage.withCode(this.getArrayType());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, (Object)arrayStorage);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, null);
            }
            return arrayStorage;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    public int getArrayType() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, new Object[0]);
            }
            int n2 = ((OracleTypeCOLLECTION)this.pickler).getUserCode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, n2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public long getMaxLength() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            long l2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, new Object[0]);
            }
            long l3 = l2 = this.getArrayType() == 3 ? ((OracleTypeCOLLECTION)this.pickler).getMaxLength() : 0L;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, l2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    public String descType() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, new Object[0]);
            }
            StringBuffer strBuf = new StringBuffer();
            String string = this.descType(strBuf, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, string);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void strBuf;
            int level;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$14, this, stringBuffer, n2);
            }
            String level_one = "";
            for (int i2 = 0; i2 < level; ++i2) {
                level_one = level_one + "  ";
            }
            String level_two = level_one + "  ";
            strBuf.append(level_one);
            strBuf.append(this.getTypeName());
            strBuf.append("\n");
            int tcode = this.getBaseType();
            if (tcode == 2002 || tcode == 2008) {
                StructDescriptor adt_desc = StructDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
                adt_desc.descType((StringBuffer)strBuf, (int)(level + true));
            } else if (tcode == 2003) {
                ArrayDescriptor array_desc = ArrayDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
                array_desc.descType((StringBuffer)strBuf, (int)(level + true));
            } else if (tcode == 2007) {
                OpaqueDescriptor opaque_desc = OpaqueDescriptor.createDescriptor(this.getBaseName(), (Connection)this.connection);
                opaque_desc.descType((StringBuffer)strBuf, (int)(level + true));
            } else {
                strBuf.append(level_two);
                strBuf.append(this.getBaseName());
                strBuf.append("\n");
            }
            String string = strBuf.substring(0, strBuf.length());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$14, this, string);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$14, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int toLength(OracleArray oracleArray, Datum datum) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void array;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, oracleArray, datum);
            }
            if (array.getNumElems() == -1) {
                if (array.getDatumArray() != null) {
                    array.setLength(array.getDatumArray().length);
                } else if (array.getObjArray() != null) {
                    Object objArray = array.getObjArray();
                    int numElems = array.getNumElems();
                    if (objArray instanceof Object[]) {
                        numElems = ((Object[])objArray).length;
                    } else if (objArray instanceof int[]) {
                        numElems = ((long[])objArray).length;
                    } else if (objArray instanceof long[]) {
                        numElems = ((float[])objArray).length;
                    } else if (objArray instanceof float[]) {
                        numElems = ((double[])objArray).length;
                    } else if (objArray instanceof double[]) {
                        numElems = ((boolean[])objArray).length;
                    } else if (objArray instanceof boolean[]) {
                        numElems = ((int[])objArray).length;
                    } else if (objArray instanceof byte[]) {
                        numElems = ((byte[])objArray).length;
                    } else if (objArray instanceof short[]) {
                        numElems = ((short[])objArray).length;
                    } else if (objArray instanceof char[]) {
                        numElems = ((char[])objArray).length;
                    }
                    array.setLength(numElems);
                } else if (array.getLocator() != null) {
                    array.setLength(this.toLengthFromLocator(array.getLocator()));
                } else if (array.shareBytes() != null) {
                    void arrayDatum;
                    this.pickler.unlinearize(array.shareBytes(), array.getImageOffset(), (Datum)arrayDatum, 0, null);
                    if (array.getNumElems() == -1) {
                        if (array.getLocator() != null) {
                            array.setLength(this.toLengthFromLocator(array.getLocator()));
                        } else {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to get array length").fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, sQLException);
                            }
                            throw sQLException;
                        }
                    }
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, sQLException);
                    }
                    throw sQLException;
                }
            }
            int n2 = array.getNumElems();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, n2);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toBytes(OracleArray oracleArray, Datum datum, boolean bl) throws SQLException {
        boolean bl2 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] bytes;
            block15: {
                void s2;
                block13: {
                    void keepLocalCopy;
                    void sDatum;
                    block14: {
                        if (bl2) {
                            ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, oracleArray, datum, bl);
                        }
                        if ((bytes = s2.shareBytes()) != null) break block13;
                        if (s2.getDatumArray() == null && s2.getLocator() == null) break block14;
                        bytes = this.pickler.linearize((Datum)sDatum);
                        if (keepLocalCopy == false) {
                            s2.setShareBytes(null);
                        }
                        break block15;
                    }
                    if (s2.getObjArray() != null) {
                        s2.setDatumArray(this.toOracleArray(s2.getObjArray(), 1L, -1));
                        bytes = this.pickler.linearize((Datum)sDatum);
                        if (keepLocalCopy == false) {
                            s2.setDatumArray(null);
                            s2.setShareBytes(null);
                        }
                        break block15;
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                if (s2.getImageLength() != 0L) {
                    long imageLength = s2.getImageLength();
                    if (s2.getImageOffset() != 0L || imageLength != (long)bytes.length) {
                        byte[] image = new byte[(int)imageLength];
                        System.arraycopy(bytes, (int)s2.getImageOffset(), image, 0, (int)imageLength);
                        s2.setImage(image, 0L, 0L);
                        byte[] byArray = image;
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, byArray);
                            ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, null);
                        }
                        return image;
                    }
                }
            }
            byte[] byArray = bytes;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, null);
            }
            return bytes;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Datum[] toOracleArray(OracleArray oracleArray, Datum datum, long l2, int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void keepLocalCopy;
            void s2;
            Datum[] datumArray;
            block15: {
                void count;
                void beginIdx;
                block13: {
                    block16: {
                        block14: {
                            if (bl2) {
                                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, oracleArray, datum, l2, n2, bl);
                            }
                            if ((datumArray = s2.getDatumArray()) != null) break block13;
                            if (s2.getObjArray() == null) break block14;
                            datumArray = this.toOracleArray(s2.getObjArray(), (long)beginIdx, (int)count);
                            break block15;
                        }
                        if (s2.getLocator() == null) break block16;
                        datumArray = this.toOracleArrayFromLocator(s2.getLocator(), (long)beginIdx, (int)count, null);
                        break block15;
                    }
                    if (s2.shareBytes() != null) {
                        void sDatum;
                        this.pickler.unlinearize(s2.shareBytes(), s2.getImageOffset(), (Datum)sDatum, (long)beginIdx, (int)count, 1, null);
                        datumArray = s2.getLocator() != null ? this.toOracleArrayFromLocator(s2.getLocator(), (long)beginIdx, (int)count, null) : s2.getDatumArray();
                        if (keepLocalCopy == false) {
                            s2.setDatumArray(null);
                        }
                        break block15;
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status.").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
                if (beginIdx > (long)datumArray.length) {
                    Datum[] datumArray2 = new Datum[]{};
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, datumArray2);
                        ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, null);
                    }
                    return datumArray2;
                }
                int length = (int)(count == -1 ? (long)datumArray.length - beginIdx + 1L : Math.min((long)datumArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                System.arraycopy(s2.getDatumArray(), (int)beginIdx - 1, datumArray, 0, length);
            }
            Datum[] ret = null;
            if (keepLocalCopy != false) {
                s2.setDatumArray(datumArray);
                ret = (Datum[])datumArray.clone();
            } else {
                ret = datumArray;
            }
            Datum[] datumArray3 = ret;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, datumArray3);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object[] toJavaArray(OracleArray oracleArray, Datum datum, long l2, int n2, Map map, boolean bl) throws SQLException {
        boolean bl2 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void beginIdx;
            void count;
            void s2;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, oracleArray, datum, l2, n2, map, bl);
            }
            Object[] objArray = null;
            if (s2.getObjArray() != null) {
                objArray = (Object[])((Object[])s2.getObjArray()).clone();
                int nbElem = objArray.length;
                int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
                if (length <= 0) {
                    Object[] ret;
                    Object[] objectArray = ret = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
                    if (bl2) {
                        ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, objectArray);
                        ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, null);
                    }
                    return ret;
                }
                objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
                System.arraycopy(s2.getObjArray(), (int)beginIdx - 1, objArray, 0, length);
            } else {
                void keepLocalCopy;
                void map2;
                if (s2.getDatumArray() != null) {
                    objArray = (Object[])this.toJavaArray((OracleArray)s2, (long)beginIdx, (int)count, (Map)map2);
                } else if (s2.getLocator() != null) {
                    objArray = this.toArrayFromLocator(s2.getLocator(), (long)beginIdx, (int)count, (Map)map2);
                } else if (s2.shareBytes() != null) {
                    void sDatum;
                    this.pickler.unlinearize(s2.shareBytes(), s2.getImageOffset(), (Datum)sDatum, (long)beginIdx, (int)count, 2, (Map)map2);
                    objArray = s2.getLocator() != null ? this.toArrayFromLocator(s2.getLocator(), (long)beginIdx, (int)count, (Map)map2) : (Object[])s2.getObjArray();
                } else {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, sQLException);
                    }
                    throw sQLException;
                }
                if (keepLocalCopy != false && this.getBaseType() != 2002 && this.getBaseType() != 2008 && objArray != null) {
                    s2.setObjArray(objArray.clone());
                } else {
                    s2.setNullObjArray();
                }
            }
            Object[] objectArray = objArray;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, null);
            }
            return objArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Datum[] toOracleArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void beginIdx;
            void count;
            void locator_bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$19, this, byArray, l2, n2, map);
            }
            int nbElem = this.toLengthFromLocator((byte[])locator_bytes);
            int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
            Datum[] datumArray = null;
            if (length <= 0) {
                datumArray = new Datum[]{};
            } else {
                void map2;
                datumArray = new Datum[length];
                ResultSet rset = this.toResultSetFromLocator((byte[])locator_bytes, (long)beginIdx, (int)count, (Map)map2);
                int i2 = 0;
                while (rset.next()) {
                    datumArray[i2] = ((OracleResultSet)rset).getOracleObject(2);
                    ++i2;
                }
                rset.close();
            }
            Datum[] datumArray2 = datumArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$19, this, datumArray2);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$19, this, null);
            }
            return datumArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object[] toArrayFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void beginIdx;
            void count;
            void locator_bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$20, this, byArray, l2, n2, map);
            }
            int nbElem = this.toLengthFromLocator((byte[])locator_bytes);
            int length = (int)(count == -1 ? (long)nbElem - beginIdx + 1L : Math.min((long)nbElem - beginIdx + 1L, (long)count));
            Object[] objArray = null;
            if (length <= 0) {
                objArray = ArrayDescriptor.makeJavaArray(0, this.getBaseType());
            } else {
                void map2;
                objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
                ResultSet rset = this.toResultSetFromLocator((byte[])locator_bytes, (long)beginIdx, (int)count, (Map)map2);
                int i2 = 0;
                while (rset.next()) {
                    objArray[i2] = ((OracleResultSet)rset).getObject(2, (Map<String, Class<?>>)map2);
                    ++i2;
                }
                rset.close();
            }
            Object[] objectArray = objArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$20, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$20, this, null);
            }
            return objArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet toResultSet(ARRAY aRRAY, long l2, int n2, Map map, boolean bl) throws SQLException {
        boolean bl2 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void saveLocalCopy;
            void map2;
            void count;
            void index;
            void array;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, aRRAY, l2, n2, map, bl);
            }
            ResultSet resultSet = this.toResultSet((OracleArray)array, (Datum)array, (long)index, (int)count, (Map)map2, (boolean)saveLocalCopy);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet toResultSet(OracleArray oracleArray, Datum datum, long l2, int n2, Map map, boolean bl) throws SQLException {
        boolean bl2 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void count;
            void index;
            void array;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, oracleArray, datum, l2, n2, map, bl);
            }
            ResultSet rset = null;
            if (array.getDatumArray() != null) {
                rset = this.toResultSet(array.getDatumArray(), (long)index, (int)count, (Map)map2);
            } else if (array.getLocator() != null) {
                rset = this.toResultSetFromLocator(array.getLocator(), (long)index, (int)count, (Map)map2);
            } else if (array.getObjArray() != null) {
                rset = this.toResultSet(this.toOracleArray(array.getObjArray(), (long)index, (int)count), 1L, -1, (Map)map2);
            } else if (array.shareBytes() != null) {
                if (((OracleTypeCOLLECTION)this.pickler).isInlineImage(array.shareBytes(), (int)array.getImageOffset())) {
                    rset = this.toResultSetFromImage((OracleArray)array, (long)index, (int)count, (Map)map2);
                } else {
                    void arrayDatum;
                    this.pickler.unlinearize(array.shareBytes(), array.getImageOffset(), (Datum)arrayDatum, 1, null);
                    if (array.getLocator() != null) {
                        rset = this.toResultSetFromLocator(array.getLocator(), (long)index, (int)count, (Map)map2);
                    } else {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Array is in inconsistent status").fillInStackTrace();
                        if (bl2) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            if (rset == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unable to create array ResultSet").fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, sQLException);
                }
                throw sQLException;
            }
            ResultSet resultSet = rset;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet toResultSet(Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void index;
            void data;
            void count;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, datumArray, l2, n2, map);
            }
            ResultSet ret = null;
            ret = count == -1 ? this.connection.newArrayDataResultSet((Datum[])data, (long)index, ((void)data).length, (Map)map2) : this.connection.newArrayDataResultSet((Datum[])data, (long)index, (int)count, (Map)map2);
            ResultSet resultSet = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet toResultSetFromLocator(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void count;
            void index;
            void locator;
            ResultSet ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, byArray, l2, n2, map);
            }
            ResultSet resultSet = ret = this.connection.newArrayLocatorResultSet(this, (byte[])locator, (long)index, (int)count, (Map)map2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet toResultSetFromImage(OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void count;
            void index;
            void array;
            ResultSet ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, oracleArray, l2, n2, map);
            }
            ResultSet resultSet = ret = this.connection.newArrayDataResultSet((OracleArray)array, (long)index, (int)count, (Map)map2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object[] makeJavaArray(int n2, int n3) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void otype;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, n2, n3);
            }
            Object[] ret = null;
            switch (otype) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    int length;
                    ret = new BigDecimal[length];
                    break;
                }
                case -15: 
                case -9: 
                case 1: 
                case 12: {
                    int length;
                    ret = new String[length];
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    int length;
                    ret = new Timestamp[length];
                    break;
                }
                case -102: 
                case -101: {
                    int length;
                    ret = new OffsetDateTime[length];
                    break;
                }
                case 2002: 
                case 2008: {
                    int length;
                    ret = new Object[length];
                    break;
                }
                case -13: {
                    int length;
                    ret = new BFILE[length];
                    break;
                }
                case 2004: {
                    int length;
                    ret = new BLOB[length];
                    break;
                }
                case 2005: 
                case 2011: {
                    int length;
                    ret = new CLOB[length];
                    break;
                }
                case -3: 
                case -2: {
                    int length;
                    ret = (Object[])new byte[length][];
                    break;
                }
                case 2006: {
                    int length;
                    ret = new REF[length];
                    break;
                }
                case 2003: {
                    int length;
                    ret = new Object[length];
                    break;
                }
                case 2007: {
                    int length;
                    ret = new Object[length];
                    break;
                }
                case 100: {
                    int length;
                    ret = new Float[length];
                    break;
                }
                case 101: {
                    int length;
                    ret = new Double[length];
                    break;
                }
                case -104: {
                    int length;
                    ret = new INTERVALDS[length];
                    break;
                }
                case -103: {
                    int length;
                    ret = new INTERVALYM[length];
                    break;
                }
                case -8: {
                    int length;
                    ret = new ROWID[length];
                    break;
                }
                default: {
                    SQLException sQLException = (SQLException)DatabaseError.createSqlException(1, "makeJavaArray doesn't support type " + (int)otype).fillInStackTrace();
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, sQLException);
                    }
                    throw sQLException;
                }
            }
            Object[] objectArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, objectArray);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int toLengthFromLocator(byte[] byArray) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void locator_bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$27, this, new Object[]{byArray});
            }
            ARRAY tmpObj = new ARRAY(this, this.connection, (Object)null);
            tmpObj.setLocator((byte[])locator_bytes);
            int numElems = 0;
            OraclePreparedStatement pstmt = null;
            OracleResultSet rs = null;
            pstmt = (OraclePreparedStatement)this.connection.prepareStatement("SELECT count(*) FROM TABLE( CAST(:1 AS " + this.getName() + ") )");
            pstmt.setArray(1, tmpObj);
            rs = (OracleResultSet)pstmt.executeQuery();
            if (!rs.next()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fail to access array storage table").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$27, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$27, this, sQLException);
                }
                throw sQLException;
            }
            numElems = rs.getInt(1);
            rs.close();
            pstmt.close();
            int n2 = numElems;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$27, this, n2);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$27, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$27, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Datum[] toOracleArray(Object object, long l2, int n2) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void elements;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, object, l2, n2);
            }
            Datum[] ret = null;
            if (elements != null) {
                OracleType otype = this.getElementType();
                if (this.getArrayType() == 1) {
                    if (elements.getClass().isArray()) {
                        int len = Array.getLength(elements);
                        Datum[] datumArray = new Datum[len];
                        for (int i2 = 0; i2 < len; ++i2) {
                            Object elem = Array.get(elements, i2);
                            Datum d2 = otype.toDatum(elem, this.connection);
                            datumArray[i2] = new AssociativeArrayEntry<Integer, Datum>(i2, d2);
                        }
                        ret = datumArray;
                    } else if (elements instanceof Map) {
                        Map map = (Map)elements;
                        Datum[] datumArray = new Datum[map.size()];
                        int i3 = 0;
                        for (Map.Entry e2 : map.entrySet()) {
                            if (!(e2.getKey() instanceof Integer)) {
                                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "SQL Associative Array Index Type").fillInStackTrace();
                                if (bl) {
                                    ClioSupport.throwing($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, sQLException);
                                }
                                throw sQLException;
                            }
                            Datum d3 = otype.toDatum(e2.getValue(), this.connection);
                            datumArray[i3] = new AssociativeArrayEntry(e2.getKey(), d3);
                            ++i3;
                        }
                        ret = datumArray;
                    }
                } else {
                    void count;
                    void beginIdx;
                    ret = otype.toDatumArray(elements, this.connection, (long)beginIdx, (int)count);
                }
            }
            Datum[] datumArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, datumArray);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$28, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object toJavaArray(OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void beginIdx;
            void count;
            void array;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$29, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$29, this, oracleArray, l2, n2, map);
            }
            HashMap<Integer, Object> javaMap = null;
            if (this.getArrayType() == 1) {
                javaMap = new HashMap<Integer, Object>();
            }
            Datum[] elements = array.getDatumArray();
            int length = (int)(count == -1 ? (long)elements.length - beginIdx + 1L : Math.min((long)elements.length - beginIdx + 1L, (long)count));
            if (length < 0) {
                length = 0;
            }
            Object[] objArray = ArrayDescriptor.makeJavaArray(length, this.getBaseType());
            for (int i2 = 0; i2 < length; ++i2) {
                Integer idx = null;
                Datum d2 = elements[(int)beginIdx + i2 - 1];
                if (d2 instanceof AssociativeArrayEntry) {
                    idx = (Integer)((AssociativeArrayEntry)d2).getKey();
                    d2 = (Datum)((AssociativeArrayEntry)d2).getValue();
                }
                if (this.getBaseType() == 2002) {
                    void map2;
                    objArray[i2] = d2 != null ? ((STRUCT)d2).toJdbc((Map)map2) : null;
                } else if (this.getBaseType() == -101) {
                    objArray[i2] = d2 != null ? ((TIMESTAMPTZ)d2).offsetDateTimeValue(array.getJavaSqlConnection()) : null;
                } else if (this.getBaseType() == -102) {
                    objArray[i2] = d2 != null ? ((TIMESTAMPLTZ)d2).offsetDateTimeValue(array.getJavaSqlConnection()) : null;
                } else {
                    Object object = objArray[i2] = d2 != null ? d2.toJdbc() : null;
                }
                if (javaMap == null) continue;
                javaMap.put(idx, objArray[i2]);
            }
            array.setJavaMap(javaMap);
            Object[] objectArray = objArray;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$29, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$29, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$29, this, null);
            }
            return objArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$29, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$29, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object toNumericArray(Datum[] datumArray, long l2, int n2, int n3) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void type;
            void beginIdx;
            void darray;
            void count;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$30, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$30, this, datumArray, l2, n2, n3);
            }
            Object[] ret = null;
            int length = (int)(count == -1 ? (long)((void)darray).length - beginIdx + 1L : Math.min((long)((void)darray).length - beginIdx + 1L, (long)count));
            if (length < 0) {
                length = 0;
            }
            switch (type) {
                case 4: {
                    int[] objArray = new int[length];
                    for (int i2 = 0; i2 < length; ++i2) {
                        void d2 = darray[(int)beginIdx + i2 - 1];
                        if (d2 == null) continue;
                        objArray[i2] = d2.intValue();
                    }
                    ret = objArray;
                    break;
                }
                case 5: {
                    double[] objArray = new double[length];
                    for (int i3 = 0; i3 < length; ++i3) {
                        void d3 = darray[(int)beginIdx + i3 - 1];
                        if (d3 == null) continue;
                        objArray[i3] = d3.doubleValue();
                    }
                    ret = objArray;
                    break;
                }
                case 6: {
                    float[] objArray = new float[length];
                    for (int i4 = 0; i4 < length; ++i4) {
                        void d4 = darray[(int)beginIdx + i4 - 1];
                        if (d4 == null) continue;
                        objArray[i4] = d4.floatValue();
                    }
                    ret = objArray;
                    break;
                }
                case 7: {
                    long[] objArray = new long[length];
                    for (int i5 = 0; i5 < length; ++i5) {
                        void d5 = darray[(int)beginIdx + i5 - 1];
                        if (d5 == null) continue;
                        objArray[i5] = d5.longValue();
                    }
                    ret = objArray;
                    break;
                }
                case 8: {
                    short[] objArray = new short[length];
                    for (int i6 = 0; i6 < length; ++i6) {
                        void d6 = darray[(int)beginIdx + i6 - 1];
                        if (d6 == null) continue;
                        objArray[i6] = ((NUMBER)d6).shortValue();
                    }
                    ret = objArray;
                    break;
                }
                default: {
                    SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
                    ex.fillInStackTrace();
                    SQLFeatureNotSupportedException sQLFeatureNotSupportedException = ex;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$30, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$30, this, sQLFeatureNotSupportedException);
                    }
                    throw sQLFeatureNotSupportedException;
                }
            }
            Object[] objectArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$30, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$30, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$30, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$30, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$30, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object toNumericArrayFromLocator(byte[] byArray, long l2, int n2, int n3) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void type;
            void count;
            void beginIdx;
            void locator_bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$31, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$31, this, byArray, l2, n2, n3);
            }
            Object[] ret = null;
            int nbElem = this.toLengthFromLocator((byte[])locator_bytes);
            ResultSet rs = this.toResultSetFromLocator((byte[])locator_bytes, (long)beginIdx, (int)count, null);
            int idx = 0;
            switch (type) {
                case 4: {
                    int[] objArray = new int[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = ((OracleResultSet)rs).getInt(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 5: {
                    double[] objArray = new double[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = ((OracleResultSet)rs).getDouble(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 6: {
                    float[] objArray = new float[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = ((OracleResultSet)rs).getFloat(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 7: {
                    long[] objArray = new long[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = ((OracleResultSet)rs).getLong(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                case 8: {
                    short[] objArray = new short[nbElem];
                    while (rs.next() && idx < nbElem) {
                        objArray[idx++] = ((OracleResultSet)rs).getShort(2);
                    }
                    rs.close();
                    ret = objArray;
                    break;
                }
                default: {
                    SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
                    ex.fillInStackTrace();
                    SQLFeatureNotSupportedException sQLFeatureNotSupportedException = ex;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$31, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$31, this, sQLFeatureNotSupportedException);
                    }
                    throw sQLFeatureNotSupportedException;
                }
            }
            Object[] objectArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$31, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$31, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$31, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$31, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$31, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object toNumericArray(OracleArray oracleArray, Datum datum, long l2, int n2, int n3, boolean bl) throws SQLException {
        boolean bl2 = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void count;
            void beginIdx;
            void type;
            void array;
            OracleType elementType;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, oracleArray, datum, l2, n2, n3, bl);
            }
            if (!((elementType = this.getElementType()) instanceof OracleTypeNUMBER) && !(elementType instanceof OracleTypeFLOAT)) {
                SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
                ex.fillInStackTrace();
                SQLFeatureNotSupportedException sQLFeatureNotSupportedException = ex;
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, sQLFeatureNotSupportedException);
                }
                throw sQLFeatureNotSupportedException;
            }
            Object objArray = null;
            if (array.getObjArray() != null) {
                Object origObjArray = array.getObjArray();
                if (type == 4 && origObjArray instanceof int[]) {
                    int length = ((int[])origObjArray).length;
                    if (beginIdx > (long)length) {
                        int[] nArray = new int[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, nArray);
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return nArray;
                    }
                    length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                    int[] newOarray = new int[length];
                    System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                    objArray = newOarray;
                } else if (type == 5 && origObjArray instanceof double[]) {
                    int length = ((double[])origObjArray).length;
                    if (beginIdx > (long)length) {
                        double[] dArray = new double[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, dArray);
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return dArray;
                    }
                    length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                    double[] newOarray = new double[length];
                    System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                    objArray = newOarray;
                } else if (type == 6 && origObjArray instanceof float[]) {
                    int length = ((float[])origObjArray).length;
                    if (beginIdx > (long)length) {
                        float[] fArray = new float[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, fArray);
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return fArray;
                    }
                    length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                    float[] newOarray = new float[length];
                    System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                    objArray = newOarray;
                } else if (type == 7 && origObjArray instanceof long[]) {
                    int length = ((long[])origObjArray).length;
                    if (beginIdx > (long)length) {
                        long[] lArray = new long[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, lArray);
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return lArray;
                    }
                    length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                    long[] newOarray = new long[length];
                    System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                    objArray = newOarray;
                } else if (type == 8 && origObjArray instanceof short[]) {
                    int length = ((short[])origObjArray).length;
                    if (beginIdx > (long)length) {
                        short[] sArray = new short[]{};
                        if (bl2) {
                            ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, sArray);
                            ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
                        }
                        return sArray;
                    }
                    length = (int)(count == -1 ? (long)length - beginIdx + 1L : Math.min((long)length - beginIdx + 1L, (long)count));
                    short[] newOarray = new short[length];
                    System.arraycopy(origObjArray, (int)beginIdx - 1, newOarray, 0, length);
                    objArray = newOarray;
                }
            } else {
                void saveLocalCopy;
                if (array.getDatumArray() != null) {
                    objArray = this.toNumericArray(array.getDatumArray(), (long)beginIdx, (int)count, (int)type);
                } else if (array.getLocator() != null) {
                    objArray = this.toNumericArrayFromLocator(array.getLocator(), (long)beginIdx, (int)count, (int)type);
                } else if (array.shareBytes() != null) {
                    void arrayDatum;
                    this.pickler.unlinearize(array.shareBytes(), array.getImageOffset(), (Datum)arrayDatum, (long)beginIdx, (int)count, (int)type, null);
                    objArray = array.getLocator() != null ? this.toNumericArrayFromLocator(array.getLocator(), (long)beginIdx, (int)count, (int)type) : array.getObjArray();
                } else {
                    SQLFeatureNotSupportedException ex = DatabaseError.createUnsupportedFeatureSqlException();
                    ex.fillInStackTrace();
                    SQLFeatureNotSupportedException sQLFeatureNotSupportedException = ex;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, sQLFeatureNotSupportedException);
                    }
                    throw sQLFeatureNotSupportedException;
                }
                if (saveLocalCopy == false) {
                    array.setNullObjArray();
                }
            }
            Object object = objArray;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, object);
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$32, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$32, this, throwable2);
            }
            throw throwable;
        }
    }

    private void initPickler() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$33, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$33, this, new Object[0]);
            }
            try {
                String typeName = this.typeNameByUser;
                if (typeName == null) {
                    typeName = this.getName();
                }
                OracleTypeADT adt = new OracleTypeADT(typeName, (Connection)this.connection);
                adt.init(this.connection);
                this.pickler = (OracleTypeCOLLECTION)adt.cleanup();
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
                this.pickler.setDescriptor(this);
            }
            catch (Exception e2) {
                if (e2 instanceof SQLException) {
                    SQLException sQLException = (SQLException)e2;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$33, this, sQLException);
                    }
                    throw sQLException;
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type: \"" + this.getName() + "\"").fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$33, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$33, this, sQLException);
                }
                throw sQLException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$33, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$33, this);
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$33, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$33, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$33, this, throwable2);
            }
            throw throwable;
        }
    }

    private OracleType getElementType() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleType ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, new Object[0]);
            }
            OracleType oracleType = ret = ((OracleTypeCOLLECTION)this.pickler).getElementType();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, oracleType);
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, null);
            }
            return oracleType;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$34, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$34, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public int getTypeCode() throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, new Object[0]);
            }
            int n2 = ret = 2003;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, n2);
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$35, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$35, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public SQLInput toJdbcToSQLInput(ARRAY aRRAY, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void map2;
            void obj;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, aRRAY, map);
            }
            OracleJdbc2SQLInput oracleJdbc2SQLInput = new OracleJdbc2SQLInput(this.toOracleArray((OracleArray)obj, (Datum)obj, 0L, obj.length(), false), (Map)map2, this.connection);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, oracleJdbc2SQLInput);
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, null);
            }
            return oracleJdbc2SQLInput;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$36, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$36, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void attributes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, new Object[]{datumArray});
            }
            ARRAY s2 = new ARRAY(this, this.connection, attributes);
            byte[] byArray = this.pickler.linearize(s2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$37, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$37, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toBytes(Object[] objectArray) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] ret;
            void attributes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, new Object[]{objectArray});
            }
            Datum[] datums = this.toArray(attributes);
            byte[] byArray = ret = this.toBytes(datums);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$38, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$38, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int length(byte[] byArray) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int ret;
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, new Object[]{byArray});
            }
            ARRAY tmpObj = new ARRAY(this, this.connection, bytes);
            int n2 = ret = this.toLength(tmpObj, tmpObj);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, n2);
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$39, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$39, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Datum[] toArray(byte[] byArray) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, new Object[]{byArray});
            }
            Datum[] ret = null;
            if (bytes != null) {
                ARRAY tmpObj = new ARRAY(this, this.connection, bytes);
                ret = this.toOracleArray(tmpObj, tmpObj, 1L, -1, false);
            }
            Datum[] datumArray = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, datumArray);
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$40, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$40, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Datum[] toArray(Object object) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void attributes;
            Datum[] ret;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, object);
            }
            Datum[] datumArray = ret = this.toOracleArray(attributes, 1L, -1);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, datumArray);
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, null);
            }
            return ret;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$41, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$41, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet toResultSet(byte[] byArray, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, byArray, map);
            }
            ResultSet ret = null;
            if (bytes != null) {
                void map2;
                ARRAY tmpObj = (ARRAY)this.pickler.unlinearize((byte[])bytes, 0L, null, 1, null);
                ret = this.toResultSet(tmpObj, tmpObj, 1L, -1, (Map)map2, false);
            }
            ResultSet resultSet = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$42, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$42, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ResultSet toResultSet(byte[] byArray, long l2, int n2, Map map) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void bytes;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, byArray, l2, n2, map);
            }
            ResultSet ret = null;
            if (bytes != null) {
                void map2;
                void count;
                void index;
                ARRAY tmpObj = (ARRAY)this.pickler.unlinearize((byte[])bytes, 0L, null, 1, null);
                ret = this.toResultSet(tmpObj, tmpObj, (long)index, (int)count, (Map)map2, false);
            }
            ResultSet resultSet = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, resultSet);
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, null);
            }
            return resultSet;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$43, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$43, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    String tagName() {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, this, new Object[0]);
            }
            String string = "ArrayDescriptor";
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, this, string);
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, this, null);
            }
            return "ArrayDescriptor";
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$44, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$44, this, throwable2);
            }
            throw throwable;
        }
    }

    public static int getCacheStyle(OracleArray oracleArray) throws SQLException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleArray array;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, oracleArray);
            }
            int ret = 2;
            if (array.getAutoIndexing() && (array.getAccessDirection() == 2 || array.getAccessDirection() == 3)) {
                ret = 1;
            }
            int n2 = ret;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, n2);
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$45, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$45, null, throwable2);
            }
            throw throwable;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$46, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$46, this, objectOutputStream);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$46, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$46, this);
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$46, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$46, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$46, this, throwable2);
            }
            throw throwable;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = (0x200000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, this, objectInputStream);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, this);
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$47, Level.FINEST, ArrayDescriptor.class, $$$methodRef$$$47, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$52 = ArrayDescriptor.class.getDeclaredConstructor(byte[].class, Integer.TYPE, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$51 = ArrayDescriptor.class.getDeclaredConstructor(OracleTypeCOLLECTION.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$50 = ArrayDescriptor.class.getDeclaredConstructor(SQLName.class, OracleTypeCOLLECTION.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$49 = ArrayDescriptor.class.getDeclaredConstructor(SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$48 = ArrayDescriptor.class.getDeclaredConstructor(String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$47 = ArrayDescriptor.class.getDeclaredMethod("readObject", ObjectInputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$46 = ArrayDescriptor.class.getDeclaredMethod("writeObject", ObjectOutputStream.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$45 = ArrayDescriptor.class.getDeclaredMethod("getCacheStyle", OracleArray.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$44 = ArrayDescriptor.class.getDeclaredMethod("tagName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$43 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$42 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", byte[].class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$41 = ArrayDescriptor.class.getDeclaredMethod("toArray", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$40 = ArrayDescriptor.class.getDeclaredMethod("toArray", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$39 = ArrayDescriptor.class.getDeclaredMethod("length", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$38 = ArrayDescriptor.class.getDeclaredMethod("toBytes", Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$37 = ArrayDescriptor.class.getDeclaredMethod("toBytes", Datum[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$36 = ArrayDescriptor.class.getDeclaredMethod("toJdbcToSQLInput", ARRAY.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$35 = ArrayDescriptor.class.getDeclaredMethod("getTypeCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$34 = ArrayDescriptor.class.getDeclaredMethod("getElementType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$33 = ArrayDescriptor.class.getDeclaredMethod("initPickler", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$32 = ArrayDescriptor.class.getDeclaredMethod("toNumericArray", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$31 = ArrayDescriptor.class.getDeclaredMethod("toNumericArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$30 = ArrayDescriptor.class.getDeclaredMethod("toNumericArray", Datum[].class, Long.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$29 = ArrayDescriptor.class.getDeclaredMethod("toJavaArray", OracleArray.class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$28 = ArrayDescriptor.class.getDeclaredMethod("toOracleArray", Object.class, Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$27 = ArrayDescriptor.class.getDeclaredMethod("toLengthFromLocator", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$26 = ArrayDescriptor.class.getDeclaredMethod("makeJavaArray", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$25 = ArrayDescriptor.class.getDeclaredMethod("toResultSetFromImage", OracleArray.class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$24 = ArrayDescriptor.class.getDeclaredMethod("toResultSetFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$23 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", Datum[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$22 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$21 = ArrayDescriptor.class.getDeclaredMethod("toResultSet", ARRAY.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$20 = ArrayDescriptor.class.getDeclaredMethod("toArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$19 = ArrayDescriptor.class.getDeclaredMethod("toOracleArrayFromLocator", byte[].class, Long.TYPE, Integer.TYPE, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$18 = ArrayDescriptor.class.getDeclaredMethod("toJavaArray", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Map.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$17 = ArrayDescriptor.class.getDeclaredMethod("toOracleArray", OracleArray.class, Datum.class, Long.TYPE, Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$16 = ArrayDescriptor.class.getDeclaredMethod("toBytes", OracleArray.class, Datum.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$15 = ArrayDescriptor.class.getDeclaredMethod("toLength", OracleArray.class, Datum.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$14 = ArrayDescriptor.class.getDeclaredMethod("descType", StringBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$13 = ArrayDescriptor.class.getDeclaredMethod("descType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$12 = ArrayDescriptor.class.getDeclaredMethod("getMaxLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = ArrayDescriptor.class.getDeclaredMethod("getArrayType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = ArrayDescriptor.class.getDeclaredMethod("getArrayStorage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = ArrayDescriptor.class.getDeclaredMethod("getOracleTypeCOLLECTION", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = ArrayDescriptor.class.getDeclaredMethod("getBaseName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = ArrayDescriptor.class.getDeclaredMethod("getBaseType", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = ArrayDescriptor.class.getDeclaredMethod("getKind", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, byte[].class, Integer.TYPE, byte[].class, OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", OracleTypeCOLLECTION.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, Connection.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", SQLName.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", String.class, Connection.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = ArrayDescriptor.class.getDeclaredMethod("createDescriptor", String.class, Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
    }
}

