/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.macho;

import com.oracle.objectfile.LayoutDecisionMap;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.io.OutputAssembler;
import com.oracle.objectfile.macho.MachOObjectFile;
import com.oracle.objectfile.macho.MachORelocationElement;
import com.oracle.objectfile.macho.MachOSymtab;
import com.oracle.objectfile.macho.X86_64Reloc;
import java.util.Map;
import java.util.Objects;

final class RelocationInfo
implements ObjectFile.RelocationRecord,
ObjectFile.RelocationMethod {
    private final MachORelocationElement containingElement;
    private final MachOObjectFile.MachOSection relocatedSection;
    private final ObjectFile.RelocationKind kind;
    private final int sectionOffset;
    private final ObjectFile.Symbol sym;
    private final MachOObjectFile.MachOSection targetSection;
    private final byte log2length;

    RelocationInfo(MachORelocationElement containingElement, MachOObjectFile.MachOSection relocatedSection, int offset, int requestedLength, ObjectFile.RelocationKind kind, String symbolName, boolean asLocalReloc) {
        this.containingElement = containingElement;
        this.relocatedSection = relocatedSection;
        this.sectionOffset = offset;
        if (requestedLength != 8 && requestedLength != 4 && requestedLength != 2 && requestedLength != 1) {
            throw new IllegalArgumentException("Mach-O cannot represent relocation lengths other than {1,2,4,8} bytes");
        }
        this.log2length = (byte)(requestedLength == 8 ? 3 : (requestedLength == 4 ? 2 : (requestedLength == 2 ? 1 : 0)));
        this.kind = kind;
        MachOSymtab symtab = relocatedSection.getOwner().getSymbolTable();
        this.sym = symtab.getSymbol(symbolName);
        assert (!asLocalReloc || this.sym.isDefined());
        this.targetSection = asLocalReloc ? (MachOObjectFile.MachOSection)this.sym.getDefinedSection() : null;
    }

    public static int getEncodedSize() {
        return 8;
    }

    public void write(OutputAssembler oa, Map<ObjectFile.Element, LayoutDecisionMap> alreadyDecided) {
        int symbolNum;
        if (this.isExtern()) {
            symbolNum = this.relocatedSection.getOwner().getSymbolTable().indexOf(this.sym);
        } else {
            symbolNum = this.relocatedSection.getOwner().getSections().indexOf(this.sym.getDefinedSection());
            assert (this.sym.getDefinedOffset() == 0L);
        }
        if (this.log2length < 0 || this.log2length >= 4) {
            throw new IllegalArgumentException("length must be in {1,2,4,8} bytes, so log2length must be in [0,3]");
        }
        int startPos = oa.pos();
        oa.write4Byte(this.sectionOffset);
        int remainingWord = 0;
        remainingWord |= symbolNum & 0xFFFFFF;
        remainingWord |= this.kind == ObjectFile.RelocationKind.PC_RELATIVE ? 0x1000000 : 0;
        remainingWord |= (this.log2length & 3) << 25;
        remainingWord |= this.isExtern() ? 0x8000000 : 0;
        oa.write4Byte(remainingWord |= (this.getMachORelocationType() & 0xF) << 28);
        assert (oa.pos() - startPos == 8);
    }

    @Override
    public ObjectFile.RelocationKind getKind() {
        return this.kind;
    }

    @Override
    public long getOffset() {
        return this.sectionOffset;
    }

    @Override
    public ObjectFile.Symbol getReferencedSymbol() {
        return this.sym;
    }

    @Override
    public int getRelocatedByteSize() {
        return 1 << this.log2length;
    }

    @Override
    public boolean canUseExplicitAddend() {
        return false;
    }

    @Override
    public boolean canUseImplicitAddend() {
        return true;
    }

    public MachOObjectFile.MachOSection getRelocatedSection() {
        return this.relocatedSection;
    }

    private boolean isExtern() {
        return this.targetSection == null;
    }

    private int getMachORelocationType() {
        switch (this.getRelocatedSection().getOwner().cpuType) {
            case X86_64: {
                switch (this.kind) {
                    case DIRECT: {
                        return X86_64Reloc.UNSIGNED.getValue();
                    }
                    case PC_RELATIVE: {
                        return X86_64Reloc.SIGNED.getValue();
                    }
                    case PROGRAM_BASE: {
                        throw new IllegalArgumentException("Mach-O does not support PROGRAM_BASE relocations");
                    }
                }
                throw new IllegalArgumentException("unknown relocation kind: " + (Object)((Object)this.kind));
            }
        }
        throw new IllegalArgumentException("unknown relocation kind: " + (Object)((Object)this.kind));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            RelocationInfo other = (RelocationInfo)obj;
            return this.sectionOffset == other.sectionOffset && this.log2length == other.log2length && Objects.equals(this.containingElement, other.containingElement) && Objects.equals(this.getRelocatedSection(), other.getRelocatedSection()) && this.kind == other.kind && Objects.equals(this.sym, other.sym) && Objects.equals(this.targetSection, other.targetSection);
        }
        return false;
    }

    public int hashCode() {
        return (((((this.containingElement.hashCode() * 31 + this.relocatedSection.hashCode()) * 31 + this.kind.hashCode()) * 31 + this.sectionOffset) * 31 + this.sym.hashCode()) * 31 + this.targetSection.hashCode()) * 31 + this.log2length;
    }
}

