/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.reports;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.reports.AnalysisReportsOptions;
import com.oracle.graal.pointsto.reports.ReportUtils;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.options.OptionValues;

public final class ObjectTreePrinter
extends ObjectScanner {
    private static final String[] suppressTypesDefault = new String[]{"java.lang.String", "java.math.BigInteger", "java.lang.Character$UnicodeScript", "sun.misc.FDBigInteger", "boolean", "char", "byte", "int", "long", "double", "float"};
    private static final String[] suppressRootsDefault = new String[]{"java.lang.Character$UnicodeBlock.map*", "java.lang.Character$UnicodeScript.aliases*", "java.lang.ConditionalSpecialCasing.entryTable*", "java.util.Formatter.fsPattern*", "java.lang.Character$UnicodeBlock.of(int)", "java.util.ResourceBundle.getBundle(String, Locale, ResourceBundle$Control)", "com.ibm.icu.impl.ICUResourceBundle.BUNDLE_CACHE*", "com.ibm.icu.impl.ICUResourceBundle.GET_AVAILABLE_CACHE*", "com.ibm.icu.impl.ICUResourceBundleReader.CACHE*", "ibm.icu.impl.DayPeriodRules$DayPeriodRulesData*", "com.ibm.icu.util.ULocale.nameCache*", "com.oracle.svm.core.option.RuntimeOptionsSupportImpl.set(String, Object)"};
    private final Map<JavaConstant, ObjectNodeBase> constantToNode;
    private final SimpleMatcher suppressTypeMatcher;
    private final SimpleMatcher expandTypeMatcher;
    private final SimpleMatcher defaultSuppressTypeMatcher;
    private final SimpleMatcher suppressRootMatcher;
    private final SimpleMatcher expandRootMatcher;
    private final SimpleMatcher defaultSuppressRootMatcher;
    private Map<ObjectNodeBase, Integer> expandedNodes = new LinkedHashMap<ObjectNodeBase, Integer>();
    private int nodeId = 0;

    public static void print(BigBang bigbang, String path, String reportName) {
        ReportUtils.report("object tree", path + "/reports", "object_tree_" + reportName, "txt", writer -> ObjectTreePrinter.doPrint(writer, bigbang));
    }

    private static void doPrint(PrintWriter out, BigBang bigbang) {
        ObjectTreePrinter printer = new ObjectTreePrinter(bigbang);
        printer.scanBootImageHeapRoots(ReportUtils.fieldComparator, ReportUtils.methodComparator);
        printer.printTypeHierarchy(out);
    }

    private ObjectTreePrinter(BigBang bigbang) {
        super(bigbang);
        this.constantToNode = new LinkedHashMap<JavaConstant, ObjectNodeBase>();
        OptionValues options = bigbang.getOptions();
        this.suppressTypeMatcher = new SimpleMatcher(((String)AnalysisReportsOptions.ImageObjectTreeSuppressTypes.getValue(options)).trim().split(","));
        this.expandTypeMatcher = new SimpleMatcher(((String)AnalysisReportsOptions.ImageObjectTreeExpandTypes.getValue(options)).trim().split(","));
        this.defaultSuppressTypeMatcher = new SimpleMatcher(suppressTypesDefault);
        this.suppressRootMatcher = new SimpleMatcher(((String)AnalysisReportsOptions.ImageObjectTreeSuppressRoots.getValue(options)).trim().split(","));
        this.expandRootMatcher = new SimpleMatcher(((String)AnalysisReportsOptions.ImageObjectTreeExpandRoots.getValue(options)).trim().split(","));
        this.defaultSuppressRootMatcher = new SimpleMatcher(suppressRootsDefault);
    }

    @Override
    public void forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
    }

    @Override
    public void forNullFieldValue(JavaConstant receiver, AnalysisField field) {
        if (receiver == null) {
            return;
        }
        assert (this.constantToNode.containsKey(receiver));
        ObjectNode receiverNode = (ObjectNode)this.constantToNode.get(receiver);
        receiverNode.addField(field, ObjectNodeBase.forNull());
    }

    @Override
    public void forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue) {
        if (receiver == null) {
            return;
        }
        assert (this.constantToNode.containsKey(receiver));
        assert (this.constantToNode.containsKey(fieldValue));
        ObjectNode receiverNode = (ObjectNode)this.constantToNode.get(receiver);
        ObjectNodeBase valueNode = this.constantToNode.get(fieldValue);
        receiverNode.addField(field, valueNode);
    }

    @Override
    public void forNullArrayElement(JavaConstant array, AnalysisType arrayType, int index) {
        assert (this.constantToNode.containsKey(array));
        ArrayObjectNode arrayNode = (ArrayObjectNode)this.constantToNode.get(array);
        arrayNode.addElement(index, ObjectNodeBase.forNull());
    }

    @Override
    public void forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int index) {
        assert (this.constantToNode.containsKey(array));
        assert (this.constantToNode.containsKey(elementConstant));
        ArrayObjectNode arrayNode = (ArrayObjectNode)this.constantToNode.get(array);
        ObjectNodeBase valueNode = this.constantToNode.get(elementConstant);
        arrayNode.addElement(index, valueNode);
    }

    @Override
    protected void forScannedConstant(JavaConstant scannedValue, Object reason) {
        JVMCIError.guarantee((scannedValue != null ? 1 : 0) != 0, (String)"scannedValue is null", (Object[])new Object[0]);
        this.constantToNode.computeIfAbsent(scannedValue, c -> {
            ObjectNodeBase node;
            if (reason instanceof ResolvedJavaField) {
                ResolvedJavaField field = (ResolvedJavaField)reason;
                node = field.isStatic() ? ObjectNodeBase.fromConstant(this.bb, scannedValue, new RootSource(field)) : ObjectNodeBase.fromConstant(this.bb, scannedValue);
            } else if (reason instanceof ResolvedJavaMethod) {
                ResolvedJavaMethod method = (ResolvedJavaMethod)reason;
                node = ObjectNodeBase.fromConstant(this.bb, scannedValue, new RootSource(method));
            } else {
                node = ObjectNodeBase.fromConstant(this.bb, scannedValue);
            }
            return node;
        });
    }

    private static AnalysisType constantType(BigBang bb, JavaConstant scannedValue) {
        return bb.getMetaAccess().lookupJavaType((Class)ObjectTreePrinter.constantAsObject(bb, scannedValue).getClass());
    }

    static String constantAsString(BigBang bb, JavaConstant constant) {
        Object object = ObjectTreePrinter.constantAsObject(bb, constant);
        if (object instanceof String) {
            String str = (String)object;
            if ((str = ObjectTreePrinter.escape(str)).length() > 10) {
                str = str.substring(0, 10);
                str = str + "...";
            }
            return "\"" + str + "\"";
        }
        return ObjectTreePrinter.escape(JavaKind.Object.format(object));
    }

    private static Object constantAsObject(BigBang bb, JavaConstant constant) {
        return bb.getSnippetReflectionProvider().asObject(Object.class, constant);
    }

    private static String escape(String str) {
        return str.replace("\n", "\\n").replace("\r", "\\r");
    }

    private boolean suppressType(AnalysisType type) {
        AnalysisType elementalType = (AnalysisType)type.getElementalType();
        String elementalTypeName = elementalType.toJavaName(true);
        if (this.expandTypeMatcher.matches(elementalTypeName)) {
            return false;
        }
        if (this.suppressTypeMatcher.matches(elementalTypeName)) {
            return true;
        }
        return this.defaultSuppressTypeMatcher.matches(elementalTypeName);
    }

    private boolean suppressRoot(RootSource source) {
        if (this.expandRootMatcher.matches(source.format())) {
            return false;
        }
        if (this.suppressRootMatcher.matches(source.format())) {
            return true;
        }
        return this.defaultSuppressRootMatcher.matches(source.format());
    }

    private void printTypeHierarchy(PrintWriter out) {
        out.println("Heap roots");
        Iterator iterator = this.constantToNode.values().stream().filter(n -> n.isRoot()).iterator();
        while (iterator.hasNext()) {
            ObjectNodeBase node = (ObjectNodeBase)iterator.next();
            boolean lastRoot = !iterator.hasNext();
            this.printTypeHierarchyNode(out, node, lastRoot);
        }
        out.println();
    }

    private void printTypeHierarchyNode(PrintWriter out, ObjectNodeBase root, boolean lastRoot) {
        ArrayDeque<WorkListEntry> workList = new ArrayDeque<WorkListEntry>();
        if (this.expandedNodes.containsKey(root)) {
            out.format("%s%s %s id-ref=%s toString=%s%n", lastRoot ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ", "root", root.source.format(), this.expandedNodes.get(root), root.constantFormat(this.bb));
        } else if (this.suppressRoot(root.source)) {
            out.format("%s%s %s toString=%s (expansion suppressed)%n", lastRoot ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ", "root", root.source.format(), root.constantFormat(this.bb));
        } else {
            out.format("%s%s %s value:%n", lastRoot ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ", "root", root.source.format());
            if (this.suppressType(root.type)) {
                out.format("%s%s%s toString=%s (expansion suppressed)%n", lastRoot ? "    " : "\u2502   ", "\u2514\u2500\u2500 ", root.typeFormat(), root.constantFormat(this.bb));
            } else {
                workList.push(new WorkListEntry(lastRoot ? "    " : "\u2502   ", "\u2514\u2500\u2500 ", root, true, new LinkedHashSet<ObjectNodeBase>()));
            }
        }
        while (!workList.isEmpty()) {
            String prefix;
            WorkListEntry entry = (WorkListEntry)workList.pop();
            if (entry.node instanceof ObjectNode) {
                int id;
                ObjectNode objectNode = (ObjectNode)entry.node;
                if (this.expandedNodes.containsKey(objectNode)) {
                    out.format("%s%s%s id-ref=%s toString=%s%n", entry.prefix, entry.marker, objectNode.typeFormat(), this.expandedNodes.get(objectNode), objectNode.constantFormat(this.bb));
                    continue;
                }
                ++this.nodeId;
                this.expandedNodes.put(objectNode, id);
                out.format("%s%s%s id=%s toString=%s ", entry.prefix, entry.marker, objectNode.typeFormat(), id, objectNode.constantFormat(this.bb));
                if (ObjectTreePrinter.hasProperties(objectNode)) {
                    out.format("fields:%n", new Object[0]);
                    prefix = entry.prefix + (entry.lastProperty ? "    " : "\u2502   ");
                    ObjectTreePrinter.explore(entry.trail, workList, prefix, objectNode);
                    continue;
                }
                out.format("(no fields)%n", new Object[0]);
                continue;
            }
            if (entry.node instanceof ArrayObjectNode) {
                int id;
                ArrayObjectNode arrayObjectNode = (ArrayObjectNode)entry.node;
                if (this.expandedNodes.containsKey(arrayObjectNode)) {
                    out.format("%s%s%s id-ref=%s toString=%s%n", entry.prefix, entry.marker, arrayObjectNode.typeFormat(), this.expandedNodes.get(arrayObjectNode), arrayObjectNode.constantFormat(this.bb));
                    continue;
                }
                ++this.nodeId;
                this.expandedNodes.put(arrayObjectNode, id);
                out.format("%s%s%s id=%s toString=%s ", entry.prefix, entry.marker, arrayObjectNode.typeFormat(), id, arrayObjectNode.constantFormat(this.bb));
                if (ObjectTreePrinter.hasProperties(arrayObjectNode)) {
                    out.format("elements (excluding null):%n", new Object[0]);
                    prefix = entry.prefix + (entry.lastProperty ? "    " : "\u2502   ");
                    ObjectTreePrinter.explore(entry.trail, workList, prefix, arrayObjectNode);
                    continue;
                }
                out.format("(no elements)%n", new Object[0]);
                continue;
            }
            if (entry.node instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)entry.node;
                if (fieldNode.value.isNull()) {
                    out.format("%s%s%s value=null%n", entry.prefix, entry.marker, fieldNode.format());
                    continue;
                }
                if (this.suppressType(fieldNode.value.type)) {
                    out.format("%s%s%s toString=%s (expansion suppressed)%n", entry.prefix, entry.marker, fieldNode.format(), fieldNode.value.constantFormat(this.bb));
                    continue;
                }
                out.format("%s%s%s value:%n", entry.prefix, entry.marker, fieldNode.format());
                String prefix2 = entry.prefix + (entry.lastProperty ? "    " : "\u2502   ");
                workList.push(new WorkListEntry(prefix2, "\u2514\u2500\u2500 ", fieldNode.value, true, entry.trail));
                continue;
            }
            if (entry.node instanceof ElementNode) {
                ElementNode elementNode = (ElementNode)entry.node;
                if (elementNode.value.isNull()) continue;
                if (this.suppressType(elementNode.value.type)) {
                    out.format("%s%s%s toString=%s (expansion suppressed)%n", entry.prefix, entry.marker, elementNode.format(), elementNode.value.constantFormat(this.bb));
                    continue;
                }
                workList.push(new WorkListEntry(entry.prefix, (entry.lastProperty ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") + "[" + elementNode.index + "] ", elementNode.value, entry.lastProperty, entry.trail));
                continue;
            }
            out.format("%s%s %s%n", entry.prefix, entry.marker, entry.node);
        }
    }

    private static boolean hasProperties(ObjectNodeBase value) {
        if (value instanceof ObjectNode) {
            ObjectNode typeNode = (ObjectNode)value;
            return typeNode.fields().size() > 0;
        }
        if (value instanceof ArrayObjectNode) {
            ArrayObjectNode arrayTypeNode = (ArrayObjectNode)value;
            return arrayTypeNode.elements().stream().filter(e -> !e.value.isNull()).count() > 0L;
        }
        throw JVMCIError.shouldNotReachHere((String)"unknown object");
    }

    private static void explore(Set<ObjectNodeBase> trail, Deque<WorkListEntry> workList, String prefix, ObjectNodeBase value) {
        block4: {
            block3: {
                if (trail.contains(value)) {
                    return;
                }
                trail.add(value);
                if (!(value instanceof ObjectNode)) break block3;
                ObjectNode typeNode = (ObjectNode)value;
                boolean firstProperty = true;
                for (FieldNode fieldNode : typeNode.fields()) {
                    workList.push(new WorkListEntry(prefix, firstProperty ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ", fieldNode, firstProperty, trail));
                    firstProperty = false;
                }
                break block4;
            }
            if (!(value instanceof ArrayObjectNode)) break block4;
            ArrayObjectNode arrayTypeNode = (ArrayObjectNode)value;
            boolean firstProperty = true;
            for (int idx = arrayTypeNode.elements().size() - 1; idx >= 0; --idx) {
                ElementNode elementNode = arrayTypeNode.elements.get(idx);
                workList.push(new WorkListEntry(prefix, firstProperty ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ", elementNode, firstProperty, trail));
                firstProperty = false;
            }
        }
    }

    static class WorkListEntry {
        final String prefix;
        final String marker;
        final Object node;
        final Set<ObjectNodeBase> trail;
        final boolean lastProperty;

        WorkListEntry(String prefix, String marker, Object node, boolean lastProperty, Set<ObjectNodeBase> parentTrail) {
            this.prefix = prefix;
            this.marker = marker;
            this.node = node;
            this.lastProperty = lastProperty;
            this.trail = new LinkedHashSet<ObjectNodeBase>(parentTrail);
        }
    }

    static class SimpleMatcher {
        private final String[] patterns;

        SimpleMatcher(String[] patterns) {
            this.patterns = patterns;
        }

        public boolean matches(String input) {
            for (String pattern : this.patterns) {
                if (pattern.startsWith("*") && input.endsWith(pattern.substring(1, pattern.length()))) {
                    return true;
                }
                if (pattern.endsWith("*") && input.startsWith(pattern.substring(0, pattern.length() - 1))) {
                    return true;
                }
                if (pattern.startsWith("*") && pattern.endsWith("*") && input.contains(pattern.substring(1, pattern.length() - 1))) {
                    return true;
                }
                if (!input.equals(pattern)) continue;
                return true;
            }
            return false;
        }
    }

    static final class NullValue
    extends ObjectNodeBase {
        static final ObjectNodeBase INSTANCE = new NullValue(null);

        private NullValue(AnalysisType type) {
            super(type, null);
        }

        @Override
        public int hashCode() {
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    static class ElementNode {
        final Integer index;
        final ObjectNodeBase value;

        ElementNode(Integer index, ObjectNodeBase value) {
            this.index = index;
            this.value = value;
        }

        public Object format() {
            return "[" + this.index + "]";
        }
    }

    static class ArrayObjectNode
    extends ObjectNodeBase {
        final Map<Integer, ElementNode> elements = new LinkedHashMap<Integer, ElementNode>();

        ArrayObjectNode(AnalysisType type, RootSource rootSource, JavaConstant constant) {
            super(type, rootSource, constant);
        }

        public Collection<ElementNode> elements() {
            return this.elements.values();
        }

        void addElement(Integer index, ObjectNodeBase object) {
            assert (!this.elements.containsKey(index));
            this.elements.put(index, new ElementNode(index, object));
        }
    }

    static class FieldNode {
        final AnalysisField field;
        final ObjectNodeBase value;

        FieldNode(AnalysisField field, ObjectNodeBase value) {
            this.field = field;
            this.value = value;
        }

        public Object format() {
            return this.field.format("%n:%T");
        }
    }

    static class ObjectNode
    extends ObjectNodeBase {
        final Map<AnalysisField, FieldNode> fields = new LinkedHashMap<AnalysisField, FieldNode>();

        ObjectNode(AnalysisType type, RootSource rootSource, JavaConstant constant) {
            super(type, rootSource, constant);
        }

        public Collection<FieldNode> fields() {
            return this.fields.values();
        }

        void addField(AnalysisField field, ObjectNodeBase typeNode) {
            assert (!this.fields.containsKey(field));
            this.fields.put(field, new FieldNode(field, typeNode));
        }
    }

    static class ObjectNodeBase {
        final RootSource source;
        final AnalysisType type;
        final JavaConstant constant;

        ObjectNodeBase(AnalysisType type, JavaConstant constant) {
            this(type, null, constant);
        }

        ObjectNodeBase(AnalysisType type, RootSource rootSource, JavaConstant constant) {
            this.type = type;
            this.source = rootSource;
            this.constant = constant;
        }

        boolean isRoot() {
            return this.source != null;
        }

        String typeFormat() {
            return this.type.toJavaName(true);
        }

        String constantFormat(BigBang bb) {
            return ObjectTreePrinter.constantAsString(bb, this.constant);
        }

        boolean isNull() {
            return this == NullValue.INSTANCE;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.constant.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectNodeBase) {
                ObjectNodeBase that = (ObjectNodeBase)obj;
                return this.type.equals(that.type) && this.constant.equals(that.constant);
            }
            return false;
        }

        static ObjectNodeBase forNull() {
            return NullValue.INSTANCE;
        }

        static ObjectNodeBase fromConstant(BigBang bb, JavaConstant constant) {
            return ObjectNodeBase.fromConstant(bb, constant, null);
        }

        static ObjectNodeBase fromConstant(BigBang bb, JavaConstant constant, RootSource rootSource) {
            AnalysisType type = ObjectTreePrinter.constantType(bb, constant);
            if (type == null) {
                return ObjectNode.forNull();
            }
            if (type.isArray()) {
                return new ArrayObjectNode(type, rootSource, constant);
            }
            return new ObjectNode(type, rootSource, constant);
        }
    }

    static class RootSource {
        final Object source;

        RootSource(Object source) {
            this.source = source;
        }

        String format() {
            if (this.source instanceof ResolvedJavaField) {
                ResolvedJavaField field = (ResolvedJavaField)this.source;
                return field.format("%H.%n:%T");
            }
            if (this.source instanceof ResolvedJavaMethod) {
                ResolvedJavaMethod method = (ResolvedJavaMethod)this.source;
                return method.format("%H.%n(%p)");
            }
            throw JVMCIError.shouldNotReachHere((String)("unknown source: " + this.source));
        }
    }
}

