/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.util.ParallelExecutionException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GlobalMetrics;
import org.graalvm.compiler.options.OptionValues;

public final class CompletionExecutor {
    private final AtomicReference<State> state;
    private final LongAdder postedOperations;
    private final LongAdder completedOperations;
    private final List<DebugContextRunnable> postedBeforeStart;
    private volatile CopyOnWriteArrayList<Throwable> exceptions = new CopyOnWriteArrayList();
    private final ForkJoinPool executorService;
    private BigBang bb;
    private Timing timing;
    private Object vmConfig;

    public CompletionExecutor(BigBang bb, ForkJoinPool forkJoin) {
        this.bb = bb;
        this.executorService = forkJoin;
        this.state = new AtomicReference<State>(State.UNUSED);
        this.postedOperations = new LongAdder();
        this.completedOperations = new LongAdder();
        this.postedBeforeStart = new ArrayList<DebugContextRunnable>();
    }

    public void init() {
        this.init(null);
    }

    public void init(Timing newTiming) {
        assert (this.isSequential() || !this.executorService.hasQueuedSubmissions());
        this.timing = newTiming;
        this.setState(State.BEFORE_START);
        this.postedOperations.reset();
        this.completedOperations.reset();
        this.postedBeforeStart.clear();
        this.vmConfig = this.bb.getHostVM().getConfiguration();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(DebugContextRunnable command) {
        if (!this.exceptions.isEmpty()) {
            return;
        }
        switch (this.state.get()) {
            case UNUSED: {
                throw JVMCIError.shouldNotReachHere();
            }
            case BEFORE_START: {
                this.postedBeforeStart.add(command);
                return;
            }
            case STARTED: {
                this.postedOperations.increment();
                if (this.timing != null) {
                    this.timing.addScheduled(command);
                }
                if (!this.isSequential()) {
                    this.executorService.execute(() -> {
                        this.bb.getHostVM().installInThread(this.vmConfig);
                        long startTime = 0L;
                        if (this.timing != null) {
                            startTime = System.nanoTime();
                        }
                        Throwable thrown = null;
                        try (DebugContext debug = command.getDebug(this.bb.getOptions(), this.bb.getDebugHandlerFactories());
                             DebugContext.Scope s = debug.scope((Object)"Operation");
                             DebugContext.Activation a = debug.activate();){
                            command.run(debug);
                        }
                        catch (Throwable x) {
                            thrown = x;
                        }
                        finally {
                            this.bb.getHostVM().clearInThread();
                            if (this.timing != null) {
                                long taskTime = System.nanoTime() - startTime;
                                this.timing.addCompleted(command, taskTime);
                            }
                            if (thrown != null) {
                                this.exceptions.add(thrown);
                            }
                            this.completedOperations.increment();
                        }
                    });
                    return;
                }
                try (DebugContext debug = command.getDebug(this.bb.getOptions(), this.bb.getDebugHandlerFactories());
                     DebugContext.Scope s = debug.scope((Object)"Operation");){
                    command.run(debug);
                }
                this.completedOperations.increment();
                return;
            }
        }
        throw JVMCIError.shouldNotReachHere();
    }

    public void start() {
        assert (this.state.get() == State.BEFORE_START);
        this.setState(State.STARTED);
        this.postedBeforeStart.forEach(this::execute);
        this.postedBeforeStart.clear();
    }

    private void setState(State newState) {
        this.state.set(newState);
    }

    public long complete() throws InterruptedException {
        if (this.isSequential()) {
            long completed = this.completedOperations.sum();
            long posted = this.postedOperations.sum();
            assert (completed == posted);
            return posted;
        }
        long lastPrint = 0L;
        if (this.timing != null) {
            this.timing.printHeader();
            this.timing.print();
            lastPrint = System.nanoTime();
        }
        do {
            long curTime;
            assert (this.state.get() == State.STARTED);
            boolean quiescent = this.executorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
            if (this.timing != null && !quiescent && (curTime = System.nanoTime()) - lastPrint > this.timing.getPrintIntervalNanos()) {
                this.timing.print();
                lastPrint = curTime;
            }
            long completed = this.completedOperations.sum();
            long posted = this.postedOperations.sum();
            assert (completed <= posted);
            if (completed != posted || !this.exceptions.isEmpty()) continue;
            if (this.timing != null) {
                this.timing.print();
            }
            return posted;
        } while (this.exceptions.isEmpty());
        this.setState(State.UNUSED);
        throw new ParallelExecutionException(this.exceptions);
    }

    public long getPostedOperations() {
        return this.postedOperations.sum() + (long)this.postedBeforeStart.size();
    }

    public boolean isSequential() {
        return this.executorService == null;
    }

    public void shutdown() {
        assert (this.isSequential() || !this.executorService.hasQueuedSubmissions()) : "There should be no queued submissions on shutdown.";
        assert (this.completedOperations.sum() == this.postedOperations.sum()) : "Posted operations must match completed operations";
        this.setState(State.UNUSED);
    }

    public boolean isStarted() {
        return this.state.get() == State.STARTED;
    }

    public ForkJoinPool getExecutorService() {
        return this.executorService;
    }

    public static interface DebugContextRunnable {
        public void run(DebugContext var1);

        default public DebugContext.Description getDescription() {
            return null;
        }

        default public DebugContext getDebug(OptionValues options, List<DebugHandlersFactory> factories) {
            return DebugContext.create((OptionValues)options, (DebugContext.Description)this.getDescription(), (GlobalMetrics)DebugContext.NO_GLOBAL_METRIC_VALUES, (PrintStream)DebugContext.DEFAULT_LOG_STREAM, factories);
        }
    }

    public static interface Timing {
        public long getPrintIntervalNanos();

        public void addScheduled(DebugContextRunnable var1);

        public void addCompleted(DebugContextRunnable var1, long var2);

        public void printHeader();

        public void print();
    }

    private static enum State {
        BEFORE_START,
        STARTED,
        UNUSED;

    }
}

