/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Target_java_util_concurrent_locks_AbstractOwnableSynchronizer;
import com.oracle.svm.core.Target_java_util_concurrent_locks_ReentrantLock;
import com.oracle.svm.core.UnsafeAccess;
import com.oracle.svm.core.WeakIdentityHashMap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.thread.ThreadingSupportImpl;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.word.BarrieredAccess;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;

public class MonitorSupport {
    private final Map<Object, ReentrantLock> additionalMonitors = new WeakIdentityHashMap<Object, ReentrantLock>();
    private final ReentrantLock additionalMonitorsLock = new ReentrantLock();
    private final Map<Object, Condition> additionalConditions = new WeakIdentityHashMap<Object, Condition>();
    private final ReentrantLock additionalConditionsLock = new ReentrantLock();

    @SubstrateForeignCallTarget
    public static void monitorEnter(Object obj) {
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ReentrantLock lockObject = null;
        try (ThreadingSupportImpl.PauseRecurringCallback prc = new ThreadingSupportImpl.PauseRecurringCallback();){
            try {
                lockObject = ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).getOrCreateMonitor(obj, true);
                lockObject.lock();
            }
            catch (Throwable ex) {
                throw MonitorSupport.shouldNotReachHere("monitorEnter", obj, lockObject, ex);
            }
        }
    }

    @SubstrateForeignCallTarget
    public static void monitorExit(Object obj) {
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ReentrantLock lockObject = null;
        try (ThreadingSupportImpl.PauseRecurringCallback prc = new ThreadingSupportImpl.PauseRecurringCallback();){
            try {
                lockObject = ((MonitorSupport)ImageSingletons.lookup(MonitorSupport.class)).getOrCreateMonitor(obj, true);
                lockObject.unlock();
            }
            catch (Throwable ex) {
                throw MonitorSupport.shouldNotReachHere("monitorExit", obj, lockObject, ex);
            }
        }
    }

    private static RuntimeException shouldNotReachHere(String label, Object obj, ReentrantLock lockObject, Throwable ex) {
        StringBuilder msg = new StringBuilder();
        msg.append("Unexpected exception in MonitorSupport.").append(label);
        if (obj != null) {
            msg.append("  object: ");
            MonitorSupport.appendObject(msg, obj);
        }
        if (lockObject != null) {
            msg.append("  lock: ");
            MonitorSupport.appendObject(msg, lockObject);
            Target_java_util_concurrent_locks_ReentrantLock lockObjectTarget = KnownIntrinsics.unsafeCast(lockObject, Target_java_util_concurrent_locks_ReentrantLock.class);
            Target_java_util_concurrent_locks_AbstractOwnableSynchronizer sync = KnownIntrinsics.unsafeCast(lockObjectTarget.sync, Target_java_util_concurrent_locks_AbstractOwnableSynchronizer.class);
            if (sync != null) {
                msg.append("  sync: ");
                MonitorSupport.appendObject(msg, sync);
                Thread thread = sync.getExclusiveOwnerThread();
                if (thread == null) {
                    msg.append("  no exclusiveOwnerThread");
                } else {
                    msg.append("  exclusiveOwnerThread: ");
                    MonitorSupport.appendObject(msg, thread);
                }
            }
        }
        msg.append("  raw exception: ");
        throw VMError.shouldNotReachHere(msg.toString(), ex);
    }

    private static void appendObject(StringBuilder msg, Object obj) {
        msg.append(obj.getClass().getName()).append("@").append(Long.toHexString(Word.objectToUntrackedPointer((Object)obj).rawValue()));
    }

    public void setExclusiveOwnerThread(Object obj, Thread thread) {
        assert (obj != null);
        VMOperation.guaranteeInProgress("patching a lock while not being at a safepoint is too dangerous");
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        Target_java_util_concurrent_locks_ReentrantLock lock = KnownIntrinsics.unsafeCast(this.getOrCreateMonitor(obj, true), Target_java_util_concurrent_locks_ReentrantLock.class);
        Target_java_util_concurrent_locks_AbstractOwnableSynchronizer sync = KnownIntrinsics.unsafeCast(lock.sync, Target_java_util_concurrent_locks_AbstractOwnableSynchronizer.class);
        VMError.guarantee(sync.getExclusiveOwnerThread() != null, "Cannot patch the exclusiveOwnerThread of an object that is not locked");
        sync.setExclusiveOwnerThread(thread);
    }

    public boolean holdsLock(Object obj) {
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return true;
        }
        ReentrantLock lockObject = this.getOrCreateMonitor(obj, false);
        return lockObject != null && lockObject.isHeldByCurrentThread();
    }

    @SuppressFBWarnings(value={"WA_AWAIT_NOT_IN_LOOP"}, justification="This method is a wait implementation.")
    public void wait(Object obj, long timeoutMillis) throws InterruptedException {
        assert (obj != null);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("Timeout is negative.");
        }
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            Thread.sleep(timeoutMillis == 0L ? Long.MAX_VALUE : timeoutMillis);
            return;
        }
        ReentrantLock lock = this.ensureLocked(obj);
        Condition condition = this.getOrCreateCondition(obj, lock, true);
        if (timeoutMillis == 0L) {
            condition.await();
        } else {
            condition.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void notify(Object obj, boolean notifyAll) {
        assert (obj != null);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ReentrantLock lock = this.ensureLocked(obj);
        Condition condition = this.getOrCreateCondition(obj, lock, false);
        if (condition != null) {
            if (notifyAll) {
                condition.signalAll();
            } else {
                condition.signal();
            }
        }
    }

    private ReentrantLock ensureLocked(Object receiver) {
        ReentrantLock lockObject = this.getOrCreateMonitor(receiver, false);
        if (lockObject == null || !lockObject.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Receiver is not locked by the current thread.");
        }
        return lockObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantLock getOrCreateMonitor(Object obj, boolean createIfNotExisting) {
        DynamicHub hub = ObjectHeader.readDynamicHubFromObject(obj);
        int monitorOffset = hub.getMonitorOffset();
        if (monitorOffset != 0) {
            ReentrantLock existingMonitor = KnownIntrinsics.convertUnknownValue(BarrieredAccess.readObject((Object)obj, (int)monitorOffset), ReentrantLock.class);
            if (existingMonitor != null || !createIfNotExisting) {
                return existingMonitor;
            }
            ReentrantLock newMonitor = new ReentrantLock();
            if (UnsafeAccess.UNSAFE.compareAndSwapObject(obj, monitorOffset, null, newMonitor)) {
                return newMonitor;
            }
            return KnownIntrinsics.convertUnknownValue(BarrieredAccess.readObject((Object)obj, (int)monitorOffset), ReentrantLock.class);
        }
        this.additionalMonitorsLock.lock();
        try {
            ReentrantLock existingEntry = this.additionalMonitors.get(obj);
            if (existingEntry != null) {
                ReentrantLock newMonitor = existingEntry;
                return newMonitor;
            }
            if (!createIfNotExisting) {
                ReentrantLock newMonitor = null;
                return newMonitor;
            }
            ReentrantLock newEntry = new ReentrantLock();
            ReentrantLock previousEntry = this.additionalMonitors.put(obj, newEntry);
            VMError.guarantee(previousEntry == null, "MonitorSupport.getOrCreateMonitor: Replaced monitor");
            ReentrantLock reentrantLock = newEntry;
            return reentrantLock;
        }
        finally {
            this.additionalMonitorsLock.unlock();
        }
    }

    public ReentrantLock getMonitorForTesting(Object obj) {
        return this.getOrCreateMonitor(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Condition getOrCreateCondition(Object obj, ReentrantLock lock, boolean createIfNotExisting) {
        this.additionalConditionsLock.lock();
        try {
            Condition existingEntry = this.additionalConditions.get(obj);
            if (existingEntry != null) {
                Condition condition = existingEntry;
                return condition;
            }
            if (!createIfNotExisting) {
                Condition condition = null;
                return condition;
            }
            Condition newEntry = lock.newCondition();
            Condition previousEntry = this.additionalConditions.put(obj, newEntry);
            VMError.guarantee(previousEntry == null, "MonitorSupport.getOrCreateCondition: Replaced condition");
            Condition condition = newEntry;
            return condition;
        }
        finally {
            this.additionalConditionsLock.unlock();
        }
    }
}

