/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoVerifier;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.util.FrequencyEncoder;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.nativeimage.ImageSingletons;

public class FrameInfoEncoder {
    private final Customization customization;
    private final PinnedAllocator allocator;
    private final List<FrameData> allDebugInfos;
    private final FrequencyEncoder<JavaConstant> objectConstants;
    private final FrequencyEncoder<Class<?>> sourceClasses;
    private final FrequencyEncoder<String> sourceMethodNames;
    private final FrequencyEncoder<String> names;
    protected byte[] frameInfoEncodings;
    protected Object[] frameInfoObjectConstants;
    protected Class<?>[] frameInfoSourceClasses;
    protected String[] frameInfoSourceMethodNames;
    protected String[] frameInfoNames;
    private static final FrameInfoQueryResult.ValueInfo[] MARKER = new FrameInfoQueryResult.ValueInfo[0];

    protected FrameInfoEncoder(Customization customization, PinnedAllocator allocator) {
        this.customization = customization;
        this.allocator = allocator;
        this.allDebugInfos = new ArrayList<FrameData>();
        this.objectConstants = FrequencyEncoder.createEqualityEncoder();
        if (FrameInfoDecoder.encodeDebugNames() || FrameInfoDecoder.encodeSourceReferences()) {
            this.sourceClasses = FrequencyEncoder.createEqualityEncoder();
            this.sourceMethodNames = FrequencyEncoder.createEqualityEncoder();
            this.names = FrequencyEncoder.createEqualityEncoder();
        } else {
            this.sourceClasses = null;
            this.sourceMethodNames = null;
            this.names = null;
        }
    }

    protected FrameData addDebugInfo(ResolvedJavaMethod method, Infopoint infopoint, int totalFrameSize) {
        boolean encodeDebugNames;
        boolean shouldIncludeMethod = this.customization.shouldInclude(method, infopoint);
        boolean encodeSourceReferences = FrameInfoDecoder.encodeSourceReferences();
        if (!shouldIncludeMethod && !encodeSourceReferences) {
            return null;
        }
        DebugInfo debugInfo = infopoint.debugInfo;
        FrameData data = new FrameData();
        data.debugInfo = debugInfo;
        data.totalFrameSize = totalFrameSize;
        data.virtualObjects = new FrameInfoQueryResult.ValueInfo[FrameInfoEncoder.countVirtualObjects(debugInfo)][];
        data.frame = this.addFrame(data, debugInfo.frame(), this.customization.isDeoptEntry(method, infopoint), shouldIncludeMethod);
        boolean bl = encodeDebugNames = shouldIncludeMethod && FrameInfoDecoder.encodeDebugNames();
        if (encodeDebugNames || FrameInfoDecoder.encodeSourceReferences()) {
            FrameInfoQueryResult resultFrame = data.frame;
            for (BytecodeFrame bytecodeFrame = data.debugInfo.frame(); bytecodeFrame != null; bytecodeFrame = bytecodeFrame.caller()) {
                this.customization.fillDebugNames(bytecodeFrame, resultFrame, encodeDebugNames && shouldIncludeMethod);
                resultFrame = resultFrame.caller;
            }
            FrameInfoQueryResult cur = data.frame;
            while (cur != null) {
                this.sourceClasses.addObject(cur.sourceClass);
                this.sourceMethodNames.addObject((Object)cur.sourceMethodName);
                if (encodeDebugNames) {
                    for (FrameInfoQueryResult.ValueInfo valueInfo : cur.valueInfos) {
                        if (valueInfo.name == null) {
                            valueInfo.name = "";
                        }
                        this.names.addObject((Object)valueInfo.name);
                    }
                }
                cur = cur.caller;
            }
        }
        this.allDebugInfos.add(data);
        return data;
    }

    private static int countVirtualObjects(DebugInfo debugInfo) {
        BitSet visitedVirtualObjects = new BitSet();
        for (BytecodeFrame frame = debugInfo.frame(); frame != null; frame = frame.caller()) {
            FrameInfoEncoder.countVirtualObjects(frame.values, visitedVirtualObjects);
        }
        return visitedVirtualObjects.length();
    }

    private static void countVirtualObjects(JavaValue[] values, BitSet visitedVirtualObjects) {
        for (JavaValue value : values) {
            VirtualObject virtualObject;
            if (!(value instanceof VirtualObject) || visitedVirtualObjects.get((virtualObject = (VirtualObject)value).getId())) continue;
            visitedVirtualObjects.set(virtualObject.getId());
            FrameInfoEncoder.countVirtualObjects(virtualObject.getValues(), visitedVirtualObjects);
        }
    }

    private FrameInfoQueryResult addFrame(FrameData data, BytecodeFrame frame, boolean isDeoptEntry, boolean needLocalValues) {
        FrameInfoQueryResult result = new FrameInfoQueryResult();
        if (frame.caller() != null) {
            assert (!isDeoptEntry) : "Deoptimization entry point information for caller frames is not encoded";
            result.caller = this.addFrame(data, frame.caller(), false, needLocalValues);
        }
        result.virtualObjects = data.virtualObjects;
        result.encodedBci = FrameInfoEncoder.encodeBci(frame.getBCI(), frame.duringCall, frame.rethrowException);
        result.isDeoptEntry = isDeoptEntry;
        result.needLocalValues = needLocalValues;
        SharedMethod method = (SharedMethod)frame.getMethod();
        if (this.customization.shouldStoreMethod()) {
            result.deoptMethod = method;
            this.objectConstants.addObject((Object)SubstrateObjectConstant.forObject(method));
        }
        result.deoptMethodOffset = method.getDeoptOffsetInImage();
        result.numLocals = frame.numLocals;
        result.numStack = frame.numStack;
        result.numLocks = frame.numLocks;
        FrameInfoQueryResult.ValueInfo[] valueInfos = null;
        if (needLocalValues) {
            JavaValue[] values = frame.values;
            int numValues = 0;
            int i = values.length;
            while (--i >= 0) {
                if (ValueUtil.isIllegalJavaValue((JavaValue)values[i])) continue;
                numValues = i + 1;
                break;
            }
            valueInfos = new FrameInfoQueryResult.ValueInfo[numValues];
            for (i = 0; i < numValues; ++i) {
                valueInfos[i] = this.makeValueInfo(data, FrameInfoEncoder.getFrameValueKind(frame, i), values[i]);
            }
        }
        result.valueInfos = valueInfos;
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).frameCount.inc();
        return result;
    }

    public static JavaKind getFrameValueKind(BytecodeFrame frame, int valueIndex) {
        if (valueIndex < frame.numLocals) {
            return frame.getLocalValueKind(valueIndex);
        }
        if (valueIndex - frame.numLocals < frame.numStack) {
            return frame.getStackValueKind(valueIndex - frame.numLocals);
        }
        assert (valueIndex - frame.numLocals - frame.numStack < frame.numLocks);
        return JavaKind.Object;
    }

    private FrameInfoQueryResult.ValueInfo makeValueInfo(FrameData data, JavaKind kind, JavaValue value) {
        FrameInfoQueryResult.ValueInfo result = new FrameInfoQueryResult.ValueInfo();
        result.kind = kind;
        if (ValueUtil.isIllegalJavaValue((JavaValue)value)) {
            result.type = FrameInfoQueryResult.ValueType.Illegal;
            assert (result.kind == JavaKind.Illegal);
        } else if (value instanceof StackSlot) {
            StackSlot stackSlot = (StackSlot)value;
            result.type = FrameInfoQueryResult.ValueType.StackSlot;
            result.data = stackSlot.getOffset(data.totalFrameSize);
            result.isCompressedReference = FrameInfoEncoder.isCompressedReference((AllocatableValue)stackSlot);
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).stackValueCount.inc();
        } else if (value instanceof JavaConstant) {
            JavaConstant constant;
            result.value = constant = (JavaConstant)value;
            if (constant.isDefaultForKind()) {
                result.type = FrameInfoQueryResult.ValueType.DefaultConstant;
            } else {
                result.type = FrameInfoQueryResult.ValueType.Constant;
                if (constant.getJavaKind() == JavaKind.Object) {
                    this.objectConstants.addObject((Object)constant);
                }
            }
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).constantValueCount.inc();
        } else if (ValueUtil.isVirtualObject((JavaValue)value)) {
            VirtualObject virtualObject = (VirtualObject)value;
            result.type = FrameInfoQueryResult.ValueType.VirtualObject;
            result.data = virtualObject.getId();
            this.makeVirtualObject(data, virtualObject);
        } else {
            throw VMError.shouldNotReachHere();
        }
        return result;
    }

    private static boolean isCompressedReference(AllocatableValue value) {
        assert (value.getPlatformKind().getVectorLength() == 1) : "Only scalar types supported";
        return ((LIRKind)value.getValueKind(LIRKind.class)).isCompressedReference(0);
    }

    private void makeVirtualObject(FrameData data, VirtualObject virtualObject) {
        int id = virtualObject.getId();
        if (data.virtualObjects[id] != null) {
            return;
        }
        data.virtualObjects[id] = MARKER;
        ArrayList<FrameInfoQueryResult.ValueInfo> valueList = new ArrayList<FrameInfoQueryResult.ValueInfo>(virtualObject.getValues().length + 4);
        SharedType type = (SharedType)virtualObject.getType();
        valueList.add(this.makeValueInfo(data, JavaKind.Object, (JavaValue)SubstrateObjectConstant.forObject(type.getHub())));
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        assert (type.isArray() == LayoutEncoding.isArray(type.getHub().getLayoutEncoding())) : "deoptimization code uses layout encoding to determine if type is an array";
        if (type.isArray()) {
            valueList.add(null);
            int length = 0;
            JavaKind kind = ((SharedType)type.getComponentType()).getStorageKind();
            for (int i = 0; i < virtualObject.getValues().length; ++i) {
                JavaValue value = virtualObject.getValues()[i];
                JavaKind valueKind = virtualObject.getSlotKind(i);
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    valueList.add(this.makeValueInfo(data, valueKind, value));
                    length += 2;
                } else {
                    assert (objectLayout.sizeInBytes(valueKind.getStackKind()) <= objectLayout.sizeInBytes(kind.getStackKind()));
                    valueList.add(this.makeValueInfo(data, kind, value));
                    ++length;
                }
                assert (objectLayout.getArrayElementOffset(kind, length) == (long)(objectLayout.getArrayBaseOffset(kind) + FrameInfoEncoder.computeOffset(valueList.subList(2, valueList.size()))));
            }
            assert (valueList.get(1) == null);
            valueList.set(1, this.makeValueInfo(data, JavaKind.Int, (JavaValue)JavaConstant.forInt((int)length)));
        } else {
            SharedField[] fields = (SharedField[])type.getInstanceFields(true);
            long curOffset = objectLayout.getFirstFieldOffset();
            int fieldIdx = 0;
            int valueIdx = 0;
            while (valueIdx < virtualObject.getValues().length) {
                SharedField field = fields[fieldIdx];
                ++fieldIdx;
                JavaValue value = virtualObject.getValues()[valueIdx];
                JavaKind valueKind = virtualObject.getSlotKind(valueIdx);
                ++valueIdx;
                JavaKind kind = field.getStorageKind();
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    kind = valueKind;
                    assert (fields[fieldIdx].getJavaKind() == field.getJavaKind());
                    ++fieldIdx;
                }
                if (field.getLocation() < 0) continue;
                assert (curOffset <= (long)field.getLocation());
                while (curOffset + 7L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Long, (JavaValue)JavaConstant.LONG_0));
                    curOffset += 8L;
                }
                if (curOffset + 3L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Int, (JavaValue)JavaConstant.INT_0));
                    curOffset += 4L;
                }
                if (curOffset + 1L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Short, (JavaValue)JavaConstant.forShort((short)0)));
                    curOffset += 2L;
                }
                if (curOffset < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Byte, (JavaValue)JavaConstant.forByte((byte)0)));
                    ++curOffset;
                }
                assert (curOffset == (long)field.getLocation());
                assert (curOffset == (long)FrameInfoEncoder.computeOffset(valueList));
                valueList.add(this.makeValueInfo(data, kind, value));
                curOffset += (long)objectLayout.sizeInBytes(kind);
            }
        }
        data.virtualObjects[id] = valueList.toArray(new FrameInfoQueryResult.ValueInfo[valueList.size()]);
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).virtualObjectsCount.inc();
    }

    private static int computeOffset(List<FrameInfoQueryResult.ValueInfo> valueInfos) {
        int result = 0;
        for (FrameInfoQueryResult.ValueInfo valueInfo : valueInfos) {
            result += ConfigurationValues.getObjectLayout().sizeInBytes(valueInfo.kind);
        }
        return result;
    }

    protected void encodeAll() {
        JavaConstant[] encodedJavaConstants = (JavaConstant[])this.objectConstants.encodeAll((Object[])new JavaConstant[this.objectConstants.getLength()]);
        this.frameInfoObjectConstants = this.newObjectArray(encodedJavaConstants.length);
        for (int i = 0; i < encodedJavaConstants.length; ++i) {
            this.frameInfoObjectConstants[i] = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject((Constant)encodedJavaConstants[i]), Object.class);
        }
        boolean encodeDebugNames = FrameInfoDecoder.encodeDebugNames();
        if (encodeDebugNames || FrameInfoDecoder.encodeSourceReferences()) {
            this.frameInfoSourceClasses = (Class[])this.sourceClasses.encodeAll((Object[])this.newClassArray(this.sourceClasses.getLength()));
            this.frameInfoSourceMethodNames = (String[])this.sourceMethodNames.encodeAll((Object[])this.newStringArray(this.sourceMethodNames.getLength()));
        }
        this.frameInfoNames = encodeDebugNames ? (String[])this.names.encodeAll((Object[])this.newStringArray(this.names.getLength())) : null;
        this.encodeFrameDatas();
        assert (this.verifyEncoding());
    }

    private void encodeFrameDatas() {
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        for (FrameData data : this.allDebugInfos) {
            data.indexInEncodings = encodingBuffer.getBytesWritten();
            this.encodeFrameData(data, encodingBuffer);
        }
        this.frameInfoEncodings = encodingBuffer.toArray(this.newByteArray(TypeConversion.asS4((long)encodingBuffer.getBytesWritten())));
    }

    private Object[] newObjectArray(int length) {
        return this.allocator == null ? new Object[length] : (Object[])this.allocator.newArray(Object.class, length);
    }

    private String[] newStringArray(int length) {
        return this.allocator == null ? new String[length] : (String[])this.allocator.newArray(String.class, length);
    }

    private Class<?>[] newClassArray(int length) {
        return this.allocator == null ? new Class[length] : (Class[])this.allocator.newArray(Class.class, length);
    }

    private byte[] newByteArray(int length) {
        return this.allocator == null ? new byte[length] : (byte[])this.allocator.newArray(Byte.TYPE, length);
    }

    private void encodeFrameData(FrameData data, UnsafeArrayTypeWriter encodingBuffer) {
        FrameInfoQueryResult cur = data.frame;
        while (cur != null) {
            boolean encodeDebugNames;
            assert (cur.encodedBci != -1L) : "used as the end marker during decoding";
            boolean needLocalValues = cur.needLocalValues;
            if (!needLocalValues) {
                cur.encodedBci = -2L;
            }
            encodingBuffer.putSV(cur.encodedBci);
            assert (cur == data.frame || !cur.isDeoptEntry) : "Deoptimization entry information for caller frames is not persisted";
            if (needLocalValues) {
                int deoptMethodIndex;
                encodingBuffer.putUV((long)cur.numLocks);
                encodingBuffer.putUV((long)cur.numLocals);
                encodingBuffer.putUV((long)cur.numStack);
                if (cur.deoptMethod != null) {
                    deoptMethodIndex = -1 - this.objectConstants.getIndex((Object)SubstrateObjectConstant.forObject(cur.deoptMethod));
                    assert (deoptMethodIndex < 0);
                    assert (cur.deoptMethodOffset == cur.deoptMethod.getDeoptOffsetInImage());
                } else {
                    deoptMethodIndex = cur.deoptMethodOffset;
                    assert (deoptMethodIndex >= 0);
                }
                encodingBuffer.putSV((long)deoptMethodIndex);
                this.encodeValues(cur.valueInfos, encodingBuffer);
                if (cur == data.frame) {
                    encodingBuffer.putUV((long)cur.virtualObjects.length);
                    for (FrameInfoQueryResult.ValueInfo valueInfo : cur.virtualObjects) {
                        this.encodeValues((FrameInfoQueryResult.ValueInfo[])valueInfo, encodingBuffer);
                    }
                }
            }
            boolean bl = encodeDebugNames = needLocalValues && FrameInfoDecoder.encodeDebugNames();
            if (encodeDebugNames || FrameInfoDecoder.encodeSourceReferences()) {
                int classIndex = this.sourceClasses.getIndex(cur.sourceClass);
                int methodIndex = this.sourceMethodNames.getIndex((Object)cur.sourceMethodName);
                cur.sourceClassIndex = classIndex;
                cur.sourceMethodNameIndex = methodIndex;
                encodingBuffer.putSV((long)classIndex);
                encodingBuffer.putSV((long)methodIndex);
                encodingBuffer.putSV((long)cur.sourceLineNumber);
            }
            if (encodeDebugNames) {
                for (FrameInfoQueryResult.ValueInfo valueInfo : cur.valueInfos) {
                    valueInfo.nameIndex = this.names.getIndex((Object)valueInfo.name);
                    encodingBuffer.putUV((long)valueInfo.nameIndex);
                }
            }
            cur = cur.caller;
        }
        encodingBuffer.putSV(-1L);
    }

    private void encodeValues(FrameInfoQueryResult.ValueInfo[] valueInfos, UnsafeArrayTypeWriter encodingBuffer) {
        encodingBuffer.putUV((long)valueInfos.length);
        for (FrameInfoQueryResult.ValueInfo valueInfo : valueInfos) {
            if (valueInfo.type == FrameInfoQueryResult.ValueType.Constant) {
                valueInfo.data = valueInfo.kind == JavaKind.Object ? (long)this.objectConstants.getIndex((Object)valueInfo.value) : FrameInfoEncoder.encodePrimitiveConstant(valueInfo.value);
            }
            encodingBuffer.putU1((long)FrameInfoEncoder.encodeFlags(valueInfo.type, valueInfo.kind, valueInfo.isCompressedReference));
            if (!valueInfo.type.hasData) continue;
            encodingBuffer.putSV(valueInfo.data);
        }
    }

    protected static long encodePrimitiveConstant(JavaConstant constant) {
        switch (constant.getJavaKind()) {
            case Float: {
                return Float.floatToRawIntBits(constant.asFloat());
            }
            case Double: {
                return Double.doubleToRawLongBits(constant.asDouble());
            }
        }
        return constant.asLong();
    }

    private static int encodeFlags(FrameInfoQueryResult.ValueType type, JavaKind kind, boolean isCompressedReference) {
        return type.ordinal() << 0 | kind.ordinal() << 3 | (isCompressedReference ? 1 : 0) << 7;
    }

    public static long encodeBci(int bci, boolean duringCall, boolean rethrowException) {
        return (long)bci << 2 | (long)(duringCall ? 2 : 0) | (long)(rethrowException ? 1 : 0);
    }

    private boolean verifyEncoding() {
        for (FrameData expectedData : this.allDebugInfos) {
            FrameInfoQueryResult actualFrame = FrameInfoDecoder.decodeFrameInfo(expectedData.frame.isDeoptEntry, new ReusableTypeReader(this.frameInfoEncodings, expectedData.indexInEncodings), this.frameInfoObjectConstants, this.frameInfoSourceClasses, this.frameInfoSourceMethodNames, this.frameInfoNames, FrameInfoDecoder.HeapBasedFrameInfoQueryResultAllocator, FrameInfoDecoder.HeapBasedValueInfoAllocator, true);
            FrameInfoVerifier.verifyFrames(expectedData, expectedData.frame, actualFrame);
        }
        return true;
    }

    static class FrameData {
        protected DebugInfo debugInfo;
        protected int totalFrameSize;
        protected FrameInfoQueryResult.ValueInfo[][] virtualObjects;
        protected FrameInfoQueryResult frame;
        protected long indexInEncodings;

        FrameData() {
        }
    }

    public static class NamesFromImage
    extends Customization {
        @Override
        protected void fillDebugNames(BytecodeFrame bytecodeFrame, FrameInfoQueryResult resultFrameInfo, boolean fillValueNames) {
            CodeInfoQueryResult targetCodeInfo;
            int deoptOffsetInImage = ((SharedMethod)bytecodeFrame.getMethod()).getDeoptOffsetInImage();
            if (deoptOffsetInImage != 0 && (targetCodeInfo = CodeInfoTable.lookupDeoptimizationEntrypoint(deoptOffsetInImage, resultFrameInfo.encodedBci)) != null) {
                FrameInfoQueryResult targetFrameInfo = targetCodeInfo.getFrameInfo();
                assert (targetFrameInfo != null);
                resultFrameInfo.sourceClass = targetFrameInfo.sourceClass;
                resultFrameInfo.sourceMethodName = targetFrameInfo.sourceMethodName;
                resultFrameInfo.sourceLineNumber = targetFrameInfo.sourceLineNumber;
                if (fillValueNames) {
                    int minLength = Math.min(resultFrameInfo.valueInfos.length, targetFrameInfo.valueInfos.length);
                    for (int i = 0; i < minLength; ++i) {
                        resultFrameInfo.valueInfos[i].name = targetFrameInfo.valueInfos[i].name;
                    }
                }
            }
        }
    }

    public static abstract class NamesFromMethod
    extends Customization {
        private final HostedStringDeduplication stringTable = HostedStringDeduplication.singleton();

        @Override
        protected void fillDebugNames(BytecodeFrame bytecodeFrame, FrameInfoQueryResult resultFrameInfo, boolean fillValueNames) {
            Local[] locals;
            LocalVariableTable localVariableTable;
            ResolvedJavaMethod method = bytecodeFrame.getMethod();
            StackTraceElement source = method.asStackTraceElement(bytecodeFrame.getBCI());
            resultFrameInfo.sourceClass = this.getDeclaringJavaClass(method);
            resultFrameInfo.sourceMethodName = this.stringTable.deduplicate(source.getMethodName(), true);
            resultFrameInfo.sourceLineNumber = source.getLineNumber();
            if (fillValueNames && (localVariableTable = bytecodeFrame.getMethod().getLocalVariableTable()) != null && (locals = localVariableTable.getLocalsAt(bytecodeFrame.getBCI())) != null) {
                for (Local local : locals) {
                    if (local.getSlot() < resultFrameInfo.valueInfos.length) {
                        resultFrameInfo.valueInfos[local.getSlot()].name = local.getName();
                        continue;
                    }
                    assert (ValueUtil.isIllegalJavaValue((JavaValue)bytecodeFrame.values[local.getSlot()]));
                }
            }
        }

        protected abstract Class<?> getDeclaringJavaClass(ResolvedJavaMethod var1);
    }

    public static abstract class Customization {
        protected boolean shouldStoreMethod() {
            return true;
        }

        protected boolean shouldInclude(ResolvedJavaMethod method, Infopoint infopoint) {
            return true;
        }

        protected boolean isDeoptEntry(ResolvedJavaMethod method, Infopoint infopoint) {
            return false;
        }

        protected abstract void fillDebugNames(BytecodeFrame var1, FrameInfoQueryResult var2, boolean var3);
    }
}

